/*
 * Decompiled with CFR 0.152.
 */
package com.simba.athena.amazonaws.services.glue.model.transform;

import com.simba.athena.amazonaws.SdkClientException;
import com.simba.athena.amazonaws.annotation.SdkInternalApi;
import com.simba.athena.amazonaws.protocol.MarshallLocation;
import com.simba.athena.amazonaws.protocol.MarshallingInfo;
import com.simba.athena.amazonaws.protocol.MarshallingType;
import com.simba.athena.amazonaws.protocol.ProtocolMarshaller;
import com.simba.athena.amazonaws.protocol.StructuredPojo;
import com.simba.athena.amazonaws.services.glue.model.TaskRun;
import java.util.Date;

@SdkInternalApi
public class TaskRunMarshaller {
    private static final MarshallingInfo<String> TRANSFORMID_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TransformId").build();
    private static final MarshallingInfo<String> TASKRUNID_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TaskRunId").build();
    private static final MarshallingInfo<String> STATUS_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Status").build();
    private static final MarshallingInfo<String> LOGGROUPNAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LogGroupName").build();
    private static final MarshallingInfo<StructuredPojo> PROPERTIES_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Properties").build();
    private static final MarshallingInfo<String> ERRORSTRING_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ErrorString").build();
    private static final MarshallingInfo<Date> STARTEDON_BINDING = MarshallingInfo.builder(MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StartedOn").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<Date> LASTMODIFIEDON_BINDING = MarshallingInfo.builder(MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LastModifiedOn").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<Date> COMPLETEDON_BINDING = MarshallingInfo.builder(MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CompletedOn").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<Integer> EXECUTIONTIME_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ExecutionTime").build();
    private static final TaskRunMarshaller instance = new TaskRunMarshaller();

    public static TaskRunMarshaller getInstance() {
        return instance;
    }

    public void marshall(TaskRun taskRun, ProtocolMarshaller protocolMarshaller) {
        if (taskRun == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(taskRun.getTransformId(), TRANSFORMID_BINDING);
            protocolMarshaller.marshall(taskRun.getTaskRunId(), TASKRUNID_BINDING);
            protocolMarshaller.marshall(taskRun.getStatus(), STATUS_BINDING);
            protocolMarshaller.marshall(taskRun.getLogGroupName(), LOGGROUPNAME_BINDING);
            protocolMarshaller.marshall(taskRun.getProperties(), PROPERTIES_BINDING);
            protocolMarshaller.marshall(taskRun.getErrorString(), ERRORSTRING_BINDING);
            protocolMarshaller.marshall(taskRun.getStartedOn(), STARTEDON_BINDING);
            protocolMarshaller.marshall(taskRun.getLastModifiedOn(), LASTMODIFIEDON_BINDING);
            protocolMarshaller.marshall(taskRun.getCompletedOn(), COMPLETEDON_BINDING);
            protocolMarshaller.marshall(taskRun.getExecutionTime(), EXECUTIONTIME_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

