/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.snowflake.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.generic.model.GenericScriptObject;
import org.jkiss.dbeaver.ext.generic.model.GenericSequence;
import org.jkiss.dbeaver.ext.generic.model.GenericStructContainer;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.meta.PropertyLength;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;

public class SnowflakeSequence
extends GenericSequence
implements GenericScriptObject {
    private long startValue;
    private long nextValue;
    private Date createTime;
    private Date lastAlter;
    private String source;
    private String description;

    public SnowflakeSequence(GenericStructContainer container, String name, String description, Number lastValue, Number minValue, Number maxValue, Number incrementBy, @NotNull JDBCResultSet dbResult) {
        super(container, name, description, lastValue, minValue, maxValue, incrementBy);
        this.startValue = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"START_VALUE");
        this.nextValue = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"NEXT_VALUE");
        this.createTime = JDBCUtils.safeGetTimestamp((ResultSet)dbResult, (String)"CREATED");
        this.lastAlter = JDBCUtils.safeGetTimestamp((ResultSet)dbResult, (String)"LAST_ALTERED");
        this.description = description;
    }

    @Property(viewable=true, editable=true, updatable=true, length=PropertyLength.MULTILINE, order=10)
    @Nullable
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Number getLastValue() {
        return super.getLastValue();
    }

    @Property(viewable=true, order=2)
    public long getStartValue() {
        return this.startValue;
    }

    @Property(viewable=true, order=3)
    public long getNextValue() {
        return this.nextValue;
    }

    public Number getMinValue() {
        return super.getMinValue();
    }

    public Number getMaxValue() {
        return super.getMaxValue();
    }

    @Property(viewable=true, editable=true, updatable=true, order=5)
    public Long getIncrementBy() {
        return super.getIncrementBy().longValue();
    }

    @Property(viewable=true, order=6)
    public Date getCreateTime() {
        return this.createTime;
    }

    @Property(viewable=true, order=7)
    public Date getLastAlter() {
        return this.lastAlter;
    }

    public String getObjectDefinitionText(DBRProgressMonitor monitor, Map<String, Object> options) throws DBException {
        if (this.source == null) {
            try {
                Throwable throwable = null;
                Object var4_6 = null;
                try (JDBCSession session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBSObject)this, (String)"Read Snowflake sequence DDL");){
                    Throwable throwable2 = null;
                    Object var7_11 = null;
                    try (JDBCPreparedStatement dbStat = session.prepareStatement("SELECT GET_DDL('SEQUENCE', '" + this.getFullyQualifiedName(DBPEvaluationContext.DML) + "')");){
                        Throwable throwable3 = null;
                        Object var10_16 = null;
                        try (JDBCResultSet dbResult = dbStat.executeQuery();){
                            if (dbResult.nextRow()) {
                                this.source = JDBCUtils.safeGetString((ResultSet)dbResult, (int)1);
                            }
                        }
                        catch (Throwable throwable4) {
                            if (throwable3 == null) {
                                throwable3 = throwable4;
                            } else if (throwable3 != throwable4) {
                                throwable3.addSuppressed(throwable4);
                            }
                            throw throwable3;
                        }
                    }
                    catch (Throwable throwable5) {
                        if (throwable2 == null) {
                            throwable2 = throwable5;
                        } else if (throwable2 != throwable5) {
                            throwable2.addSuppressed(throwable5);
                        }
                        throw throwable2;
                    }
                }
                catch (Throwable throwable6) {
                    if (throwable == null) {
                        throwable = throwable6;
                    } else if (throwable != throwable6) {
                        throwable.addSuppressed(throwable6);
                    }
                    throw throwable;
                }
            }
            catch (SQLException e) {
                throw new DBException("Can't read sequence DDL from database", (Throwable)e);
            }
        }
        return this.source;
    }
}

