/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.redshiftarcadiainternal.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.redshiftarcadiainternal.model.SnapshotMessage;
import java.util.List;

@SdkInternalApi
public class SnapshotMessageMarshaller {
    private static final MarshallingInfo<String> MARKER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("marker").build();
    private static final MarshallingInfo<List> SNAPSHOTS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("snapshots").build();
    private static final SnapshotMessageMarshaller instance = new SnapshotMessageMarshaller();

    public static SnapshotMessageMarshaller getInstance() {
        return instance;
    }

    public void marshall(SnapshotMessage snapshotMessage, ProtocolMarshaller protocolMarshaller) {
        if (snapshotMessage == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)snapshotMessage.getMarker(), MARKER_BINDING);
            protocolMarshaller.marshall(snapshotMessage.getSnapshots(), SNAPSHOTS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

