/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.redshiftarcadiainternal.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.redshiftarcadiainternal.model.Snapshot;
import java.util.Date;

@SdkInternalApi
public class SnapshotMarshaller {
    private static final MarshallingInfo<Double> ACTUALINCREMENTALBACKUPSIZEINMEGABYTES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DOUBLE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("actualIncrementalBackupSizeInMegaBytes").build();
    private static final MarshallingInfo<Double> BACKUPPROGRESSINMEGABYTES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DOUBLE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("backupProgressInMegaBytes").build();
    private static final MarshallingInfo<Double> CURRENTBACKUPRATEINMEGABYTESPERSECOND_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DOUBLE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("currentBackupRateInMegaBytesPerSecond").build();
    private static final MarshallingInfo<String> DBNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("dbName").build();
    private static final MarshallingInfo<Long> ELAPSEDTIMEINSECONDS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("elapsedTimeInSeconds").build();
    private static final MarshallingInfo<Boolean> ENCRYPTED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("encrypted").build();
    private static final MarshallingInfo<Long> ESTIMATEDSECONDSTOCOMPLETION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("estimatedSecondsToCompletion").build();
    private static final MarshallingInfo<String> KMSKEYID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("kmsKeyId").build();
    private static final MarshallingInfo<Integer> MANUALSNAPSHOTREMAININGDAYS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("manualSnapshotRemainingDays").build();
    private static final MarshallingInfo<Integer> MANUALSNAPSHOTRETENTIONPERIOD_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("manualSnapshotRetentionPeriod").build();
    private static final MarshallingInfo<String> MASTERUSERNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("masterUsername").build();
    private static final MarshallingInfo<String> OWNERACCOUNT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ownerAccount").build();
    private static final MarshallingInfo<Date> SNAPSHOTCREATETIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("snapshotCreateTime").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<String> SNAPSHOTIDENTIFIER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("snapshotIdentifier").build();
    private static final MarshallingInfo<Date> SNAPSHOTRETENTIONSTARTTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("snapshotRetentionStartTime").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<String> SOURCEREGION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("sourceRegion").build();
    private static final MarshallingInfo<String> STATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("status").build();
    private static final MarshallingInfo<Double> TOTALBACKUPSIZEINMEGABYTES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DOUBLE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("totalBackupSizeInMegaBytes").build();
    private static final MarshallingInfo<String> VPCID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("vpcId").build();
    private static final SnapshotMarshaller instance = new SnapshotMarshaller();

    public static SnapshotMarshaller getInstance() {
        return instance;
    }

    public void marshall(Snapshot snapshot, ProtocolMarshaller protocolMarshaller) {
        if (snapshot == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)snapshot.getActualIncrementalBackupSizeInMegaBytes(), ACTUALINCREMENTALBACKUPSIZEINMEGABYTES_BINDING);
            protocolMarshaller.marshall((Object)snapshot.getBackupProgressInMegaBytes(), BACKUPPROGRESSINMEGABYTES_BINDING);
            protocolMarshaller.marshall((Object)snapshot.getCurrentBackupRateInMegaBytesPerSecond(), CURRENTBACKUPRATEINMEGABYTESPERSECOND_BINDING);
            protocolMarshaller.marshall((Object)snapshot.getDbName(), DBNAME_BINDING);
            protocolMarshaller.marshall((Object)snapshot.getElapsedTimeInSeconds(), ELAPSEDTIMEINSECONDS_BINDING);
            protocolMarshaller.marshall((Object)snapshot.getEncrypted(), ENCRYPTED_BINDING);
            protocolMarshaller.marshall((Object)snapshot.getEstimatedSecondsToCompletion(), ESTIMATEDSECONDSTOCOMPLETION_BINDING);
            protocolMarshaller.marshall((Object)snapshot.getKmsKeyId(), KMSKEYID_BINDING);
            protocolMarshaller.marshall((Object)snapshot.getManualSnapshotRemainingDays(), MANUALSNAPSHOTREMAININGDAYS_BINDING);
            protocolMarshaller.marshall((Object)snapshot.getManualSnapshotRetentionPeriod(), MANUALSNAPSHOTRETENTIONPERIOD_BINDING);
            protocolMarshaller.marshall((Object)snapshot.getMasterUsername(), MASTERUSERNAME_BINDING);
            protocolMarshaller.marshall((Object)snapshot.getOwnerAccount(), OWNERACCOUNT_BINDING);
            protocolMarshaller.marshall((Object)snapshot.getSnapshotCreateTime(), SNAPSHOTCREATETIME_BINDING);
            protocolMarshaller.marshall((Object)snapshot.getSnapshotIdentifier(), SNAPSHOTIDENTIFIER_BINDING);
            protocolMarshaller.marshall((Object)snapshot.getSnapshotRetentionStartTime(), SNAPSHOTRETENTIONSTARTTIME_BINDING);
            protocolMarshaller.marshall((Object)snapshot.getSourceRegion(), SOURCEREGION_BINDING);
            protocolMarshaller.marshall((Object)snapshot.getStatus(), STATUS_BINDING);
            protocolMarshaller.marshall((Object)snapshot.getTotalBackupSizeInMegaBytes(), TOTALBACKUPSIZEINMEGABYTES_BINDING);
            protocolMarshaller.marshall((Object)snapshot.getVpcId(), VPCID_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

