/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.redshiftarcadiainternal.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.redshiftarcadiainternal.model.ConfigParameter;

@SdkInternalApi
public class ConfigParameterMarshaller {
    private static final MarshallingInfo<String> PARAMETERKEY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("parameterKey").build();
    private static final MarshallingInfo<String> PARAMETERVALUE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("parameterValue").build();
    private static final ConfigParameterMarshaller instance = new ConfigParameterMarshaller();

    public static ConfigParameterMarshaller getInstance() {
        return instance;
    }

    public void marshall(ConfigParameter configParameter, ProtocolMarshaller protocolMarshaller) {
        if (configParameter == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)configParameter.getParameterKey(), PARAMETERKEY_BINDING);
            protocolMarshaller.marshall((Object)configParameter.getParameterValue(), PARAMETERVALUE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

