/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.redshiftarcadiainternal.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.redshiftarcadiainternal.model.Tag;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class CreateSnapshotRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String dbName;
    private Integer manualSnapshotRetentionPeriod;
    private String snapshotIdentifier;
    private SdkInternalList<Tag> tags;

    public void setDbName(String dbName) {
        this.dbName = dbName;
    }

    public String getDbName() {
        return this.dbName;
    }

    public CreateSnapshotRequest withDbName(String dbName) {
        this.setDbName(dbName);
        return this;
    }

    public void setManualSnapshotRetentionPeriod(Integer manualSnapshotRetentionPeriod) {
        this.manualSnapshotRetentionPeriod = manualSnapshotRetentionPeriod;
    }

    public Integer getManualSnapshotRetentionPeriod() {
        return this.manualSnapshotRetentionPeriod;
    }

    public CreateSnapshotRequest withManualSnapshotRetentionPeriod(Integer manualSnapshotRetentionPeriod) {
        this.setManualSnapshotRetentionPeriod(manualSnapshotRetentionPeriod);
        return this;
    }

    public void setSnapshotIdentifier(String snapshotIdentifier) {
        this.snapshotIdentifier = snapshotIdentifier;
    }

    public String getSnapshotIdentifier() {
        return this.snapshotIdentifier;
    }

    public CreateSnapshotRequest withSnapshotIdentifier(String snapshotIdentifier) {
        this.setSnapshotIdentifier(snapshotIdentifier);
        return this;
    }

    public List<Tag> getTags() {
        if (this.tags == null) {
            this.tags = new SdkInternalList();
        }
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new SdkInternalList(tags);
    }

    public CreateSnapshotRequest withTags(Tag ... tags) {
        if (this.tags == null) {
            this.setTags((Collection<Tag>)new SdkInternalList(tags.length));
        }
        for (Tag ele : tags) {
            this.tags.add((Object)ele);
        }
        return this;
    }

    public CreateSnapshotRequest withTags(Collection<Tag> tags) {
        this.setTags(tags);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDbName() != null) {
            sb.append("DbName: ").append(this.getDbName()).append(",");
        }
        if (this.getManualSnapshotRetentionPeriod() != null) {
            sb.append("ManualSnapshotRetentionPeriod: ").append(this.getManualSnapshotRetentionPeriod()).append(",");
        }
        if (this.getSnapshotIdentifier() != null) {
            sb.append("SnapshotIdentifier: ").append(this.getSnapshotIdentifier()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateSnapshotRequest)) {
            return false;
        }
        CreateSnapshotRequest other = (CreateSnapshotRequest)obj;
        if (other.getDbName() == null ^ this.getDbName() == null) {
            return false;
        }
        if (other.getDbName() != null && !other.getDbName().equals(this.getDbName())) {
            return false;
        }
        if (other.getManualSnapshotRetentionPeriod() == null ^ this.getManualSnapshotRetentionPeriod() == null) {
            return false;
        }
        if (other.getManualSnapshotRetentionPeriod() != null && !other.getManualSnapshotRetentionPeriod().equals(this.getManualSnapshotRetentionPeriod())) {
            return false;
        }
        if (other.getSnapshotIdentifier() == null ^ this.getSnapshotIdentifier() == null) {
            return false;
        }
        if (other.getSnapshotIdentifier() != null && !other.getSnapshotIdentifier().equals(this.getSnapshotIdentifier())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || other.getTags().equals(this.getTags());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDbName() == null ? 0 : this.getDbName().hashCode());
        hashCode = 31 * hashCode + (this.getManualSnapshotRetentionPeriod() == null ? 0 : this.getManualSnapshotRetentionPeriod().hashCode());
        hashCode = 31 * hashCode + (this.getSnapshotIdentifier() == null ? 0 : this.getSnapshotIdentifier().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        return hashCode;
    }

    public CreateSnapshotRequest clone() {
        return (CreateSnapshotRequest)super.clone();
    }
}

