/*
 * Decompiled with CFR 0.152.
 */
package utilities;

import com.ibm.as400.access.CommandLineArguments;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import utilities.JarMaker;

public class ToolboxJarMaker
extends JarMaker {
    static final String[] VALID_COMPONENTS = new String[]{"AS400", "CommandCall", "ConnectionPool", "DataArea", "DataDescription", "DataQueue", "DigitalCertificate", "FTP", "IntegratedFileSystem", "JAAS", "JavaApplicationCall", "JDBC", "Job", "Message", "NetServer", "NumericDataTypes", "PCML", "Print", "ProgramCall", "RecordLevelAccess", "SecureAS400", "ServiceProgramCall", "SystemStatus", "SystemValue", "Trace", "User", "UserSpace", "AS400Visual", "CommandCallVisual", "DataQueueVisual", "IntegratedFileSystemVisual", "JavaApplicationCallVisual", "JDBCVisual", "JobVisual", "MessageVisual", "PrintVisual", "ProgramCallVisual", "RecordLevelAccessVisual", "UserVisual"};
    static final String[] VALID_COMPONENT_ABBREVS = new String[]{"AS400", "CmdCall", "ConnPool", "DA", "DD", "DQ", "DigCert", "FTP", "IFS", "JAAS", "JavaApp", "JDBC", "Job", "Msg", "NetS", "DataType", "PCML", "Prt", "PgmCall", "RLA", "Secure", "SvcPgmCall", "SysStat", "SysVal", "Trace", "User", "UserSpc", "AS400V", "CmdCallV", "DQV", "IFSV", "JavaAppV", "JDBCV", "JobV", "MsgV", "PrtV", "PgmCallV", "RLAV", "UserV"};
    public static final Integer AS400 = new Integer(0);
    public static final Integer COMMAND_CALL = new Integer(1);
    public static final Integer CONNECTION_POOL = new Integer(2);
    public static final Integer DATA_AREA = new Integer(3);
    public static final Integer DATA_DESCRIPTION = new Integer(4);
    public static final Integer DATA_QUEUE = new Integer(5);
    public static final Integer DIGITAL_CERTIFICATE = new Integer(6);
    public static final Integer FTP = new Integer(7);
    public static final Integer INTEGRATED_FILE_SYSTEM = new Integer(8);
    public static final Integer JAAS = new Integer(9);
    public static final Integer JAVA_APPLICATION_CALL = new Integer(10);
    public static final Integer JDBC = new Integer(11);
    public static final Integer JOB = new Integer(12);
    public static final Integer MESSAGE = new Integer(13);
    public static final Integer NETSERVER = new Integer(14);
    public static final Integer NUMERIC_DATA_TYPES = new Integer(15);
    public static final Integer PCML = new Integer(16);
    public static final Integer PRINT = new Integer(17);
    public static final Integer PROGRAM_CALL = new Integer(18);
    public static final Integer RECORD_LEVEL_ACCESS = new Integer(19);
    public static final Integer SECURE_AS400 = new Integer(20);
    public static final Integer SERVICE_PROGRAM_CALL = new Integer(21);
    public static final Integer SYSTEM_STATUS = new Integer(22);
    public static final Integer SYSTEM_VALUE = new Integer(23);
    public static final Integer TRACE = new Integer(24);
    public static final Integer USER = new Integer(25);
    public static final Integer USER_SPACE = new Integer(26);
    public static final Integer AS400_VISUAL = new Integer(27);
    public static final Integer COMMAND_CALL_VISUAL = new Integer(28);
    public static final Integer DATA_QUEUE_VISUAL = new Integer(29);
    public static final Integer INTEGRATED_FILE_SYSTEM_VISUAL = new Integer(30);
    public static final Integer JAVA_APPLICATION_CALL_VISUAL = new Integer(31);
    public static final Integer JDBC_VISUAL = new Integer(32);
    public static final Integer JOB_VISUAL = new Integer(33);
    public static final Integer MESSAGE_VISUAL = new Integer(34);
    public static final Integer PRINT_VISUAL = new Integer(35);
    public static final Integer PROGRAM_CALL_VISUAL = new Integer(36);
    public static final Integer RECORD_LEVEL_ACCESS_VISUAL = new Integer(37);
    public static final Integer USER_VISUAL = new Integer(38);
    private static final String CIAA = "com/ibm/as400/access/";
    private static final String CIAD = "com/ibm/as400/data/";
    private static final String CIAV = "com/ibm/as400/vaccess/";
    private static final String CIASA = "com/ibm/as400/security/auth/";
    private static final String COPYRIGHT_ENTRY_NAME = "com/ibm/as400/access/Copyright.class";
    static final String DEFAULT_SOURCE_JAR_NAME = "jt400.jar";
    private Vector components_ = new Vector();
    private Vector languages_ = new Vector();
    private File languageDirectory_ = new File(System.getProperty("user.dir"));
    private Vector ccsids_ = new Vector();
    private Vector ccsidsExcluded_ = new Vector();
    private boolean noProxy_;
    private boolean excludeResource_;
    private boolean excludeJDBC_;
    private boolean excludeRLA_;
    private boolean excludeSysVal_;
    private boolean excludeDirEntryClass_;
    private boolean excludeSecAuth_;
    private boolean excludeValidationList_;
    private boolean excludePathOptimizer_;
    private boolean excludeBidi_;
    private Arguments arguments_ = new Arguments();

    public ToolboxJarMaker() {
        super("com/ibm/as400");
        File file = new File(DEFAULT_SOURCE_JAR_NAME);
        this.setSourceJar(file);
    }

    private void addLanguageFiles(File file, Vector vector, JarMaker.JarMap jarMap) {
        Object object;
        if (file == null) {
            throw new NullPointerException("baseDirectory");
        }
        if (vector == null) {
            throw new NullPointerException("neededJarEntries");
        }
        if (jarMap == null) {
            throw new NullPointerException("jarMap");
        }
        Vector vector2 = new Vector();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            object = (String)enumeration.nextElement();
            if (((String)object).lastIndexOf("MRI") <= ((String)object).lastIndexOf(47)) continue;
            vector2.addElement(object);
        }
        if (this.languages_.size() != 0) {
            object = new Vector<File>();
            Enumeration enumeration2 = this.languages_.elements();
            while (enumeration2.hasMoreElements()) {
                String string = (String)enumeration2.nextElement();
                Enumeration enumeration3 = vector2.elements();
                while (enumeration3.hasMoreElements()) {
                    String string2 = (String)enumeration3.nextElement();
                    String string3 = ToolboxJarMaker.addMriSuffix(string2, string);
                    String string4 = JarMaker.generateFilePath(this.languageDirectory_, string3);
                    ((Vector)object).addElement(new File(string4));
                }
            }
            this.setAdditionalFiles((Vector)object, file);
        } else {
            object = vector2.elements();
            while (object.hasMoreElements()) {
                String string = (String)object.nextElement();
                String string5 = ToolboxJarMaker.addMriSuffix(string, "en");
                String string6 = ToolboxJarMaker.addMriSuffix(string, "en_US");
                if (jarMap.contains(string5) && !vector.contains(string5)) {
                    vector.addElement(string5);
                }
                if (!jarMap.contains(string6) || vector.contains(string6)) continue;
                vector.addElement(string6);
            }
        }
    }

    private static String addMriSuffix(String string, String string2) {
        int n = string.lastIndexOf(46);
        if (n == -1) {
            n = string.length();
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        stringBuffer.insert(n, "_" + string2);
        return stringBuffer.toString();
    }

    private static void addPcmlFiles(Vector vector, JarMaker.JarMap jarMap) {
        Object object;
        if (vector == null) {
            throw new NullPointerException("neededJarEntries");
        }
        if (jarMap == null) {
            throw new NullPointerException("jarMap");
        }
        Enumeration enumeration = jarMap.elements();
        Vector<Object> vector2 = new Vector<Object>();
        while (enumeration.hasMoreElements()) {
            object = (String)enumeration.nextElement();
            if (!((String)object).endsWith(".pcml") && !((String)object).endsWith(".pcml.ser")) continue;
            vector2.addElement(object);
        }
        object = vector2.elements();
        while (object.hasMoreElements()) {
            String string = (String)object.nextElement();
            String string2 = ToolboxJarMaker.getClassEntryForPcml(string);
            if (!vector.contains(string2) || vector.contains(string)) continue;
            vector.addElement(string);
        }
    }

    Vector adjustDependencies1(Vector vector, JarMaker.JarMap jarMap) throws IOException {
        if (this.ccsids_.size() != 0) {
            if (this.components_.contains(INTEGRATED_FILE_SYSTEM)) {
                JarMaker.addElement(this.ccsids_, new Integer(61952));
            }
            JarMaker.addElement(this.ccsids_, new Integer(13488));
            Enumeration enumeration = this.ccsids_.elements();
            while (enumeration.hasMoreElements()) {
                Integer n = (Integer)enumeration.nextElement();
                String string = "com/ibm/as400/access/ConvTable" + n.toString() + ".class";
                if (vector.contains(string)) continue;
                if (jarMap.contains(string)) {
                    vector.addElement(string);
                    continue;
                }
                System.err.println("Warning: No entry in source file for CCSID " + n.toString() + ".");
            }
        }
        if (this.noProxy_) {
            JarMaker.addElement(this.dependenciesToExclude_, "com/ibm/as400/access/ProxyClientConnection.class");
            JarMaker.addElement(this.dependenciesToExclude_, "com/ibm/as400/access/ProxyReturnValue.class");
            if (this.verbose_) {
                System.out.println("Excluding Proxy* class dependencies.");
            }
        }
        if (this.excludeSomeDependencies_) {
            boolean bl = this.getPackages().contains("com.ibm.as400.access");
            if (!(bl || this.components_.isEmpty() || this.components_.contains(JDBC) || this.components_.contains(JDBC_VISUAL))) {
                this.excludeJDBC_ = true;
                if (this.verbose_) {
                    System.out.println("Excluding JDBC classes.");
                }
                if (!this.getFilesRequired().contains("com/ibm/as400/access/DBBaseReplyDS.class")) {
                    JarMaker.addElement(this.dependenciesToExclude_, "com/ibm/as400/access/DBBaseReplyDS.class");
                    if (this.verbose_) {
                        System.out.println("Excluding dependency: com/ibm/as400/access/DBBaseReplyDS.class");
                    }
                    if (!this.getFilesRequired().contains("com/ibm/as400/access/DBDSPool.class")) {
                        JarMaker.addElement(this.dependenciesToExclude_, "com/ibm/as400/access/DBDSPool.class");
                        if (this.verbose_) {
                            System.out.println("Excluding dependency: com/ibm/as400/access/DBDSPool.class");
                        }
                    }
                }
            }
            if (!(this.getPackages().contains("com.ibm.as400.resource") || this.getFilesRequired().contains("com/ibm/as400/resource/RJob.class") || this.getFilesRequired().contains("com/ibm/as400/access/JobLog.class") || this.components_.isEmpty() || this.components_.contains(JOB) || this.components_.contains(JOB_VISUAL))) {
                this.excludeResource_ = true;
                JarMaker.addElement(this.dependenciesToExclude_, "com/ibm/as400/resource/RJob.class");
                if (this.verbose_) {
                    System.out.println("Excluding package com.ibm.as400.resource");
                }
            }
            if (!(bl || ToolboxJarMaker.containsPattern(this.getFilesRequired(), "com/ibm/as400/access/DDM") || ToolboxJarMaker.containsPattern(this.getFilesRequired(), "com/ibm/as400/access/Record") || this.components_.isEmpty() || this.components_.contains(RECORD_LEVEL_ACCESS) || this.components_.contains(RECORD_LEVEL_ACCESS_VISUAL) || this.components_.contains(DATA_DESCRIPTION))) {
                this.excludeRLA_ = true;
                JarMaker.addElement(this.dependenciesToExclude_, "com/ibm/as400/access/Record.class");
                JarMaker.addElement(this.dependenciesToExclude_, "com/ibm/as400/access/CharacterFieldDescription.class");
                if (this.verbose_) {
                    System.out.println("Excluding Record Level Access classes.");
                }
            }
            if (this.excludeJDBC_) {
                JarMaker.addElement(this.dependenciesToExclude_, "com/ibm/as400/access/AS400JDBCConnection.class");
                JarMaker.addElement(this.dependenciesToExclude_, "com/ibm/as400/access/JDProperties.class");
                if (this.verbose_) {
                    System.out.println("Excluding dependencies: com/ibm/as400/access/AS400JDBCConnection.class, com/ibm/as400/access/JDProperties.class");
                }
            }
            if (this.excludeJDBC_ && this.excludeRLA_) {
                JarMaker.addElement(this.dependenciesToExclude_, "com/ibm/as400/access/ClassDecoupler.class");
                if (this.verbose_) {
                    System.out.println("Excluding dependency: com/ibm/as400/access/ClassDecoupler.class");
                }
            }
            if (!(bl || ToolboxJarMaker.containsPattern(this.getFilesRequired(), "com/ibm/as400/access/SystemValue") || ToolboxJarMaker.containsPattern(this.getFilesRequired(), "com/ibm/as400/access/SV") || this.components_.isEmpty() || this.components_.contains(SYSTEM_VALUE))) {
                this.excludeSysVal_ = true;
                if (this.verbose_) {
                    System.out.println("Excluding System Value classes.");
                }
            }
            if (!this.getPackages().contains("com.ibm.as400.security.auth") && !this.getFilesRequired().contains("com/ibm/as400/security/auth/ProfileTokenCredential.class")) {
                this.excludeSecAuth_ = true;
                JarMaker.addElement(this.dependenciesToExclude_, "com/ibm/as400/security/auth/ProfileTokenCredential.class");
                JarMaker.addElement(this.dependenciesToExclude_, "com/ibm/as400/security/auth/AS400Credential.class");
                if (this.verbose_) {
                    System.out.println("Excluding ProfileTokenCredential dependencies.");
                }
            }
            if (!(bl || ToolboxJarMaker.containsPattern(this.getFilesRequired(), "com/ibm/as400/access/Directory") || this.components_.isEmpty() || this.components_.contains(USER) || this.components_.contains(USER_VISUAL))) {
                this.excludeDirEntryClass_ = true;
                if (this.verbose_) {
                    System.out.println("Excluding DirectoryEntry classes.");
                }
            }
            if (!(bl || this.components_.isEmpty() || this.components_.contains(JOB) || this.components_.contains(JOB_VISUAL))) {
                if (this.verbose_) {
                    System.out.println("Excluding Job classes from dependency analysis.");
                }
                if (!this.getFilesRequired().contains("com/ibm/as400/access/Job.class")) {
                    JarMaker.addElement(this.dependenciesToExclude_, "com/ibm/as400/access/Job.class");
                    if (this.verbose_) {
                        System.out.println("Excluding dependency: com/ibm/as400/access/Job.class");
                    }
                }
            }
            if (!bl && !ToolboxJarMaker.containsPattern(this.getFilesRequired(), "com/ibm/as400/access/ValidationList")) {
                this.excludeValidationList_ = true;
                JarMaker.addElement(this.dependenciesToExclude_, "com/ibm/as400/access/ValidationList.class");
                if (this.verbose_) {
                    System.out.println("Excluding ValidationList classes.");
                }
            }
            if (!this.getPackages().contains("com.ibm.as400.util") && !this.getFilesRequired().contains("com/ibm/as400/util/AS400ClassPathOptimizer.class")) {
                this.excludePathOptimizer_ = true;
                if (this.verbose_) {
                    System.out.println("Excluding AS400ClassPathOptimizer.");
                }
            }
            if (ToolboxJarMaker.isOkToExcludeBidi(this.components_, this.languages_, this.ccsids_)) {
                this.excludeBidi_ = true;
            }
        }
        return vector;
    }

    private static final boolean isOkToExcludeBidi(Vector vector, Vector vector2, Vector vector3) {
        if (vector2.isEmpty() && vector3.isEmpty()) {
            return false;
        }
        if (vector2.contains("ar") || vector2.contains("he")) {
            return false;
        }
        if (vector3.isEmpty()) {
            return true;
        }
        int[] nArray = new int[vector3.size()];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = (Integer)vector3.get(i);
        }
        Arrays.sort(nArray);
        return !JarMaker.contains(nArray, 1046) && !JarMaker.contains(nArray, 1089) && !JarMaker.contains(nArray, 1255) && !JarMaker.contains(nArray, 1256) && !JarMaker.contains(nArray, 12708) && !JarMaker.contains(nArray, 420) && !JarMaker.contains(nArray, 424) && !JarMaker.contains(nArray, 425) && !JarMaker.contains(nArray, 5351) && !JarMaker.contains(nArray, 62211) && !JarMaker.contains(nArray, 62224) && !JarMaker.contains(nArray, 62235) && !JarMaker.contains(nArray, 62245) && !JarMaker.contains(nArray, 62251) && !JarMaker.contains(nArray, 8612) && !JarMaker.contains(nArray, 862) && !JarMaker.contains(nArray, 864) && !JarMaker.contains(nArray, 916);
    }

    Vector adjustDependencies2(Vector vector, JarMaker.JarMap jarMap) throws IOException {
        Object object;
        Object object2;
        Enumeration enumeration;
        Vector<Object> vector2;
        String string = "com/ibm/as400/access/ConvTableJavaMap.class";
        boolean bl = !jarMap.contains(string);
        if (vector.contains("com/ibm/as400/access/ConvTable.class")) {
            String string2;
            Serializable serializable;
            if (this.ccsids_.size() == 0) {
                if (!bl) {
                    vector2 = new Vector();
                    enumeration = jarMap.elements();
                    while (enumeration.hasMoreElements()) {
                        object2 = (String)enumeration.nextElement();
                        object = ((String)object2).substring(1 + ((String)object2).lastIndexOf(47));
                        if (!((String)object).startsWith("ConvTable") || !Character.isDigit(((String)object).charAt(9))) continue;
                        vector2.addElement(object2);
                    }
                    object2 = vector2.elements();
                    object = jarMap.getEntryNames();
                    serializable = new Vector();
                    while (object2.hasMoreElements()) {
                        string2 = (String)object2.nextElement();
                        if (!((Vector)object).contains(string2)) continue;
                        ((Vector)object).removeElement(string2);
                        this.analyzeJarEntry(string2, (Vector)object, (Vector)serializable, jarMap);
                        JarMaker.addElement(serializable, string2);
                    }
                    JarMaker.copyVector(serializable, vector, true);
                }
            } else if (bl && this.ccsids_.size() != 0) {
                vector2 = new Vector<Object>();
                enumeration = vector.elements();
                while (enumeration.hasMoreElements()) {
                    object2 = (String)enumeration.nextElement();
                    object = ((String)object2).substring(1 + ((String)object2).lastIndexOf(47));
                    if (!((String)object).startsWith("ConvTable") || !Character.isDigit(((String)object).charAt(9))) continue;
                    vector2.addElement(object2);
                }
                object2 = vector2.elements();
                while (object2.hasMoreElements()) {
                    vector.removeElement((String)object2.nextElement());
                }
                if (this.components_.contains(INTEGRATED_FILE_SYSTEM)) {
                    JarMaker.addElement(this.ccsids_, new Integer(61952));
                }
                JarMaker.addElement(this.ccsids_, new Integer(13488));
                object = this.ccsids_.elements();
                while (object.hasMoreElements()) {
                    serializable = (Integer)object.nextElement();
                    string2 = "com/ibm/as400/access/ConvTable" + ((Integer)serializable).toString() + ".class";
                    if (vector.contains(string2)) continue;
                    if (jarMap.contains(string2)) {
                        vector.addElement(string2);
                        continue;
                    }
                    System.err.println("Warning: No entry in source file for CCSID " + ((Integer)serializable).toString() + ".");
                }
            }
        }
        if (this.ccsidsExcluded_.size() != 0) {
            vector2 = this.ccsidsExcluded_.elements();
            while (vector2.hasMoreElements()) {
                enumeration = (Integer)vector2.nextElement();
                object2 = "com/ibm/as400/access/ConvTable" + ((Integer)((Object)enumeration)).toString() + ".class";
                vector.removeElement(object2);
                if (jarMap.contains((String)object2)) continue;
                System.err.println("Warning: No entry in source file for excluded CCSID " + ((Integer)((Object)enumeration)).toString() + ".");
            }
        }
        JarMaker.removePackageFiles(vector, jarMap, this.getPackagesExcluded());
        JarMaker.addPackageFiles(vector, jarMap, this.getPackages());
        this.addLanguageFiles(this.languageDirectory_, vector, jarMap);
        ToolboxJarMaker.addPcmlFiles(vector, jarMap);
        if (this.noProxy_) {
            vector2 = new Vector();
            enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                object2 = (String)enumeration.nextElement();
                object = ((String)object2).substring(1 + ((String)object2).lastIndexOf(47));
                if (!((String)object).endsWith(".class") || !((String)(object = ((String)object).substring(0, ((String)object).lastIndexOf(".class")))).endsWith("Proxy") && !((String)object).endsWith("ProxyImpl") && !((String)object).startsWith("Proxy") && !((String)object).startsWith("Px")) continue;
                vector2.addElement(object2);
                if (!this.verbose_) continue;
                System.out.println("Excluding proxy class: " + (String)object);
            }
            object2 = vector2.elements();
            while (object2.hasMoreElements()) {
                vector.removeElement((String)object2.nextElement());
            }
        }
        if (this.excludeJDBC_) {
            vector.removeElement("com/ibm/as400/access/DBDSPool.class");
        }
        if (this.excludeResource_) {
            JarMaker.removeElements(vector, "com/ibm/as400/resource/", 1);
        }
        if (this.excludeRLA_) {
            JarMaker.removeElements(vector, "com/ibm/as400/access/Record", 1);
            JarMaker.removeElements(vector, "FieldDescription.class", 2);
        }
        if (this.excludeSysVal_) {
            JarMaker.removeElements(vector, "com/ibm/as400/access/SV", 1);
        }
        if (this.excludeSecAuth_) {
            JarMaker.addElement(vector, "com/ibm/as400/security/auth/ProfileTokenCredential.class");
            JarMaker.addElement(vector, "com/ibm/as400/security/auth/AS400Credential.class");
            JarMaker.addElement(vector, "com/ibm/as400/security/auth/AS400BasicAuthenticationCredential.class");
            JarMaker.addElement(vector, "com/ibm/as400/security/auth/AS400SwappableCredential.class");
        }
        if (this.excludeDirEntryClass_) {
            JarMaker.removeElements(vector, "com/ibm/as400/access/DirectoryEntry", 1);
        }
        if (this.excludeValidationList_) {
            vector.removeElement("com/ibm/as400/access/PersistenceException.class");
            JarMaker.removeElements(vector, "com/ibm/as400/access/ValidationList", 1);
        }
        if (this.excludePathOptimizer_) {
            vector.removeElement("com/ibm/as400/util/AS400ClassPathOptimizer.class");
        }
        if (this.excludeBidi_) {
            JarMaker.removeElements(vector, "Arabic", 3);
        }
        if (jarMap.contains(COPYRIGHT_ENTRY_NAME)) {
            JarMaker.addElement(vector, COPYRIGHT_ENTRY_NAME);
        }
        return vector;
    }

    private static boolean containsPattern(Vector vector, String string) {
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            if (!string2.startsWith(string)) continue;
            return true;
        }
        return false;
    }

    private static Vector getBaseDependenciesForComponent(Integer n, boolean bl) {
        Vector<String> vector = new Vector<String>();
        if (n.equals(AS400)) {
            vector.addElement("com/ibm/as400/access/AS400.class");
            if (bl) {
                vector.addElement("com/ibm/as400/access/AS400BeanInfo.class");
            }
        } else if (n.equals(COMMAND_CALL)) {
            vector.addElement("com/ibm/as400/access/CommandCall.class");
            if (bl) {
                vector.addElement("com/ibm/as400/access/CommandCallBeanInfo.class");
            }
        } else if (n.equals(CONNECTION_POOL)) {
            vector.addElement("com/ibm/as400/access/AS400ConnectionPool.class");
            if (bl) {
                vector.addElement("com/ibm/as400/access/AS400ConnectionPoolBeanInfo.class");
                vector.addElement("com/ibm/as400/access/ConnectionPoolBeanInfo.class");
            }
        } else if (n.equals(DATA_AREA)) {
            vector.addElement("com/ibm/as400/access/CharacterDataArea.class");
            vector.addElement("com/ibm/as400/access/DecimalDataArea.class");
            vector.addElement("com/ibm/as400/access/LocalDataArea.class");
            vector.addElement("com/ibm/as400/access/LogicalDataArea.class");
            if (bl) {
                vector.addElement("com/ibm/as400/access/CharacterDataAreaBeanInfo.class");
                vector.addElement("com/ibm/as400/access/DecimalDataAreaBeanInfo.class");
                vector.addElement("com/ibm/as400/access/LocalDataAreaBeanInfo.class");
                vector.addElement("com/ibm/as400/access/LogicalDataAreaBeanInfo.class");
            }
        } else if (n.equals(DATA_DESCRIPTION)) {
            vector.addElement("com/ibm/as400/access/ArrayFieldDescription.class");
            vector.addElement("com/ibm/as400/access/BinaryFieldDescription.class");
            vector.addElement("com/ibm/as400/access/CharacterFieldDescription.class");
            vector.addElement("com/ibm/as400/access/DateFieldDescription.class");
            vector.addElement("com/ibm/as400/access/DBCSEitherFieldDescription.class");
            vector.addElement("com/ibm/as400/access/DBCSGraphicFieldDescription.class");
            vector.addElement("com/ibm/as400/access/DBCSOnlyFieldDescription.class");
            vector.addElement("com/ibm/as400/access/DBCSOpenFieldDescription.class");
            vector.addElement("com/ibm/as400/access/FloatFieldDescription.class");
            vector.addElement("com/ibm/as400/access/HexFieldDescription.class");
            vector.addElement("com/ibm/as400/access/PackedDecimalFieldDescription.class");
            vector.addElement("com/ibm/as400/access/TimeFieldDescription.class");
            vector.addElement("com/ibm/as400/access/TimestampFieldDescription.class");
            vector.addElement("com/ibm/as400/access/VariableLengthFieldDescription.class");
            vector.addElement("com/ibm/as400/access/ZonedDecimalFieldDescription.class");
            vector.addElement("com/ibm/as400/access/AS400Array.class");
            vector.addElement("com/ibm/as400/access/AS400Bin2.class");
            vector.addElement("com/ibm/as400/access/AS400Bin4.class");
            vector.addElement("com/ibm/as400/access/AS400ByteArray.class");
            vector.addElement("com/ibm/as400/access/AS400Float4.class");
            vector.addElement("com/ibm/as400/access/AS400Float8.class");
            vector.addElement("com/ibm/as400/access/AS400PackedDecimal.class");
            vector.addElement("com/ibm/as400/access/AS400Structure.class");
            vector.addElement("com/ibm/as400/access/AS400Text.class");
            vector.addElement("com/ibm/as400/access/AS400UnsignedBin2.class");
            vector.addElement("com/ibm/as400/access/AS400UnsignedBin4.class");
            vector.addElement("com/ibm/as400/access/AS400ZonedDecimal.class");
            vector.addElement("com/ibm/as400/access/Record.class");
            if (bl) {
                vector.addElement("com/ibm/as400/access/AS400ArrayBeanInfo.class");
                vector.addElement("com/ibm/as400/access/AS400StructureBeanInfo.class");
                vector.addElement("com/ibm/as400/access/RecordBeanInfo.class");
                vector.addElement("com/ibm/as400/access/RecordFormatBeanInfo.class");
            }
        } else if (n.equals(DATA_QUEUE)) {
            vector.addElement("com/ibm/as400/access/DataQueue.class");
            vector.addElement("com/ibm/as400/access/KeyedDataQueue.class");
            if (bl) {
                vector.addElement("com/ibm/as400/access/BaseDataQueueBeanInfo.class");
                vector.addElement("com/ibm/as400/access/DataQueueAttributesBeanInfo.class");
                vector.addElement("com/ibm/as400/access/DataQueueBeanInfo.class");
                vector.addElement("com/ibm/as400/access/KeyedDataQueueBeanInfo.class");
            }
        } else if (n.equals(DIGITAL_CERTIFICATE)) {
            vector.addElement("com/ibm/as400/access/AS400Certificate.class");
            vector.addElement("com/ibm/as400/access/AS400CertificateAttribute.class");
            vector.addElement("com/ibm/as400/access/AS400CertificateUserProfileUtil.class");
            vector.addElement("com/ibm/as400/access/AS400CertificateVldlUtil.class");
            if (bl) {
                vector.addElement("com/ibm/as400/access/AS400CertificateUserProfileUtilBeanInfo.class");
                vector.addElement("com/ibm/as400/access/AS400CertificateUtilBeanInfo.class");
                vector.addElement("com/ibm/as400/access/AS400CertificateVldlUtilBeanInfo.class");
            }
        } else if (n.equals(FTP)) {
            vector.addElement("com/ibm/as400/access/AS400FTP.class");
            if (bl) {
                vector.addElement("com/ibm/as400/access/AS400FTPBeanInfo.class");
                vector.addElement("com/ibm/as400/access/FTPBeanInfo.class");
            }
        } else if (n.equals(INTEGRATED_FILE_SYSTEM)) {
            vector.addElement("com/ibm/as400/access/IFSFile.class");
            vector.addElement("com/ibm/as400/access/IFSRandomAccessFile.class");
            vector.addElement("com/ibm/as400/access/IFSTextFileInputStream.class");
            vector.addElement("com/ibm/as400/access/IFSTextFileOutputStream.class");
            vector.addElement("com/ibm/as400/access/IFSFileReader.class");
            vector.addElement("com/ibm/as400/access/IFSFileWriter.class");
            if (bl) {
                vector.addElement("com/ibm/as400/access/IFSFileBeanInfo.class");
                vector.addElement("com/ibm/as400/access/IFSRandomAccessFileBeanInfo.class");
                vector.addElement("com/ibm/as400/access/IFSTextFileInputStreamBeanInfo.class");
                vector.addElement("com/ibm/as400/access/IFSTextFileOutputStreamBeanInfo.class");
            }
        } else if (n.equals(JAAS)) {
            vector.addElement("com/ibm/as400/security/auth/ProfileHandleCredential.class");
            vector.addElement("com/ibm/as400/security/auth/ProfileTokenCredential.class");
            vector.addElement("com/ibm/as400/security/auth/UserProfilePrincipal.class");
            if (bl) {
                vector.addElement("com/ibm/as400/security/auth/ProfileHandleCredentialBeanInfo.class");
                vector.addElement("com/ibm/as400/security/auth/ProfileTokenCredentialBeanInfo.class");
                vector.addElement("com/ibm/as400/security/auth/UserProfilePrincipalBeanInfo.class");
            }
        } else if (n.equals(JAVA_APPLICATION_CALL)) {
            vector.addElement("com/ibm/as400/access/JavaApplicationCall.class");
            if (bl) {
                vector.addElement("com/ibm/as400/access/JavaApplicationCallBeanInfo.class");
            }
        } else if (n.equals(JDBC)) {
            vector.addElement("com/ibm/as400/access/AS400JDBCDriver.class");
            vector.addElement("com/ibm/as400/access/AS400JDBCRowSet.class");
            vector.addElement("com/ibm/as400/access/AS400JDBCXAConnection.class");
            vector.addElement("com/ibm/as400/access/AS400JDBCConnectionPool.class");
            if (bl) {
                vector.addElement("com/ibm/as400/access/AS400JDBCRowSetBeanInfo.class");
                vector.addElement("com/ibm/as400/access/AS400JDBCDataSourceBeanInfo.class");
                vector.addElement("com/ibm/as400/access/AS400JDBCXADataSourceBeanInfo.class");
                vector.addElement("com/ibm/as400/access/AS400JDBCConnectionPoolBeanInfo.class");
                vector.addElement("com/ibm/as400/access/AS400JDBCConnectionPoolDataSourceBeanInfo.class");
                vector.addElement("com/ibm/as400/access/ConnectionPoolBeanInfo.class");
            }
        } else if (n.equals(JOB)) {
            vector.addElement("com/ibm/as400/access/JobList.class");
            vector.addElement("com/ibm/as400/access/JobLog.class");
            if (bl) {
                // empty if block
            }
        } else if (n.equals(MESSAGE)) {
            vector.addElement("com/ibm/as400/access/MessageQueue.class");
            if (bl) {
                // empty if block
            }
        } else if (n.equals(NETSERVER)) {
            vector.addElement("com/ibm/as400/access/ISeriesNetServer.class");
            vector.addElement("com/ibm/as400/access/NetServer.class");
            if (bl) {
                vector.addElement("com/ibm/as400/access/NetServerBeanInfo.class");
                vector.addElement("com/ibm/as400/access/NetServerFileShareBeanInfo.class");
                vector.addElement("com/ibm/as400/access/NetServerPrintShareBeanInfo.class");
            }
        } else if (n.equals(NUMERIC_DATA_TYPES)) {
            vector.addElement("com/ibm/as400/access/AS400Array.class");
            vector.addElement("com/ibm/as400/access/AS400Bin2.class");
            vector.addElement("com/ibm/as400/access/AS400Bin4.class");
            vector.addElement("com/ibm/as400/access/AS400ByteArray.class");
            vector.addElement("com/ibm/as400/access/AS400Float4.class");
            vector.addElement("com/ibm/as400/access/AS400Float8.class");
            vector.addElement("com/ibm/as400/access/AS400PackedDecimal.class");
            vector.addElement("com/ibm/as400/access/AS400Structure.class");
            vector.addElement("com/ibm/as400/access/AS400UnsignedBin2.class");
            vector.addElement("com/ibm/as400/access/AS400UnsignedBin4.class");
            vector.addElement("com/ibm/as400/access/AS400ZonedDecimal.class");
            if (bl) {
                vector.addElement("com/ibm/as400/access/AS400ArrayBeanInfo.class");
                vector.addElement("com/ibm/as400/access/AS400StructureBeanInfo.class");
            }
        } else if (n.equals(PCML)) {
            vector.addElement("com/ibm/as400/data/ProgramCallDocument.class");
            vector.addElement("com/ibm/as400/data/RecordFormatDocument.class");
            if (bl) {
                // empty if block
            }
        } else if (n.equals(PRINT)) {
            vector.addElement("com/ibm/as400/access/AFPResourceList.class");
            vector.addElement("com/ibm/as400/access/OutputQueueList.class");
            vector.addElement("com/ibm/as400/access/PrinterList.class");
            vector.addElement("com/ibm/as400/access/PrintObjectInputStream.class");
            vector.addElement("com/ibm/as400/access/SpooledFileList.class");
            vector.addElement("com/ibm/as400/access/SpooledFileOutputStream.class");
            vector.addElement("com/ibm/as400/access/SCS3812Writer.class");
            vector.addElement("com/ibm/as400/access/SCS5553Writer.class");
            if (bl) {
                vector.addElement("com/ibm/as400/access/AFPResourceBeanInfo.class");
                vector.addElement("com/ibm/as400/access/AFPResourceListBeanInfo.class");
                vector.addElement("com/ibm/as400/access/OutputQueueBeanInfo.class");
                vector.addElement("com/ibm/as400/access/OutputQueueListBeanInfo.class");
                vector.addElement("com/ibm/as400/access/PrintObjectBeanInfo.class");
                vector.addElement("com/ibm/as400/access/PrintObjectListBeanInfo.class");
                vector.addElement("com/ibm/as400/access/PrinterBeanInfo.class");
                vector.addElement("com/ibm/as400/access/PrinterFileBeanInfo.class");
                vector.addElement("com/ibm/as400/access/PrinterFileListBeanInfo.class");
                vector.addElement("com/ibm/as400/access/PrinterListBeanInfo.class");
                vector.addElement("com/ibm/as400/access/SpooledFileListBeanInfo.class");
                vector.addElement("com/ibm/as400/access/WriterJobListBeanInfo.class");
            }
        } else if (n.equals(PROGRAM_CALL)) {
            vector.addElement("com/ibm/as400/access/ProgramCall.class");
            if (bl) {
                vector.addElement("com/ibm/as400/access/ProgramCallBeanInfo.class");
                vector.addElement("com/ibm/as400/access/ProgramParameterBeanInfo.class");
            }
        } else if (n.equals(RECORD_LEVEL_ACCESS)) {
            vector.addElement("com/ibm/as400/access/AS400FileRecordDescription.class");
            vector.addElement("com/ibm/as400/access/KeyedFile.class");
            vector.addElement("com/ibm/as400/access/SequentialFile.class");
            vector.addElement("com/ibm/as400/access/DDMAS400MessageReply.class");
            vector.addElement("com/ibm/as400/access/DDMEndUnitOfWorkReply.class");
            vector.addElement("com/ibm/as400/access/DDMObjectDataStream.class");
            vector.addElement("com/ibm/as400/access/DDMRecordCache.class");
            vector.addElement("com/ibm/as400/access/DDMRequestDataStream.class");
            vector.addElement("com/ibm/as400/access/DDMS38IOFB.class");
            vector.addElement("com/ibm/as400/access/ArrayFieldDescription.class");
            vector.addElement("com/ibm/as400/access/BinaryFieldDescription.class");
            vector.addElement("com/ibm/as400/access/CharacterFieldDescription.class");
            vector.addElement("com/ibm/as400/access/DBCSEitherFieldDescription.class");
            vector.addElement("com/ibm/as400/access/DBCSGraphicFieldDescription.class");
            vector.addElement("com/ibm/as400/access/DBCSOnlyFieldDescription.class");
            vector.addElement("com/ibm/as400/access/DBCSOpenFieldDescription.class");
            vector.addElement("com/ibm/as400/access/DateFieldDescription.class");
            vector.addElement("com/ibm/as400/access/FloatFieldDescription.class");
            vector.addElement("com/ibm/as400/access/HexFieldDescription.class");
            vector.addElement("com/ibm/as400/access/PackedDecimalFieldDescription.class");
            vector.addElement("com/ibm/as400/access/TimeFieldDescription.class");
            vector.addElement("com/ibm/as400/access/TimestampFieldDescription.class");
            vector.addElement("com/ibm/as400/access/ZonedDecimalFieldDescription.class");
            if (bl) {
                vector.addElement("com/ibm/as400/access/AS400FileBeanInfo.class");
                vector.addElement("com/ibm/as400/access/AS400FileRecordDescriptionBeanInfo.class");
                vector.addElement("com/ibm/as400/access/KeyedFileBeanInfo.class");
                vector.addElement("com/ibm/as400/access/SequentialFileBeanInfo.class");
            }
        } else if (n.equals(SECURE_AS400)) {
            vector.addElement("com/ibm/as400/access/SecureAS400.class");
            if (bl) {
                vector.addElement("com/ibm/as400/access/SecureAS400BeanInfo.class");
            }
        } else if (n.equals(SERVICE_PROGRAM_CALL)) {
            vector.addElement("com/ibm/as400/access/ServiceProgramCall.class");
            if (bl) {
                vector.addElement("com/ibm/as400/access/ServiceProgramCallBeanInfo.class");
            }
        } else if (n.equals(SYSTEM_STATUS)) {
            vector.addElement("com/ibm/as400/access/SystemStatus.class");
            vector.addElement("com/ibm/as400/access/SystemPool.class");
            if (bl) {
                vector.addElement("com/ibm/as400/access/SystemStatusBeanInfo.class");
                vector.addElement("com/ibm/as400/access/SystemPoolBeanInfo.class");
            }
        } else if (n.equals(SYSTEM_VALUE)) {
            vector.addElement("com/ibm/as400/access/SystemValueList.class");
            if (bl) {
                vector.addElement("com/ibm/as400/access/SystemValueListBeanInfo.class");
                vector.addElement("com/ibm/as400/access/SystemValueBeanInfo.class");
            }
        } else if (n.equals(TRACE)) {
            vector.addElement("com/ibm/as400/access/Trace.class");
        } else if (n.equals(USER)) {
            vector.addElement("com/ibm/as400/access/UserList.class");
            if (bl) {
                // empty if block
            }
        } else if (n.equals(USER_SPACE)) {
            vector.addElement("com/ibm/as400/access/UserSpace.class");
            if (bl) {
                vector.addElement("com/ibm/as400/access/UserSpaceBeanInfo.class");
            }
        } else if (n.equals(AS400_VISUAL)) {
            vector.addElement("com/ibm/as400/vaccess/AS400ListPane.class");
            vector.addElement("com/ibm/as400/vaccess/AS400ExplorerPane.class");
            vector.addElement("com/ibm/as400/vaccess/ErrorDialogAdapter.class");
            if (bl) {
                vector.addElement("com/ibm/as400/vaccess/AS400DetailsModelBeanInfo.class");
                vector.addElement("com/ibm/as400/vaccess/AS400DetailsPaneBeanInfo.class");
                vector.addElement("com/ibm/as400/vaccess/AS400ExplorerPaneBeanInfo.class");
                vector.addElement("com/ibm/as400/vaccess/AS400ListModelBeanInfo.class");
                vector.addElement("com/ibm/as400/vaccess/AS400ListPaneBeanInfo.class");
                vector.addElement("com/ibm/as400/vaccess/AS400TreeModelBeanInfo.class");
                vector.addElement("com/ibm/as400/vaccess/AS400TreePaneBeanInfo.class");
                vector.addElement("com/ibm/as400/vaccess/ErrorDialogAdapterBeanInfo.class");
                vector.addElement("com/ibm/as400/vaccess/VActionAdapterBeanInfo.class");
                vector.addElement("com/ibm/as400/vaccess/VPropertiesActionBeanInfo.class");
                vector.addElement("com/ibm/as400/vaccess/WorkingCursorAdapterBeanInfo.class");
            }
        } else if (n.equals(COMMAND_CALL_VISUAL)) {
            vector.addElement("com/ibm/as400/vaccess/CommandCallButton.class");
            vector.addElement("com/ibm/as400/vaccess/CommandCallMenuItem.class");
            if (bl) {
                vector.addElement("com/ibm/as400/vaccess/CommandCallButtonBeanInfo.class");
                vector.addElement("com/ibm/as400/vaccess/CommandCallMenuItemBeanInfo.class");
            }
        } else if (n.equals(DATA_QUEUE_VISUAL)) {
            vector.addElement("com/ibm/as400/vaccess/DataQueueDocument.class");
            vector.addElement("com/ibm/as400/vaccess/KeyedDataQueueDocument.class");
            if (bl) {
                vector.addElement("com/ibm/as400/vaccess/DataQueueDocumentBeanInfo.class");
                vector.addElement("com/ibm/as400/vaccess/KeyedDataQueueDocumentBeanInfo.class");
            }
        } else if (n.equals(INTEGRATED_FILE_SYSTEM_VISUAL)) {
            vector.addElement("com/ibm/as400/vaccess/IFSFileDialog.class");
            vector.addElement("com/ibm/as400/vaccess/IFSTextFileDocument.class");
            vector.addElement("com/ibm/as400/vaccess/VIFSDirectory.class");
            vector.addElement("com/ibm/as400/vaccess/AS400ExplorerPane.class");
            vector.addElement("com/ibm/as400/vaccess/AS400ListPane.class");
            if (bl) {
                vector.addElement("com/ibm/as400/vaccess/IFSTextFileDocumentBeanInfo.class");
                vector.addElement("com/ibm/as400/vaccess/VIFSDirectoryBeanInfo.class");
                vector.addElement("com/ibm/as400/vaccess/AS400DetailsModelBeanInfo.class");
                vector.addElement("com/ibm/as400/vaccess/AS400DetailsPaneBeanInfo.class");
                vector.addElement("com/ibm/as400/vaccess/AS400ExplorerPaneBeanInfo.class");
                vector.addElement("com/ibm/as400/vaccess/AS400ListModelBeanInfo.class");
                vector.addElement("com/ibm/as400/vaccess/AS400ListPaneBeanInfo.class");
                vector.addElement("com/ibm/as400/vaccess/AS400TreeModelBeanInfo.class");
                vector.addElement("com/ibm/as400/vaccess/AS400TreePaneBeanInfo.class");
            }
        } else if (n.equals(JAVA_APPLICATION_CALL_VISUAL)) {
            vector.addElement("com/ibm/as400/vaccess/VJavaApplicationCall.class");
            if (bl) {
                vector.addElement("com/ibm/as400/vaccess/VJavaApplicationCallBeanInfo.class");
            }
        } else if (n.equals(JDBC_VISUAL)) {
            vector.addElement("com/ibm/as400/vaccess/SQLResultSetFormPane.class");
            vector.addElement("com/ibm/as400/vaccess/SQLResultSetTablePane.class");
            vector.addElement("com/ibm/as400/vaccess/SQLStatementButton.class");
            vector.addElement("com/ibm/as400/vaccess/SQLStatementMenuItem.class");
            vector.addElement("com/ibm/as400/vaccess/SQLStatementDocument.class");
            vector.addElement("com/ibm/as400/vaccess/SQLQueryBuilderPane.class");
            if (bl) {
                vector.addElement("com/ibm/as400/vaccess/SQLConnectionBeanInfo.class");
                vector.addElement("com/ibm/as400/vaccess/SQLQueryBuilderPaneBeanInfo.class");
                vector.addElement("com/ibm/as400/vaccess/SQLResultSetFormPaneBeanInfo.class");
                vector.addElement("com/ibm/as400/vaccess/SQLResultSetTableModelBeanInfo.class");
                vector.addElement("com/ibm/as400/vaccess/SQLResultSetTablePaneBeanInfo.class");
                vector.addElement("com/ibm/as400/vaccess/SQLStatementButtonBeanInfo.class");
                vector.addElement("com/ibm/as400/vaccess/SQLStatementDocumentBeanInfo.class");
                vector.addElement("com/ibm/as400/vaccess/SQLStatementMenuItemBeanInfo.class");
            }
        } else if (n.equals(JOB_VISUAL)) {
            vector.addElement("com/ibm/as400/vaccess/VJobList.class");
            vector.addElement("com/ibm/as400/vaccess/AS400ExplorerPane.class");
            vector.addElement("com/ibm/as400/vaccess/AS400ListPane.class");
            if (bl) {
                vector.addElement("com/ibm/as400/vaccess/VJobBeanInfo.class");
                vector.addElement("com/ibm/as400/vaccess/VJobListBeanInfo.class");
                vector.addElement("com/ibm/as400/vaccess/AS400DetailsModelBeanInfo.class");
                vector.addElement("com/ibm/as400/vaccess/AS400DetailsPaneBeanInfo.class");
                vector.addElement("com/ibm/as400/vaccess/AS400ExplorerPaneBeanInfo.class");
                vector.addElement("com/ibm/as400/vaccess/AS400ListModelBeanInfo.class");
                vector.addElement("com/ibm/as400/vaccess/AS400ListPaneBeanInfo.class");
                vector.addElement("com/ibm/as400/vaccess/AS400TreeModelBeanInfo.class");
                vector.addElement("com/ibm/as400/vaccess/AS400TreePaneBeanInfo.class");
            }
        } else if (n.equals(MESSAGE_VISUAL)) {
            vector.addElement("com/ibm/as400/vaccess/VMessageList.class");
            vector.addElement("com/ibm/as400/vaccess/VMessageQueue.class");
            vector.addElement("com/ibm/as400/vaccess/AS400ExplorerPane.class");
            vector.addElement("com/ibm/as400/vaccess/AS400ListPane.class");
            if (bl) {
                vector.addElement("com/ibm/as400/vaccess/VMessageListBeanInfo.class");
                vector.addElement("com/ibm/as400/vaccess/VMessageQueueBeanInfo.class");
                vector.addElement("com/ibm/as400/vaccess/AS400DetailsModelBeanInfo.class");
                vector.addElement("com/ibm/as400/vaccess/AS400DetailsPaneBeanInfo.class");
                vector.addElement("com/ibm/as400/vaccess/AS400ExplorerPaneBeanInfo.class");
                vector.addElement("com/ibm/as400/vaccess/AS400ListModelBeanInfo.class");
                vector.addElement("com/ibm/as400/vaccess/AS400ListPaneBeanInfo.class");
                vector.addElement("com/ibm/as400/vaccess/AS400TreeModelBeanInfo.class");
                vector.addElement("com/ibm/as400/vaccess/AS400TreePaneBeanInfo.class");
            }
        } else if (n.equals(PRINT_VISUAL)) {
            vector.addElement("com/ibm/as400/vaccess/VPrinters.class");
            vector.addElement("com/ibm/as400/vaccess/AS400ExplorerPane.class");
            vector.addElement("com/ibm/as400/vaccess/AS400ListPane.class");
            if (bl) {
                vector.addElement("com/ibm/as400/vaccess/VPrinterBeanInfo.class");
                vector.addElement("com/ibm/as400/vaccess/VPrinterOutputBeanInfo.class");
                vector.addElement("com/ibm/as400/vaccess/VPrintersBeanInfo.class");
                vector.addElement("com/ibm/as400/vaccess/AS400DetailsModelBeanInfo.class");
                vector.addElement("com/ibm/as400/vaccess/AS400DetailsPaneBeanInfo.class");
                vector.addElement("com/ibm/as400/vaccess/AS400ExplorerPaneBeanInfo.class");
                vector.addElement("com/ibm/as400/vaccess/AS400ListModelBeanInfo.class");
                vector.addElement("com/ibm/as400/vaccess/AS400ListPaneBeanInfo.class");
                vector.addElement("com/ibm/as400/vaccess/AS400TreeModelBeanInfo.class");
                vector.addElement("com/ibm/as400/vaccess/AS400TreePaneBeanInfo.class");
            }
        } else if (n.equals(PROGRAM_CALL_VISUAL)) {
            vector.addElement("com/ibm/as400/vaccess/ProgramCallButton.class");
            vector.addElement("com/ibm/as400/vaccess/ProgramCallMenuItem.class");
            if (bl) {
                vector.addElement("com/ibm/as400/vaccess/ProgramCallButtonBeanInfo.class");
                vector.addElement("com/ibm/as400/vaccess/ProgramCallMenuItemBeanInfo.class");
            }
        } else if (n.equals(RECORD_LEVEL_ACCESS_VISUAL)) {
            vector.addElement("com/ibm/as400/vaccess/RecordListFormPane.class");
            vector.addElement("com/ibm/as400/vaccess/RecordListTablePane.class");
            if (bl) {
                vector.addElement("com/ibm/as400/vaccess/RecordListFormPaneBeanInfo.class");
                vector.addElement("com/ibm/as400/vaccess/RecordListTableModelBeanInfo.class");
                vector.addElement("com/ibm/as400/vaccess/RecordListTablePaneBeanInfo.class");
            }
        } else if (n.equals(USER_VISUAL)) {
            vector.addElement("com/ibm/as400/vaccess/VUserList.class");
            vector.addElement("com/ibm/as400/vaccess/AS400ExplorerPane.class");
            vector.addElement("com/ibm/as400/vaccess/AS400ListPane.class");
            if (bl) {
                vector.addElement("com/ibm/as400/vaccess/VUserListBeanInfo.class");
                vector.addElement("com/ibm/as400/vaccess/AS400DetailsModelBeanInfo.class");
                vector.addElement("com/ibm/as400/vaccess/AS400DetailsPaneBeanInfo.class");
                vector.addElement("com/ibm/as400/vaccess/AS400ExplorerPaneBeanInfo.class");
                vector.addElement("com/ibm/as400/vaccess/AS400ListModelBeanInfo.class");
                vector.addElement("com/ibm/as400/vaccess/AS400ListPaneBeanInfo.class");
                vector.addElement("com/ibm/as400/vaccess/AS400TreeModelBeanInfo.class");
                vector.addElement("com/ibm/as400/vaccess/AS400TreePaneBeanInfo.class");
            }
        } else {
            throw new IllegalArgumentException("component (" + n + ")");
        }
        return vector;
    }

    public Vector getCCSIDs() {
        return this.ccsids_;
    }

    public Vector getCCSIDsExcluded() {
        return this.ccsidsExcluded_;
    }

    private static String getClassEntryForPcml(String string) {
        int n = string.lastIndexOf(".pcml");
        return string.substring(0, n) + ".class";
    }

    private static Integer getComponentID(String string) {
        int n;
        String string2 = string.trim();
        Integer n2 = null;
        for (n = 0; n < VALID_COMPONENTS.length; ++n) {
            if (!string2.equalsIgnoreCase(VALID_COMPONENTS[n])) continue;
            n2 = new Integer(n);
            break;
        }
        if (n2 == null) {
            for (n = 0; n < VALID_COMPONENT_ABBREVS.length; ++n) {
                if (!string2.equalsIgnoreCase(VALID_COMPONENT_ABBREVS[n])) continue;
                n2 = new Integer(n);
                break;
            }
        }
        return n2;
    }

    public Vector getComponents() {
        return this.components_;
    }

    public File getLanguageDirectory() {
        return this.languageDirectory_;
    }

    public Vector getLanguages() {
        return this.languages_;
    }

    private static String getShippedLanguageSuffixFor(String string, boolean bl) {
        String string2 = null;
        String string3 = ToolboxJarMaker.normalizeLanguageSuffix(string);
        if (string3.startsWith("en")) {
            if (bl) {
                System.out.println("English MRI files are included by default.");
            }
        } else if (string3.startsWith("de_CH")) {
            string2 = "de_CH";
        } else if (string3.startsWith("de")) {
            string2 = "de";
        } else if (string3.startsWith("es")) {
            string2 = "es";
        } else if (string3.startsWith("fr_BE")) {
            string2 = "fr_BE";
        } else if (string3.startsWith("fr_CA")) {
            string2 = "fr_CA";
        } else if (string3.startsWith("fr_CH")) {
            string2 = "fr_CH";
        } else if (string3.startsWith("fr")) {
            string2 = "fr";
        } else if (string3.startsWith("it_CH")) {
            string2 = "it_CH";
        } else if (string3.startsWith("it")) {
            string2 = "it";
        } else if (string3.startsWith("ja")) {
            string2 = "ja";
        } else if (string3.startsWith("ko")) {
            string2 = "ko";
        } else if (string3.startsWith("zh_TW")) {
            string2 = "zh_TW";
        } else if (string3.startsWith("zh")) {
            string2 = "zh";
        } else if (string3.startsWith("cs")) {
            string2 = "cs";
        } else if (string3.startsWith("hu")) {
            string2 = "hu";
        } else if (string3.startsWith("pl")) {
            string2 = "pl";
        } else {
            System.err.println("Warning: Unsupported language ID specified: " + string + ".");
            string2 = string3;
        }
        return string2;
    }

    private static String normalizeLanguageSuffix(String string) {
        CharSequence charSequence;
        String string2 = string;
        String string3 = string.trim();
        while (string3.charAt(0) == '_') {
            string3 = string3.substring(1);
        }
        while (string3.endsWith("_")) {
            string3 = string3.substring(0, string3.length() - 1);
        }
        if (string3.length() < 2) {
            throw new IllegalArgumentException("language (" + string + ")");
        }
        if (string3.indexOf("_") == 2) {
            string2 = string3;
        } else {
            charSequence = new StringBuffer(string3);
            ((StringBuffer)charSequence).insert(2, '_');
            string2 = ((StringBuffer)charSequence).toString();
        }
        charSequence = string2.substring(0, 2).toLowerCase();
        String string4 = string2.substring(2).toUpperCase();
        String string5 = (String)charSequence + string4;
        return string5;
    }

    private boolean parseArgs(String[] stringArray) {
        boolean bl = false;
        this.reset();
        bl = this.arguments_.parse(stringArray, this);
        return bl;
    }

    public void reset() {
        super.reset();
        this.arguments_ = new Arguments();
        File file = new File(DEFAULT_SOURCE_JAR_NAME);
        this.setSourceJar(file);
        this.components_.removeAllElements();
        this.languages_.removeAllElements();
        this.languageDirectory_ = new File(System.getProperty("user.dir"));
        this.ccsids_.removeAllElements();
        this.ccsidsExcluded_.removeAllElements();
    }

    public void setCCSIDs(Vector vector) {
        if (vector == null) {
            throw new NullPointerException("ccsidList");
        }
        vector = JarMaker.validateList(vector, "CCSID", "java.lang.Integer", this.verbose_);
        Enumeration enumeration = vector.elements();
        block8: while (enumeration.hasMoreElements()) {
            Integer n = (Integer)enumeration.nextElement();
            JarMaker.addElement(this.ccsids_, n);
            if (this.ccsidsExcluded_.contains(n)) {
                System.err.println("Warning: CCSID " + n + ", specified for both inclusion " + "and exclusion, will be included.");
                this.ccsidsExcluded_.removeElement(n);
            }
            switch (n) {
                case 930: 
                case 5026: {
                    JarMaker.addElement(this.ccsids_, new Integer(290));
                    JarMaker.addElement(this.ccsids_, new Integer(300));
                    continue block8;
                }
                case 933: 
                case 1364: {
                    JarMaker.addElement(this.ccsids_, new Integer(833));
                    JarMaker.addElement(this.ccsids_, new Integer(834));
                    continue block8;
                }
                case 935: 
                case 1388: {
                    JarMaker.addElement(this.ccsids_, new Integer(836));
                    JarMaker.addElement(this.ccsids_, new Integer(837));
                    continue block8;
                }
                case 937: {
                    JarMaker.addElement(this.ccsids_, new Integer(37));
                    JarMaker.addElement(this.ccsids_, new Integer(835));
                    continue block8;
                }
                case 939: 
                case 5035: {
                    JarMaker.addElement(this.ccsids_, new Integer(1027));
                    JarMaker.addElement(this.ccsids_, new Integer(300));
                    continue block8;
                }
                case 1399: {
                    JarMaker.addElement(this.ccsids_, new Integer(5123));
                    JarMaker.addElement(this.ccsids_, new Integer(16684));
                    continue block8;
                }
            }
        }
    }

    public void setCCSIDsExcluded(Vector vector) {
        if (vector == null) {
            throw new NullPointerException("ccsidList");
        }
        vector = JarMaker.validateList(vector, "CCSID", "java.lang.Integer", this.verbose_);
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Integer n = (Integer)enumeration.nextElement();
            if (this.ccsids_.contains(n)) {
                System.err.println("Warning: CCSID " + n + ", specified for both exclusion " + "and inclusion, will be included.");
                continue;
            }
            JarMaker.addElement(this.ccsidsExcluded_, n);
        }
    }

    public void setComponents(Vector vector) {
        this.setComponents(vector, false);
    }

    public void setComponents(Vector vector, boolean bl) {
        if (vector == null) {
            throw new NullPointerException("componentList");
        }
        vector = JarMaker.validateList(vector, "component", "java.lang.Integer", this.verbose_);
        Vector vector2 = new Vector();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Integer n = (Integer)enumeration.nextElement();
            if (!JarMaker.addElement(this.components_, n)) continue;
            Vector vector3 = ToolboxJarMaker.getBaseDependenciesForComponent(n, bl);
            JarMaker.copyVector(vector3, vector2, true);
        }
        this.setFilesRequired(vector2);
    }

    public void setLanguageDirectory(File file) {
        if (file == null) {
            throw new NullPointerException("baseDirectory");
        }
        this.languageDirectory_ = file;
    }

    public void setLanguages(Vector vector) {
        if (vector == null) {
            throw new NullPointerException("languageList");
        }
        vector = JarMaker.validateList(vector, "language", "java.lang.String", this.verbose_);
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = ToolboxJarMaker.getShippedLanguageSuffixFor(string, this.verbose_);
            JarMaker.addElement(this.languages_, string2);
        }
    }

    public void setProxyFilesExcluded(boolean bl) {
        this.noProxy_ = bl;
    }

    public void setExcludeSomeDependencies(boolean bl) {
        this.excludeSomeDependencies_ = bl;
    }

    public static void main(String[] stringArray) {
        try {
            ToolboxJarMaker toolboxJarMaker = new ToolboxJarMaker();
            if (toolboxJarMaker.parseArgs(stringArray)) {
                if (toolboxJarMaker.isSplit()) {
                    File file = toolboxJarMaker.getSourceJar();
                    int n = toolboxJarMaker.getSplitSize();
                    toolboxJarMaker.split(file, n);
                } else if (toolboxJarMaker.isExtract()) {
                    File file = toolboxJarMaker.getSourceJar();
                    File file2 = toolboxJarMaker.getExtractionDirectory();
                    toolboxJarMaker.extract(file, file2);
                } else {
                    File file = toolboxJarMaker.getSourceJar();
                    File file3 = toolboxJarMaker.getDestinationJar();
                    toolboxJarMaker.makeJar(file, file3);
                }
            } else {
                System.exit(1);
            }
        }
        catch (Throwable throwable) {
            System.err.println(throwable.toString());
            throwable.printStackTrace(System.err);
            System.exit(1);
        }
        System.exit(0);
    }

    class Arguments {
        Arguments() {
        }

        boolean parse(String[] stringArray, ToolboxJarMaker toolboxJarMaker) {
            Object object;
            String string;
            Object object2;
            Vector vector = null;
            Vector vector2 = null;
            Vector vector3 = null;
            Vector vector4 = null;
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = true;
            if (!toolboxJarMaker.parseArgs(stringArray, true)) {
                this.printUsage(System.err);
                return false;
            }
            String[] stringArray2 = toolboxJarMaker.getUnrecognizedArgs();
            if (stringArray2.length == 0) {
                if (ToolboxJarMaker.this.requestedUsageInfo_) {
                    this.printUsage(System.out);
                    return false;
                }
                return bl3;
            }
            Vector<String> vector5 = new Vector<String>();
            vector5.addElement("-component");
            vector5.addElement("-beans");
            vector5.addElement("-language");
            vector5.addElement("-languageDirectory");
            vector5.addElement("-ccsid");
            vector5.addElement("-ccsidExcluded");
            vector5.addElement("-noProxy");
            vector5.addElement("-excludeSomeDependencies");
            Hashtable<String, String> hashtable = new Hashtable<String, String>();
            hashtable.put("-c", "-component");
            hashtable.put("-comp", "-component");
            hashtable.put("-b", "-beans");
            hashtable.put("-l", "-language");
            hashtable.put("-lang", "-language");
            hashtable.put("-ld", "-languageDirectory");
            hashtable.put("-langdir", "-languageDirectory");
            hashtable.put("-languagedir", "-languageDirectory");
            hashtable.put("-cc", "-ccsid");
            hashtable.put("-cx", "-ccsidExcluded");
            hashtable.put("-ccx", "-ccsidExcluded");
            hashtable.put("-ccsidex", "-ccsidExcluded");
            hashtable.put("-ccsidsex", "-ccsidExcluded");
            hashtable.put("-np", "-noProxy");
            hashtable.put("-npprox", "-noProxy");
            hashtable.put("-xd", "-excludeSomeDependencies");
            hashtable.put("-xsd", "-excludeSomeDependencies");
            hashtable.put("-excludesome", "-excludeSomeDependencies");
            CommandLineArguments commandLineArguments = new CommandLineArguments(stringArray2, vector5, hashtable);
            if (ToolboxJarMaker.this.verbose_) {
                System.out.print("Arguments parsed by ToolboxJarMaker: ");
                object2 = JarMaker.listCommandOptions(commandLineArguments, true);
                System.out.println((String)object2);
                object2 = JarMaker.listCommandOptions(commandLineArguments, false);
                if (((String)object2).length() != 0) {
                    System.out.print("Arguments unrecognized by ToolboxJarMaker: ");
                    System.out.println((String)object2);
                }
            }
            if ((string = commandLineArguments.getOptionValue("-component")) != null) {
                if (string.length() != 0) {
                    object2 = new StringTokenizer(string, ",");
                    if (((StringTokenizer)object2).countTokens() != 0) {
                        if (vector == null) {
                            vector = new Vector(((StringTokenizer)object2).countTokens());
                        }
                        boolean bl4 = false;
                        while (((StringTokenizer)object2).hasMoreTokens()) {
                            String string2 = ((StringTokenizer)object2).nextToken();
                            object = ToolboxJarMaker.getComponentID(string2);
                            if (object == null) {
                                System.err.println("Error: Unrecognized component name: " + string2);
                                bl4 = true;
                                bl3 = false;
                                continue;
                            }
                            JarMaker.addElement(vector, object);
                        }
                        if (bl4 && toolboxJarMaker.isVerbose()) {
                            int n;
                            System.err.println("The recognized components are:");
                            for (n = 0; n < VALID_COMPONENTS.length - 1; ++n) {
                                System.err.print(VALID_COMPONENTS[n] + ", ");
                            }
                            System.err.println(VALID_COMPONENTS[n]);
                        }
                    }
                } else {
                    System.err.println("Warning: No component specified after -component.");
                }
            }
            bl = commandLineArguments.isOptionSpecified("-beans");
            string = commandLineArguments.getOptionValue("-language");
            if (string != null) {
                if (string.length() != 0) {
                    object2 = new StringTokenizer(string, ",");
                    if (((StringTokenizer)object2).countTokens() != 0) {
                        if (vector2 == null) {
                            vector2 = new Vector(((StringTokenizer)object2).countTokens());
                        }
                        while (((StringTokenizer)object2).hasMoreTokens()) {
                            JarMaker.addElement(vector2, ((StringTokenizer)object2).nextToken());
                        }
                    }
                } else {
                    System.err.println("Warning: No language specified after -language.");
                }
            }
            if ((string = commandLineArguments.getOptionValue("-languageDirectory")) != null) {
                if (string.length() != 0) {
                    toolboxJarMaker.setLanguageDirectory(new File(string));
                } else {
                    System.err.println("Warning: No directory specified after -languageDirectory.");
                }
            }
            if ((string = commandLineArguments.getOptionValue("-ccsid")) != null) {
                if (string.length() != 0) {
                    object2 = new StringTokenizer(string, ",");
                    if (((StringTokenizer)object2).countTokens() != 0) {
                        if (vector3 == null) {
                            vector3 = new Vector(((StringTokenizer)object2).countTokens());
                        }
                        while (((StringTokenizer)object2).hasMoreTokens()) {
                            String string3 = ((StringTokenizer)object2).nextToken();
                            Integer n = null;
                            try {
                                n = new Integer(string3);
                            }
                            catch (NumberFormatException numberFormatException) {
                                System.err.println("Error: Non-integer CCSID value: " + string3);
                                bl3 = false;
                                continue;
                            }
                            JarMaker.addElement(vector3, n);
                        }
                    }
                } else {
                    System.err.println("Warning: No CCSID specified after -ccsid.");
                }
            }
            if ((string = commandLineArguments.getOptionValue("-ccsidExcluded")) != null) {
                if (string.length() != 0) {
                    object2 = new StringTokenizer(string, ",");
                    if (((StringTokenizer)object2).countTokens() != 0) {
                        if (vector4 == null) {
                            vector4 = new Vector(((StringTokenizer)object2).countTokens());
                        }
                        while (((StringTokenizer)object2).hasMoreTokens()) {
                            String string4 = ((StringTokenizer)object2).nextToken();
                            Integer n = null;
                            try {
                                n = new Integer(string4);
                            }
                            catch (NumberFormatException numberFormatException) {
                                System.err.println("Error: Non-integer CCSID value: " + string4);
                                bl3 = false;
                                continue;
                            }
                            JarMaker.addElement(vector4, n);
                        }
                    }
                } else {
                    System.err.println("Warning: No CCSID specified after -ccsidExcluded.");
                }
            }
            if (commandLineArguments.isOptionSpecified("-noproxy")) {
                ToolboxJarMaker.this.noProxy_ = true;
                bl2 = true;
            }
            ToolboxJarMaker.this.excludeSomeDependencies_ = commandLineArguments.isOptionSpecified("-excludeSomeDependencies");
            object2 = commandLineArguments.getExtraOptions();
            while (object2.hasMoreElements()) {
                String string5 = (String)object2.nextElement();
                String string6 = commandLineArguments.getOptionValue(string5);
                object = string6 == null ? string5 : string5 + " " + string6;
                System.err.println("Error: Unrecognized option: " + (String)object);
                bl3 = false;
            }
            if (toolboxJarMaker.isSplit()) {
                if (vector != null || bl || vector2 != null || vector3 != null || vector4 != null) {
                    System.err.println("Warning: When -split is specified, all other options are ignored, except -source and -verbose.");
                }
            } else {
                if (!(toolboxJarMaker.isOptionInfoSufficient() || vector != null || vector2 != null || vector3 != null || vector4 != null || bl2 || ToolboxJarMaker.this.excludeSomeDependencies_)) {
                    System.err.println("Error: Need to specify more options.");
                    bl3 = false;
                }
                if (vector2 != null) {
                    ToolboxJarMaker.this.setLanguages(vector2);
                }
                if (vector != null) {
                    if (vector.size() != 0) {
                        ToolboxJarMaker.this.setComponents(vector, bl);
                    } else {
                        bl3 = false;
                    }
                }
                if (vector3 != null) {
                    ToolboxJarMaker.this.setCCSIDs(vector3);
                }
                if (vector4 != null) {
                    ToolboxJarMaker.this.setCCSIDsExcluded(vector4);
                }
            }
            if (!bl3) {
                this.printUsage(System.err);
            }
            return bl3;
        }

        private void printUsage(PrintStream printStream) {
            printStream.println();
            printStream.println("Usage: ");
            printStream.println();
            printStream.println("  ToolboxJarMaker [-source jarFile]");
            printStream.println("           [-destination jarFile]");
            printStream.println("           [-fileRequired entry1[,entry2[...]]]");
            printStream.println("           [-fileExcluded entry1[,entry2[...]]]");
            printStream.println("           [-additionalFile file1[,file2[...]]]");
            printStream.println("           [-additionalFilesDirectory directory");
            printStream.println("           [-package pkg1[,pkg2[...]]]");
            printStream.println("           [-packageExcluded pkg1[,pkg2[...]]]");
            printStream.println("           [-extract [directory]]");
            printStream.println("           [-split [kilobytes]]");
            printStream.println("           [-component comp1[,comp2[...]]]");
            printStream.println("           [-beans]");
            printStream.println("           [-language language1[,language2[...]]]");
            printStream.println("           [-languageDirectory directory");
            printStream.println("           [-ccsid ccsid1[,ccsid2[...]]]");
            printStream.println("           [-ccsidExcluded ccsid1[,ccsid2[...]]]");
            printStream.println("           [-noProxy]");
            printStream.println("           [-excludeSomeDependencies]");
            printStream.println("           [-verbose]");
            printStream.println("           [-help]");
            printStream.println();
            printStream.println("At least one of the following options must be specified: ");
            printStream.println("-fileRequired, -fileExcluded, -additionalFile, -package, -packageExcluded, -extract, -split, -component, -language, -ccsid, -ccsidExcluded, -noProxy");
            printStream.println();
            printStream.println("The -excludeSomeDependencies option is not recommended for pre-V5R2 Toolbox JAR files.");
        }
    }
}

