/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access.jdbcClient;

import com.ibm.as400.access.JVMInfo;
import com.ibm.as400.access.jdbcClient.ClientBlob;
import com.ibm.as400.access.jdbcClient.ClientClob;
import com.ibm.as400.access.jdbcClient.ReflectionUtil;
import com.ibm.as400.access.jdbcClient.StringFormatUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.zip.CRC32;

public class Main
implements Runnable {
    public static String[] knownDrivers = new String[]{"com.ibm.as400.access.AS400JDBCDriver", "com.ibm.db2.jdbc.app.DB2Driver", "com.ibm.jtopenlite.database.jdbc.JDBCDriver"};
    public static String promptString = ">";
    public static String usage = "Usage:  java com.ibm.as400.access.jdbcClient.Main <jdbcUrl> <userid> <password>";
    public static String[] commandHelp = new String[]{"com.ibm.as400.access.jdbcClient.Main executes SQL commands using a JDBC connection.  ", "  This program is provided AS IS and formal support will NOT be provided.", "  This program should not be used in a production environment.", "", "Parameters are passed to a CALL procedure by using the following ", "CALL ... -- INPARM [p1]....    Calls the stored procedure with the specified parameters", "", "Using CL:  [as400 command] will use QSYS.QCMDEXEC to execute the as400 command ", "", "Besides SQL COMMANDS, the following COMMANDS and SUBCOMMANDS are available", "", "!USAGE                          Displays this information", "!HELP                           Displays this information", "!PREPARE [sql statement]        prepares an sql statement", "!EXECUTEQUERY                   Invokes executeQuery on the prepared statement", "!EXECUTEUPDATE                  Invokes executeUpdate on the prepared statement", "!SETPARM [index],[value]        Sets the parameter for the sql statement", "!SETPARMFROMVAR [index],[var]   Sets the parameter using a variable", "!SETRESULTSETTYPE [..]          Sets the results set type for prepare", "!SETRESULTSETCONCURRENCY [..]   ..", "!SETRESULTSETHOLDABILITY [..]   ..", "!REUSE STATEMENT [true|false]   Controls whethe the stmt object is reused", "!ECHO [string]                  Echos the string", "!ECHOCOMMAND [true|false]       Should the input command be echod.", "!PRINTSTACKTRACE [true|false]   Should the stack trace be printed for SQLExceptions.", "-- [string]                     Specifies a comment", "!SETQUERYTIMEOUT [number]       Sets the query timeout for subsequent statements", "!RESET CONNECTION PROPERTIES    Resets connection properties", "!ADD CONNECTION PROPERTY        Set properties to be used on subsequent connects", "!REUSE CONNECTION [true|false]  Should the connection be reused by connect to ", "!CONNECT TO URL [URL] [USERID=..] [PASSWORD=...]  Connect using the URL", "!CONNECT TO SCHEMA [schema]            Reconnect using the current URL to the specified schema", "!CONNECT RESET                  Closes the current connection", "!EXISTFILE                      Indicates if the specified file exists (on the client)", "!GC                             Force the Java garbage collector to run", "!OUTPUT FORMAT [xml | html]     Set the output format to include XML or HTML", "!SHOWMIXEDUX [true | false]     Set if mixed UX strings will be displayed", "!SET AUTOCOMMIT [true|false]    Sets the autocommit value", "!SET TRANSACTIONISOLATION [VALUE] Sets the autocommit value", "                                 Supported values are ", "                               TRANSACTION_READ_UNCOMMITTED", "                               TRANSACTION_READ_COMMITTED", "                               TRANSACTION_REPEATABLE_READ", "                               TRANSACTION_SERIALIZABLE", "!GETSERVERJOBNAME               Returns connection.getServerJobName", "!CLOSESTATEMENTRS [on|off]      Close statement and result set after execution of query default off", "!MEASUREEXECUTE [on|off]        Measure time to do execute", "!CHARACTERDETAILS [on|off]      Turn on to see entire character details -- default of off", "!MANUALFETCH [on|off]           Set if manual fetch operations should be used", "!RS.NEXT,!RS.FIRST, !RS.LAST, !RS.PREVIOUS, !RS.ABSOLUTE pos, !RS.RELATIVE pos, !RS.BEFOREFIRST, !RS.AFTERLAST", "                               Call rs.next,... for manually fetching", "!DMD.GETCOLUMNS catalog, schemaPattern, tableNamePattern, columnNamePattern ", "!DMD.GETTABLES catalog, schemaPattern, tableNamePattern, type1 | type2", "!DMD.GETINDEXINFO catalog, schema, table, booleanUnique, booleanApproximate ", "!DMD.GETSCHEMAS", "!HISTORY.CLEAR                    Clears the stored history", "!HISTORY.SHOW                     Shows the history of commands", "!SETCLITRACE [true|false]         Sets CLI tracing for native JDBC driver -- valid V5R5 and later", "!SETDB2TRACE [0|1|2|3|4]          Sets jdbc tracing for native JDBC driver  -- valid V5R5 and later", "", "Parameters for prepared statements and callable statements may be specified in the following formats", "UX'....'                       Unicode string (in hexadecimal)", "X'....'                        Byte array (in hexademical)", "FILEBLOB=<filename>            A Blob retrieved from the named file", "FILECLOB=<filename>            A clob retrieved from the named file", "SAVEDPARM=<number>             A parameter from a previous CALL statement", "GEN_BYTE_ARRAY+<count>         A generated byte array of count bytes", "GEN_HEX_STRING+<count>         A generated hex string", "GEN_CHAR_ARRAY+<count>C<ccsid> A generated character string", "SQLARRAY[TYPE:e1:e2:...]       A JAVA.SQL.ARRAY type", "                               Types are String:BigDecimal:Date:Time:Timestamp:Blob:Clob:int:short:long:float:double:byteArray", "SQLARRAY[Date:e1 e2 ...]       A JAVA.SQL.ARRAY with data blank sep", "SQLARRAY[Timestamp:e1|e2 ...]  A JAVA.SQL.ARRAY with timestamp | sep", "", "The following prefixes are available", "!INVISIBLE:     The command and its results are not echoed", "!SILENT:        The results of the command are not echoed", "", "", "The following 'reflection' based commands are available", "!SETVAR [VARNAME] = [METHODCALL]  Sets a variable use a method.. i.e. ", "                                 SETVAR BLOB = RS.getBlob(1)", "!SETVAR [VARNAME] [PARAMETER SPECIFICATION] Sets a variable using a parameter specification", "!SETNEWVAR [VARNAME] = [CONSTRUCTORCALL]  Sets a variable by calling the contructor", "                                 SETNEWVAR DS = com.ibm.db2.jdbc.app.UDBDataSource()", "!SHOWVARMETHODS [VARNAME]         Shows the methods for a variable", "!CALLMETHOD [METHODCALL]          Calls a method on a variable", "  Hint:  To see a result set use CALLMETHOD com.ibm.as400.access.jdbcClient.Main.dispResultSet(RS)", "", "!THREAD [COMMAND]                 Runs a command in its own thread.", "!REPEAT [NUMBER] [COMMAND]        Repeat a command a number of times.", ""};
    String url_;
    String userid_;
    String password_;
    boolean prompt_ = true;
    boolean echoCommand_ = false;
    boolean printStackTrace_ = false;
    int queryTimeout_ = 0;
    boolean measureExecute_ = false;
    boolean manualFetch_ = false;
    int resultSetType_ = 1003;
    int resultSetConcurrency_ = 1007;
    int resultSetHoldability_ = 1;
    boolean jdk14_ = false;
    boolean jdk16_ = false;
    private boolean hideWarnings_ = false;
    private boolean toolboxDriver_ = false;
    Connection connection_;
    Statement stmt_;
    private int manualResultSetNumCols_;
    private ResultSet manualResultSet_;
    private String[] manualResultSetColumnLabel_;
    private int showLobThreshold_ = 4096;
    private boolean characterDetails_ = false;
    private int stringSampleSize_ = 256;
    private boolean showMixedUX_;
    private int[] manualResultSetColType_;
    private boolean closeStatementRS_;
    private PreparedStatement pstmt_;
    private String[] savedStringParm_ = new String[256];
    private boolean echoComments_ = false;
    private String urlArgs_ = "";
    private boolean debug_ = false;
    private String conLabel_;
    private CallableStatement cstmt_;
    private String cstmtSql_;
    private Vector threads_ = new Vector();
    boolean html_ = false;
    boolean xml_ = false;
    private boolean useConnectionPool_ = false;
    private boolean reuseStatement_ = false;
    private Connection poolConnection = null;
    private String poolUserId = null;
    private String poolPassword = null;
    private String poolUrl = null;
    private Hashtable connectionPool = new Hashtable();
    private Hashtable variables = new Hashtable();
    private int conCount;
    private String conName = "CON";
    private boolean silent;
    private Vector history = new Vector();
    String command_;
    PrintStream out_;
    private long startTime_;
    private long finishTime_;

    void initializeDefaults() {
        for (int i = 0; i < knownDrivers.length; ++i) {
            try {
                Class.forName(knownDrivers[i]);
                continue;
            }
            catch (Exception exception) {
                if (!(this.debug_ | this.printStackTrace_)) continue;
                exception.printStackTrace();
            }
        }
        this.jdk14_ = JVMInfo.isJDK14();
        this.jdk16_ = JVMInfo.isJDK16();
        this.addVariable("MAIN", this);
        String string = System.getProperty("com.ibm.as400.access.jdbcClient.debug");
        if (string != null && (string = string.toUpperCase()).equals("TRUE")) {
            this.debug_ = true;
        }
        String string2 = System.getProperty("com.ibm.as400.access.jdbcClient.drivers");
        while (string2 != null) {
            String string3 = null;
            int n = string2.indexOf(":");
            if (n > 0) {
                string3 = string2.substring(0, n);
                if ((string2 = string2.substring(n + 1).trim()).length() == 0) {
                    string2 = null;
                }
            } else {
                string3 = string2;
                string2 = null;
            }
            try {
                Class.forName(string3);
            }
            catch (Exception exception) {
                if (!this.debug_ && !this.printStackTrace_) continue;
                exception.printStackTrace();
            }
        }
    }

    public Main(String string, String string2, String string3) throws SQLException {
        this.initializeDefaults();
        this.setUrl(string);
        this.userid_ = string2;
        this.password_ = string3;
        try {
            this.connection_ = DriverManager.getConnection(this.url_, this.userid_, this.password_);
            this.addVariable("CON", this.connection_);
        }
        catch (SQLException sQLException) {
            System.out.println("Warning:  Unable to connect to " + this.url_ + " using " + this.userid_);
            System.out.println("CON is not defined");
            this.connection_ = null;
        }
    }

    Main() {
        this.initializeDefaults();
    }

    public int go(InputStream inputStream, PrintStream printStream) {
        int n = 0;
        boolean bl = true;
        try {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            if (this.prompt_) {
                printStream.print(promptString);
            }
            String string = bufferedReader.readLine();
            while (bl) {
                bl = this.executeTopLevelCommand(string, printStream);
                if (!bl) continue;
                if (this.prompt_) {
                    printStream.print(promptString);
                }
                if ((string = bufferedReader.readLine()) != null) {
                    string = string.trim();
                    continue;
                }
                bl = false;
            }
            if (this.connection_ != null) {
                this.connection_.close();
                this.cstmt_ = null;
                this.cstmtSql_ = "";
                this.variables.remove("CSTMT");
            }
            this.connection_ = null;
            this.variables.remove("CON");
        }
        catch (Exception exception) {
            exception.printStackTrace(printStream);
        }
        catch (UnknownError unknownError) {
            unknownError.printStackTrace(printStream);
        }
        return n;
    }

    public Main(String string, PrintStream printStream) {
        this.command_ = string;
        this.out_ = printStream;
    }

    public void run() {
        Thread thread = Thread.currentThread();
        this.out_.println("Thread " + thread + " running " + this.command_);
        this.executeTopLevelCommand(this.command_, this.out_);
        this.out_.println("Thread " + thread + " ending");
    }

    public void useConnectionPool(boolean bl) {
        this.useConnectionPool_ = bl;
    }

    public void setUrl(String string) {
        this.url_ = string;
        if (this.url_.indexOf(":as400:") > 0) {
            this.toolboxDriver_ = true;
        }
    }

    public void setUserId(String string, PrintStream printStream) {
        if (this.debug_) {
            printStream.println("User ID set to " + string);
        }
        this.userid_ = string;
    }

    public void setPassword(String string) {
        this.password_ = string;
    }

    public String removeProperty(String string, String string2) {
        int n = string2.indexOf("=");
        while (n > 0) {
            int n2;
            String string3 = string2.substring(0, n).trim();
            int n3 = string.indexOf(string3);
            while (n3 > 0) {
                n2 = string.indexOf(";", n3);
                string = n2 > 0 ? string.substring(0, n3).trim() + string.substring(n2 + 1).trim() : string.substring(0, n3).trim();
                n3 = string.indexOf(string3);
            }
            n2 = string2.indexOf(";", n);
            string2 = n2 > 0 ? string2.substring(n2 + 1) : "";
            n = string2.indexOf("=");
        }
        return string;
    }

    public void setManualResultSetColType(ResultSetMetaData resultSetMetaData) throws SQLException {
        this.manualResultSetColType_ = new int[this.manualResultSetNumCols_ + 1];
        for (int i = 1; i <= this.manualResultSetNumCols_; ++i) {
            this.manualResultSetColType_[i] = resultSetMetaData.getColumnType(i);
        }
    }

    public Connection getPooledConnection(String string, String string2, String string3, PrintStream printStream) throws SQLException {
        if (this.poolConnection != null && string.equals(this.poolUserId) && string2.equals(this.poolPassword) && string3.equals(this.poolUrl)) {
            this.connection_ = this.poolConnection;
            this.addVariable("CON", this.connection_);
        } else {
            String string4;
            if (this.poolConnection != null) {
                string4 = this.poolUserId + "." + this.poolPassword + "." + this.poolUrl;
                this.connectionPool.put(string4, this.poolConnection);
                if (this.debug_) {
                    printStream.println("Added connection to pool for " + string4);
                }
            }
            string4 = string + "." + string2 + "." + string3;
            this.connection_ = (Connection)this.connectionPool.get(string4);
            if (this.connection_ != null) {
                this.addVariable("CON", this.connection_);
                if (this.debug_) {
                    printStream.println("Retrieved connection from pool for " + string4);
                }
                this.connectionPool.remove(string4);
            } else {
                if (this.debug_) {
                    printStream.println("Didn't retrieve connection from pool for " + string4);
                }
                this.connection_ = string.equals("null") && string2.equals("null") ? DriverManager.getConnection(string3) : DriverManager.getConnection(string3, string, string2);
                this.addVariable("CON", this.connection_);
            }
            this.poolConnection = this.connection_;
            this.poolUserId = string;
            this.poolPassword = string2;
            this.poolUrl = string3;
        }
        return this.connection_;
    }

    void executeSqlQuery(String string, PrintStream printStream) throws Exception {
        this.history.addElement(string);
        if (!(this.connection_ == null || this.stmt_ != null && this.reuseStatement_)) {
            if (this.stmt_ != null) {
                this.stmt_.close();
            }
            this.stmt_ = this.jdk14_ ? this.connection_.createStatement(this.resultSetType_, this.resultSetConcurrency_, this.resultSetHoldability_) : this.connection_.createStatement();
            this.addVariable("STMT", this.stmt_);
        }
        if (this.queryTimeout_ != 0) {
            this.stmt_.setQueryTimeout(this.queryTimeout_);
        }
        if (this.stmt_ != null) {
            if (this.measureExecute_) {
                this.startTime_ = System.currentTimeMillis();
            }
            ResultSet resultSet = this.stmt_.executeQuery(string);
            if (this.measureExecute_) {
                this.finishTime_ = System.currentTimeMillis();
                printStream.println("TIME: " + (this.finishTime_ - this.startTime_) + " ms");
            }
            SQLWarning sQLWarning = this.stmt_.getWarnings();
            if (this.manualFetch_) {
                ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                this.manualResultSetNumCols_ = resultSetMetaData.getColumnCount();
                this.setManualResultSetColType(resultSetMetaData);
                this.manualResultSet_ = resultSet;
                this.addVariable("RS", this.manualResultSet_);
                this.manualResultSetColumnLabel_ = Main.dispColumnHeadings(printStream, resultSet, resultSetMetaData, false, this.manualResultSetNumCols_, this.html_, this.xml_);
            } else {
                this.dispResultSet(printStream, resultSet, false);
                if (sQLWarning != null && !this.silent) {
                    Main.dispWarning(printStream, sQLWarning, this.hideWarnings_, this.html_);
                }
                if (this.closeStatementRS_) {
                    resultSet.close();
                }
            }
        } else {
            printStream.println("UNABLE to EXECUTE SELECT because not connected");
        }
    }

    public void executeCLCommand(String string, PrintStream printStream) throws Exception {
        this.history.addElement("CL: " + string);
        int n = string.length();
        String string2 = n < 10 ? "000000000" + n + ".00000" : (n < 100 ? "00000000" + n + ".00000" : (n < 1000 ? "0000000" + n + ".00000" : (n < 10000 ? "000000" + n + ".00000" : "00000" + n + ".00000")));
        String string3 = "CALL QSYS.QCMDEXC('" + string + "    ', " + string2 + ")";
        if (!(this.connection_ == null || this.stmt_ != null && this.reuseStatement_)) {
            if (this.stmt_ != null) {
                this.stmt_.close();
            }
            this.stmt_ = this.jdk14_ ? this.connection_.createStatement(this.resultSetType_, this.resultSetConcurrency_, this.resultSetHoldability_) : this.connection_.createStatement();
            this.addVariable("STMT", this.stmt_);
        }
        if (this.stmt_ != null) {
            SQLWarning sQLWarning;
            if (this.measureExecute_) {
                this.startTime_ = System.currentTimeMillis();
            }
            this.stmt_.executeUpdate(string3);
            if (this.measureExecute_) {
                this.finishTime_ = System.currentTimeMillis();
                printStream.println("TIME: " + (this.finishTime_ - this.startTime_) + " ms");
            }
            if ((sQLWarning = this.stmt_.getWarnings()) != null && !this.silent) {
                Main.dispWarning(printStream, sQLWarning, this.hideWarnings_, this.html_);
            }
        } else {
            printStream.println("UNABLE to EXECUTE SELECT because not connected");
        }
    }

    public void executeCallCommand(String string, PrintStream printStream) throws Exception {
        this.history.addElement(string);
        if (this.connection_ != null) {
            block36: {
                ResultSet resultSet;
                int n;
                int n2;
                int n3 = string.indexOf("-- INPARM");
                String string2 = null;
                if (n3 > 0) {
                    string2 = string.substring(n3 + 9).trim();
                    string = string.substring(0, n3);
                }
                if (!string.equals(this.cstmtSql_)) {
                    this.cstmt_ = this.jdk14_ ? this.connection_.prepareCall(string, this.resultSetType_, this.resultSetConcurrency_, this.resultSetHoldability_) : this.connection_.prepareCall(string);
                    this.cstmtSql_ = string;
                    this.addVariable("CSTMT", this.cstmt_);
                }
                if (this.jdk14_) {
                    ParameterMetaData parameterMetaData = this.cstmt_.getParameterMetaData();
                    int n4 = parameterMetaData.getParameterCount();
                    for (int i = 1; i <= n4; ++i) {
                        n2 = parameterMetaData.getParameterMode(i);
                        if (n2 == 4 || n2 == 2) {
                            n = parameterMetaData.getParameterType(i);
                            switch (n) {
                                case -8: 
                                case -4: 
                                case -3: 
                                case -2: 
                                case 2003: 
                                case 2004: {
                                    this.cstmt_.registerOutParameter(i, n);
                                    break;
                                }
                                default: {
                                    this.cstmt_.registerOutParameter(i, 12);
                                }
                            }
                        }
                        if (n2 != 1 && n2 != 2) continue;
                        String string3 = string2;
                        if (string2 != null && (n3 = string2.indexOf(",")) >= 0) {
                            string3 = string2.substring(0, n3).trim();
                            string2 = string2.substring(n3 + 1).trim();
                        }
                        if (string3 != null) {
                            this.setParameter(this.cstmt_, string3, i, printStream);
                            continue;
                        }
                        printStream.println("Warning:  thisParm is null");
                        printStream.println("--INPARM not found but num param > 0 ");
                    }
                } else if (string.indexOf("?") >= 0) {
                    throw new SQLException("Use of parameter markers in call statement only supported in JDK 1.4 -- statement was " + string);
                }
                boolean bl = this.cstmt_.execute();
                SQLWarning sQLWarning = this.cstmt_.getWarnings();
                if (sQLWarning != null) {
                    if (!this.silent) {
                        Main.dispWarning(printStream, sQLWarning, this.hideWarnings_, this.html_);
                    }
                    if (this.html_) {
                        printStream.println("Statement was " + string);
                    }
                }
                if (this.jdk14_) {
                    ParameterMetaData parameterMetaData = this.cstmt_.getParameterMetaData();
                    n2 = parameterMetaData.getParameterCount();
                    block10: for (n = 1; n <= n2; ++n) {
                        int n5 = parameterMetaData.getParameterMode(n);
                        if (n5 != 4 && n5 != 2) continue;
                        int n6 = parameterMetaData.getParameterType(n);
                        switch (n6) {
                            case -8: 
                            case -4: 
                            case -3: 
                            case -2: 
                            case 2004: {
                                printStream.print("Parameter " + n + " returned ");
                                byte[] byArray = this.cstmt_.getBytes(n);
                                if (byArray == null) {
                                    printStream.println("null");
                                    continue block10;
                                }
                                if (byArray.length < this.showLobThreshold_) {
                                    printStream.print("X'");
                                    for (int i = 0; i < byArray.length; ++i) {
                                        int n7 = 0xFF & byArray[i];
                                        if (n7 < 16) {
                                            printStream.print("0" + Integer.toHexString(n7));
                                            continue;
                                        }
                                        printStream.print(Integer.toHexString(n7));
                                    }
                                    printStream.println("'");
                                    continue block10;
                                }
                                CRC32 cRC32 = new CRC32();
                                cRC32.update(byArray);
                                printStream.println("ARRAY[size=" + byArray.length + ",CRC32=" + cRC32.getValue() + "]");
                                continue block10;
                            }
                            case 2003: {
                                printStream.print("Parameter " + n + " returned ARRAY ");
                                this.printArray(printStream, this.cstmt_.getArray(n));
                                printStream.println();
                                continue block10;
                            }
                            default: {
                                printStream.print("Parameter " + n + " returned ");
                                this.savedStringParm_[n] = this.cstmt_.getString(n);
                                this.printUnicodeString(printStream, this.savedStringParm_[n]);
                                printStream.println();
                            }
                        }
                    }
                }
                if (bl && (resultSet = this.cstmt_.getResultSet()) != null) {
                    if (this.manualFetch_) {
                        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                        this.manualResultSetNumCols_ = resultSetMetaData.getColumnCount();
                        this.setManualResultSetColType(resultSetMetaData);
                        this.manualResultSet_ = resultSet;
                        this.addVariable("RS", this.manualResultSet_);
                        this.manualResultSetColumnLabel_ = Main.dispColumnHeadings(printStream, resultSet, resultSetMetaData, false, this.manualResultSetNumCols_, this.html_, this.xml_);
                    } else {
                        this.dispResultSet(printStream, resultSet, false);
                        if (this.closeStatementRS_) {
                            resultSet.close();
                            resultSet = null;
                        }
                    }
                    if (!this.manualFetch_) {
                        try {
                            while (this.cstmt_.getMoreResults()) {
                                printStream.println("<<<< NEXT RESULT SET >>>>>>>");
                                resultSet = this.cstmt_.getResultSet();
                                this.dispResultSet(printStream, resultSet, false);
                                if (!this.closeStatementRS_) continue;
                                resultSet.close();
                                resultSet = null;
                            }
                        }
                        catch (Exception exception) {
                            String string4 = exception.toString();
                            if (string4.indexOf("implemented") >= 0) break block36;
                            throw exception;
                        }
                    }
                }
            }
            if (!this.manualFetch_ && this.closeStatementRS_) {
                // empty if block
            }
        } else {
            printStream.println("UNABLE to EXECUTE CALL because not connected");
        }
    }

    public void executeSqlCommand(String string, PrintStream printStream) throws Exception {
        if (this.connection_ != null) {
            SQLWarning sQLWarning;
            if (!(this.connection_ == null || this.stmt_ != null && this.reuseStatement_)) {
                this.stmt_ = this.jdk14_ ? this.connection_.createStatement(this.resultSetType_, this.resultSetConcurrency_, this.resultSetHoldability_) : this.connection_.createStatement();
                this.addVariable("STMT", this.stmt_);
            }
            if (this.queryTimeout_ != 0) {
                this.stmt_.setQueryTimeout(this.queryTimeout_);
            }
            if (this.measureExecute_) {
                this.startTime_ = System.currentTimeMillis();
            }
            this.stmt_.executeUpdate(string);
            this.history.addElement(string);
            if (this.measureExecute_) {
                this.finishTime_ = System.currentTimeMillis();
                printStream.println("TIME: " + (this.finishTime_ - this.startTime_) + " ms");
            }
            if ((sQLWarning = this.stmt_.getWarnings()) != null && !this.silent) {
                Main.dispWarning(printStream, sQLWarning, this.hideWarnings_, this.html_);
            }
        } else {
            printStream.println("UNABLE to EXECUTE because not connected");
        }
    }

    public void processException(SQLException sQLException, String string, PrintStream printStream) {
        if (!this.silent) {
            printStream.println("\n*** SQLException caught ***");
            printStream.println("Statement was " + string);
            Throwable throwable = sQLException;
            while (throwable != null) {
                if (throwable instanceof SQLException) {
                    int n;
                    sQLException = throwable;
                    printStream.println("SQLState: " + sQLException.getSQLState());
                    String string2 = sQLException.getMessage();
                    string2 = Main.cleanupMessage(string2);
                    printStream.println("Message:  " + string2);
                    printStream.println("Vendor:   " + sQLException.getErrorCode());
                    if (this.debug_ || this.printStackTrace_) {
                        sQLException.printStackTrace(printStream);
                    }
                    if ((n = sQLException.getErrorCode()) == -104) {
                        printStream.println("\nToken not valid found.  Use !HELP to see what you can do");
                    }
                    if ((throwable = sQLException.getNextException()) == null) {
                        try {
                            throwable = sQLException.getCause();
                        }
                        catch (Throwable throwable2) {
                            // empty catch block
                        }
                    }
                    printStream.println("");
                    continue;
                }
                if (throwable == null) continue;
                throwable.printStackTrace(printStream);
                try {
                    throwable = throwable.getCause();
                }
                catch (Throwable throwable3) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public boolean executeTopLevelCommand(String string, PrintStream printStream) {
        boolean bl;
        block32: {
            block31: {
                bl = true;
                this.silent = false;
                if ((string = string.trim()).toUpperCase().startsWith("!INVISIBLE:")) {
                    this.silent = true;
                    string = string.substring(10).trim();
                } else if (this.echoCommand_) {
                    printStream.println(string);
                    if (this.html_) {
                        printStream.println("<BR>");
                    }
                }
                if (string.toUpperCase().startsWith("!SILENT:")) {
                    this.silent = true;
                    string = string.substring(7).trim();
                }
                String string2 = string.toUpperCase();
                if (string2.startsWith("SELECT") || string2.startsWith("VALUES")) {
                    this.executeSqlQuery(string, printStream);
                    break block31;
                }
                if (string2.startsWith("CL:")) {
                    String string3 = string.substring(3).trim();
                    this.executeCLCommand(string3, printStream);
                    break block31;
                }
                if (string2.startsWith("!ECHO") || string2.startsWith("--") || string2.startsWith("//") || string2.startsWith("/*")) {
                    this.history.addElement(string);
                    if (this.echoComments_) {
                        printStream.println(string);
                        if (this.html_) {
                            printStream.println("<BR>");
                        }
                    }
                    break block31;
                }
                if (string2.equals("!QUIT") || string2.equals("!EXIT") || string2.equals("QUIT") || string2.equals("EXIT")) {
                    bl = false;
                    break block31;
                }
                if (string.length() > 0 && string.startsWith("!")) {
                    string = string.substring(1);
                    this.executeCommand(string, printStream);
                    break block31;
                }
                if (string2.startsWith("CALL ")) {
                    this.executeCallCommand(string, printStream);
                    break block31;
                }
                if (string2.length() == 0) break block31;
                this.executeSqlCommand(string, printStream);
            }
            Object var7_9 = null;
            if (this.stmt_ == null) break block32;
            try {
                if (!this.reuseStatement_ && !this.manualFetch_ && this.closeStatementRS_) {
                    this.stmt_.close();
                    this.stmt_ = null;
                    this.variables.remove("STMT");
                }
                break block32;
            }
            catch (Exception exception) {
                exception.printStackTrace(printStream);
            }
            break block32;
            {
                catch (SQLException sQLException) {
                    this.processException(sQLException, string, printStream);
                    Object var7_10 = null;
                    if (this.stmt_ == null) break block32;
                    try {
                        if (!this.reuseStatement_ && !this.manualFetch_ && this.closeStatementRS_) {
                            this.stmt_.close();
                            this.stmt_ = null;
                            this.variables.remove("STMT");
                        }
                        break block32;
                    }
                    catch (Exception exception) {
                        exception.printStackTrace(printStream);
                    }
                    break block32;
                }
                catch (Exception exception) {
                    printStream.println("\n*** exception caught *** " + exception);
                    printStream.println("Statement was " + string);
                    exception.printStackTrace(printStream);
                    Object var7_11 = null;
                    if (this.stmt_ == null) break block32;
                    try {
                        if (!this.reuseStatement_ && !this.manualFetch_ && this.closeStatementRS_) {
                            this.stmt_.close();
                            this.stmt_ = null;
                            this.variables.remove("STMT");
                        }
                        break block32;
                    }
                    catch (Exception exception2) {
                        exception2.printStackTrace(printStream);
                    }
                    break block32;
                }
                catch (UnknownError unknownError) {
                    printStream.println("\n*** java.lang.UnknownError caught ***" + unknownError);
                    printStream.println("Statement was " + string);
                    unknownError.printStackTrace(printStream);
                    Object var7_12 = null;
                    if (this.stmt_ == null) break block32;
                    try {
                        if (!this.reuseStatement_ && !this.manualFetch_ && this.closeStatementRS_) {
                            this.stmt_.close();
                            this.stmt_ = null;
                            this.variables.remove("STMT");
                        }
                        break block32;
                    }
                    catch (Exception exception) {
                        exception.printStackTrace(printStream);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var7_13 = null;
                if (this.stmt_ != null) {
                    try {
                        if (!this.reuseStatement_ && !this.manualFetch_ && this.closeStatementRS_) {
                            this.stmt_.close();
                            this.stmt_ = null;
                            this.variables.remove("STMT");
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace(printStream);
                    }
                }
                throw throwable;
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public boolean executeCommand(String string, PrintStream printStream) {
        boolean bl;
        block372: {
            block371: {
                bl = true;
                this.silent = false;
                if ((string = string.trim()).toUpperCase().startsWith("INVISIBLE:")) {
                    this.silent = true;
                    string = string.substring(10).trim();
                }
                if (string.toUpperCase().startsWith("SILENT:")) {
                    this.silent = true;
                    string = string.substring(7).trim();
                }
                String string2 = string.toUpperCase();
                if (string2.startsWith("PREPARE")) {
                    this.history.addElement("!" + string);
                    string = string.substring(7).trim();
                    if (this.pstmt_ != null && this.closeStatementRS_) {
                        this.pstmt_.close();
                    }
                    this.pstmt_ = this.jdk14_ ? this.connection_.prepareStatement(string, this.resultSetType_, this.resultSetConcurrency_, this.resultSetHoldability_) : this.connection_.prepareStatement(string);
                    this.addVariable("PSTMT", this.pstmt_);
                    break block371;
                }
                if (string2.startsWith("SETRESULTSETTYPE")) {
                    this.history.addElement("!" + string);
                    string = string.substring(16).trim();
                    if (string.indexOf("FORWARD_ONLY") >= 0) {
                        this.resultSetType_ = 1003;
                    } else if (string.indexOf("SCROLL_INSENSITIVE") >= 0) {
                        this.resultSetType_ = 1004;
                    } else if (string.indexOf("SCROLL_SENSITIVE") >= 0) {
                        this.resultSetType_ = 1005;
                    } else {
                        printStream.println("Value of '" + string + " not valid use");
                        printStream.println("     FORWARD_ONLY, SCROLL_INSENSITIVE, or SCROLL_SENSITIVE");
                    }
                    break block371;
                }
                if (string2.startsWith("SETRESULTSETCONCURRENCY")) {
                    this.history.addElement("!" + string);
                    string = string.substring(15).trim();
                    if (string.indexOf("READ_ONLY") >= 0) {
                        this.resultSetConcurrency_ = 1007;
                    } else if (string.indexOf("UPDATABLE") >= 0) {
                        this.resultSetConcurrency_ = 1008;
                    } else {
                        printStream.println("Value of '" + string + " not valid. Use");
                        printStream.println(" CONCUR_READ_ONLY or CONCUR_UPDATABLE ");
                    }
                    break block371;
                }
                if (string2.startsWith("SETRESULTSETHOLDABILITY")) {
                    this.history.addElement("!" + string);
                    string = string.substring(15).trim();
                    if (string.indexOf("HOLD") >= 0) {
                        this.resultSetHoldability_ = 1;
                    } else if (string.indexOf("CLOSE") >= 0) {
                        this.resultSetHoldability_ = 2;
                    } else {
                        printStream.println("Value of '" + string + " not valid. Use");
                        printStream.println(" HOLD_CURSORS_OVER_COMMIT or CLOSE_CURSORS_AT_COMMIT");
                    }
                    break block371;
                }
                if (string2.startsWith("EXECUTEQUERY")) {
                    this.history.addElement("!" + string);
                    if (this.pstmt_ != null) {
                        if (this.measureExecute_) {
                            this.startTime_ = System.currentTimeMillis();
                        }
                        ResultSet resultSet = this.pstmt_.executeQuery();
                        if (this.measureExecute_) {
                            this.finishTime_ = System.currentTimeMillis();
                            printStream.println("TIME: " + (this.finishTime_ - this.startTime_) + " ms");
                        }
                        if (this.manualFetch_) {
                            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                            this.manualResultSetNumCols_ = resultSetMetaData.getColumnCount();
                            this.setManualResultSetColType(resultSetMetaData);
                            this.manualResultSet_ = resultSet;
                            this.addVariable("RS", this.manualResultSet_);
                            this.manualResultSetColumnLabel_ = Main.dispColumnHeadings(printStream, resultSet, resultSetMetaData, false, this.manualResultSetNumCols_, this.html_, this.xml_);
                        } else {
                            this.dispResultSet(printStream, resultSet, false);
                            SQLWarning sQLWarning = this.pstmt_.getWarnings();
                            if (sQLWarning != null && !this.silent) {
                                Main.dispWarning(printStream, sQLWarning, this.hideWarnings_, this.html_);
                            }
                            if (this.closeStatementRS_) {
                                resultSet.close();
                            }
                        }
                    } else {
                        printStream.println("UNABLE to EXECUTE QUERY because prepared statement does not exist");
                    }
                    break block371;
                }
                if (string2.startsWith("EXECUTEUPDATE")) {
                    this.history.addElement("!" + string);
                    if (this.pstmt_ != null) {
                        SQLWarning sQLWarning;
                        if (this.measureExecute_) {
                            this.startTime_ = System.currentTimeMillis();
                        }
                        this.pstmt_.executeUpdate();
                        if (this.measureExecute_) {
                            this.finishTime_ = System.currentTimeMillis();
                            printStream.println("TIME: " + (this.finishTime_ - this.startTime_) + " ms");
                        }
                        if ((sQLWarning = this.pstmt_.getWarnings()) != null && !this.silent) {
                            Main.dispWarning(printStream, sQLWarning, this.hideWarnings_, this.html_);
                        }
                    } else {
                        printStream.println("UNABLE to EXECUTE UPDATE because prepared statement does not exist");
                    }
                    break block371;
                }
                if (string2.startsWith("SETPARMFROMVAR")) {
                    this.history.addElement("!" + string);
                    if (this.pstmt_ != null) {
                        int n = (string = string.substring(14).trim()).indexOf(",");
                        if (n > 0) {
                            String string3 = string.substring(0, n).trim();
                            int n2 = Integer.parseInt(string3);
                            String string4 = string.substring(n + 1).trim();
                            Object v = this.variables.get(string4);
                            if (v != null) {
                                this.pstmt_.setObject(n2, v);
                                SQLWarning sQLWarning = this.pstmt_.getWarnings();
                                if (sQLWarning != null && !this.silent) {
                                    Main.dispWarning(printStream, sQLWarning, this.hideWarnings_, this.html_);
                                }
                            } else {
                                printStream.println("Unable to find object for variable " + string4);
                                this.showValidVariables(printStream);
                            }
                        } else {
                            printStream.println("UNABLE to find comma for SETPARM  --> SETPARM [index],[value]");
                        }
                    } else {
                        printStream.println("UNABLE to SETPARM because prepared statement does not exist");
                    }
                    break block371;
                }
                if (string2.startsWith("SETPARM")) {
                    this.history.addElement("!" + string);
                    if (this.pstmt_ != null) {
                        int n = (string = string.substring(7).trim()).indexOf(",");
                        if (n > 0) {
                            String string5 = string.substring(0, n).trim();
                            int n3 = Integer.parseInt(string5);
                            String string6 = string.substring(n + 1).trim();
                            this.setParameter(this.pstmt_, string6, n3, printStream);
                        } else {
                            printStream.println("UNABLE to find comma for SETPARM  --> SETPARM [index],[value]");
                        }
                    } else {
                        printStream.println("UNABLE to SETPARM because prepared statement does not exist");
                    }
                    break block371;
                }
                if (string2.startsWith("ECHO") || string2.startsWith("--") || string2.startsWith("//") || string2.startsWith("/*")) {
                    this.history.addElement("!" + string);
                    if (this.echoComments_) {
                        printStream.println(string);
                        if (this.html_) {
                            printStream.println("<BR>");
                        }
                    }
                    break block371;
                }
                if (string2.startsWith("SETQUERYTIMEOUT")) {
                    this.history.addElement("!" + string);
                    String string7 = string.substring(16).trim();
                    try {
                        this.queryTimeout_ = Integer.parseInt(string7);
                        printStream.println("-->Query timeout set to " + this.queryTimeout_);
                    }
                    catch (Exception exception) {
                        printStream.println("Unable to parse (" + string7 + ")");
                    }
                    break block371;
                }
                if (string2.startsWith("RESET CONNECTION PROPERTIES")) {
                    this.history.addElement("!" + string);
                    this.urlArgs_ = "";
                    break block371;
                }
                if (string2.startsWith("ADD CONNECTION PROPERTY")) {
                    this.history.addElement("!" + string);
                    String string8 = string.substring(23).trim();
                    this.urlArgs_ = this.removeProperty(this.urlArgs_, string8);
                    this.urlArgs_ = this.urlArgs_ + "; " + string8;
                    break block371;
                }
                if (string2.startsWith("CONNECT TO URL")) {
                    this.history.addElement("!" + string);
                    if (this.connection_ != null && this.connection_ != this.poolConnection) {
                        this.connection_.close();
                        this.cstmt_ = null;
                        this.cstmtSql_ = "";
                        this.variables.remove("CSTMT");
                    }
                    String string9 = string.substring(14).trim();
                    String string10 = null;
                    String string11 = null;
                    int n = string9.indexOf("USERID=");
                    if (n > 0) {
                        int n4;
                        string10 = string9.substring(n + 7).trim();
                        string9 = string9.substring(0, n);
                        int n5 = string10.indexOf(" ");
                        if (n5 >= 0) {
                            string10 = string10.substring(0, n5);
                        }
                        if ((n4 = string.indexOf("PASSWORD=")) > 0) {
                            string11 = string.substring(n4 + 9).trim();
                            n5 = string11.indexOf(" ");
                            if (n5 > 0) {
                                string11 = string11.substring(0, n5);
                            }
                            if (this.debug_) {
                                printStream.println("Connecting using " + this.userid_ + ", " + this.password_ + " to " + string9);
                            }
                            Object object = null;
                            try {
                                Object object2;
                                if (string9.indexOf("jdbc:db2://") >= 0) {
                                    if (this.debug_) {
                                        printStream.println("Loading jcc driver");
                                    }
                                    Class.forName("com.ibm.db2.jcc.DB2Driver").newInstance();
                                    object2 = DriverManager.getDriver(this.url_);
                                    if (object2.getClass().getName().equals("com.ibm.db2.jdbc.app.DB2Driver")) {
                                        if (this.debug_) {
                                            printStream.println("removing native driver");
                                        }
                                        object = object2;
                                        DriverManager.deregisterDriver((Driver)object);
                                    }
                                }
                                if (this.useConnectionPool_) {
                                    this.connection_ = this.getPooledConnection(string10, string11, string9, printStream);
                                } else {
                                    this.connection_ = DriverManager.getConnection(string9, string10, string11);
                                    this.addVariable("CON", this.connection_);
                                    object2 = this.connection_.getWarnings();
                                    if (object2 != null && !this.silent) {
                                        Main.dispWarning(printStream, (SQLWarning)object2, this.hideWarnings_, this.html_);
                                    }
                                }
                            }
                            catch (Exception exception) {
                                exception.printStackTrace(printStream);
                                string11 = null;
                            }
                            if (object != null) {
                                DriverManager.registerDriver(object);
                            }
                            this.conLabel_ = this.conName;
                            if (this.conCount > 0) {
                                this.conLabel_ = this.conLabel_ + this.conCount;
                            }
                            ++this.conCount;
                        }
                    }
                    if (string11 == null) {
                        printStream.println("Usage:  CONNECT TO URL [URL] [USERID=XXXX] [PASSWORD=YYYY]");
                        printStream.println("  i.e.  CONNECT TO URL jdbc:db2:localhost USERID=EBERHARD PASSWORD=XXXXX");
                        printStream.println("        CONNECT TO URL jdbc:db2://localhost/*LOCAL USERID=EBERHARD PASSWORD=XXXXX");
                        printStream.println("        CONNECT TO URL jdbc:db2:SAMPLE\\;transaction isolation=serializable USERID=EBERHARD PASSWORD=XXXXXXX");
                    }
                    break block371;
                }
                if (string2.startsWith("CONNECT TO SCHEMA")) {
                    String string12;
                    Object object;
                    int n;
                    int n6;
                    String string13;
                    this.history.addElement("!" + string);
                    if (this.connection_ != null) {
                        if (this.connection_ != this.poolConnection) {
                            this.connection_.close();
                            this.cstmt_ = null;
                            this.cstmtSql_ = "";
                            this.variables.remove("CSTMT");
                        }
                        this.connection_ = null;
                    }
                    if ((string13 = string.substring(17).trim()).length() > 0) {
                        n6 = string13.indexOf(47);
                        if (n6 >= 0) {
                            n = this.url_.indexOf(":");
                            n = this.url_.indexOf(":", n + 1);
                            object = this.url_.substring(0, n + 1);
                            string12 = (String)object + string13 + this.urlArgs_;
                        } else {
                            string12 = this.url_ + "/" + string13 + this.urlArgs_;
                        }
                    } else {
                        string12 = this.url_ + this.urlArgs_;
                    }
                    n6 = string12.indexOf(" ;");
                    while (n6 > 0) {
                        string12 = string12.substring(0, n6) + string12.substring(n6 + 1);
                        n6 = string12.indexOf(" ;");
                    }
                    if (this.userid_ != null) {
                        if (this.debug_) {
                            printStream.println("Connecting using " + this.userid_ + ", " + this.password_ + " to " + string12);
                        }
                        if (this.useConnectionPool_) {
                            this.connection_ = this.getPooledConnection(this.userid_, this.password_, string12, printStream);
                        } else {
                            this.connection_ = DriverManager.getConnection(string12, this.userid_, this.password_);
                            SQLWarning sQLWarning = this.connection_.getWarnings();
                            if (sQLWarning != null && !this.silent) {
                                Main.dispWarning(printStream, sQLWarning, this.hideWarnings_, this.html_);
                            }
                        }
                        this.addVariable("CON", this.connection_);
                    } else {
                        if (this.debug_) {
                            printStream.println("Connecting using default id and password to " + string12);
                        }
                        if (this.useConnectionPool_) {
                            this.connection_ = this.getPooledConnection("null", "null", string12, printStream);
                        } else {
                            this.connection_ = DriverManager.getConnection(string12);
                            SQLWarning sQLWarning = this.connection_.getWarnings();
                            if (sQLWarning != null && !this.silent) {
                                Main.dispWarning(printStream, sQLWarning, this.hideWarnings_, this.html_);
                            }
                        }
                        this.addVariable("CON", this.connection_);
                    }
                    this.conLabel_ = this.conName;
                    if (this.conCount > 0) {
                        this.conLabel_ = this.conLabel_ + this.conCount;
                    }
                    ++this.conCount;
                    int n7 = string13.indexOf(59);
                    if (n7 > 0) {
                        string13 = string13.substring(0, n7).trim();
                    }
                    if (string13.length() > 0) {
                        n = string13.lastIndexOf("/");
                        if (n >= 0) {
                            string13 = string13.substring(n + 1);
                        }
                        object = this.connection_.prepareStatement("SET CURRENT PATH " + string13 + ", SYSTEM PATH");
                        object.execute();
                        object.close();
                    }
                    break block371;
                }
                if (string2.startsWith("CONNECT RESET")) {
                    this.history.addElement("!" + string);
                    if (this.connection_ != null) {
                        if (this.connection_ != this.poolConnection) {
                            this.connection_.close();
                            this.cstmt_ = null;
                            this.cstmtSql_ = "";
                            this.variables.remove("CSTMT");
                        }
                        this.connection_ = null;
                        this.variables.remove("CON");
                    }
                    break block371;
                }
                if (string2.startsWith("CHARACTERDETAILS")) {
                    this.history.addElement("!" + string);
                    String string14 = string.substring(16).trim().toUpperCase();
                    if (string14.equals("TRUE")) {
                        this.characterDetails_ = true;
                    } else if (string14.equals("ON")) {
                        this.characterDetails_ = true;
                    } else if (string14.equals("FALSE")) {
                        this.characterDetails_ = false;
                    } else if (string14.equals("OFF")) {
                        this.characterDetails_ = false;
                    } else {
                        printStream.println("Invalid arg '" + string14 + "' for CHARACTERDETAILS");
                    }
                    break block371;
                }
                if (string2.startsWith("ECHOCOMMAND")) {
                    this.history.addElement("!" + string);
                    String string15 = string.substring(11).trim().toUpperCase();
                    if (string15.equals("TRUE")) {
                        this.echoCommand_ = true;
                    } else if (string15.equals("ON")) {
                        this.echoCommand_ = true;
                    } else if (string15.equals("FALSE")) {
                        this.echoCommand_ = false;
                    } else if (string15.equals("OFF")) {
                        this.echoCommand_ = false;
                    } else {
                        printStream.println("Invalid arg '" + string15 + "' for ECHOCOMMAND");
                    }
                    break block371;
                }
                if (string2.startsWith("PRINTSTACKTRACE")) {
                    this.history.addElement("!" + string);
                    String string16 = string.substring(15).trim().toUpperCase();
                    if (string16.equals("TRUE")) {
                        this.printStackTrace_ = true;
                    } else if (string16.equals("ON")) {
                        this.printStackTrace_ = true;
                    } else if (string16.equals("FALSE")) {
                        this.printStackTrace_ = false;
                    } else if (string16.equals("OFF")) {
                        this.printStackTrace_ = false;
                    } else {
                        printStream.println("Invalid arg '" + string16 + "' for ECHOCOMMAND");
                    }
                    break block371;
                }
                if (string2.startsWith("CLOSESTATEMENTRS")) {
                    this.history.addElement("!" + string);
                    String string17 = string.substring(16).trim().toUpperCase();
                    if (string17.equals("TRUE")) {
                        this.closeStatementRS_ = true;
                    } else if (string17.equals("ON")) {
                        this.closeStatementRS_ = true;
                    } else if (string17.equals("FALSE")) {
                        this.closeStatementRS_ = false;
                    } else if (string17.equals("OFF")) {
                        this.closeStatementRS_ = false;
                    } else {
                        printStream.println("Invalid arg '" + string17 + "' for closeStatementRS");
                    }
                    break block371;
                }
                if (string2.startsWith("MEASUREEXECUTE")) {
                    this.history.addElement("!" + string);
                    String string18 = string.substring(14).trim().toUpperCase();
                    if (string18.equals("TRUE")) {
                        this.measureExecute_ = true;
                    } else if (string18.equals("ON")) {
                        this.measureExecute_ = true;
                    } else if (string18.equals("FALSE")) {
                        this.measureExecute_ = false;
                    } else if (string18.equals("OFF")) {
                        this.measureExecute_ = false;
                    } else {
                        printStream.println("Invalid arg '" + string18 + "' for measureExecute");
                    }
                    break block371;
                }
                if (string2.startsWith("CALL ")) {
                    this.history.addElement(string);
                    if (this.connection_ != null) {
                        ResultSet resultSet;
                        int n;
                        int n8 = string.indexOf("-- INPARM");
                        String string19 = null;
                        if (n8 > 0) {
                            string19 = string.substring(n8 + 9).trim();
                            string = string.substring(0, n8);
                        }
                        this.cstmt_ = this.jdk14_ ? this.connection_.prepareCall(string, this.resultSetType_, this.resultSetConcurrency_, this.resultSetHoldability_) : this.connection_.prepareCall(string);
                        this.addVariable("CSTMT", this.cstmt_);
                        if (this.jdk14_) {
                            ParameterMetaData parameterMetaData = this.cstmt_.getParameterMetaData();
                            int n9 = parameterMetaData.getParameterCount();
                            for (int i = 1; i <= n9; ++i) {
                                n = parameterMetaData.getParameterMode(i);
                                if (n == 4 || n == 2) {
                                    int n10 = parameterMetaData.getParameterType(i);
                                    switch (n10) {
                                        case -8: 
                                        case -4: 
                                        case -3: 
                                        case -2: 
                                        case 2003: 
                                        case 2004: {
                                            this.cstmt_.registerOutParameter(i, n10);
                                            break;
                                        }
                                        default: {
                                            this.cstmt_.registerOutParameter(i, 12);
                                        }
                                    }
                                }
                                if (n != 1 && n != 2) continue;
                                String string20 = string19;
                                if (string19 != null && (n8 = string19.indexOf(",")) >= 0) {
                                    string20 = string19.substring(0, n8).trim();
                                    string19 = string19.substring(n8 + 1).trim();
                                }
                                if (string20 != null) {
                                    this.setParameter(this.cstmt_, string20, i, printStream);
                                    continue;
                                }
                                printStream.println("Warning:  thisParm is null");
                                printStream.println("--INPARM not found but num param > 0 ");
                            }
                        } else if (string.indexOf("?") >= 0) {
                            throw new SQLException("Use of parameter markers in call statement only supported in JDK 1.4 -- statement was " + string);
                        }
                        boolean bl2 = this.cstmt_.execute();
                        SQLWarning sQLWarning = this.cstmt_.getWarnings();
                        if (sQLWarning != null) {
                            if (!this.silent) {
                                Main.dispWarning(printStream, sQLWarning, this.hideWarnings_, this.html_);
                            }
                            if (this.html_) {
                                printStream.println("Statement was " + string);
                            }
                        }
                        if (this.jdk14_) {
                            ParameterMetaData parameterMetaData = this.cstmt_.getParameterMetaData();
                            n = parameterMetaData.getParameterCount();
                            block50: for (int i = 1; i <= n; ++i) {
                                int n11 = parameterMetaData.getParameterMode(i);
                                if (n11 != 4 && n11 != 2) continue;
                                int n12 = parameterMetaData.getParameterType(i);
                                switch (n12) {
                                    case -8: 
                                    case -4: 
                                    case -3: 
                                    case -2: 
                                    case 2004: {
                                        printStream.print("Parameter " + i + " returned ");
                                        byte[] byArray = this.cstmt_.getBytes(i);
                                        if (byArray == null) {
                                            printStream.println("null");
                                            continue block50;
                                        }
                                        if (byArray.length < this.showLobThreshold_) {
                                            printStream.print("X'");
                                            for (int j = 0; j < byArray.length; ++j) {
                                                int n13 = 0xFF & byArray[j];
                                                if (n13 < 16) {
                                                    printStream.print("0" + Integer.toHexString(n13));
                                                    continue;
                                                }
                                                printStream.print(Integer.toHexString(n13));
                                            }
                                            printStream.println("'");
                                            continue block50;
                                        }
                                        CRC32 cRC32 = new CRC32();
                                        cRC32.update(byArray);
                                        printStream.println("ARRAY[size=" + byArray.length + ",CRC32=" + cRC32.getValue() + "]");
                                        continue block50;
                                    }
                                    case 2003: {
                                        printStream.print("Parameter " + i + " returned ARRAY ");
                                        this.printArray(printStream, this.cstmt_.getArray(i));
                                        printStream.println();
                                        continue block50;
                                    }
                                    default: {
                                        printStream.print("Parameter " + i + " returned ");
                                        this.savedStringParm_[i] = this.cstmt_.getString(i);
                                        this.printUnicodeString(printStream, this.savedStringParm_[i]);
                                        printStream.println();
                                    }
                                }
                            }
                        }
                        if (bl2 && (resultSet = this.cstmt_.getResultSet()) != null) {
                            if (this.manualFetch_) {
                                ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                                this.manualResultSetNumCols_ = resultSetMetaData.getColumnCount();
                                this.setManualResultSetColType(resultSetMetaData);
                                this.manualResultSet_ = resultSet;
                                this.addVariable("RS", this.manualResultSet_);
                                this.manualResultSetColumnLabel_ = Main.dispColumnHeadings(printStream, resultSet, resultSetMetaData, false, this.manualResultSetNumCols_, this.html_, this.xml_);
                            } else {
                                this.dispResultSet(printStream, resultSet, false);
                                if (this.closeStatementRS_) {
                                    resultSet.close();
                                    resultSet = null;
                                }
                            }
                            if (!this.manualFetch_) {
                                while (this.cstmt_.getMoreResults()) {
                                    printStream.println("<<<< NEXT RESULT SET >>>>>>>");
                                    resultSet = this.cstmt_.getResultSet();
                                    this.dispResultSet(printStream, resultSet, false);
                                    if (!this.closeStatementRS_) continue;
                                    resultSet.close();
                                    resultSet = null;
                                }
                            }
                        }
                        if (!this.manualFetch_ && this.closeStatementRS_) {
                            this.cstmt_.close();
                        }
                    } else {
                        printStream.println("UNABLE to EXECUTE CALL because not connected");
                    }
                    break block371;
                }
                if (string2.startsWith("EXISTFILE")) {
                    this.history.addElement("!" + string);
                    String string21 = string.substring(9).trim();
                    try {
                        File file = new File(string21);
                        if (file.exists()) {
                            printStream.println("EXISTFILE " + string21 + ": YES");
                            break block371;
                        }
                        printStream.println("EXISTFILE " + string21 + ": NO");
                    }
                    catch (Exception exception) {
                        exception.printStackTrace(printStream);
                    }
                    break block371;
                }
                if (string2.startsWith("GC")) {
                    this.history.addElement("!" + string);
                    this.startTime_ = System.currentTimeMillis();
                    System.gc();
                    this.finishTime_ = System.currentTimeMillis();
                    printStream.println("GC ran in " + (this.finishTime_ - this.startTime_) + " milliseconds");
                    break block371;
                }
                if (string2.startsWith("OUTPUT FORMAT ")) {
                    this.history.addElement("!" + string);
                    String string22 = string.substring(14).trim().toUpperCase();
                    if (string22.equals("XML")) {
                        this.xml_ = true;
                        this.html_ = false;
                    } else if (string22.equals("HTML")) {
                        this.html_ = true;
                        this.xml_ = false;
                    } else {
                        printStream.println("Error.  Did not recognize output format '" + string22 + "'");
                    }
                    break block371;
                }
                if (string2.startsWith("SHOWMIXEDUX ")) {
                    this.history.addElement("!" + string);
                    String string23 = string.substring(11).trim().toUpperCase();
                    if (string23.equals("TRUE")) {
                        this.showMixedUX_ = true;
                    } else if (string23.equals("FALSE")) {
                        this.showMixedUX_ = false;
                    } else {
                        printStream.println("Error.  Did not recognize SHOWMIXEDUX value  '" + string23 + "'");
                    }
                    break block371;
                }
                if (string2.startsWith("QUIT") || string2.startsWith("EXIT")) {
                    bl = false;
                    break block371;
                }
                if (string2.startsWith("SET AUTOCOMMIT")) {
                    this.history.addElement("!" + string);
                    String string24 = string.substring(14).trim();
                    if (string24.startsWith("true")) {
                        this.connection_.setAutoCommit(true);
                    } else if (string24.startsWith("false")) {
                        this.connection_.setAutoCommit(false);
                    } else {
                        printStream.println("SET AUTOCOMMIT:  Didn't understand \"" + string24 + "\"");
                        printStream.println("  Usage:  SET AUTOCOMMIT true");
                        printStream.println("          SET AUTOCOMMIT false");
                    }
                    break block371;
                }
                if (string2.startsWith("REUSE CONNECTION")) {
                    this.history.addElement("!" + string);
                    String string25 = string.substring(16).trim();
                    if (string25.startsWith("true")) {
                        this.useConnectionPool_ = true;
                    } else if (string25.startsWith("false")) {
                        this.useConnectionPool_ = false;
                    } else {
                        printStream.println("REUSE CONNECTION:  Didn't understand \"" + string25 + "\"");
                        printStream.println("  Usage:  REUSE CONNECTION true");
                        printStream.println("          REUSE CONNECTION false");
                    }
                    break block371;
                }
                if (string2.startsWith("REUSE STATEMENT")) {
                    this.history.addElement("!" + string);
                    String string26 = string.substring(16).trim();
                    if (string26.startsWith("true")) {
                        this.reuseStatement_ = true;
                    } else if (string26.startsWith("false")) {
                        this.reuseStatement_ = false;
                    } else {
                        printStream.println("REUSE STATEMENT:  Didn't understand \"" + string26 + "\"");
                        printStream.println("  Usage:  REUSE STATEMENT true");
                        printStream.println("          REUSE STATEMENT false");
                    }
                    break block371;
                }
                if (string2.startsWith("SETCLITRACE")) {
                    this.history.addElement("!" + string);
                    boolean bl3 = false;
                    boolean bl4 = false;
                    String string27 = string.substring(11).trim();
                    if (string27.startsWith("true")) {
                        bl3 = true;
                        bl4 = true;
                    } else if (string27.startsWith("false")) {
                        bl3 = false;
                        bl4 = true;
                    }
                    if (bl4) {
                        try {
                            Class<?> clazz = Class.forName("com.ibm.db2.jdbc.app.T");
                            Class[] classArray = new Class[]{Boolean.TYPE};
                            Method method = clazz.getMethod("setCliTrace", classArray);
                            Object[] objectArray = new Object[]{new Boolean(bl3)};
                            method.invoke(null, objectArray);
                        }
                        catch (Exception exception) {
                            printStream.println("Exception while setting cli trace");
                            exception.printStackTrace(printStream);
                        }
                    } else {
                        printStream.println("SETCLITRACE:  Didn't understand \"" + string27 + "\"");
                        printStream.println("  Usage:  SETCLITRACE true");
                        printStream.println("          SETCLITRACE false");
                    }
                    break block371;
                }
                if (string2.startsWith("SETDB2TRACE")) {
                    this.history.addElement("!" + string);
                    try {
                        String string28 = string.substring(11).trim();
                        Class<?> clazz = Class.forName("com.ibm.db2.jdbc.app.T");
                        Class[] classArray = new Class[]{Integer.TYPE};
                        Method method = clazz.getMethod("setDb2Trace", classArray);
                        Object[] objectArray = new Object[]{string28.startsWith("true") ? new Integer(3) : (string28.startsWith("false") ? new Integer(0) : new Integer(Integer.parseInt(string28)))};
                        method.invoke(null, objectArray);
                    }
                    catch (Exception exception) {
                        printStream.println("Exception while setting cli trace");
                        exception.printStackTrace(printStream);
                    }
                    break block371;
                }
                if (string2.startsWith("SET TRANSACTIONISOLATION")) {
                    this.history.addElement("!" + string);
                    String string29 = string.substring(24).trim();
                    if (string29.startsWith("TRANSACTION_READ_UNCOMMITTED")) {
                        this.connection_.setTransactionIsolation(1);
                    } else if (string29.startsWith("TRANSACTION_READ_COMMITTED")) {
                        this.connection_.setTransactionIsolation(2);
                    } else if (string29.startsWith("TRANSACTION_REPEATABLE_READ")) {
                        this.connection_.setTransactionIsolation(4);
                    } else if (string29.startsWith("TRANSACTION_SERIALIZABLE")) {
                        this.connection_.setTransactionIsolation(8);
                    } else {
                        printStream.println("SET TRANSACTIONISOLATION:  Didn't understand \"" + string29 + "\"");
                        printStream.println("  Usage:  SET TRANSACTIONISOLATION TRANSACTION_READ_UNCOMMITTED");
                        printStream.println("          SET TRANSACTIONISOLATION TRANSACTION_READ_COMMITTED");
                        printStream.println("          SET TRANSACTIONISOLATION TRANSACTION_REPEATABLE_READ");
                        printStream.println("          SET TRANSACTIONISOLATION TRANSACTION_SERIALIZABLE");
                    }
                    break block371;
                }
                if (string2.startsWith("USAGE") || string2.startsWith("HELP")) {
                    for (int i = 0; i < commandHelp.length; ++i) {
                        printStream.println(commandHelp[i]);
                    }
                    break block371;
                }
                if (string2.startsWith("GETSERVERJOBNAME")) {
                    this.history.addElement("!" + string);
                    try {
                        String string30 = ReflectionUtil.callMethod_S(this.connection_, "getServerJobName");
                        printStream.println("getServerJobName returned " + string30);
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        try {
                            DatabaseMetaData databaseMetaData = this.connection_.getMetaData();
                            String string31 = databaseMetaData.getDriverName();
                            if (string31.indexOf("Toolbox") >= 0 || string31.indexOf("jtopenlite") >= 0) {
                                String string32 = "";
                                try {
                                    string32 = ReflectionUtil.callMethod_S(this.connection_, "getServerJobIdentifier");
                                    if (string32.length() >= 26) {
                                        string32 = string32.substring(20).trim() + "/" + string32.substring(10, 20).trim() + "/" + string32.substring(0, 10).trim();
                                    }
                                    printStream.println("getServerJobName returned " + string32);
                                }
                                catch (Exception exception) {
                                    printStream.println("server jobname is not available");
                                }
                            } else {
                                printStream.println("getServerJobName:3 failed with exception " + noSuchMethodException + " for driver " + string31);
                                noSuchMethodException.printStackTrace(printStream);
                            }
                            break block371;
                        }
                        catch (Exception exception) {
                            printStream.println("getServerJobName:2 failed with 2 exceptions ");
                            noSuchMethodException.printStackTrace(printStream);
                            exception.printStackTrace(printStream);
                        }
                    }
                    catch (Exception exception) {
                        printStream.println("getServerJobName:1 failed with exception " + exception);
                        exception.printStackTrace(printStream);
                    }
                    break block371;
                }
                if (string2.startsWith("DMD.GETCOLUMNS")) {
                    this.history.addElement("!" + string);
                    try {
                        String string33 = null;
                        String string34 = null;
                        String string35 = null;
                        String string36 = null;
                        DatabaseMetaData databaseMetaData = this.connection_.getMetaData();
                        String string37 = string.substring(14).trim();
                        int n = string37.indexOf(",");
                        if (n > 0) {
                            string33 = string37.substring(0, n).trim();
                            if (string33.equals("null")) {
                                string33 = null;
                            }
                            if ((n = (string37 = string37.substring(n + 1)).indexOf(",")) > 0) {
                                string34 = string37.substring(0, n).trim();
                                if (string34.equals("null")) {
                                    string34 = null;
                                }
                                if ((n = (string37 = string37.substring(n + 1)).indexOf(",")) > 0) {
                                    string35 = string37.substring(0, n).trim();
                                    if (string35.equals("null")) {
                                        string35 = null;
                                    }
                                    if ((string36 = string37.substring(n + 1).trim()).equals("null")) {
                                        string36 = null;
                                    }
                                }
                            }
                        }
                        printStream.println("Calling dmd.getColumns(" + string33 + ", " + string34 + ", " + string35 + ", " + string36 + ")");
                        ResultSet resultSet = databaseMetaData.getColumns(string33, string34, string35, string36);
                        if (resultSet != null) {
                            this.dispResultSet(printStream, resultSet, false);
                            resultSet.close();
                        }
                        break block371;
                    }
                    catch (Exception exception) {
                        printStream.println("databaseMetaData.getColumns failed with exception " + exception);
                        exception.printStackTrace(printStream);
                    }
                    break block371;
                }
                if (string2.startsWith("DMD.GETTABLES")) {
                    this.history.addElement("!" + string);
                    try {
                        Object object;
                        String string38 = null;
                        String string39 = null;
                        String string40 = null;
                        String string41 = null;
                        String[] stringArray = null;
                        DatabaseMetaData databaseMetaData = this.connection_.getMetaData();
                        String string42 = string.substring(14).trim();
                        int n = string42.indexOf(",");
                        if (n > 0) {
                            string38 = string42.substring(0, n).trim();
                            if (string38.equals("null")) {
                                string38 = null;
                            }
                            if ((n = (string42 = string42.substring(n + 1)).indexOf(",")) > 0) {
                                string39 = string42.substring(0, n).trim();
                                if (string39.equals("null")) {
                                    string39 = null;
                                }
                                if ((n = (string42 = string42.substring(n + 1)).indexOf(",")) > 0) {
                                    string40 = string42.substring(0, n).trim();
                                    if (string40.equals("null")) {
                                        string40 = null;
                                    }
                                    if ((string41 = string42.substring(n + 1).trim()).equals("null")) {
                                        string41 = null;
                                    } else {
                                        object = new Vector();
                                        int n14 = string41.indexOf(124);
                                        while (n14 > 0) {
                                            String string43 = string41.substring(0, n14);
                                            ((Vector)object).add(string43);
                                            string41 = string41.substring(1 + n14);
                                            n14 = string41.indexOf(124);
                                        }
                                        ((Vector)object).add(string41);
                                        int n15 = ((Vector)object).size();
                                        stringArray = new String[n15];
                                        for (int i = 0; i < n15; ++i) {
                                            stringArray[i] = (String)((Vector)object).elementAt(i);
                                        }
                                    }
                                }
                            }
                        }
                        printStream.println("Calling dmd.getTables(" + string38 + ", " + string39 + ", " + string40 + ", " + string41 + "=" + StringFormatUtil.stringArrayContents(stringArray) + ")");
                        object = databaseMetaData.getTables(string38, string39, string40, stringArray);
                        if (object != null) {
                            this.dispResultSet(printStream, (ResultSet)object, false);
                            object.close();
                        }
                        break block371;
                    }
                    catch (Exception exception) {
                        printStream.println("databaseMetaData.getTables failed with exception " + exception);
                        exception.printStackTrace(printStream);
                    }
                    break block371;
                }
                if (string2.startsWith("DMD.GETINDEXINFO")) {
                    this.history.addElement("!" + string);
                    try {
                        Object object;
                        String string44 = null;
                        String string45 = null;
                        String string46 = null;
                        boolean bl5 = false;
                        boolean bl6 = false;
                        DatabaseMetaData databaseMetaData = this.connection_.getMetaData();
                        String string47 = string.substring(16).trim();
                        int n = string47.indexOf(",");
                        if (n > 0) {
                            string44 = string47.substring(0, n).trim();
                            if (string44.equals("null")) {
                                string44 = null;
                            }
                            if ((n = (string47 = string47.substring(n + 1)).indexOf(",")) > 0) {
                                string45 = string47.substring(0, n).trim();
                                if (string45.equals("null")) {
                                    string45 = null;
                                }
                                if ((n = (string47 = string47.substring(n + 1)).indexOf(",")) > 0) {
                                    string46 = string47.substring(0, n).trim();
                                    if (string46.equals("null")) {
                                        string46 = null;
                                    }
                                    if ((n = (string47 = string47.substring(n + 1)).indexOf(",")) > 0) {
                                        object = string47.substring(0, n).trim();
                                        bl5 = ((String)object).equalsIgnoreCase("true");
                                        String string48 = string47 = string47.substring(n + 1);
                                        bl6 = string48.equalsIgnoreCase("true");
                                    }
                                }
                            }
                        }
                        printStream.println("Calling dmd.getIndexInfo(" + string44 + ", " + string45 + ", " + string46 + ", " + bl5 + "," + bl6 + ")");
                        object = databaseMetaData.getIndexInfo(string44, string45, string46, bl5, bl6);
                        if (object != null) {
                            this.dispResultSet(printStream, (ResultSet)object, false);
                            object.close();
                        }
                        break block371;
                    }
                    catch (Exception exception) {
                        printStream.println("databaseMetaData.getIndexInfo failed with exception " + exception);
                        exception.printStackTrace(printStream);
                    }
                    break block371;
                }
                if (string2.startsWith("DMD.GETSCHEMAS")) {
                    this.history.addElement("!" + string);
                    try {
                        DatabaseMetaData databaseMetaData = this.connection_.getMetaData();
                        printStream.println("Calling dmd.getSchemas()");
                        ResultSet resultSet = databaseMetaData.getSchemas();
                        if (resultSet != null) {
                            this.dispResultSet(printStream, resultSet, false);
                            resultSet.close();
                        }
                        break block371;
                    }
                    catch (Exception exception) {
                        printStream.println("databaseMetaData.getSchemas failed with exception " + exception);
                        exception.printStackTrace(printStream);
                    }
                    break block371;
                }
                if (string2.startsWith("HISTORY.CLEAR")) {
                    this.history.clear();
                    break block371;
                }
                if (string2.startsWith("HISTORY.SHOW")) {
                    Enumeration enumeration = this.history.elements();
                    while (enumeration.hasMoreElements()) {
                        String string49 = (String)enumeration.nextElement();
                        printStream.println(string49);
                    }
                    break block371;
                }
                if (string2.startsWith("MANUALFETCH")) {
                    this.history.addElement("!" + string);
                    String string50 = string.substring(11).trim().toUpperCase();
                    if (string50.equals("TRUE")) {
                        this.manualFetch_ = true;
                    } else if (string50.equals("ON")) {
                        this.manualFetch_ = true;
                    } else if (string50.equals("FALSE")) {
                        this.manualFetch_ = false;
                    } else if (string50.equals("OFF")) {
                        this.manualFetch_ = false;
                    } else {
                        printStream.println("Invalid arg '" + string50 + "' for MANUALFETCH");
                    }
                    break block371;
                }
                if (string2.startsWith("RS.NEXT")) {
                    this.history.addElement("!" + string);
                    boolean bl7 = this.manualResultSet_.next();
                    if (bl7) {
                        Main.dispRow(printStream, this.manualResultSet_, false, this.manualResultSetNumCols_, this.manualResultSetColType_, this.manualResultSetColumnLabel_, null, this.xml_, this.html_, this.showLobThreshold_, this.stringSampleSize_, this.characterDetails_, this.showMixedUX_);
                    } else {
                        printStream.println("rs.next returned false");
                    }
                    break block371;
                }
                if (string2.startsWith("RS.FIRST")) {
                    this.history.addElement("!" + string);
                    boolean bl8 = this.manualResultSet_.first();
                    if (bl8) {
                        Main.dispRow(printStream, this.manualResultSet_, false, this.manualResultSetNumCols_, this.manualResultSetColType_, this.manualResultSetColumnLabel_, null, this.xml_, this.html_, this.showLobThreshold_, this.stringSampleSize_, this.characterDetails_, this.showMixedUX_);
                    } else {
                        printStream.println("rs.first returned false");
                    }
                    break block371;
                }
                if (string2.startsWith("RS.BEFOREFIRST")) {
                    this.history.addElement("!" + string);
                    this.manualResultSet_.beforeFirst();
                    printStream.println("rs.beforeFirst called");
                    break block371;
                }
                if (string2.startsWith("RS.AFTERLAST")) {
                    this.history.addElement("!" + string);
                    this.manualResultSet_.afterLast();
                    printStream.println("rs.afterLast called");
                    break block371;
                }
                if (string2.startsWith("RS.LAST")) {
                    this.history.addElement("!" + string);
                    boolean bl9 = this.manualResultSet_.last();
                    if (bl9) {
                        Main.dispRow(printStream, this.manualResultSet_, false, this.manualResultSetNumCols_, this.manualResultSetColType_, this.manualResultSetColumnLabel_, null, this.xml_, this.html_, this.showLobThreshold_, this.stringSampleSize_, this.characterDetails_, this.showMixedUX_);
                    } else {
                        printStream.println("rs.last returned false");
                    }
                    break block371;
                }
                if (string2.startsWith("RS.PREVIOUS")) {
                    this.history.addElement("!" + string);
                    boolean bl10 = this.manualResultSet_.previous();
                    if (bl10) {
                        Main.dispRow(printStream, this.manualResultSet_, false, this.manualResultSetNumCols_, this.manualResultSetColType_, this.manualResultSetColumnLabel_, null, this.xml_, this.html_, this.showLobThreshold_, this.stringSampleSize_, this.characterDetails_, this.showMixedUX_);
                    } else {
                        printStream.println("rs.previous returned false");
                    }
                    break block371;
                }
                if (string2.startsWith("RS.ABSOLUTE")) {
                    this.history.addElement("!" + string);
                    String string51 = string.substring(11).trim().toUpperCase();
                    int n = Integer.parseInt(string51);
                    boolean bl11 = this.manualResultSet_.absolute(n);
                    if (bl11) {
                        Main.dispRow(printStream, this.manualResultSet_, false, this.manualResultSetNumCols_, this.manualResultSetColType_, this.manualResultSetColumnLabel_, null, this.xml_, this.html_, this.showLobThreshold_, this.stringSampleSize_, this.characterDetails_, this.showMixedUX_);
                    } else {
                        printStream.println("rs.absolute returned false");
                    }
                    break block371;
                }
                if (string2.startsWith("RS.RELATIVE")) {
                    this.history.addElement("!" + string);
                    String string52 = string.substring(11).trim().toUpperCase();
                    int n = Integer.parseInt(string52);
                    boolean bl12 = this.manualResultSet_.relative(n);
                    if (bl12) {
                        Main.dispRow(printStream, this.manualResultSet_, false, this.manualResultSetNumCols_, this.manualResultSetColType_, this.manualResultSetColumnLabel_, null, this.xml_, this.html_, this.showLobThreshold_, this.stringSampleSize_, this.characterDetails_, this.showMixedUX_);
                    } else {
                        printStream.println("rs.relative returned false");
                    }
                    break block371;
                }
                if (string2.startsWith("SETVAR")) {
                    this.history.addElement("!" + string);
                    try {
                        String string53 = string.substring(6).trim();
                        int n = string53.indexOf("=");
                        if (n > 0) {
                            String string54 = string53.substring(0, n).trim();
                            Object object = this.callMethod(string53 = string53.substring(n + 1), printStream);
                            if (object != null) {
                                this.addVariable(string54, object);
                                printStream.println(string54 + "=" + object.toString());
                            } else {
                                printStream.println("ERROR:  Method not found or output is null");
                            }
                            break block371;
                        }
                        int n16 = string53.indexOf(" ");
                        if (n16 > 0) {
                            String string55 = string53.substring(0, n16).trim();
                            Object object = this.getParameterObject(string53 = string53.substring(n16 + 1), printStream);
                            if (object != null) {
                                this.addVariable(string55, object);
                                printStream.println(string55 + "=" + object.toString());
                            } else {
                                printStream.println("ERROR:  Unable to get parameter ");
                            }
                            break block371;
                        }
                        printStream.println("ERROR:  '=' or ' ' not found after SETVAR [VAR]");
                    }
                    catch (Exception exception) {
                        exception.printStackTrace(printStream);
                    }
                    break block371;
                }
                if (string2.startsWith("SETNEWVAR")) {
                    this.history.addElement("!" + string);
                    try {
                        String string56 = string.substring(9).trim();
                        int n = string56.indexOf("=");
                        if (n > 0) {
                            String string57 = string56.substring(0, n).trim();
                            Object object = this.callNewMethod(string56 = string56.substring(n + 1), printStream);
                            if (object != null) {
                                this.addVariable(string57, object);
                                printStream.println(string57 + "=" + object.toString());
                            } else {
                                printStream.println("ERROR:  Method not found or output is null");
                            }
                            break block371;
                        }
                        printStream.println("line missing =");
                    }
                    catch (Exception exception) {
                        exception.printStackTrace(printStream);
                    }
                    break block371;
                }
                if (string2.startsWith("SHOWVARMETHODS")) {
                    this.history.addElement("!" + string);
                    String string58 = string.substring(14).trim();
                    this.showMethods(string58, printStream);
                    break block371;
                }
                if (string2.startsWith("THREAD ")) {
                    this.history.addElement("!" + string);
                    String string59 = string.substring(7).trim();
                    printStream.println("Starting thread for " + string59);
                    Main main = new Main(string59, printStream);
                    Thread thread = new Thread(main);
                    thread.start();
                    this.threads_.add(thread);
                    break block371;
                }
                if (string2.startsWith("REPEAT ")) {
                    this.history.addElement("!" + string);
                    String string60 = string.substring(7).trim();
                    int n = string60.indexOf(" ");
                    if (n > 0) {
                        int n17 = Integer.parseInt(string60.substring(0, n));
                        if (n17 > 0) {
                            String string61 = string60.substring(n).trim();
                            int n18 = n17;
                            int n19 = 1;
                            while (n17 > 0) {
                                printStream.println("Iteration " + n19 + " of " + n18);
                                ++n19;
                                this.executeTopLevelCommand(string61, printStream);
                                --n17;
                            }
                        } else {
                            printStream.println("Error.. invalid repeat count " + string60.substring(0, n));
                        }
                    } else {
                        printStream.println("Error.  No count for repeat");
                    }
                    break block371;
                }
                if (string2.startsWith("CALLMETHOD")) {
                    int n;
                    this.history.addElement("!" + string);
                    String string62 = string.substring(10).trim();
                    Object object = this.callMethod(string62, printStream);
                    printStream.println("Call returned " + object);
                    if (object != null && object instanceof InputStream) {
                        printStream.println("InputStream[ ");
                        InputStream inputStream = (InputStream)object;
                        n = inputStream.read();
                        while (n > 0) {
                            printStream.print(" " + Integer.toHexString(n));
                            n = inputStream.read();
                        }
                        printStream.println("]");
                    }
                    if (object != null && object.getClass().isArray()) {
                        int n20 = Array.getLength(object);
                        printStream.println("  .. Array of size " + n20);
                        for (n = 0; n < n20; ++n) {
                            Object object3 = Array.get(object, n);
                            if (object3 instanceof DriverPropertyInfo) {
                                DriverPropertyInfo driverPropertyInfo = (DriverPropertyInfo)object3;
                                printStream.println("[" + n + "]=" + driverPropertyInfo.name + " " + driverPropertyInfo.value + " " + driverPropertyInfo.description);
                                continue;
                            }
                            if (object3 instanceof Byte) {
                                int n21 = 0xFF & ((Byte)object3).intValue();
                                printStream.println("[" + n + "]=0x" + Integer.toHexString(n21) + " a[" + StringFormatUtil.asciiChar(n21) + "]" + " e[" + StringFormatUtil.ebcdicChar(n21) + "]");
                                continue;
                            }
                            printStream.println("[" + n + "][" + object3.getClass().getName() + "]=" + object3);
                        }
                    }
                    break block371;
                }
                if (string2.length() == 0) break block371;
                if (this.connection_ != null) {
                    SQLWarning sQLWarning;
                    if (!(this.connection_ == null || this.stmt_ != null && this.reuseStatement_)) {
                        this.stmt_ = this.jdk14_ ? this.connection_.createStatement(this.resultSetType_, this.resultSetConcurrency_, this.resultSetHoldability_) : this.connection_.createStatement();
                        this.addVariable("STMT", this.stmt_);
                    }
                    if (this.queryTimeout_ != 0) {
                        this.stmt_.setQueryTimeout(this.queryTimeout_);
                    }
                    if (this.measureExecute_) {
                        this.startTime_ = System.currentTimeMillis();
                    }
                    this.stmt_.executeUpdate(string);
                    this.history.addElement(string);
                    if (this.measureExecute_) {
                        this.finishTime_ = System.currentTimeMillis();
                        printStream.println("TIME: " + (this.finishTime_ - this.startTime_) + " ms");
                    }
                    if ((sQLWarning = this.stmt_.getWarnings()) != null && !this.silent) {
                        Main.dispWarning(printStream, sQLWarning, this.hideWarnings_, this.html_);
                    }
                    break block371;
                }
                printStream.println("UNABLE to EXECUTE because not connected");
            }
            Object var18_181 = null;
            if (this.stmt_ == null) break block372;
            try {
                if (!this.reuseStatement_ && !this.manualFetch_ && this.closeStatementRS_) {
                    this.stmt_.close();
                    this.stmt_ = null;
                    this.variables.remove("STMT");
                }
                break block372;
            }
            catch (Exception exception) {
                exception.printStackTrace(printStream);
            }
            break block372;
            {
                catch (SQLException sQLException) {
                    if (!this.silent) {
                        this.processException(sQLException, string, printStream);
                    }
                    Object var18_182 = null;
                    if (this.stmt_ == null) break block372;
                    try {
                        if (!this.reuseStatement_ && !this.manualFetch_ && this.closeStatementRS_) {
                            this.stmt_.close();
                            this.stmt_ = null;
                            this.variables.remove("STMT");
                        }
                        break block372;
                    }
                    catch (Exception exception) {
                        exception.printStackTrace(printStream);
                    }
                    break block372;
                }
                catch (Exception exception) {
                    printStream.println("\n*** exception caught *** " + exception);
                    printStream.println("Statement was " + string);
                    exception.printStackTrace(printStream);
                    Object var18_183 = null;
                    if (this.stmt_ == null) break block372;
                    try {
                        if (!this.reuseStatement_ && !this.manualFetch_ && this.closeStatementRS_) {
                            this.stmt_.close();
                            this.stmt_ = null;
                            this.variables.remove("STMT");
                        }
                        break block372;
                    }
                    catch (Exception exception2) {
                        exception2.printStackTrace(printStream);
                    }
                    break block372;
                }
                catch (UnknownError unknownError) {
                    printStream.println("\n*** java.lang.UnknownError caught ***" + unknownError);
                    printStream.println("Statement was " + string);
                    unknownError.printStackTrace(printStream);
                    Object var18_184 = null;
                    if (this.stmt_ == null) break block372;
                    try {
                        if (!this.reuseStatement_ && !this.manualFetch_ && this.closeStatementRS_) {
                            this.stmt_.close();
                            this.stmt_ = null;
                            this.variables.remove("STMT");
                        }
                        break block372;
                    }
                    catch (Exception exception) {
                        exception.printStackTrace(printStream);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var18_185 = null;
                if (this.stmt_ != null) {
                    try {
                        if (!this.reuseStatement_ && !this.manualFetch_ && this.closeStatementRS_) {
                            this.stmt_.close();
                            this.stmt_ = null;
                            this.variables.remove("STMT");
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace(printStream);
                    }
                }
                throw throwable;
            }
        }
        return bl;
    }

    private Object callMethod(String string, PrintStream printStream) {
        try {
            Object object = null;
            int n = string.indexOf("(");
            if (n > 0) {
                int n2 = string.lastIndexOf(".", n);
                if (n2 > 0) {
                    String string2 = string.substring(0, n2).trim();
                    Object v = this.variables.get(string2);
                    Class<?> clazz = null;
                    string = string.substring(n2 + 1).trim();
                    n = string.indexOf("(");
                    String string3 = string.substring(0, n).trim();
                    string = string.substring(n + 1);
                    if (v == null) {
                        try {
                            clazz = Class.forName(string2);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (v != null || clazz != null) {
                        if (n > 0) {
                            Method[] methodArray = v instanceof Connection && !this.jdk14_ ? (string3.equals("commit") ? new Method[]{v.getClass().getMethod(string3, new Class[0])} : new Method[]{v.getClass().getMethod(string3, new Class[0])}) : (v != null ? v.getClass().getMethods() : (clazz != null ? clazz.getMethods() : new Method[]{}));
                            boolean bl = false;
                            boolean bl2 = false;
                            for (int i = 0; !bl && i < methodArray.length && object == null; ++i) {
                                int n3 = 0;
                                int n4 = 0;
                                if (!methodArray[i].getName().equals(string3)) continue;
                                Class<?>[] classArray = methodArray[i].getParameterTypes();
                                String string4 = string;
                                Object[] objectArray = new Object[classArray.length];
                                bl = true;
                                bl2 = true;
                                n4 = classArray.length;
                                String string5 = "";
                                for (n3 = 0; n3 < classArray.length; ++n3) {
                                    int n5;
                                    Object[] objectArray2;
                                    int n6;
                                    int n7;
                                    String string6;
                                    int n8 = 0;
                                    int n9 = 0;
                                    int n10 = 0;
                                    if (string4.length() > 1 && (string4.charAt(0) == '\"' || string4.charAt(0) == '\'')) {
                                        n8 = 1;
                                        n9 = string4.indexOf(string4.charAt(0), 1);
                                        if (n9 > 0) {
                                            if (string4.charAt(n9 + 1) == ',' || string4.charAt(n9 + 1) == ')') {
                                                n10 = n9 + 2;
                                            } else {
                                                printStream.println("[,)] does not follow #" + string4.charAt(0) + "#");
                                                n9 = -1;
                                            }
                                        }
                                    } else {
                                        n9 = string4.indexOf(",");
                                        if (n9 < 0) {
                                            n9 = string4.indexOf(")");
                                        }
                                        if (n9 >= 0) {
                                            n10 = n9 + 1;
                                        }
                                    }
                                    if (n9 < 0) {
                                        bl = false;
                                        printStream.println("Unable to find arg with remaining args " + string4);
                                        printStream.println("Number of parameters is " + classArray.length);
                                        bl = false;
                                        continue;
                                    }
                                    if (n8 > n9) continue;
                                    String string7 = string4.substring(n8, n9).trim();
                                    string4 = string4.substring(n10);
                                    Object v2 = this.variables.get(string7);
                                    if (v2 != null) {
                                        objectArray[n3] = v2;
                                        continue;
                                    }
                                    String string8 = classArray[n3].getName();
                                    string5 = string5 + string8 + " ";
                                    if (string7.equals("null")) {
                                        objectArray[n3] = null;
                                        continue;
                                    }
                                    if (string8.equals("java.lang.String") || string8.equals("java.lang.Object")) {
                                        objectArray[n3] = string7;
                                        continue;
                                    }
                                    if (string8.equals("boolean")) {
                                        try {
                                            objectArray[n3] = new Boolean(string7);
                                        }
                                        catch (Exception exception) {
                                            printStream.println("Could not parse " + string7 + " as integer");
                                            bl = false;
                                        }
                                        continue;
                                    }
                                    if (string8.equals("short")) {
                                        try {
                                            objectArray[n3] = new Short(string7);
                                        }
                                        catch (Exception exception) {
                                            printStream.println("Could not parse " + string7 + " as short");
                                            bl = false;
                                        }
                                        continue;
                                    }
                                    if (string8.equals("int")) {
                                        try {
                                            objectArray[n3] = new Integer(string7);
                                        }
                                        catch (Exception exception) {
                                            printStream.println("Could not parse " + string7 + " as integer");
                                            bl = false;
                                        }
                                        continue;
                                    }
                                    if (string8.equals("long")) {
                                        try {
                                            objectArray[n3] = new Long(string7);
                                        }
                                        catch (Exception exception) {
                                            printStream.println("Could not parse " + string7 + " as long");
                                            bl = false;
                                        }
                                        continue;
                                    }
                                    if (string8.equals("float")) {
                                        try {
                                            objectArray[n3] = new Float(string7);
                                        }
                                        catch (Exception exception) {
                                            printStream.println("Could not parse " + string7 + " as float");
                                            bl = false;
                                        }
                                        continue;
                                    }
                                    if (string8.equals("double")) {
                                        try {
                                            objectArray[n3] = new Double(string7);
                                        }
                                        catch (Exception exception) {
                                            printStream.println("Could not parse " + string7 + " as double");
                                            bl = false;
                                        }
                                        continue;
                                    }
                                    if (string8.equals("[Ljava.lang.String;")) {
                                        if (string7.charAt(0) == '[') {
                                            string6 = string7.substring(1);
                                            n7 = string6.length();
                                            n6 = 1;
                                            for (int j = 0; j < n7; ++j) {
                                                if (string6.charAt(j) != '+') continue;
                                                ++n6;
                                            }
                                            objectArray[n3] = objectArray2 = new String[n6];
                                            int n11 = 0;
                                            int n12 = 0;
                                            n5 = string6.indexOf(43, n12);
                                            if (n5 < 0) {
                                                n5 = string6.indexOf(93, n12);
                                            }
                                            while (n5 > 0) {
                                                if (n11 < n6) {
                                                    objectArray2[n11] = string6.substring(n12, n5);
                                                    ++n11;
                                                }
                                                if ((n12 = n5 + 1) >= n7) {
                                                    n5 = -1;
                                                    continue;
                                                }
                                                n5 = string6.indexOf(43, n12);
                                                if (n5 >= 0) continue;
                                                n5 = string6.indexOf(93, n12);
                                            }
                                            continue;
                                        }
                                        printStream.println("Could not parse " + string7 + " as String array .. try [A+B+C]");
                                        bl = false;
                                        continue;
                                    }
                                    if (string8.equals("[I")) {
                                        if (string7.charAt(0) == '[') {
                                            string6 = string7.substring(1);
                                            n7 = string6.length();
                                            n6 = 1;
                                            for (int j = 0; j < n7; ++j) {
                                                if (string6.charAt(j) != '+') continue;
                                                ++n6;
                                            }
                                            objectArray[n3] = objectArray2 = (Object[])new int[n6];
                                            String string9 = "";
                                            try {
                                                int n13 = 0;
                                                n5 = 0;
                                                int n14 = string6.indexOf(43, n5);
                                                if (n14 < 0) {
                                                    n14 = string6.indexOf(93, n5);
                                                }
                                                while (n14 > 0) {
                                                    if (n13 < n6) {
                                                        objectArray2[n13] = (String)Integer.parseInt(string6.substring(n5, n14));
                                                        ++n13;
                                                    }
                                                    if ((n5 = n14 + 1) >= n7) {
                                                        n14 = -1;
                                                        continue;
                                                    }
                                                    n14 = string6.indexOf(43, n5);
                                                    if (n14 >= 0) continue;
                                                    n14 = string6.indexOf(93, n5);
                                                }
                                                continue;
                                            }
                                            catch (Exception exception) {
                                                printStream.println("Exception " + exception + " piece = " + string9);
                                                printStream.println("Could not parse " + string7 + " as Integer.. try [1+2+3]");
                                                bl = false;
                                                continue;
                                            }
                                        }
                                        printStream.println("Could not parse " + string7 + " as Integer.. try [1+2+3]");
                                        bl = false;
                                        continue;
                                    }
                                    printStream.println("Did not handle parameter with class " + string8);
                                    bl = false;
                                }
                                if (bl) {
                                    if (n3 == n4) {
                                        if (string4.trim().equals(")") || string4.trim().length() == 0) {
                                            try {
                                                ((AccessibleObject)methodArray[i]).setAccessible(true);
                                                object = methodArray[i].invoke(v, objectArray);
                                            }
                                            catch (Exception exception) {
                                                exception.printStackTrace(printStream);
                                                printStream.println("Calling method " + string3 + " with " + string5 + " failed");
                                                bl = false;
                                            }
                                            continue;
                                        }
                                        printStream.println("Not calling method " + string3 + " with " + string5 + " because argsLeft = " + string4);
                                        bl = false;
                                        continue;
                                    }
                                    printStream.println("Not calling method " + string3 + " with " + string5 + " because parsed parameter count = " + n3);
                                    continue;
                                }
                                printStream.println("Method not found " + string3);
                            }
                            if (!bl2) {
                                printStream.println("ERROR:  Method not found " + string3);
                            }
                        } else {
                            printStream.println("ERROR:  could find ( in " + string);
                        }
                    } else {
                        printStream.println("ERROR:  could not find variable or class " + string2);
                        this.showValidVariables(printStream);
                    }
                } else {
                    printStream.println("ERROR:  could find . in " + string);
                }
            } else {
                printStream.println("ERROR:  could find ( in " + string);
            }
            return object;
        }
        catch (Exception exception) {
            printStream.println("Unexpected exception");
            exception.printStackTrace(printStream);
            return null;
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            printStream.println("NoClassDefFoundError");
            noClassDefFoundError.printStackTrace(printStream);
            return null;
        }
    }

    private Object callNewMethod(String string, PrintStream printStream) {
        try {
            Object var3_3 = null;
            int n = string.indexOf("(");
            if (n > 0) {
                String string2 = string.substring(0, n).trim();
                Class<?> clazz = null;
                string = string.substring(n + 1);
                try {
                    clazz = Class.forName(string2);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (clazz != null) {
                    if (n > 0) {
                        Constructor<?>[] constructorArray = clazz.getConstructors();
                        boolean bl = false;
                        for (int i = 0; !bl && i < constructorArray.length && var3_3 == null; ++i) {
                            Class<?>[] classArray = constructorArray[i].getParameterTypes();
                            String string3 = string;
                            Object[] objectArray = new Object[classArray.length];
                            bl = true;
                            String string4 = "";
                            for (int j = 0; j < classArray.length; ++j) {
                                int n2;
                                Object[] objectArray2;
                                int n3;
                                int n4;
                                String string5;
                                int n5 = 0;
                                int n6 = 0;
                                int n7 = 0;
                                if (string3.length() > 1 && string3.charAt(0) == '\"') {
                                    n5 = 1;
                                    n6 = string3.indexOf(34, 1);
                                    if (n6 > 0) {
                                        if (string3.charAt(n6 + 1) == ',' || string3.charAt(n6 + 1) == ')') {
                                            n7 = n6 + 2;
                                        } else {
                                            printStream.println("[,)] does not follow ");
                                            n6 = -1;
                                        }
                                    }
                                } else {
                                    n6 = string3.indexOf(",");
                                    if (n6 < 0) {
                                        n6 = string3.indexOf(")");
                                    }
                                    if (n6 >= 0) {
                                        n7 = n6 + 1;
                                    }
                                }
                                if (n6 < 0) {
                                    bl = false;
                                    printStream.println("Unable to find arg in " + string3);
                                    bl = false;
                                    continue;
                                }
                                String string6 = string3.substring(n5, n6).trim();
                                string3 = string3.substring(n7);
                                Object v = this.variables.get(string6);
                                if (v != null) {
                                    objectArray[j] = v;
                                    continue;
                                }
                                String string7 = classArray[j].getName();
                                string4 = string4 + string7 + " ";
                                if (string6.equals("null")) {
                                    objectArray[j] = null;
                                    continue;
                                }
                                if (string7.equals("java.lang.String")) {
                                    objectArray[j] = string6;
                                    continue;
                                }
                                if (string7.equals("int")) {
                                    try {
                                        objectArray[j] = new Integer(string6);
                                    }
                                    catch (Exception exception) {
                                        printStream.println("Could not parse " + string6 + " as integer");
                                        bl = false;
                                    }
                                    continue;
                                }
                                if (string7.equals("boolean")) {
                                    try {
                                        objectArray[j] = new Boolean(string6);
                                    }
                                    catch (Exception exception) {
                                        printStream.println("Could not parse " + string6 + " as integer");
                                        bl = false;
                                    }
                                    continue;
                                }
                                if (string7.equals("long")) {
                                    try {
                                        objectArray[j] = new Long(string6);
                                    }
                                    catch (Exception exception) {
                                        printStream.println("Could not parse " + string6 + " as long");
                                        bl = false;
                                    }
                                    continue;
                                }
                                if (string7.equals("[Ljava.lang.String;")) {
                                    if (string6.charAt(0) == '[') {
                                        string5 = string6.substring(1);
                                        n4 = string5.length();
                                        n3 = 1;
                                        for (int k = 0; k < n4; ++k) {
                                            if (string5.charAt(k) != '+') continue;
                                            ++n3;
                                        }
                                        objectArray[j] = objectArray2 = new String[n3];
                                        int n8 = 0;
                                        int n9 = 0;
                                        n2 = string5.indexOf(43, n9);
                                        if (n2 < 0) {
                                            n2 = string5.indexOf(93, n9);
                                        }
                                        while (n2 > 0) {
                                            if (n8 < n3) {
                                                objectArray2[n8] = string5.substring(n9, n2);
                                                ++n8;
                                            }
                                            if ((n9 = n2 + 1) >= n4) {
                                                n2 = -1;
                                                continue;
                                            }
                                            n2 = string5.indexOf(43, n9);
                                            if (n2 >= 0) continue;
                                            n2 = string5.indexOf(93, n9);
                                        }
                                        continue;
                                    }
                                    printStream.println("Could not parse " + string6 + " as String array .. try [A+B+C]");
                                    bl = false;
                                    continue;
                                }
                                if (string7.equals("[I")) {
                                    if (string6.charAt(0) == '[') {
                                        string5 = string6.substring(1);
                                        n4 = string5.length();
                                        n3 = 1;
                                        for (int k = 0; k < n4; ++k) {
                                            if (string5.charAt(k) != '+') continue;
                                            ++n3;
                                        }
                                        objectArray[j] = objectArray2 = (Object[])new int[n3];
                                        String string8 = "";
                                        try {
                                            int n10 = 0;
                                            n2 = 0;
                                            int n11 = string5.indexOf(43, n2);
                                            if (n11 < 0) {
                                                n11 = string5.indexOf(93, n2);
                                            }
                                            while (n11 > 0) {
                                                if (n10 < n3) {
                                                    objectArray2[n10] = (String)Integer.parseInt(string5.substring(n2, n11));
                                                    ++n10;
                                                }
                                                if ((n2 = n11 + 1) >= n4) {
                                                    n11 = -1;
                                                    continue;
                                                }
                                                n11 = string5.indexOf(43, n2);
                                                if (n11 >= 0) continue;
                                                n11 = string5.indexOf(93, n2);
                                            }
                                            continue;
                                        }
                                        catch (Exception exception) {
                                            printStream.println("Exception " + exception + " piece = " + string8);
                                            printStream.println("Could not parse " + string6 + " as Integer.. try [1+2+3]");
                                            bl = false;
                                            continue;
                                        }
                                    }
                                    printStream.println("Could not parse " + string6 + " as Integer.. try [1+2+3]");
                                    bl = false;
                                    continue;
                                }
                                printStream.println("Did not handle parameter with class " + string7);
                                bl = false;
                            }
                            if (!bl) continue;
                            if (string3.trim().equals(")") || string3.trim().length() == 0) {
                                try {
                                    var3_3 = constructorArray[i].newInstance(objectArray);
                                }
                                catch (Exception exception) {
                                    exception.printStackTrace(printStream);
                                    printStream.println("Creating object  with " + string4 + " failed");
                                    bl = false;
                                }
                                continue;
                            }
                            printStream.println("Not calling constructor  with " + string4 + " because argsLeft = " + string3);
                            bl = false;
                        }
                    } else {
                        printStream.println("ERROR:  could find ( in " + string);
                    }
                } else {
                    printStream.println("ERROR:  could not find variable or class " + string2);
                }
            } else {
                printStream.println("ERROR:  could find ( in " + string);
            }
            return var3_3;
        }
        catch (Exception exception) {
            printStream.println("Unexpected exception");
            exception.printStackTrace(printStream);
            return null;
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            printStream.println("NoClassDefFoundError");
            noClassDefFoundError.printStackTrace(printStream);
            return null;
        }
    }

    private void showValidVariables(PrintStream printStream) {
        printStream.println("Valid variables are the following");
        Enumeration enumeration = this.variables.keys();
        while (enumeration.hasMoreElements()) {
            printStream.println(enumeration.nextElement());
        }
    }

    private void showMethods(String string, PrintStream printStream) {
        String string2 = string.trim();
        Object v = this.variables.get(string2);
        Class<?> clazz = null;
        if (v == null) {
            try {
                clazz = Class.forName(string2);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (v != null || clazz != null) {
            Method[] methodArray = v != null ? v.getClass().getMethods() : (clazz != null ? clazz.getMethods() : new Method[]{});
            for (int i = 0; i < methodArray.length; ++i) {
                Class<?> clazz2 = methodArray[i].getReturnType();
                String string3 = clazz2 != null ? clazz2.getName() + " " + methodArray[i].getName() : "void " + methodArray[i].getName();
                Class<?>[] classArray = methodArray[i].getParameterTypes();
                string3 = string3 + "(";
                for (int j = 0; j < classArray.length; ++j) {
                    String string4 = classArray[j].getName();
                    if (j > 0) {
                        string3 = string3 + ",";
                    }
                    string3 = string3 + string4;
                }
                string3 = string3 + ")";
                printStream.println(string3);
            }
        } else {
            printStream.println("Could not find variable " + string2);
            this.showValidVariables(printStream);
        }
    }

    private static String[] dispColumnHeadings(PrintStream printStream, ResultSet resultSet, ResultSetMetaData resultSetMetaData, boolean bl, int n, boolean bl2, boolean bl3) throws SQLException {
        StringBuffer stringBuffer = new StringBuffer();
        if (bl2) {
            stringBuffer.append("<table border>\n");
        }
        String[] stringArray = new String[n + 1];
        for (int i = 1; i <= n; ++i) {
            stringArray[i] = resultSetMetaData.getColumnLabel(i);
            if (bl2) {
                stringBuffer.append("<th>" + stringArray[i].replace('_', ' '));
                continue;
            }
            if (bl3) continue;
            if (i > 1) {
                stringBuffer.append(",");
            }
            stringBuffer.append(stringArray[i]);
        }
        if (bl2) {
            stringBuffer.append("<tr>\n");
        }
        if (bl3) {
            stringBuffer.append("<table>");
            printStream.println(stringBuffer.toString());
        } else {
            stringBuffer.append("");
            printStream.println(stringBuffer.toString());
        }
        return stringArray;
    }

    private static void dispRow(PrintStream printStream, ResultSet resultSet, boolean bl, int n, int[] nArray, String[] stringArray, String[] stringArray2, boolean bl2, boolean bl3, int n2, int n3, boolean bl4, boolean bl5) throws SQLException {
        StringBuffer stringBuffer = new StringBuffer();
        if (bl2) {
            stringBuffer.append("<row>\n");
        }
        for (int i = 1; i <= n; ++i) {
            if (bl3) {
                stringBuffer.append("<td>");
            } else if (bl2) {
                stringBuffer.append("   <" + stringArray[i] + ">");
            } else if (i > 1) {
                stringBuffer.append(",");
            }
            switch (nArray[i]) {
                case 2004: {
                    int n4;
                    Object object = resultSet.getBlob(i);
                    if (object != null && object.getClass().getName().equals("com.ibm.db2.jdbc.app.DB2BlobLocator")) {
                        try {
                            n4 = ReflectionUtil.callMethod_I(object, "getLocator");
                            stringBuffer.append("L#" + n4 + ":");
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
                case -8: 
                case -4: 
                case -3: 
                case -2: {
                    int n4;
                    Object object = resultSet.getBytes(i);
                    if (object == null) {
                        stringBuffer.append(resultSet.getString(i));
                        break;
                    }
                    if (((Object)object).length < n2) {
                        for (n4 = 0; n4 < ((Object)object).length; ++n4) {
                            int n5 = object[n4] & 0xFF;
                            if (n5 >= 16) {
                                stringBuffer.append(Integer.toHexString(n5));
                                continue;
                            }
                            stringBuffer.append("0" + Integer.toHexString(n5));
                        }
                        break;
                    }
                    CRC32 cRC32 = new CRC32();
                    cRC32.update((byte[])object);
                    stringBuffer.append("ARRAY[size=" + ((Object)object).length + ",CRC32=" + cRC32.getValue() + "]");
                    break;
                }
                default: {
                    String string = resultSet.getString(i);
                    if (bl && string != null) {
                        string = string.trim();
                    }
                    if (stringArray2 != null && i - 1 < stringArray2.length && stringArray2[i - 1] != null) {
                        string = Main.formatString(string, stringArray2[i - 1]);
                    }
                    Main.appendUnicodeString(stringBuffer, string, n2, n3, bl4, bl5);
                }
            }
            if (!bl2) continue;
            stringBuffer.append("</" + stringArray[i] + ">\n");
        }
        if (bl3) {
            printStream.println(stringBuffer.toString() + "<tr>");
        } else if (bl2) {
            printStream.println(stringBuffer.toString() + "</row>");
        } else {
            printStream.println(stringBuffer.toString());
        }
    }

    private static String stripTS(String string) {
        string = string.replace(' ', '-');
        int n = (string = string.replace(':', '.')).indexOf(".000000");
        if (n > 0) {
            string = string.substring(0, n);
        }
        return string;
    }

    private static String formatString(String string, String string2) {
        if (string2 != null) {
            int n = string2.indexOf("{STUFF}");
            if (n > 0) {
                return Main.formatString(string, string2.substring(0, n)) + string + Main.formatString(string, string2.substring(n + 7));
            }
            if (n == 0) {
                return string + Main.formatString(string, string2.substring(n + 7));
            }
            n = string2.indexOf("{STRIPPEDTS}");
            if (n > 0) {
                return Main.formatString(string, string2.substring(0, n)) + Main.stripTS(string) + Main.formatString(string, string2.substring(n + 12));
            }
            if (n == 0) {
                return Main.stripTS(string) + Main.formatString(string, string2.substring(n + 12));
            }
            n = string2.indexOf("{PART");
            if (n >= 0) {
                int n2 = string2.indexOf("}", n);
                int n3 = n2 - n + 1;
                int n4 = string2.charAt(n + 5) - 48;
                String string3 = string2.substring(n + 9, n2);
                String string4 = Main.getNthItem(string, string3, n4);
                if (n > 0) {
                    return Main.formatString(string, string2.substring(0, n)) + string4 + Main.formatString(string, string2.substring(n + n3));
                }
                return string4 + Main.formatString(string, string2.substring(n + n3));
            }
            return string2;
        }
        return string;
    }

    private static String getNthItem(String string, String string2, int n) {
        String string3 = string;
        int n2 = string2.length();
        int n3 = string3.indexOf(string2);
        int n4 = 1;
        while (n3 > 0) {
            if (n4 == n) {
                return string3.substring(0, n3);
            }
            string3 = string3.substring(n3 + n2);
            n3 = string3.indexOf(string2);
            ++n4;
        }
        return string3;
    }

    public static void dispResultSet(ResultSet resultSet) throws SQLException {
        Main.dispResultSet(System.out, resultSet, false, null, false, false, 16384, 16384, true, true, false);
    }

    void dispResultSet(PrintStream printStream, ResultSet resultSet, boolean bl) throws SQLException {
        Main.dispResultSet(printStream, resultSet, bl, null, this.xml_, this.html_, this.showLobThreshold_, this.stringSampleSize_, this.characterDetails_, this.showMixedUX_, this.hideWarnings_);
    }

    static void dispResultSet(PrintStream printStream, ResultSet resultSet, boolean bl, String[] stringArray, boolean bl2, boolean bl3, int n, int n2, boolean bl4, boolean bl5, boolean bl6) throws SQLException {
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        int n3 = resultSetMetaData.getColumnCount();
        String[] stringArray2 = Main.dispColumnHeadings(printStream, resultSet, resultSetMetaData, bl, n3, bl2, bl3);
        int[] nArray = new int[n3 + 1];
        for (int i = 1; i <= n3; ++i) {
            nArray[i] = resultSetMetaData.getColumnType(i);
        }
        boolean bl7 = resultSet.next();
        while (bl7) {
            Main.dispRow(printStream, resultSet, bl, n3, nArray, stringArray2, stringArray, bl2, bl3, n, n2, bl4, bl5);
            SQLWarning sQLWarning = resultSet.getWarnings();
            if (sQLWarning != null) {
                Main.dispWarning(printStream, sQLWarning, bl6, bl3);
            }
            bl7 = resultSet.next();
        }
        if (bl3) {
            printStream.println("</table>");
        }
        if (bl2) {
            printStream.println("</table>");
        }
    }

    private static void dispWarning(PrintStream printStream, SQLWarning sQLWarning, boolean bl, boolean bl2) {
        if (bl) {
            return;
        }
        if (sQLWarning != null) {
            printStream.println("\n *** Warning ***\n");
            if (bl2) {
                printStream.println("<br>");
            }
            while (sQLWarning != null) {
                printStream.println("SQLState: " + sQLWarning.getSQLState());
                if (bl2) {
                    printStream.println("<br>");
                }
                printStream.println("Message:  " + Main.cleanupMessage(sQLWarning.getMessage()));
                if (bl2) {
                    printStream.println("<br>");
                }
                printStream.println("Vendor:   " + sQLWarning.getErrorCode());
                if (bl2) {
                    printStream.println("<br>");
                }
                printStream.println("");
                if (bl2) {
                    printStream.println("<br>");
                }
                sQLWarning = sQLWarning.getNextWarning();
            }
        }
    }

    private static String cleanupMessage(String string) {
        boolean bl = false;
        char[] cArray = string.toCharArray();
        for (int i = 0; i < cArray.length; ++i) {
            if (cArray[i] >= ' ' && cArray[i] <= '~') continue;
            bl = true;
            cArray[i] = 42;
        }
        if (!bl) {
            return string;
        }
        return new String(cArray);
    }

    private void printArray(PrintStream printStream, java.sql.Array array) throws SQLException {
        if (array == null) {
            printStream.print("nullArray");
        } else {
            Object[] objectArray = (Object[])array.getArray();
            if (objectArray == null) {
                printStream.print("XXXX_null_returned_from_outArray.getArray");
            } else {
                String string = objectArray.getClass().getComponentType().getName();
                printStream.print(string + "[" + objectArray.length + "]=[");
                for (int i = 0; i < objectArray.length; ++i) {
                    long l;
                    Object object;
                    if (i > 0) {
                        printStream.print(",");
                    }
                    if (objectArray[i] == null) {
                        printStream.print("null");
                        continue;
                    }
                    if (string.equals("[B")) {
                        printStream.print(StringFormatUtil.dumpBytes((byte[])objectArray[i]));
                        continue;
                    }
                    if (objectArray[i] instanceof Blob) {
                        object = (Blob)objectArray[i];
                        l = object.length();
                        printStream.print(StringFormatUtil.dumpBytes(object.getBytes(1L, (int)l)));
                        continue;
                    }
                    if (objectArray[i] instanceof Clob) {
                        object = (Clob)objectArray[i];
                        l = object.length();
                        printStream.print(object.getSubString(1L, (int)l));
                        continue;
                    }
                    if (objectArray[i] instanceof String) {
                        this.printUnicodeString(printStream, (String)objectArray[i]);
                        continue;
                    }
                    printStream.print(objectArray[i].toString());
                }
                printStream.print("]");
            }
        }
    }

    private void printUnicodeString(PrintStream printStream, String string) {
        int n;
        if (string != null && (n = string.length()) > this.showLobThreshold_) {
            printStream.print("CHARARRAY[size=" + n + ",CRC32=" + Main.getCRC32(string) + "]->");
            if (!this.characterDetails_) {
                string = string.substring(0, this.stringSampleSize_);
            }
        }
        if (string != null) {
            int n2;
            char[] cArray = string.toCharArray();
            boolean bl = false;
            for (n2 = 0; !bl && n2 < cArray.length; ++n2) {
                if (cArray[n2] == '\r' || cArray[n2] == '\n' || cArray[n2] == '\t' || cArray[n2] < '\u007f' && cArray[n2] >= ' ') continue;
                bl = true;
            }
            if (!bl) {
                printStream.print(string);
            } else if (this.showMixedUX_) {
                this.showMixedUXOutput(printStream, cArray);
            } else {
                printStream.print("U'");
                for (n2 = 0; n2 < cArray.length; ++n2) {
                    int n3 = cArray[n2] & 0xFFFF;
                    if (n3 > 65280 && n3 < 65375 || n3 == 12288) {
                        if (n3 == 12288) {
                            printStream.print("| ");
                            continue;
                        }
                        printStream.print('|');
                        printStream.print((char)(n3 - 65248));
                        continue;
                    }
                    String string2 = Integer.toHexString(n3);
                    if (n3 >= 4096) {
                        printStream.print(string2);
                        continue;
                    }
                    if (n3 >= 256) {
                        printStream.print("0" + string2);
                        continue;
                    }
                    if (n3 >= 16) {
                        printStream.print("00" + string2);
                        continue;
                    }
                    printStream.print("000" + string2);
                }
                printStream.print("'");
            }
        } else {
            printStream.print(string);
        }
    }

    private static void appendUnicodeString(StringBuffer stringBuffer, String string, int n, int n2, boolean bl, boolean bl2) {
        int n3;
        if (string != null && (n3 = string.length()) > n) {
            stringBuffer.append("CHARARRAY[size=" + n3 + ",CRC32=" + Main.getCRC32(string) + "]->");
            if (!bl) {
                string = string.substring(0, n2);
            }
        }
        if (string != null) {
            int n4;
            char[] cArray = string.toCharArray();
            boolean bl3 = false;
            for (n4 = 0; !bl3 && n4 < cArray.length; ++n4) {
                if (cArray[n4] == '\r' || cArray[n4] == '\n' || cArray[n4] == '\t' || cArray[n4] < '\u007f' && cArray[n4] >= ' ') continue;
                bl3 = true;
            }
            if (!bl3) {
                stringBuffer.append(string);
            } else if (bl2) {
                Main.appendMixedUXOutput(stringBuffer, cArray);
            } else {
                stringBuffer.append("U'");
                for (n4 = 0; n4 < cArray.length; ++n4) {
                    int n5 = cArray[n4] & 0xFFFF;
                    if (n5 > 65280 && n5 < 65375 || n5 == 12288) {
                        if (n5 == 12288) {
                            stringBuffer.append("| ");
                            continue;
                        }
                        stringBuffer.append('|');
                        stringBuffer.append((char)(n5 - 65248));
                        continue;
                    }
                    String string2 = Integer.toHexString(n5);
                    if (n5 >= 4096) {
                        stringBuffer.append(string2);
                        continue;
                    }
                    if (n5 >= 256) {
                        stringBuffer.append("0" + string2);
                        continue;
                    }
                    if (n5 >= 16) {
                        stringBuffer.append("00" + string2);
                        continue;
                    }
                    stringBuffer.append("000" + string2);
                }
                stringBuffer.append("'");
            }
        } else {
            stringBuffer.append(string);
        }
    }

    public void showMixedUXOutput(PrintStream printStream, char[] cArray) {
        boolean bl = false;
        for (int i = 0; i < cArray.length; ++i) {
            int n = cArray[i] & 0xFFFF;
            if (n == 10 || n >= 32 && n < 127) {
                if (bl) {
                    printStream.print("''");
                    bl = false;
                }
                printStream.print(cArray[i]);
                continue;
            }
            if (!bl) {
                bl = true;
                printStream.print("UX''");
            }
            String string = Integer.toHexString(n);
            if (n >= 4096) {
                printStream.print(string);
                continue;
            }
            if (n >= 256) {
                printStream.print("0" + string);
                continue;
            }
            if (n >= 16) {
                printStream.print("00" + string);
                continue;
            }
            printStream.print("000" + string);
        }
        if (bl) {
            printStream.print("''");
        }
    }

    public static void appendMixedUXOutput(StringBuffer stringBuffer, char[] cArray) {
        boolean bl = false;
        for (int i = 0; i < cArray.length; ++i) {
            int n = cArray[i] & 0xFFFF;
            if (n == 10 || n >= 32 && n < 127) {
                if (bl) {
                    stringBuffer.append("''");
                    bl = false;
                }
                stringBuffer.append(cArray[i]);
                continue;
            }
            if (!bl) {
                bl = true;
                stringBuffer.append("UX''");
            }
            String string = Integer.toHexString(n);
            if (n >= 4096) {
                stringBuffer.append(string);
                continue;
            }
            if (n >= 256) {
                stringBuffer.append("0" + string);
                continue;
            }
            if (n >= 16) {
                stringBuffer.append("00" + string);
                continue;
            }
            stringBuffer.append("000" + string);
        }
        if (bl) {
            stringBuffer.append("''");
        }
    }

    public Object getParameterObject(String string, PrintStream printStream) {
        if (string.indexOf("UX'") == 0) {
            int n = string.length();
            if ((string = string.substring(3, n - 1)).indexOf("null") >= 0) {
                return null;
            }
            String string2 = null;
            try {
                char[] cArray = new char[(n -= 4) / 4];
                for (int i = 0; i < cArray.length; ++i) {
                    String string3 = string.substring(i * 4, i * 4 + 4);
                    cArray[i] = (char)Integer.parseInt(string3, 16);
                }
                string2 = new String(cArray);
            }
            catch (Exception exception) {
                printStream.println("Processing of " + string + " failed");
                exception.printStackTrace(printStream);
            }
            return string2;
        }
        if (string.indexOf("X'") == 0) {
            int n = string.length();
            if ((string = string.substring(2, n - 1)).indexOf("null") >= 0) {
                return null;
            }
            byte[] byArray = null;
            try {
                byArray = new byte[(n -= 3) / 2];
                for (int i = 0; i < byArray.length; ++i) {
                    String string4 = string.substring(i * 2, i * 2 + 2);
                    byArray[i] = (byte)Integer.parseInt(string4, 16);
                }
            }
            catch (Exception exception) {
                printStream.println("Processing of " + string + " failed");
                exception.printStackTrace(printStream);
            }
            return byArray;
        }
        if (string.indexOf("FILEBLOB=") == 0) {
            ClientBlob clientBlob = null;
            try {
                String string5 = string.substring(9).trim();
                byte[] byArray = null;
                File file = new File(string5);
                int n = (int)file.length();
                byArray = new byte[n];
                FileInputStream fileInputStream = new FileInputStream(string5);
                fileInputStream.read(byArray);
                fileInputStream.close();
                clientBlob = new ClientBlob(byArray);
            }
            catch (Exception exception) {
                printStream.println("Processing of " + string + " failed because of " + exception);
                exception.printStackTrace(printStream);
            }
            return clientBlob;
        }
        if (string.indexOf("FILECLOB=") == 0) {
            ClientClob clientClob = null;
            try {
                String string6 = string.substring(9).trim();
                char[] cArray = null;
                File file = new File(string6);
                int n = (int)file.length();
                cArray = new char[n];
                BufferedReader bufferedReader = new BufferedReader(new FileReader(string6));
                bufferedReader.read(cArray, 0, n);
                clientClob = new ClientClob(new String(cArray));
            }
            catch (Exception exception) {
                printStream.println("Processing of " + string + " failed because of " + exception);
                exception.printStackTrace(printStream);
            }
            return clientClob;
        }
        if (string.indexOf("SAVEDPARM=") == 0) {
            printStream.println("ERROR:  SAVEDPARM not supported yet");
        } else if (string.indexOf("SQLARRAY[") == 0) {
            printStream.println("ERROR:  SQLARRAY not supported yet");
        } else {
            if (string.indexOf("GEN_BYTE_ARRAY+") == 0) {
                return this.getGenByteArrayParm(string, printStream);
            }
            if (string.indexOf("GEN_HEX_STRING+") == 0) {
                printStream.println("ERROR:  GEN_HEX_STRING+ not supported yet");
            } else if (string.indexOf("GEN_CHAR_ARRAY+") == 0) {
                printStream.println("ERROR:  GEN_CHAR_ARRAY+ not supported yet");
            }
        }
        return string;
    }

    public void setParameter(PreparedStatement preparedStatement, String string, int n, PrintStream printStream) throws SQLException {
        if (string.indexOf("UX'") == 0) {
            this.handleUnicodeStringParm(preparedStatement, string, n, printStream);
        } else if (string.indexOf("X'") == 0) {
            this.handleByteArrayParm(preparedStatement, string, n, printStream);
        } else if (string.indexOf("FILEBLOB=") == 0) {
            this.handleFileBlobParm(preparedStatement, string, n, printStream);
        } else if (string.indexOf("FILECLOB=") == 0) {
            this.handleFileClobParm(preparedStatement, string, n, printStream);
        } else if (string.indexOf("SAVEDPARM=") == 0) {
            this.handleSavedParm(preparedStatement, string, n, printStream);
        } else if (string.indexOf("SQLARRAY[") == 0) {
            this.handleSqlarrayParm(preparedStatement, string, n, printStream);
        } else if (string.indexOf("GEN_BYTE_ARRAY+") == 0) {
            this.handleGenByteArrayParm(preparedStatement, string, n, printStream);
        } else if (string.indexOf("GEN_HEX_STRING+") == 0) {
            this.handleGenHexStringParm(preparedStatement, string, n, printStream);
        } else if (string.indexOf("GEN_CHAR_ARRAY+") == 0) {
            Object object;
            String string2 = null;
            int n2 = -1;
            try {
                object = null;
                String string3 = null;
                int n3 = -1;
                int n4 = -1;
                String string4 = string.substring(15).trim();
                n4 = string4.indexOf("C");
                object = string4.substring(0, n4);
                string3 = string4.substring(n4 + 1).trim();
                n2 = Integer.parseInt((String)object);
                n3 = Integer.parseInt(string3);
                char[] cArray = new char[]{'a', 'b', 'c', 'd'};
                char[] cArray2 = new char[]{'\u00c0', '\u35c0', '\ub5a0', '\u3055', '\u31ff', '\u3066'};
                char[] cArray3 = new char[]{'\u3055', '\u31ff', '\u3066'};
                char[] cArray4 = new char[]{'\u00c0', '\u35c0', '\ub5a0', '\u3055', '\u31ff', '\u3066'};
                char[] cArray5 = new char[]{'\u5e03', '\u5f17', '\u672b', '\u5378', '\u59cb', '\u8679', '\u500c', '\u89f4', '\u9853', '\u8271', '\u8f44', '\u977e', '\u52f1'};
                char[] cArray6 = new char[n2];
                char[] cArray7 = new char[n2];
                switch (n3) {
                    case 37: {
                        cArray6 = cArray;
                        break;
                    }
                    case 835: {
                        cArray6 = cArray5;
                        break;
                    }
                    case 1200: {
                        cArray6 = cArray4;
                        break;
                    }
                    case 1208: {
                        cArray6 = cArray2;
                        break;
                    }
                    case 13488: {
                        cArray6 = cArray3;
                    }
                }
                for (int i = 0; i < n2; ++i) {
                    cArray7[i] = cArray6[i % cArray6.length];
                }
                string2 = new String(cArray7);
            }
            catch (Exception exception) {
                printStream.println("Processing of " + string + " failed");
                exception.printStackTrace(printStream);
            }
            preparedStatement.setString(n, string2);
            printStream.println("CHARARRAY[size=" + n2 + ",CRC32=" + Main.getCRC32(string2) + ",CRC32xor1=" + this.getCRC32xor1(string2) + "]");
            object = preparedStatement.getWarnings();
            if (object != null && !this.silent) {
                Main.dispWarning(printStream, (SQLWarning)object, this.hideWarnings_, this.html_);
            }
        } else {
            if (string.indexOf("'") == 0) {
                int n5 = string.indexOf("'", 1);
                string = n5 > 0 ? string.substring(1, n5) : string.substring(1);
            }
            preparedStatement.setString(n, string);
            SQLWarning sQLWarning = preparedStatement.getWarnings();
            if (sQLWarning != null && !this.silent) {
                Main.dispWarning(printStream, sQLWarning, this.hideWarnings_, this.html_);
            }
        }
    }

    static String getCRC32(String string) {
        if (string == null) {
            return null;
        }
        int n = string.length();
        byte[] byArray = new byte[2 * n];
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            byArray[2 * i] = (byte)((c & 0xFF00) >> 16);
            byArray[2 * i + 1] = (byte)(c & 0xFF);
        }
        CRC32 cRC32 = new CRC32();
        cRC32.update(byArray);
        return "" + cRC32.getValue();
    }

    String getCRC32xor1(String string) {
        if (string == null) {
            return null;
        }
        int n = string.length();
        byte[] byArray = new byte[2 * n];
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            byArray[2 * i] = (byte)((c & 0xFF00) >> 16);
            byArray[2 * i + 1] = byArray[2 * i] == -40 ? (byte)(c & 0xFF) : (byte)((c ^ '\u0001') & 0xFF);
        }
        CRC32 cRC32 = new CRC32();
        cRC32.update(byArray);
        return "" + cRC32.getValue();
    }

    void handleUnicodeStringParm(PreparedStatement preparedStatement, String string, int n, PrintStream printStream) throws SQLException {
        String string2 = (String)this.getParameterObject(string, printStream);
        preparedStatement.setString(n, string2);
        SQLWarning sQLWarning = preparedStatement.getWarnings();
        if (sQLWarning != null && !this.silent) {
            Main.dispWarning(printStream, sQLWarning, this.hideWarnings_, this.html_);
        }
    }

    void handleByteArrayParm(PreparedStatement preparedStatement, String string, int n, PrintStream printStream) throws SQLException {
        byte[] byArray = (byte[])this.getParameterObject(string, printStream);
        preparedStatement.setBytes(n, byArray);
        SQLWarning sQLWarning = preparedStatement.getWarnings();
        if (sQLWarning != null && !this.silent) {
            Main.dispWarning(printStream, sQLWarning, this.hideWarnings_, this.html_);
        }
    }

    byte[] getGenByteArrayParm(String string, PrintStream printStream) {
        byte[] byArray = null;
        try {
            String string2 = string.substring(15);
            int n = Integer.parseInt(string2);
            byArray = new byte[n];
            for (int i = 0; i < n; ++i) {
                byArray[i] = (byte)(i & 0xFF);
            }
        }
        catch (Exception exception) {
            printStream.println("Processing of " + string + " failed");
            exception.printStackTrace(printStream);
        }
        return byArray;
    }

    void handleGenByteArrayParm(PreparedStatement preparedStatement, String string, int n, PrintStream printStream) throws SQLException {
        byte[] byArray = this.getGenByteArrayParm(string, printStream);
        preparedStatement.setBytes(n, byArray);
        CRC32 cRC32 = new CRC32();
        cRC32.update(byArray);
        printStream.println("GEN_BYTE_ARRAY generated array of size = " + byArray.length + " with checksum of " + cRC32.getValue());
    }

    void handleSavedParm(PreparedStatement preparedStatement, String string, int n, PrintStream printStream) throws SQLException {
        Object object;
        int n2 = 0;
        try {
            object = string.substring(10);
            n2 = Integer.parseInt((String)object);
        }
        catch (Exception exception) {
            printStream.println("Processing of " + string + " failed");
            exception.printStackTrace(printStream);
        }
        preparedStatement.setString(n, this.savedStringParm_[n2]);
        printStream.println("SAVEDPARM set(" + n + "," + this.savedStringParm_[n2] + " from saved " + n2);
        object = preparedStatement.getWarnings();
        if (object != null && !this.silent) {
            Main.dispWarning(printStream, (SQLWarning)object, this.hideWarnings_, this.html_);
        }
    }

    static void appendDigit(StringBuffer stringBuffer, int n) {
        switch (n) {
            case 0: {
                stringBuffer.append('0');
                break;
            }
            case 1: {
                stringBuffer.append('1');
                break;
            }
            case 2: {
                stringBuffer.append('2');
                break;
            }
            case 3: {
                stringBuffer.append('3');
                break;
            }
            case 4: {
                stringBuffer.append('4');
                break;
            }
            case 5: {
                stringBuffer.append('5');
                break;
            }
            case 6: {
                stringBuffer.append('6');
                break;
            }
            case 7: {
                stringBuffer.append('7');
                break;
            }
            case 8: {
                stringBuffer.append('8');
                break;
            }
            case 9: {
                stringBuffer.append('9');
                break;
            }
            case 10: {
                stringBuffer.append('a');
                break;
            }
            case 11: {
                stringBuffer.append('b');
                break;
            }
            case 12: {
                stringBuffer.append('c');
                break;
            }
            case 13: {
                stringBuffer.append('d');
                break;
            }
            case 14: {
                stringBuffer.append('e');
                break;
            }
            case 15: {
                stringBuffer.append('f');
            }
        }
    }

    void handleGenHexStringParm(PreparedStatement preparedStatement, String string, int n, PrintStream printStream) throws SQLException {
        Object object;
        StringBuffer stringBuffer = null;
        byte[] byArray = null;
        try {
            object = string.substring(15);
            int n2 = Integer.parseInt((String)object);
            stringBuffer = new StringBuffer(2 * n2);
            byArray = new byte[n2];
            for (int i = 0; i < n2; ++i) {
                byArray[i] = (byte)(i & 0xFF);
                Main.appendDigit(stringBuffer, (i & 0xF0) >> 4);
                Main.appendDigit(stringBuffer, i & 0xF);
            }
        }
        catch (Exception exception) {
            printStream.println("Processing of " + string + " failed");
            exception.printStackTrace(printStream);
            throw new SQLException("Unable to set HexString parameter");
        }
        preparedStatement.setString(n, stringBuffer.toString());
        object = new CRC32();
        object.update(byArray);
        printStream.println("GEN_BYTE_ARRAY generated array of size = " + byArray.length + " with checksum of " + ((CRC32)object).getValue());
        SQLWarning sQLWarning = preparedStatement.getWarnings();
        if (sQLWarning != null && !this.silent) {
            Main.dispWarning(printStream, sQLWarning, this.hideWarnings_, this.html_);
        }
    }

    void handleFileBlobParm(PreparedStatement preparedStatement, String string, int n, PrintStream printStream) throws SQLException {
        Blob blob = (Blob)this.getParameterObject(string, printStream);
        preparedStatement.setBlob(n, blob);
    }

    void handleFileClobParm(PreparedStatement preparedStatement, String string, int n, PrintStream printStream) throws SQLException {
        Clob clob = (Clob)this.getParameterObject(string, printStream);
        preparedStatement.setClob(n, clob);
    }

    public java.sql.Array makeArray(Object object, String string) throws Exception {
        Object[] objectArray = new Object[]{};
        Class[] classArray = new Class[]{"".getClass(), objectArray.getClass()};
        java.sql.Array array = (java.sql.Array)ReflectionUtil.callMethod_O(this.connection_, "createArrayOf", classArray, string, object);
        return array;
    }

    void handleSqlarrayParm(PreparedStatement preparedStatement, String string, int n, PrintStream printStream) throws SQLException {
        block95: {
            try {
                String string2 = string.substring(9).trim();
                int n2 = string2.indexOf(":");
                boolean bl = false;
                if (n2 == -1 && (n2 = string2.indexOf("]")) > 0) {
                    bl = true;
                }
                if (n2 > 0) {
                    String string3 = string2.substring(0, n2);
                    string2 = bl ? string2.substring(n2) : string2.substring(n2 + 1);
                    Vector<String> vector = new Vector<String>();
                    String string4 = ":";
                    if (string3.equals("Time")) {
                        string4 = " ";
                    }
                    if (string3.equals("Timestamp")) {
                        string4 = "|";
                    }
                    n2 = string2.indexOf(string4);
                    while (n2 >= 0) {
                        String string5 = string2.substring(0, n2);
                        vector.addElement(string5);
                        string2 = string2.substring(n2 + 1);
                        n2 = string2.indexOf(string4);
                    }
                    int n3 = string2.indexOf("]");
                    if (n3 >= 0) {
                        if (!bl) {
                            vector.addElement(string2.substring(0, n3));
                        }
                        int n4 = vector.size();
                        String string6 = "String:BigDecimal:Date:Time:Timestamp:Blob:Clob:int:short:long:float:double:byteArray";
                        if (string3.equals("String")) {
                            String[] stringArray = new String[n4];
                            for (int i = 0; i < n4; ++i) {
                                String string7 = (String)vector.get(i);
                                if ("null".equals(string7)) {
                                    stringArray[i] = null;
                                    continue;
                                }
                                if (string7.indexOf("UX'") == 0) {
                                    int n5 = string7.length();
                                    char[] cArray = new char[(n5 -= 4) / 4];
                                    for (int j = 0; j < cArray.length; ++j) {
                                        String string8 = string7.substring(3 + j * 4, 3 + j * 4 + 4);
                                        cArray[j] = (char)Integer.parseInt(string8, 16);
                                    }
                                    stringArray[i] = new String(cArray);
                                    continue;
                                }
                                stringArray[i] = string7;
                            }
                            if (this.toolboxDriver_) {
                                preparedStatement.setArray(n, this.makeArray(stringArray, "VARCHAR"));
                            } else {
                                preparedStatement.setObject(n, stringArray);
                            }
                            break block95;
                        }
                        if (string3.equals("Clob")) {
                            Clob[] clobArray = new Clob[n4];
                            for (int i = 0; i < n4; ++i) {
                                String string9 = (String)vector.get(i);
                                clobArray[i] = "null".equals(string9) ? null : new ClientClob(string9);
                            }
                            if (this.toolboxDriver_) {
                                preparedStatement.setArray(n, this.makeArray(clobArray, "CLOB"));
                            } else {
                                preparedStatement.setObject(n, clobArray);
                            }
                            break block95;
                        }
                        if (string3.equals("BigDecimal")) {
                            BigDecimal[] bigDecimalArray = new BigDecimal[n4];
                            for (int i = 0; i < n4; ++i) {
                                String string10 = (String)vector.get(i);
                                bigDecimalArray[i] = "null".equals(string10) ? null : new BigDecimal(string10);
                            }
                            if (this.toolboxDriver_) {
                                preparedStatement.setArray(n, this.makeArray(bigDecimalArray, "DECIMAL"));
                            } else {
                                preparedStatement.setObject(n, bigDecimalArray);
                            }
                            break block95;
                        }
                        if (string3.equals("Date")) {
                            Date[] dateArray = new Date[n4];
                            for (int i = 0; i < n4; ++i) {
                                String string11 = (String)vector.get(i);
                                dateArray[i] = "null".equals(string11) ? null : Date.valueOf(string11);
                            }
                            if (this.toolboxDriver_) {
                                preparedStatement.setArray(n, this.makeArray(dateArray, "DATE"));
                            } else {
                                preparedStatement.setObject(n, dateArray);
                            }
                            break block95;
                        }
                        if (string3.equals("Time")) {
                            Time[] timeArray = new Time[n4];
                            for (int i = 0; i < n4; ++i) {
                                String string12 = (String)vector.get(i);
                                timeArray[i] = "null".equals(string12) ? null : Time.valueOf(string12);
                            }
                            if (this.toolboxDriver_) {
                                preparedStatement.setArray(n, this.makeArray(timeArray, "TIME"));
                            } else {
                                preparedStatement.setObject(n, timeArray);
                            }
                            break block95;
                        }
                        if (string3.equals("Timestamp")) {
                            Timestamp[] timestampArray = new Timestamp[n4];
                            for (int i = 0; i < n4; ++i) {
                                String string13 = (String)vector.get(i);
                                timestampArray[i] = "null".equals(string13) ? null : Timestamp.valueOf(string13);
                            }
                            if (this.toolboxDriver_) {
                                preparedStatement.setArray(n, this.makeArray(timestampArray, "TIMESTAMP"));
                            } else {
                                preparedStatement.setObject(n, timestampArray);
                            }
                            break block95;
                        }
                        if (string3.equals("Integer")) {
                            Integer[] integerArray = new Integer[n4];
                            for (int i = 0; i < n4; ++i) {
                                String string14 = (String)vector.get(i);
                                integerArray[i] = "null".equals(string14) ? null : new Integer(Integer.parseInt(string14));
                            }
                            if (this.toolboxDriver_) {
                                preparedStatement.setArray(n, this.makeArray(integerArray, "INTEGER"));
                            } else {
                                preparedStatement.setObject(n, integerArray);
                            }
                            break block95;
                        }
                        if (string3.equals("int")) {
                            int[] nArray = new int[n4];
                            for (int i = 0; i < n4; ++i) {
                                String string15 = (String)vector.get(i);
                                nArray[i] = "null".equals(string15) ? 0 : Integer.parseInt(string15);
                            }
                            if (this.toolboxDriver_) {
                                Integer[] integerArray = new Integer[n4];
                                for (int i = 0; i < n4; ++i) {
                                    integerArray[i] = new Integer(nArray[i]);
                                }
                                preparedStatement.setArray(n, this.makeArray(integerArray, "INTEGER"));
                            } else {
                                preparedStatement.setObject(n, nArray);
                            }
                            break block95;
                        }
                        if (string3.equals("Short")) {
                            Short[] shortArray = new Short[n4];
                            for (int i = 0; i < n4; ++i) {
                                String string16 = (String)vector.get(i);
                                shortArray[i] = "null".equals(string16) ? null : new Short((short)Integer.parseInt(string16));
                            }
                            if (this.toolboxDriver_) {
                                preparedStatement.setArray(n, this.makeArray(shortArray, "SMALLINT"));
                            } else {
                                preparedStatement.setObject(n, shortArray);
                            }
                            break block95;
                        }
                        if (string3.equals("short")) {
                            short[] sArray = new short[n4];
                            for (int i = 0; i < n4; ++i) {
                                String string17 = (String)vector.get(i);
                                sArray[i] = "null".equals(string17) ? (short)0 : (short)Integer.parseInt(string17);
                            }
                            if (this.toolboxDriver_) {
                                Short[] shortArray = new Short[n4];
                                for (int i = 0; i < n4; ++i) {
                                    shortArray[i] = new Short(sArray[i]);
                                }
                                preparedStatement.setArray(n, this.makeArray(shortArray, "SMALLINT"));
                            } else {
                                preparedStatement.setObject(n, sArray);
                            }
                            break block95;
                        }
                        if (string3.equals("Long")) {
                            Long[] longArray = new Long[n4];
                            for (int i = 0; i < n4; ++i) {
                                String string18 = (String)vector.get(i);
                                longArray[i] = "null".equals(string18) ? null : new Long(Long.parseLong(string18));
                            }
                            if (this.toolboxDriver_) {
                                preparedStatement.setArray(n, this.makeArray(longArray, "BIGINT"));
                            } else {
                                preparedStatement.setObject(n, longArray);
                            }
                            break block95;
                        }
                        if (string3.equals("long")) {
                            long[] lArray = new long[n4];
                            for (int i = 0; i < n4; ++i) {
                                String string19 = (String)vector.get(i);
                                lArray[i] = "null".equals(string19) ? 0L : Long.parseLong(string19);
                            }
                            if (this.toolboxDriver_) {
                                Long[] longArray = new Long[n4];
                                for (int i = 0; i < n4; ++i) {
                                    longArray[i] = new Long(lArray[i]);
                                }
                                preparedStatement.setArray(n, this.makeArray(longArray, "BIGINT"));
                            } else {
                                preparedStatement.setObject(n, lArray);
                            }
                            break block95;
                        }
                        if (string3.equals("Float")) {
                            Float[] floatArray = new Float[n4];
                            for (int i = 0; i < n4; ++i) {
                                String string20 = (String)vector.get(i);
                                floatArray[i] = "null".equals(string20) ? null : new Float((float)Double.parseDouble(string20));
                            }
                            if (this.toolboxDriver_) {
                                preparedStatement.setArray(n, this.makeArray(floatArray, "REAL"));
                            } else {
                                preparedStatement.setObject(n, floatArray);
                            }
                            break block95;
                        }
                        if (string3.equals("float")) {
                            float[] fArray = new float[n4];
                            for (int i = 0; i < n4; ++i) {
                                String string21 = (String)vector.get(i);
                                fArray[i] = "null".equals(string21) ? 0.0f : (float)Double.parseDouble(string21);
                            }
                            if (this.toolboxDriver_) {
                                Float[] floatArray = new Float[n4];
                                for (int i = 0; i < n4; ++i) {
                                    floatArray[i] = new Float(fArray[i]);
                                }
                                preparedStatement.setArray(n, this.makeArray(floatArray, "REAL"));
                            } else {
                                preparedStatement.setObject(n, fArray);
                            }
                            break block95;
                        }
                        if (string3.equals("Double")) {
                            Double[] doubleArray = new Double[n4];
                            for (int i = 0; i < n4; ++i) {
                                String string22 = (String)vector.get(i);
                                doubleArray[i] = "null".equals(string22) ? null : new Double(Double.parseDouble(string22));
                            }
                            if (this.toolboxDriver_) {
                                preparedStatement.setArray(n, this.makeArray(doubleArray, "DOUBLE"));
                            } else {
                                preparedStatement.setObject(n, doubleArray);
                            }
                            break block95;
                        }
                        if (string3.equals("double")) {
                            double[] dArray = new double[n4];
                            for (int i = 0; i < n4; ++i) {
                                String string23 = (String)vector.get(i);
                                dArray[i] = "null".equals(string23) ? 0.0 : Double.parseDouble(string23);
                            }
                            if (this.toolboxDriver_) {
                                Double[] doubleArray = new Double[n4];
                                for (int i = 0; i < n4; ++i) {
                                    doubleArray[i] = new Double(dArray[i]);
                                }
                                preparedStatement.setArray(n, this.makeArray(doubleArray, "DOUBLE"));
                            } else {
                                preparedStatement.setObject(n, dArray);
                            }
                            break block95;
                        }
                        if (string3.equals("byteArray")) {
                            byte[][] byArrayArray = new byte[n4][];
                            for (int i = 0; i < n4; ++i) {
                                String string24 = (String)vector.get(i);
                                if ("null".equals(string24)) {
                                    byArrayArray[i] = null;
                                    continue;
                                }
                                byte[] byArray = new byte[string24.length() / 2];
                                for (int j = 0; j < byArray.length; ++j) {
                                    String string25 = string24.substring(j * 2, j * 2 + 2);
                                    byArray[j] = (byte)Integer.parseInt(string25, 16);
                                }
                                byArrayArray[i] = byArray;
                            }
                            if (this.toolboxDriver_) {
                                preparedStatement.setArray(n, this.makeArray(byArrayArray, "BINARY"));
                            } else {
                                preparedStatement.setObject(n, byArrayArray);
                            }
                            break block95;
                        }
                        if (string3.equals("Blob")) {
                            Blob[] blobArray = new Blob[n4];
                            for (int i = 0; i < n4; ++i) {
                                String string26 = (String)vector.get(i);
                                if ("null".equals(string26)) {
                                    blobArray[i] = null;
                                    continue;
                                }
                                byte[] byArray = new byte[string26.length() / 2];
                                for (int j = 0; j < byArray.length; ++j) {
                                    String string27 = string26.substring(j * 2, j * 2 + 2);
                                    byArray[j] = (byte)Integer.parseInt(string27, 16);
                                }
                                blobArray[i] = new ClientBlob(byArray);
                            }
                            if (this.toolboxDriver_) {
                                preparedStatement.setArray(n, this.makeArray(blobArray, "BLOB"));
                            } else {
                                preparedStatement.setObject(n, blobArray);
                            }
                            break block95;
                        }
                        if (string3.equalsIgnoreCase("null")) {
                            preparedStatement.setObject(n, null);
                            break block95;
                        }
                        throw new Exception("Type [" + string3 + "] not valid: valid types=" + string6);
                    }
                    throw new Exception("Unable to find ending brace for SQLARRAY[TYPE:e1:e2:...]");
                }
                throw new Exception("TYPE not found for SQLARRAY[TYPE:e1:e2:...]");
            }
            catch (Exception exception) {
                printStream.println("Processing of ARRAYPARAMETER '" + string + "' failed because of " + exception);
                if (exception instanceof SQLException) {
                    throw (SQLException)exception;
                }
                exception.printStackTrace(printStream);
            }
        }
    }

    void addVariable(String string, Object object) {
        this.variables.put(string, object);
        if (string.equals("CON")) {
            this.connection_ = (Connection)object;
        } else if (string.equals("STMT")) {
            this.stmt_ = (Statement)object;
        } else if (string.equals("PSTMT")) {
            this.pstmt_ = (PreparedStatement)object;
        } else if (string.equals("CSTMT")) {
            this.cstmt_ = (CallableStatement)object;
        } else if (string.equals("RS")) {
            this.manualResultSet_ = (ResultSet)object;
        }
    }

    public static void main(String[] stringArray) {
        if (stringArray.length < 1) {
            System.out.println(usage);
            System.exit(1);
        } else {
            try {
                Main main = stringArray.length == 1 ? new Main(stringArray[0], null, null) : (stringArray.length == 2 ? new Main(stringArray[0], stringArray[1], null) : new Main(stringArray[0], stringArray[1], stringArray[2]));
                int n = main.go(System.in, System.out);
                System.exit(n);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }
}

