/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400JDBCClob;
import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.ConvTable;
import com.ibm.as400.access.JDError;
import com.ibm.as400.access.SQLConversionSettings;
import com.ibm.as400.access.SQLDataBase;
import com.ibm.as400.access.SQLDataFactory;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;

final class SQLFloat
extends SQLDataBase {
    static final String copyright = "Copyright (C) 1997-2003 International Business Machines Corporation and others.";
    private double value_ = 0.0;

    SQLFloat(SQLConversionSettings sQLConversionSettings) {
        super(sQLConversionSettings);
    }

    public Object clone() {
        return new SQLFloat(this.settings_);
    }

    public void convertFromRawBytes(byte[] byArray, int n, ConvTable convTable) throws SQLException {
        this.value_ = BinaryConverter.byteArrayToDouble(byArray, n);
    }

    public void convertToRawBytes(byte[] byArray, int n, ConvTable convTable) throws SQLException {
        BinaryConverter.doubleToByteArray(this.value_, byArray, n);
    }

    public void set(Object object, Calendar calendar, int n) throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        if (object instanceof String) {
            try {
                this.value_ = Double.valueOf((String)object);
            }
            catch (NumberFormatException numberFormatException) {
                JDError.throwSQLException((Object)this, "07006");
            }
        } else if (object instanceof Number) {
            this.value_ = ((Number)object).doubleValue();
        } else if (object instanceof Boolean) {
            this.value_ = (Boolean)object == true ? 1.0 : 0.0;
        } else {
            JDError.throwSQLException((Object)this, "07006");
        }
    }

    public int getSQLType() {
        return 16;
    }

    public String getCreateParameters() {
        return null;
    }

    public int getDisplaySize() {
        return 22;
    }

    public String getJavaClassName() {
        return "java.lang.Float";
    }

    public String getLiteralPrefix() {
        return null;
    }

    public String getLiteralSuffix() {
        return null;
    }

    public String getLocalName() {
        return "FLOAT";
    }

    public int getMaximumPrecision() {
        return 53;
    }

    public int getMaximumScale() {
        return 0;
    }

    public int getMinimumScale() {
        return 0;
    }

    public int getNativeType() {
        return 480;
    }

    public int getPrecision() {
        return 53;
    }

    public int getRadix() {
        return 2;
    }

    public int getScale() {
        return 0;
    }

    public int getType() {
        return 6;
    }

    public String getTypeName() {
        return "FLOAT";
    }

    public boolean isSigned() {
        return true;
    }

    public boolean isText() {
        return false;
    }

    public int getActualSize() {
        return SQLDataFactory.getPrecision(Double.toString(this.value_));
    }

    public int getTruncated() {
        return this.truncated_;
    }

    public boolean getOutOfBounds() {
        return this.outOfBounds_;
    }

    public BigDecimal getBigDecimal(int n) throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        BigDecimal bigDecimal = null;
        String string = Double.toString(this.value_);
        int n2 = string.indexOf("E");
        if (n2 == -1) {
            bigDecimal = new BigDecimal(string);
        } else {
            String string2 = string.substring(0, n2);
            int n3 = Integer.parseInt(string.substring(n2 + 1));
            bigDecimal = new BigDecimal(string2);
            bigDecimal = bigDecimal.movePointRight(n3);
        }
        if (n >= 0) {
            if (n >= bigDecimal.scale()) {
                this.truncated_ = 0;
                this.outOfBounds_ = false;
                return bigDecimal.setScale(n);
            }
            this.truncated_ = bigDecimal.scale() - n;
            return bigDecimal.setScale(n, 4);
        }
        return bigDecimal;
    }

    public InputStream getBinaryStream() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    public Blob getBlob() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    public boolean getBoolean() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        return this.value_ != 0.0;
    }

    public byte getByte() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        if (this.value_ > 127.0 || this.value_ < -128.0) {
            if (this.value_ > 32767.0 || this.value_ < -32768.0) {
                this.truncated_ = 3;
                this.outOfBounds_ = true;
            } else {
                this.truncated_ = 1;
                this.outOfBounds_ = true;
            }
        }
        return (byte)this.value_;
    }

    public byte[] getBytes() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    public Reader getCharacterStream() throws SQLException {
        return new StringReader(this.getString());
    }

    public Clob getClob() throws SQLException {
        String string = this.getString();
        return new AS400JDBCClob(string, string.length());
    }

    public Date getDate(Calendar calendar) throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    public double getDouble() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        return this.value_;
    }

    public float getFloat() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        return (float)this.value_;
    }

    public int getInt() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        if (this.value_ > 2.147483647E9 || this.value_ < -2.147483648E9) {
            this.truncated_ = 1;
            this.outOfBounds_ = true;
        }
        return (int)this.value_;
    }

    public long getLong() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        if (this.value_ > 9.223372036854776E18 || this.value_ < -9.223372036854776E18) {
            this.truncated_ = 1;
            this.outOfBounds_ = true;
        }
        return (long)this.value_;
    }

    public Object getObject() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        return new Double(this.value_);
    }

    public short getShort() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        if (this.value_ > 32767.0 || this.value_ < -32768.0) {
            if (this.value_ > 2.147483647E9 || this.value_ < -2.147483648E9) {
                this.truncated_ = 3;
                this.outOfBounds_ = true;
            } else {
                this.truncated_ = 2;
                this.outOfBounds_ = true;
            }
        }
        return (short)this.value_;
    }

    public String getString() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        String string = Double.toString(this.value_);
        int n = string.indexOf(46);
        if (n == -1) {
            return string;
        }
        return string.substring(0, n) + this.settings_.getDecimalSeparator() + string.substring(n + 1);
    }

    public Time getTime(Calendar calendar) throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    public Timestamp getTimestamp(Calendar calendar) throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }
}

