/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.InternalErrorException;
import com.ibm.as400.access.PxSocketContainerAdapter;
import com.ibm.as400.access.SSLOptions;
import com.ibm.as400.access.Trace;
import com.ibm.as400.access.Verbose;
import com.ibm.sslight.SSLCert;
import com.ibm.sslight.SSLContext;
import com.ibm.sslight.SSLException;
import com.ibm.sslight.SSLSocket;
import com.ibm.sslight.SSLightKeyRing;
import java.io.IOException;
import java.net.Socket;
import java.util.Date;

class PxSecureSocketContainer
extends PxSocketContainerAdapter {
    private static final String copyright = "Copyright (C) 1997-2003 International Business Machines Corporation and others.";

    public PxSecureSocketContainer(String string, int n, SSLOptions sSLOptions) throws IOException {
        super(PxSecureSocketContainer.createSSLSocket(string, n, sSLOptions));
    }

    private static Socket createSSLSocket(String string, int n, SSLOptions sSLOptions) throws IOException {
        SSLContext sSLContext = PxSecureSocketContainer.initializeClientSSLContext(sSLOptions);
        SSLSocket sSLSocket = null;
        try {
            sSLSocket = new SSLSocket(string, n, sSLContext, false, null);
        }
        catch (SSLException sSLException) {
            Trace.logSSL(1, sSLException.getCategory(), sSLException.getError(), sSLException.getInt1());
            throw sSLException;
        }
        if (Trace.isTraceOn()) {
            PxSecureSocketContainer.traceSSLSocket(sSLSocket);
        }
        return sSLSocket;
    }

    static SSLContext initializeClientSSLContext(SSLOptions sSLOptions) throws IOException {
        SSLContext sSLContext = new SSLContext();
        if (Trace.isTraceOn()) {
            sSLContext.debug = true;
        }
        if (sSLOptions.keyRingData_ == null) {
            try {
                SSLightKeyRing sSLightKeyRing = (SSLightKeyRing)Class.forName(sSLOptions.keyRingName_).newInstance();
                sSLOptions.keyRingData_ = sSLightKeyRing.getKeyRingData();
            }
            catch (Exception exception) {
                Trace.log(2, "Error loading key ring:", (Throwable)exception);
                throw new InternalErrorException(10);
            }
        }
        boolean bl = sSLContext.importKeyRings(sSLOptions.keyRingData_, sSLOptions.keyRingPassword_);
        if (Trace.isTraceOn()) {
            Trace.log(1, "Import key rings successful = " + bl + ".");
            String[] stringArray = sSLContext.getEnabledCipherSuites();
            Trace.log(1, "Enabled cipher suites:");
            for (int i = 0; i < stringArray.length; ++i) {
                Trace.log(1, "  " + stringArray[i]);
            }
        }
        return sSLContext;
    }

    static SSLContext initializeServerSSLContext(String string, String string2) throws IOException {
        String[] stringArray;
        SSLContext sSLContext = null;
        SSLightKeyRing sSLightKeyRing = null;
        boolean bl = false;
        try {
            sSLightKeyRing = (SSLightKeyRing)Class.forName(string).newInstance();
            stringArray = sSLightKeyRing.getKeyRingData();
            sSLContext = new SSLContext();
            if (Trace.isTraceOn()) {
                sSLContext.debug = true;
            }
            bl = sSLContext.importKeyRings((String)stringArray, string2);
        }
        catch (SSLException sSLException) {
            sSLContext = null;
            if (Trace.isTraceOn()) {
                Trace.logSSL(1, sSLException.getCategory(), sSLException.getError(), sSLException.getInt1());
            }
        }
        catch (InstantiationException instantiationException) {
            Trace.log(2, "Unable to instantiate key ring object:", (Throwable)instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            Trace.log(2, "Unable to access key ring object:", (Throwable)illegalAccessException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            Verbose.println("  java.lang.ClassNotFoundException: " + string);
            Trace.log(2, "Unable to locate key ring class:", (Throwable)classNotFoundException);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            Verbose.println("  java.lang.NoClassDefFoundError: " + string);
            Trace.log(2, "Unable to locate key ring class:", (Throwable)noClassDefFoundError);
        }
        if (Trace.isTraceOn()) {
            Trace.log(1, "Import key rings successful = " + bl + ".");
            if (sSLContext != null) {
                stringArray = sSLContext.getEnabledCipherSuites();
                Trace.log(1, "Enabled cipher suites:");
                for (int i = 0; i < stringArray.length; ++i) {
                    Trace.log(1, "  " + stringArray[i]);
                }
            }
        }
        return sSLContext;
    }

    static void traceSSLSocket(SSLSocket sSLSocket) {
        if (Trace.isTraceOn()) {
            Trace.log(1, "SSL connection established.");
            Trace.log(1, "Cipher suite = " + sSLSocket.getCipherSuite() + ".");
            Trace.log(1, "Compression method = " + sSLSocket.getCompressionMethod() + ".");
            SSLCert[] sSLCertArray = sSLSocket.getPeerCertificateChain();
            if (sSLCertArray != null) {
                Trace.log(1, "Peer certificate: " + sSLCertArray[0].getKeyInfo() + " bits.");
                int[] nArray = new int[]{3, 11, 10, 6, 7};
                for (int i = 0; i < nArray.length; ++i) {
                    String string = sSLCertArray[0].getNameComponent(1, nArray[i]);
                    if (string != null) {
                        Trace.log(1, "Name component[" + i + "] = " + string + ".");
                        continue;
                    }
                    Trace.log(1, "Name component[" + i + "] = (null).");
                }
                Date[] dateArray = sSLCertArray[0].getValidity();
                if (dateArray != null) {
                    Trace.log(1, "Valid from " + dateArray[0] + " to " + dateArray[1] + ".");
                }
            }
        }
    }
}

