/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400Exception;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.ErrorCompletingRequestException;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.PrintObjectPageInputStreamImpl;
import com.ibm.as400.access.PrintParameterList;
import com.ibm.as400.access.RequestNotSupportedException;
import com.ibm.as400.access.SpooledFile;
import com.ibm.as400.access.SpooledFileImpl;
import com.ibm.as400.access.Trace;
import java.io.IOException;
import java.io.InputStream;

public class PrintObjectPageInputStream
extends InputStream {
    private transient AS400 system_;
    private transient PrintObjectPageInputStreamImpl impl_;

    PrintObjectPageInputStream(SpooledFile spooledFile, PrintParameterList printParameterList) throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, RequestNotSupportedException {
        this.system_ = spooledFile.getSystem();
        this.chooseImpl();
        this.system_.connectService(1);
        if (spooledFile.getImpl() == null) {
            spooledFile.chooseImpl();
        }
        this.impl_.createPrintObjectPageInputStream((SpooledFileImpl)spooledFile.getImpl(), printParameterList);
    }

    public int available() throws IOException {
        return this.impl_.available();
    }

    private void chooseImpl() {
        if (this.system_ == null) {
            Trace.log(2, "Attempt to use PrintObjectPageInputStream before setting system.");
            throw new ExtendedIllegalStateException("system", 4);
        }
        this.impl_ = (PrintObjectPageInputStreamImpl)this.system_.loadImpl2("com.ibm.as400.access.PrintObjectPageInputStreamImplRemote", "com.ibm.as400.access.PrintObjectPageInputStreamImplProxy");
    }

    public void close() throws IOException {
        this.impl_.close();
    }

    public int getCurrentPageNumber() {
        return this.impl_.getCurrentPageNumber();
    }

    public int getNumberOfPages() {
        return this.impl_.getNumberOfPages();
    }

    public boolean isPagesEstimated() {
        return this.impl_.isPagesEstimated();
    }

    public void mark(int n) {
        this.impl_.mark(n);
    }

    public boolean markSupported() {
        return true;
    }

    public boolean nextPage() throws IOException {
        return this.impl_.nextPage();
    }

    public boolean previousPage() throws IOException {
        return this.impl_.previousPage();
    }

    public int read() throws IOException {
        int n = -1;
        byte[] byArray = new byte[1];
        int n2 = this.read(byArray, 0, 1);
        if (n2 == 1) {
            n = byArray[0];
        }
        return n;
    }

    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        return this.impl_.read(byArray, n, n2);
    }

    public void reset() throws IOException {
        this.impl_.reset();
    }

    public boolean selectPage(int n) throws IOException, IllegalArgumentException {
        return this.impl_.selectPage(n);
    }

    public long skip(long l) throws IOException {
        if (l <= 0L) {
            return 0L;
        }
        return this.impl_.skip(l);
    }
}

