/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400Calendar;
import com.ibm.as400.access.JDError;
import com.ibm.as400.access.JDRow;
import com.ibm.as400.access.JDUtilities;
import com.ibm.as400.access.SQLData;
import java.sql.SQLException;
import java.util.Calendar;

class JDSimpleRow
implements JDRow {
    static final String copyright = "Copyright (C) 1997-2001 International Business Machines Corporation and others.";
    private String[] fieldNames_;
    private int[] fieldNullables_;
    private SQLData[] sqlData_;
    private boolean[] sqlNulls_;
    private boolean[] sqlDataMappingErrors_;

    JDSimpleRow(String[] stringArray, SQLData[] sQLDataArray, int[] nArray) {
        this.fieldNames_ = stringArray;
        this.fieldNullables_ = nArray;
        this.sqlData_ = sQLDataArray;
        this.sqlNulls_ = new boolean[this.sqlData_.length];
        this.sqlDataMappingErrors_ = new boolean[this.sqlData_.length];
    }

    JDSimpleRow(JDRow jDRow, boolean bl) throws SQLException {
        int n = jDRow.getFieldCount();
        this.fieldNames_ = new String[n];
        this.fieldNullables_ = new int[n];
        this.sqlData_ = new SQLData[n];
        this.sqlNulls_ = new boolean[n];
        this.sqlDataMappingErrors_ = new boolean[n];
        for (int i = 0; i < n; ++i) {
            this.fieldNames_[i] = jDRow.getFieldName(i + 1);
            this.fieldNullables_[i] = jDRow.isNullable(i + 1);
            if (bl) {
                this.sqlData_[i] = (SQLData)jDRow.getSQLData(i + 1).clone();
                this.sqlNulls_[i] = false;
                this.sqlDataMappingErrors_[i] = false;
                continue;
            }
            this.sqlData_[i] = jDRow.getSQLData(i + 1);
            this.sqlNulls_[i] = jDRow.isNull(i + 1);
            this.sqlDataMappingErrors_[i] = jDRow.isDataMappingError(i + 1);
        }
    }

    void setData(Object[] objectArray) throws SQLException {
        Calendar calendar = AS400Calendar.getGregorianInstance();
        for (int i = 0; i < this.sqlData_.length; ++i) {
            this.sqlData_[i].set(objectArray[i], calendar, -1);
        }
    }

    void setDataMappingErrors(boolean[] blArray) {
        this.sqlDataMappingErrors_ = blArray;
    }

    void setNulls(boolean[] blArray) {
        this.sqlNulls_ = blArray;
    }

    public int findField(String string) throws SQLException {
        if (string.startsWith("\"") && string.endsWith("\"")) {
            string = JDUtilities.stripOuterDoubleQuotes(string);
            for (int i = 1; i <= this.sqlData_.length; ++i) {
                if (!string.equals(this.getFieldName(i))) continue;
                return i;
            }
        } else {
            string = string.toUpperCase();
            for (int i = 0; i < this.fieldNames_.length; ++i) {
                if (!string.equals(this.fieldNames_[i])) continue;
                return i + 1;
            }
        }
        JDError.throwSQLException("42703");
        return -1;
    }

    public int getFieldCount() {
        return this.fieldNames_.length;
    }

    public String getFieldName(int n) throws SQLException {
        try {
            return this.fieldNames_[n - 1];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            JDError.throwSQLException("07009", arrayIndexOutOfBoundsException);
            return null;
        }
    }

    public SQLData getSQLData(int n) throws SQLException {
        try {
            return this.sqlData_[n - 1];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            JDError.throwSQLException("07009", arrayIndexOutOfBoundsException);
            return null;
        }
    }

    public SQLData getSQLType(int n) throws SQLException {
        try {
            return this.sqlData_[n - 1];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            JDError.throwSQLException("07009", arrayIndexOutOfBoundsException);
            return null;
        }
    }

    public boolean isDataMappingError(int n) throws SQLException {
        try {
            return this.sqlDataMappingErrors_[n - 1];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            JDError.throwSQLException("07009", arrayIndexOutOfBoundsException);
            return false;
        }
    }

    public boolean isNull(int n) throws SQLException {
        try {
            return this.sqlNulls_[n - 1];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            JDError.throwSQLException("07009", arrayIndexOutOfBoundsException);
            return false;
        }
    }

    public int isNullable(int n) throws SQLException {
        try {
            return this.fieldNullables_[n - 1];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            JDError.throwSQLException("07009", arrayIndexOutOfBoundsException);
            return -1;
        }
    }
}

