/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.test;

import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.StatsTrack;
import org.apache.zookeeper.TestableZooKeeper;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeperMain;
import org.apache.zookeeper.data.Stat;
import org.apache.zookeeper.test.QuorumBase;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuorumQuotaTest
extends QuorumBase {
    private static final Logger LOG = LoggerFactory.getLogger(QuorumQuotaTest.class);

    @Test
    public void testQuotaWithQuorum() throws Exception {
        TestableZooKeeper zk = this.createClient();
        zk.setData("/", "some".getBytes(), -1);
        zk.create("/a", "some".getBytes(), ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        int i = 0;
        for (i = 0; i < 300; ++i) {
            zk.create("/a/" + i, "some".getBytes(), ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        }
        ZooKeeperMain.createQuota(zk, "/a", 1000L, 5000);
        String statPath = "/zookeeper/quota/a/zookeeper_stats";
        byte[] data = zk.getData(statPath, false, new Stat());
        StatsTrack st = new StatsTrack(new String(data));
        Assert.assertTrue((String)"bytes are set", (st.getBytes() == 1204L ? 1 : 0) != 0);
        Assert.assertTrue((String)"num count is set", (st.getCount() == 301 ? 1 : 0) != 0);
        for (i = 300; i < 600; ++i) {
            zk.create("/a/" + i, "some".getBytes(), ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        }
        data = zk.getData(statPath, false, new Stat());
        st = new StatsTrack(new String(data));
        Assert.assertTrue((String)"bytes are set", (st.getBytes() == 2404L ? 1 : 0) != 0);
        Assert.assertTrue((String)"num count is set", (st.getCount() == 601 ? 1 : 0) != 0);
    }
}

