/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.SocketChannel;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.apache.zookeeper.ClientCnxn;
import org.apache.zookeeper.ClientCnxnSocketNIO;
import org.apache.zookeeper.ClientWatchManager;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.client.HostProvider;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;

public class ClientReconnectTest
extends TestCase {
    private SocketChannel sc;
    private CountDownLatch countDownLatch = new CountDownLatch(3);

    @Test
    public void testClientReconnect() throws IOException, InterruptedException {
        HostProvider hostProvider = (HostProvider)Mockito.mock(HostProvider.class);
        Mockito.when((Object)hostProvider.size()).thenReturn((Object)1);
        InetSocketAddress inaddr = new InetSocketAddress(1111);
        Mockito.when((Object)hostProvider.next(Matchers.anyLong())).thenReturn((Object)inaddr);
        ZooKeeper zk = (ZooKeeper)Mockito.mock(ZooKeeper.class);
        this.sc = SocketChannel.open();
        MockCnxn nioCnxn = new MockCnxn();
        ClientWatchManager watcher = (ClientWatchManager)Mockito.mock(ClientWatchManager.class);
        ClientCnxn clientCnxn = new ClientCnxn("tmp", hostProvider, 5000, zk, watcher, nioCnxn, false);
        clientCnxn.start();
        this.countDownLatch.await(5000L, TimeUnit.MILLISECONDS);
        Assert.assertTrue((this.countDownLatch.getCount() == 0L ? 1 : 0) != 0);
        clientCnxn.close();
    }

    class MockCnxn
    extends ClientCnxnSocketNIO {
        MockCnxn() throws IOException {
        }

        void registerAndConnect(SocketChannel sock, InetSocketAddress addr) throws IOException {
            ClientReconnectTest.this.countDownLatch.countDown();
            throw new IOException("failed to register");
        }

        SocketChannel createSock() {
            return ClientReconnectTest.this.sc;
        }
    }
}

