/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.couchbase.data;

import com.couchbase.client.java.document.json.JsonObject;
import com.dbeaver.db.couchbase.CouchbaseUtils;
import com.dbeaver.db.couchbase.model.CouchbaseDataSource;
import com.dbeaver.ee.model.document.data.DBAbstractDocument;
import com.dbeaver.ee.model.document.data.DBMapValue;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.data.DBDValueCloneable;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.utils.IOUtils;

public class CouchbaseDocument
extends DBAbstractDocument<CouchbaseDataSource, JsonObject>
implements DBDValueCloneable {
    private static final Log log = Log.getLog(CouchbaseDocument.class);

    public CouchbaseDocument(@NotNull CouchbaseDataSource dataSource, @NotNull JsonObject jsonDocument) {
        super((DBPDataSource)dataSource, (Object)jsonDocument);
    }

    @Nullable
    public Object getDocumentId() {
        return ((JsonObject)this.rawValue).get("_id");
    }

    public Object getDocumentProperty(String name) {
        if (name.equals("idAttributeName")) {
            return "_id";
        }
        return null;
    }

    @NotNull
    public String getDocumentContentType() {
        return "text/json";
    }

    protected DBMapValue<CouchbaseDataSource> makeRawMap() {
        return CouchbaseUtils.makeRawMap((CouchbaseDataSource)this.dataSource, (Object)this, (JsonObject)this.rawValue);
    }

    public void serializeDocument(@NotNull DBRProgressMonitor monitor, @NotNull OutputStream stream, Charset charset) throws DBException, IOException {
        Throwable throwable = null;
        Object var5_6 = null;
        try (OutputStreamWriter out = new OutputStreamWriter(stream, charset);){
            ((CouchbaseDataSource)this.dataSource).serializeDocument((JsonObject)this.rawValue, (Writer)out);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public void updateDocument(@NotNull DBRProgressMonitor monitor, @NotNull InputStream stream, Charset charset) throws DBException, IOException {
        Throwable throwable = null;
        Object var5_6 = null;
        try (InputStreamReader reader = new InputStreamReader(stream, charset);){
            String json = IOUtils.readToString((Reader)reader);
            this.rawValue = JsonObject.fromJson((String)json);
            this.rawMap = this.makeRawMap();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        this.markModified();
    }

    public CouchbaseDocument copy() {
        return new CouchbaseDocument((CouchbaseDataSource)this.dataSource, (JsonObject)this.rawValue);
    }

    public DBDValueCloneable cloneValue(DBRProgressMonitor monitor) throws DBCException {
        return this.copy();
    }

    public String toString() {
        return ((JsonObject)this.rawValue).toString();
    }
}

