/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.runtime.core;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.registry.ProjectSecureStorage;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.runtime.encode.ContentEncrypter;
import org.jkiss.dbeaver.runtime.ui.UIServiceSecurity;
import org.jkiss.dbeaver.utils.SystemVariablesResolver;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.IOUtils;

public class EnterpriseProjectSecureStorage
extends ProjectSecureStorage {
    private static final Log log = Log.getLog(EnterpriseProjectSecureStorage.class);
    private static final String VAR_PROJECT_PASSWORD = "dbeaver.project.password";
    private SecretKey projectPassword;

    public EnterpriseProjectSecureStorage(DBPProject project) {
        super(project);
    }

    private boolean isProjectPasswordUsed() {
        return CommonUtils.getBoolean((Object)this.project.getProjectProperty("useProjectPassword"), (boolean)false);
    }

    public boolean useSecurePreferences() {
        return !this.isProjectPasswordUsed() && super.useSecurePreferences();
    }

    public SecretKey getLocalSecretKey() {
        if (this.isProjectPasswordUsed()) {
            if (this.projectPassword == null) {
                this.projectPassword = DBWorkbench.getPlatform().getApplication().isHeadlessMode() ? this.acquireSecretKeyFromConfiguration() : this.acquireSecretKey();
            }
            if (this.projectPassword != null) {
                return this.projectPassword;
            }
        }
        return super.getLocalSecretKey();
    }

    @Nullable
    private SecretKey acquireSecretKey() {
        String password;
        UIServiceSecurity serviceSecurity = (UIServiceSecurity)DBWorkbench.getService(UIServiceSecurity.class);
        if (serviceSecurity == null) {
            return null;
        }
        String message = "Enter project master password";
        while ((password = serviceSecurity.askForPassword("Project '" + this.project.getName() + "' master password", message, null, false)) != null) {
            SecretKey key = this.makeSecretKeyFromPassword(password);
            if (this.isValidSecretKey(key)) {
                return key;
            }
            message = "Incorrect password. Try again";
        }
        return null;
    }

    @Nullable
    private SecretKey acquireSecretKeyFromConfiguration() {
        String passwords = SystemVariablesResolver.INSTANCE.get(VAR_PROJECT_PASSWORD);
        if (passwords == null) {
            return null;
        }
        String[] stringArray = passwords.split(",");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String projectPassword;
            String projectName;
            String entry = stringArray[n2];
            if (entry.startsWith("@") && entry.indexOf(58) > 0) {
                int div = entry.indexOf(58);
                projectName = entry.substring(1, div);
                projectPassword = entry.substring(div + 1);
            } else {
                projectName = null;
                projectPassword = entry;
            }
            if (projectName == null || projectName.equals(this.project.getName())) {
                SecretKey key = this.makeSecretKeyFromPassword(projectPassword);
                if (!this.isValidSecretKey(key)) break;
                return key;
            }
            ++n2;
        }
        return null;
    }

    public boolean isValidSecretKey(SecretKey key) {
        Path credFile;
        Path mdFolder = this.project.getMetadataFolder(false);
        if (Files.exists(mdFolder, new LinkOption[0]) && Files.exists(credFile = mdFolder.resolve("credentials-config.json"), new LinkOption[0])) {
            byte[] bytes;
            try {
                bytes = IOUtils.readFileToBuffer((File)credFile.toFile());
            }
            catch (IOException iOException) {
                log.error((Object)"Error reading credentials file");
                return true;
            }
            ContentEncrypter encrypter = new ContentEncrypter(key);
            try {
                encrypter.decrypt(bytes);
                return true;
            }
            catch (Exception e) {
                log.debug((Object)"Error decrypting secure credentials", (Throwable)e);
                return false;
            }
        }
        return true;
    }

    public void setProjectPassword(String password) {
        this.projectPassword = CommonUtils.isEmpty((String)password) ? null : this.makeSecretKeyFromPassword(password);
    }

    public SecretKey makeSecretKeyFromPassword(String password) {
        byte[] bytes = password.getBytes(StandardCharsets.UTF_8);
        byte[] passBytes = Arrays.copyOf(bytes, 16);
        return new SecretKeySpec(passBytes, "AES");
    }
}

