/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.runtime.auth;

import com.dbeaver.ee.model.auth.SMApplicationIdentityProvider;
import com.dbeaver.ee.runtime.auth.IdentityProviderDescriptor;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.utils.CommonUtils;

public final class IdentityProviderRegistry {
    public static final String PROP_AUTH_TYPE = "dbeaver.auth.type";
    public static final String AUTH_TYPE_AUTO = "auto";
    private static IdentityProviderRegistry instance;
    private final Map<String, IdentityProviderDescriptor> identityProviders = new LinkedHashMap<String, IdentityProviderDescriptor>();

    private IdentityProviderRegistry(@NotNull IExtensionRegistry registry) {
        IConfigurationElement[] iConfigurationElementArray = registry.getConfigurationElementsFor("com.dbeaver.identityProvider");
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            IdentityProviderDescriptor descriptor = new IdentityProviderDescriptor(element);
            this.identityProviders.put(descriptor.getId(), descriptor);
            ++n2;
        }
    }

    @NotNull
    public static synchronized IdentityProviderRegistry getInstance() {
        if (instance == null) {
            instance = new IdentityProviderRegistry(Platform.getExtensionRegistry());
        }
        return instance;
    }

    @NotNull
    public SMApplicationIdentityProvider getGlobalIdentityProvider() throws DBException {
        String explicitProviderId = System.getProperty(PROP_AUTH_TYPE);
        if (AUTH_TYPE_AUTO.equals(explicitProviderId)) {
            for (IdentityProviderDescriptor value : this.identityProviders.values()) {
                SMApplicationIdentityProvider instance;
                if (!value.isAutoDetect() || !(instance = value.getInstance()).isDefaultForCurrentEnvironment()) continue;
                return instance;
            }
        } else if (!CommonUtils.isEmpty((String)explicitProviderId)) {
            return this.getIdentityProvider(explicitProviderId);
        }
        for (IdentityProviderDescriptor value : this.identityProviders.values()) {
            if (!value.isDefault()) continue;
            return value.getInstance();
        }
        throw new DBException("Can't determine default identity provider");
    }

    @NotNull
    private SMApplicationIdentityProvider getIdentityProvider(@NotNull String id) throws DBException {
        IdentityProviderDescriptor descriptor = this.identityProviders.get(id);
        if (descriptor == null) {
            throw new DBException("Can't find a identity provider " + id);
        }
        return descriptor.getInstance();
    }
}

