/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.model;

import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDataSource;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDataType;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreProcedure;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.struct.DBSAttributeBase;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.rdb.DBSProcedureParameter;
import org.jkiss.dbeaver.model.struct.rdb.DBSProcedureParameterKind;

public class PostgreProcedureParameter
implements DBSProcedureParameter,
DBSAttributeBase,
DBSObject {
    private PostgreProcedure procedure;
    private String paramName;
    private int ordinalPosition;
    private PostgreDataType dataType;
    private PostgreProcedure.ArgumentMode argumentMode;
    private String defaultValue;

    public PostgreProcedureParameter(PostgreProcedure procedure, String paramName, PostgreDataType dataType, @NotNull PostgreProcedure.ArgumentMode argumentMode, int ordinalPosition) {
        this.procedure = procedure;
        this.paramName = paramName;
        this.dataType = dataType;
        this.argumentMode = argumentMode;
        this.ordinalPosition = ordinalPosition;
    }

    @NotNull
    public PostgreDataSource getDataSource() {
        return (PostgreDataSource)this.procedure.getDataSource();
    }

    @Nullable
    public String getDescription() {
        return null;
    }

    public PostgreProcedure getParentObject() {
        return this.procedure;
    }

    public boolean isPersisted() {
        return true;
    }

    @Property(viewable=true, order=1)
    @NotNull
    public String getName() {
        return this.paramName;
    }

    @Property(viewable=true, order=2)
    @NotNull
    public PostgreDataType getParameterType() {
        return this.dataType;
    }

    @Property(viewable=true, order=3)
    @NotNull
    public DBSProcedureParameterKind getParameterKind() {
        return this.argumentMode.getParameterKind();
    }

    @Property(viewable=true, order=4)
    public int getOrdinalPosition() {
        return this.ordinalPosition;
    }

    public boolean isRequired() {
        return false;
    }

    public boolean isAutoGenerated() {
        return false;
    }

    public String getTypeName() {
        return this.dataType.getTypeName();
    }

    public String getFullTypeName() {
        return this.dataType.getFullTypeName();
    }

    public int getTypeID() {
        return this.dataType.getTypeID();
    }

    public DBPDataKind getDataKind() {
        return this.dataType.getDataKind();
    }

    public Integer getScale() {
        return this.dataType.getScale();
    }

    public Integer getPrecision() {
        return this.dataType.getPrecision();
    }

    public long getMaxLength() {
        return this.dataType.getMaxLength();
    }

    public long getTypeModifiers() {
        return 0L;
    }

    @NotNull
    public PostgreProcedure.ArgumentMode getArgumentMode() {
        return this.argumentMode;
    }

    @Property(viewable=true, order=5)
    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }
}

