/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.qm.db.impl;

import com.dbeaver.ee.qm.db.impl.DataSourceInfo;
import com.dbeaver.ee.qm.db.impl.QMDBEventCursor;
import com.dbeaver.ee.qm.db.impl.QMDBModel;
import com.dbeaver.ee.qm.db.model.QMDBUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.WeakHashMap;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.auth.SMSessionPersistent;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.qm.QMDisposable;
import org.jkiss.dbeaver.model.qm.QMEventAction;
import org.jkiss.dbeaver.model.qm.QMEventCursor;
import org.jkiss.dbeaver.model.qm.QMEventFilter;
import org.jkiss.dbeaver.model.qm.QMMetaEvent;
import org.jkiss.dbeaver.model.qm.QMService;
import org.jkiss.dbeaver.model.qm.QMSessionInfo;
import org.jkiss.dbeaver.model.qm.filters.QMEventCriteria;
import org.jkiss.dbeaver.model.qm.meta.QMMConnectionInfo;
import org.jkiss.dbeaver.model.qm.meta.QMMObject;
import org.jkiss.dbeaver.model.qm.meta.QMMStatementExecuteInfo;
import org.jkiss.dbeaver.model.qm.meta.QMMStatementInfo;
import org.jkiss.dbeaver.model.qm.meta.QMMTransactionInfo;
import org.jkiss.dbeaver.model.qm.meta.QMMTransactionSavepointInfo;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.LongKeyMap;

public class QMEmbeddedService
implements QMService,
QMDisposable {
    private static final Log log = Log.getLog(QMEmbeddedService.class);
    private final Map<String, Long> connectionMap = new HashMap<String, Long>();
    private final Map<String, DataSourceInfo> dataSourceCache = new HashMap<String, DataSourceInfo>();
    private final LongKeyMap<QMMConnectionInfo> connectionCache = new LongKeyMap();
    private final Map<String, Long> qmSessionIdCache = new WeakHashMap<String, Long>();
    private final Map<String, Long> projectIdsCache = new HashMap<String, Long>();
    private volatile QMDBModel qModel;
    private PreparedStatement dbStatQueryRead;
    private PreparedStatement dbStatQueryWrite;
    private PreparedStatement dbStatEvent;
    private PreparedStatement dbStatStatement;

    private synchronized QMDBModel getModel() {
        if (this.qModel == null) {
            QMDBModel model = QMDBModel.getInstance();
            try {
                this.initModel(model);
            }
            catch (Exception e) {
                log.error((Object)"Error initializing QM listener. Stopping QMDB service", (Throwable)e);
                model.stopDatabase();
            }
            this.qModel = model;
        }
        return this.qModel;
    }

    private void initModel(QMDBModel model) throws SQLException {
        Connection connection = model.getConnection();
        if (connection == null) {
            return;
        }
        this.dbStatQueryRead = connection.prepareStatement("SELECT QUERY_ID,QUERY_TEXT FROM " + model.getTableName("QM_QUERY") + " WHERE QUERY_HASH=?");
        this.dbStatQueryWrite = connection.prepareStatement("INSERT INTO " + model.getTableName("QM_QUERY") + "(QUERY_HASH,QUERY_TEXT) VALUES(?,?)", 1);
        this.dbStatEvent = connection.prepareStatement("INSERT INTO " + model.getTableName("QM_EVENT") + " (CONNECTION_ID,SOURCE_ID,EVENT_ACTION,EVENT_TYPE,EVENT_TIME) VALUES(?,?,?,?,?)", 1);
        this.dbStatStatement = connection.prepareStatement("INSERT INTO " + model.getTableName("QM_STATEMENT") + " (STATEMENT_ID,STATEMENT_PURPOSE,QUERY_ID,ROW_COUNT,ERROR_CODE,ERROR_MESSAGE,EXECUTE_TIME,FETCH_TIME) VALUES(?,?,?,?,?,?,?,?)");
    }

    public QMEventCursor getQueryHistoryCursor(@NotNull DBRProgressMonitor monitor, @NotNull QMEventCriteria criteria, QMEventFilter filter) throws DBException {
        try {
            return new QMDBEventCursor(this, criteria, filter);
        }
        catch (SQLException e) {
            throw new DBException("Error getting filter history", (Throwable)e);
        }
    }

    public void saveEvent(QMMetaEvent event, DBRProgressMonitor monitor) throws DBException, SQLException {
        QMMObject object = event.getObject();
        Long sessionId = this.getSessionId(event.getQmAppSessionPersistent());
        if (sessionId == null) {
            log.warn((Object)"QM session not found");
            return;
        }
        if (object instanceof QMMConnectionInfo) {
            this.saveConnectionInfo(monitor, sessionId, (QMMConnectionInfo)object, event.getAction());
        } else if (object instanceof QMMTransactionInfo) {
            this.saveTransactionInfo(monitor, sessionId, (QMMTransactionInfo)object, event.getAction());
        } else if (object instanceof QMMStatementExecuteInfo) {
            this.saveStatementExecutionInfo(monitor, sessionId, (QMMStatementExecuteInfo)object, event.getAction());
        }
    }

    private void saveTransactionInfo(DBRProgressMonitor monitor, Long sessionId, QMMTransactionInfo transactionInfo, QMEventAction action) throws DBException, SQLException {
        this.createEventInfo(monitor, sessionId, (QMMObject)transactionInfo, action, transactionInfo.getConnection());
    }

    private void saveConnectionInfo(DBRProgressMonitor monitor, Long sessionId, QMMConnectionInfo connectionInfo, QMEventAction action) throws SQLException, DBException {
        if (action != QMEventAction.BEGIN && action != QMEventAction.END) {
            return;
        }
        if (action == QMEventAction.BEGIN) {
            this.saveOpenConnectionInfo(monitor, sessionId, connectionInfo);
        }
        this.createEventInfo(monitor, sessionId, (QMMObject)connectionInfo, action, connectionInfo);
        if (action == QMEventAction.END) {
            this.closeConnectionInfo(sessionId, connectionInfo);
        }
    }

    private void saveStatementExecutionInfo(DBRProgressMonitor monitor, Long sessionId, QMMStatementExecuteInfo executeInfo, QMEventAction action) throws DBException, SQLException {
        long eventId = this.createEventInfo(monitor, sessionId, (QMMObject)executeInfo, action, executeInfo.getStatement().getConnection());
        long queryId = this.getQueryId(executeInfo.getQueryString());
        if (action != QMEventAction.END) {
            return;
        }
        this.dbStatStatement.setLong(1, eventId);
        this.dbStatStatement.setInt(2, executeInfo.getStatement().getPurpose().getId());
        this.dbStatStatement.setLong(3, queryId);
        long rowCount = executeInfo.getUpdateRowCount();
        if (rowCount < 0L) {
            rowCount = executeInfo.getFetchRowCount();
        }
        this.dbStatStatement.setLong(4, rowCount);
        this.dbStatStatement.setInt(5, executeInfo.getErrorCode());
        if (CommonUtils.isEmpty((String)executeInfo.getErrorMessage())) {
            this.dbStatStatement.setNull(6, 12);
        } else {
            this.dbStatStatement.setString(6, executeInfo.getErrorMessage());
        }
        this.dbStatStatement.setInt(7, (int)(executeInfo.getCloseTime() - executeInfo.getOpenTime()));
        long fetchEndTime = executeInfo.getFetchEndTime();
        this.dbStatStatement.setInt(8, (int)(fetchEndTime > 0L ? fetchEndTime - executeInfo.getFetchBeginTime() : 0L));
        this.dbStatStatement.execute();
    }

    /*
     * Loose catch block
     */
    @NotNull
    public Collection<String> getQueryFilterHistory(@NotNull String query) throws DBException {
        try {
            QMDBModel model = this.getModel();
            long queryId = this.getQueryId(query);
            Throwable throwable = null;
            Object var6_7 = null;
            try (PreparedStatement dbStat = model.getConnection().prepareStatement("SELECT FILTER_TEXT FROM " + model.getTableName("QM_QUERY_FILTER") + " WHERE QUERY_ID=?");){
                ArrayList<String> arrayList;
                ResultSet dbResult;
                Throwable throwable2;
                block22: {
                    dbStat.setLong(1, queryId);
                    throwable2 = null;
                    Object var9_12 = null;
                    dbResult = dbStat.executeQuery();
                    ArrayList<String> history = new ArrayList<String>();
                    while (dbResult.next()) {
                        history.add(dbResult.getString(1));
                    }
                    arrayList = history;
                    if (dbResult == null) break block22;
                    dbResult.close();
                }
                return arrayList;
                {
                    catch (Throwable throwable3) {
                        try {
                            if (dbResult != null) {
                                dbResult.close();
                            }
                            throw throwable3;
                        }
                        catch (Throwable throwable4) {
                            if (throwable2 == null) {
                                throwable2 = throwable4;
                            } else if (throwable2 != throwable4) {
                                throwable2.addSuppressed(throwable4);
                            }
                            throw throwable2;
                        }
                    }
                }
            }
            catch (Throwable throwable5) {
                if (throwable == null) {
                    throwable = throwable5;
                } else if (throwable != throwable5) {
                    throwable.addSuppressed(throwable5);
                }
                throw throwable;
            }
        }
        catch (SQLException e) {
            throw new DBException("Error getting filter history", (Throwable)e);
        }
    }

    public void saveQueryFilterValue(@NotNull String query, @NotNull String filterValue) throws DBException {
        try {
            QMDBModel model = this.getModel();
            long queryId = this.getQueryId(query);
            long filterHash = QMDBUtils.getHashCode(filterValue);
            Throwable throwable = null;
            Object var9_9 = null;
            try (PreparedStatement dbStat = model.getConnection().prepareStatement("MERGE INTO " + model.getTableName("QM_QUERY_FILTER") + " (QUERY_ID,FILTER_HASH,FILTER_TEXT) " + "KEY (QUERY_ID,FILTER_HASH) VALUES(?,?,?)");){
                dbStat.setLong(1, queryId);
                dbStat.setLong(2, filterHash);
                dbStat.setString(3, filterValue);
                dbStat.execute();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (SQLException e) {
            throw new DBException("Error saving filter history", (Throwable)e);
        }
    }

    public void deleteQueryFilterValue(@NotNull String query, String filterValue) throws DBException {
        try {
            QMDBModel model = this.getModel();
            long queryId = this.getQueryId(query);
            long filterHash = QMDBUtils.getHashCode(filterValue);
            Throwable throwable = null;
            Object var9_9 = null;
            try (PreparedStatement dbStat = model.getConnection().prepareStatement("DELETE FROM " + model.getTableName("QM_QUERY_FILTER") + " WHERE QUERY_ID=? AND FILTER_HASH=?");){
                dbStat.setLong(1, queryId);
                dbStat.setLong(2, filterHash);
                dbStat.execute();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (SQLException e) {
            throw new DBException("Error deleting filter history", (Throwable)e);
        }
    }

    private long createEventInfo(DBRProgressMonitor monitor, Long sessionId, QMMObject object, QMEventAction action, QMMConnectionInfo connectionInfo) throws SQLException, DBException {
        Long connectionId = this.connectionMap.get(QMEmbeddedService.makeConnectionKey(sessionId, connectionInfo));
        if (connectionId == null) {
            log.debug((Object)("Can't find QMDB connection info " + connectionInfo.getContainerId() + " for event " + action + ". Create new one"));
            connectionId = this.saveOpenConnectionInfo(monitor, sessionId, connectionInfo);
        }
        this.dbStatEvent.setLong(1, connectionId);
        this.dbStatEvent.setNull(2, 12);
        this.dbStatEvent.setInt(3, action.getId());
        this.dbStatEvent.setInt(4, this.getEventTypeId(object));
        this.dbStatEvent.setTimestamp(5, new Timestamp(object.getOpenTime()));
        this.dbStatEvent.execute();
        return JDBCUtils.getGeneratedKey((PreparedStatement)this.dbStatEvent);
    }

    private int getEventTypeId(QMMObject object) {
        Class<?> eventClass = object.getClass();
        if (eventClass == QMMConnectionInfo.class) {
            return 1;
        }
        if (eventClass == QMMTransactionInfo.class) {
            return 2;
        }
        if (eventClass == QMMTransactionSavepointInfo.class) {
            return 3;
        }
        if (eventClass == QMMStatementInfo.class) {
            return 4;
        }
        if (eventClass == QMMStatementExecuteInfo.class) {
            return 5;
        }
        return -1;
    }

    private long saveOpenConnectionInfo(DBRProgressMonitor monitor, Long sessionId, QMMConnectionInfo connectionInfo) throws SQLException, DBException {
        QMDBModel model = this.getModel();
        Long connectionId = this.connectionMap.get(QMEmbeddedService.makeConnectionKey(sessionId, connectionInfo));
        if (connectionId != null) {
            log.debug((Object)"Connection info already exists. Mixed events?");
            return connectionId;
        }
        Long runId = model.getRunId();
        String connectionURL = connectionInfo.getConnectionConfiguration() == null ? "?" : connectionInfo.getConnectionConfiguration().getUrl();
        String dsName = (String)JDBCUtils.executeQuery((Connection)model.getConnection(), (String)("SELECT NAME FROM " + model.getTableName("QM_DATASOURCE") + " WHERE DATASOURCE_ID=?"), (Object[])new Object[]{connectionInfo.getContainerId()});
        Long workspaceId = model.getWorkspaceId();
        Long projectId = this.getProjectId(connectionInfo.getProject());
        if (dsName == null) {
            JDBCUtils.executeSQL((Connection)model.getConnection(), (String)("INSERT INTO " + model.getTableName("QM_DATASOURCE") + " (WORKSPACE_ID,DATASOURCE_ID,NAME,URL,DRIVER,UPDATE_TIME) VALUES(?,?,?,?,?,CURRENT_TIMESTAMP)"), (Object[])new Object[]{workspaceId, connectionInfo.getContainerId(), connectionInfo.getContainerName(), CommonUtils.notEmpty((String)connectionURL), connectionInfo.getDriverId()});
        } else {
            JDBCUtils.executeSQL((Connection)model.getConnection(), (String)("UPDATE " + model.getTableName("QM_DATASOURCE") + " SET NAME=?,URL=?,DRIVER=?,UPDATE_TIME=CURRENT_TIMESTAMP WHERE WORKSPACE_ID=? AND DATASOURCE_ID=?"), (Object[])new Object[]{connectionInfo.getContainerName(), CommonUtils.notEmpty((String)connectionURL), connectionInfo.getDriverId(), workspaceId, connectionInfo.getContainerId()});
        }
        connectionId = JDBCUtils.executeInsertAutoIncrement((Connection)model.getConnection(), (String)("INSERT INTO " + model.getTableName("QM_CONNECTION") + " (RUN_ID,WORKSPACE_ID,PROJECT_ID,DATASOURCE_ID,SESSION_ID,INSTANCE_ID,CONTEXT_NAME,CONNECTION_USER,CONNECT_TIME) VALUES(?,?,?,?,?,?,?,?,CURRENT_TIMESTAMP)"), (Object[])new Object[]{runId, workspaceId, projectId, connectionInfo.getContainerId(), sessionId, CommonUtils.truncateString((String)CommonUtils.notEmpty((String)connectionInfo.getInstanceId()), (int)64), CommonUtils.notEmpty((String)connectionInfo.getContextName()), CommonUtils.notEmpty((String)connectionInfo.getConnectionConfiguration().getUserName())});
        this.connectionMap.put(QMEmbeddedService.makeConnectionKey(sessionId, connectionInfo), connectionId);
        return connectionId;
    }

    private void closeConnectionInfo(Long sessionId, QMMConnectionInfo sessionInfo) throws SQLException {
        QMDBModel model = this.getModel();
        Long connectionId = this.connectionMap.get(QMEmbeddedService.makeConnectionKey(sessionId, sessionInfo));
        if (connectionId == null) {
            log.debug((Object)("Can't find QMDB connection info " + sessionInfo.getContainerId() + " for close"));
            return;
        }
        JDBCUtils.executeSQL((Connection)model.getConnection(), (String)("UPDATE " + model.getTableName("QM_CONNECTION") + " SET DISCONNECT_TIME=? WHERE CONNECTION_ID=?"), (Object[])new Object[]{new Date(), connectionId});
        this.connectionMap.remove(QMEmbeddedService.makeConnectionKey(sessionId, sessionInfo));
    }

    private long createUserSession(@NotNull Long runId, @Nullable Long userId, @NotNull String appSessionId) throws SQLException {
        QMDBModel model = this.getModel();
        return JDBCUtils.executeInsertAutoIncrement((Connection)model.getConnection(), (String)("INSERT INTO " + model.getTableName("QM_USER_SESSION") + " (RUN_ID,APP_SESSION_ID,USER_ID,START_TIME) VALUES(?,?,?,CURRENT_TIMESTAMP)"), (Object[])new Object[]{runId, appSessionId, userId});
    }

    private Long getSessionId(@NotNull SMSessionPersistent qmAppSessionPersistent) throws DBException {
        String qmAppSessionId = (String)qmAppSessionPersistent.getAttribute("qm_session_id");
        if (CommonUtils.isEmpty((String)qmAppSessionId)) {
            return null;
        }
        Long qmSessionId = null;
        try {
            qmSessionId = this.findUserSession(qmAppSessionId);
        }
        catch (SQLException e) {
            log.error((Object)"Error during find qm session", (Throwable)e);
        }
        if (qmSessionId == null) {
            throw new DBException("Session not found in qm: " + qmAppSessionId);
        }
        return qmSessionId;
    }

    @Nullable
    private Long findUserSession(@NotNull String appSessionId) throws SQLException {
        QMDBModel model = this.getModel();
        if (this.qmSessionIdCache.containsKey(appSessionId)) {
            return this.qmSessionIdCache.get(appSessionId);
        }
        Long runId = model.getRunId();
        Long sessionId = (Long)JDBCUtils.executeQuery((Connection)model.getConnection(), (String)("SELECT SESSION_ID FROM " + model.getTableName("QM_USER_SESSION") + " WHERE RUN_ID=? AND APP_SESSION_ID=?"), (Object[])new Object[]{runId, appSessionId});
        if (sessionId != null) {
            this.qmSessionIdCache.put(appSessionId, sessionId);
        }
        return sessionId;
    }

    public void dispose() {
        try {
            if (this.dbStatQueryWrite != null) {
                this.dbStatQueryWrite.close();
            }
            if (this.dbStatQueryRead != null) {
                this.dbStatQueryRead.close();
            }
            if (this.dbStatEvent != null) {
                this.dbStatEvent.close();
            }
            if (this.dbStatStatement != null) {
                this.dbStatStatement.close();
            }
        }
        catch (SQLException e) {
            log.debug((Object)e);
        }
    }

    private long getQueryId(String query) throws SQLException {
        long hashCode = QMDBUtils.getHashCode(query);
        this.dbStatQueryRead.setLong(1, hashCode);
        Throwable throwable = null;
        Object var5_5 = null;
        try (ResultSet dbResult = this.dbStatQueryRead.executeQuery();){
            while (dbResult.next()) {
                String storedText = dbResult.getString(2);
                if (!storedText.equals(query)) continue;
                return dbResult.getLong(1);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        this.dbStatQueryWrite.setLong(1, hashCode);
        this.dbStatQueryWrite.setString(2, query);
        this.dbStatQueryWrite.execute();
        return JDBCUtils.getGeneratedKey((PreparedStatement)this.dbStatQueryWrite);
    }

    public String openSession(@NotNull QMSessionInfo sessionInfo, @NotNull DBRProgressMonitor monitor) throws DBException {
        try {
            QMDBModel model = this.getModel();
            long userId = model.findOrCreateUser(sessionInfo.getUserName(), sessionInfo.getUserDomain());
            UUID qmSessionUuid = UUID.randomUUID();
            String qmSessionId = qmSessionUuid.toString();
            long sessionId = this.createUserSession(model.getRunId(), userId, qmSessionId);
            this.qmSessionIdCache.put(qmSessionId, sessionId);
            return qmSessionId;
        }
        catch (SQLException e) {
            throw new DBException("Error during open new qm session", (Throwable)e);
        }
    }

    public void closeSession(String appSessionId, DBRProgressMonitor monitor) {
        this.qmSessionIdCache.remove(appSessionId);
    }

    @NotNull
    private static String makeConnectionKey(Long sessionId, QMMConnectionInfo connectionInfo) {
        return String.valueOf(connectionInfo.getContainerId()) + ": " + connectionInfo.getInstanceId() + ":" + connectionInfo.getContextName() + ":" + sessionId + ":" + connectionInfo.getProject().getProjectID();
    }

    public QMMConnectionInfo getSessionInfo(long connectionId, String containerId, String instanceId, String contextName, long eventStart) throws DBException {
        QMMConnectionInfo sessionInfo = (QMMConnectionInfo)this.connectionCache.get(connectionId);
        if (sessionInfo == null) {
            DataSourceInfo dataSourceInfo = this.getDataSourceInfo(containerId);
            DBPConnectionConfiguration config = new DBPConnectionConfiguration();
            config.setUrl(dataSourceInfo.getUrl());
            sessionInfo = new QMMConnectionInfo(eventStart, eventStart, containerId, dataSourceInfo.getName(), dataSourceInfo.getDriverID(), config, instanceId, contextName, false);
            this.connectionCache.put(connectionId, (Object)sessionInfo);
        }
        return sessionInfo;
    }

    private synchronized DataSourceInfo getDataSourceInfo(String containerId) throws DBException {
        DataSourceInfo dataSourceInfo = this.dataSourceCache.get(containerId);
        if (dataSourceInfo == null) {
            try {
                Throwable throwable = null;
                Object var4_6 = null;
                try (PreparedStatement stmt = this.getModel().getConnection().prepareStatement("SELECT * FROM QM_DATASOURCE WHERE DATASOURCE_ID=?");){
                    stmt.setString(1, containerId);
                    Throwable throwable2 = null;
                    Object var7_11 = null;
                    try (ResultSet dbResult = stmt.executeQuery();){
                        if (dbResult.next()) {
                            String name = dbResult.getString("NAME");
                            String url = dbResult.getString("URL");
                            String driverID = dbResult.getString("DRIVER");
                            dataSourceInfo = new DataSourceInfo(containerId, driverID, name, url);
                        } else {
                            dataSourceInfo = new DataSourceInfo(containerId);
                        }
                    }
                    catch (Throwable throwable3) {
                        if (throwable2 == null) {
                            throwable2 = throwable3;
                        } else if (throwable2 != throwable3) {
                            throwable2.addSuppressed(throwable3);
                        }
                        throw throwable2;
                    }
                }
                catch (Throwable throwable4) {
                    if (throwable == null) {
                        throwable = throwable4;
                    } else if (throwable != throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                    throw throwable;
                }
            }
            catch (SQLException e) {
                throw new DBException("Error reading datasource info", (Throwable)e);
            }
            this.dataSourceCache.put(containerId, dataSourceInfo);
        }
        return dataSourceInfo;
    }

    private synchronized Long getProjectId(DBPProject project) throws SQLException, DBException {
        if (this.projectIdsCache.containsKey(project.getName())) {
            return this.projectIdsCache.get(project.getName());
        }
        Long projectId = this.getModel().findOrCreateQMDBeaverProject(project);
        this.projectIdsCache.put(project.getName(), projectId);
        return projectId;
    }
}

