/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.qm.db.impl;

import com.dbeaver.ee.qm.db.impl.QMDBModel;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.stream.Collectors;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.utils.BeanUtils;

public class EmbeddedDatabase {
    private static final Log log = Log.getLog(EmbeddedDatabase.class);
    private final String databaseId;
    private final Path databasePath;
    private Connection h2Connection;
    private boolean oldFormat = false;

    public EmbeddedDatabase(String databaseId, Path databasePath, Connection connection) {
        this.databaseId = databaseId;
        this.databasePath = databasePath;
        this.h2Connection = connection;
    }

    public Path getDatabasePath() {
        return this.databasePath;
    }

    public boolean isOldFormat() {
        return this.oldFormat;
    }

    public void setOldFormat(boolean oldFormat) {
        this.oldFormat = oldFormat;
    }

    public void backupDatabase(Path toFile) throws DBException {
        if (this.h2Connection == null) {
            throw new DBException("H2 server not started");
        }
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (Statement dbStat = this.h2Connection.createStatement();){
                dbStat.execute("BACKUP TO '" + toFile.toAbsolutePath() + "'");
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (SQLException e) {
            throw new DBException("Error running backup", (Throwable)e);
        }
    }

    public void restoreDatabase(Path backupFile) throws DBException {
        try {
            BeanUtils.invokeStaticMethod(this.h2Connection.getClass().getClassLoader().loadClass("org.h2.tools.Restore"), (String)"execute", (Class[])new Class[]{String.class, String.class, String.class}, (Object[])new Object[]{backupFile.toAbsolutePath().toString(), this.databasePath.toAbsolutePath().toString(), this.databaseId});
        }
        catch (Throwable e) {
            throw new DBException("Error calling H2 restore", e);
        }
    }

    public Path dumpDatabaseToSQL() throws DBException {
        try {
            BeanUtils.invokeStaticMethod(this.h2Connection.getClass().getClassLoader().loadClass("org.h2.tools.Recover"), (String)"execute", (Class[])new Class[]{String.class, String.class}, (Object[])new Object[]{this.databasePath.toAbsolutePath().toString(), this.databaseId});
            Path sqlFile = this.databasePath.resolve(String.valueOf(this.databaseId) + ".h2.sql");
            if (!Files.exists(sqlFile, new LinkOption[0])) {
                throw new DBException("Error dumping database - target file '" + sqlFile.toAbsolutePath() + "' doesn't exists");
            }
            return sqlFile;
        }
        catch (Throwable e) {
            throw new DBException("Error running recover", e);
        }
    }

    public void restoreFromSQL(Path backupFile) throws DBException {
        try {
            String url = this.h2Connection.getMetaData().getURL();
            BeanUtils.invokeStaticMethod(this.h2Connection.getClass().getClassLoader().loadClass("org.h2.tools.RunScript"), (String)"execute", (Class[])new Class[]{String.class, String.class, String.class, String.class, Charset.class, Boolean.TYPE}, (Object[])new Object[]{url, "", "", backupFile.toAbsolutePath().toString(), Charset.defaultCharset(), true});
        }
        catch (Throwable e) {
            throw new DBException("Error restoring SQL dump", e);
        }
    }

    public void deleteDatabaseFiles() {
        try {
            List files = Files.list(this.databasePath).collect(Collectors.toList());
            for (Path file : files) {
                if (!file.getFileName().toString().endsWith(".db")) continue;
                log.debug((Object)("Delete DB file " + file.getFileName()));
                try {
                    Files.delete(file);
                }
                catch (IOException e) {
                    log.debug((Object)"Delete failed", (Throwable)e);
                }
            }
        }
        catch (IOException e) {
            log.debug((Object)"Error deleting database files", (Throwable)e);
        }
    }

    public boolean isRunning() {
        return QMDBModel.getInstance().getEmbeddedDatabase() != null;
    }

    public void stop() {
        QMDBModel.getInstance().stopDatabase();
    }

    public void start() {
        this.h2Connection = QMDBModel.getInstance().restartDatabase();
    }
}

