/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.snowflake.ui.config;

import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.ext.snowflake.ui.config.SnowflakeAuthSnowflakeConfigurator;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.access.DBAAuthModel;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.TextWithOpenFile;
import org.jkiss.utils.CommonUtils;

public class SnowflakeAuthPrivateKeyConfigurator
extends SnowflakeAuthSnowflakeConfigurator {
    private TextWithOpenFile pkPath;

    public void createControl(@NotNull Composite parent, DBAAuthModel<?> object, @NotNull Runnable propertyChangeListener) {
        super.createControl(parent, object, propertyChangeListener);
    }

    protected boolean needsAuthTypeSelector() {
        return false;
    }

    public void loadSettings(@NotNull DBPDataSourceContainer dataSource) {
        super.loadSettings(dataSource);
        this.pkPath.setText(CommonUtils.notEmpty((String)dataSource.getConnectionConfiguration().getAuthProperty("private-key")));
    }

    public void saveSettings(@NotNull DBPDataSourceContainer dataSource) {
        super.saveSettings(dataSource);
        dataSource.getConnectionConfiguration().setAuthProperty("private-key", this.pkPath.getText());
        dataSource.getConnectionConfiguration().setAuthProperty("private-ley-password", this.passwordText.getText());
    }

    protected boolean supportsPassword() {
        return true;
    }

    protected boolean isPasswordApplicable() {
        return super.isPasswordApplicable();
    }

    protected void createPasswordControls(Composite parent, Runnable propertyChangeListener) {
        Label pkLabel = UIUtils.createLabel((Composite)parent, (String)"Private key");
        pkLabel.setLayoutData((Object)new GridData(32));
        this.pkPath = new TextWithOpenFile(parent, "Private key path", new String[]{"*"});
        this.pkPath.setLayoutData((Object)new GridData(768));
        super.createPasswordControls(parent, propertyChangeListener);
    }

    protected String getPasswordFieldLabel() {
        return "Key password";
    }

    public boolean isComplete() {
        return super.isComplete() && !CommonUtils.isEmpty((String)this.pkPath.getText());
    }
}

