/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.net.ssh;

import com.jcraft.jsch.Buffer;
import com.jcraft.jsch.Identity;
import com.jcraft.jsch.IdentityRepository;
import com.jcraft.jsch.JSchException;
import java.util.List;
import java.util.Vector;
import org.jkiss.dbeaver.model.net.ssh.SSHAgentIdentity;
import org.jkiss.dbeaver.model.net.ssh.SSHImplementationAbstract;

public class DBeaverIdentityRepository
implements IdentityRepository {
    private final SSHImplementationAbstract impl;
    private final List<SSHAgentIdentity> identities;

    public DBeaverIdentityRepository(SSHImplementationAbstract impl, List<SSHAgentIdentity> identities) {
        this.impl = impl;
        this.identities = identities;
    }

    public Vector<?> getIdentities() {
        Vector<AgentIdentity> result = new Vector<AgentIdentity>();
        for (SSHAgentIdentity identity : this.identities) {
            byte[] blob = identity.getBlob();
            byte[] comment = identity.getComment();
            AgentIdentity id = new AgentIdentity(blob, comment);
            result.addElement(id);
        }
        return result;
    }

    public boolean add(byte[] identity) {
        return false;
    }

    public boolean remove(byte[] blob) {
        return false;
    }

    public void removeAll() {
    }

    public String getName() {
        return "DBeaver Identity Repository for jsch";
    }

    public int getStatus() {
        return 2;
    }

    private class AgentIdentity
    implements Identity {
        private final byte[] blob;
        private final byte[] comment;
        String algname;

        public AgentIdentity(byte[] blob, byte[] comment) {
            this.blob = blob;
            this.comment = comment;
            this.algname = new String(new Buffer(blob).getString());
        }

        public boolean setPassphrase(byte[] passphrase) throws JSchException {
            return true;
        }

        public byte[] getPublicKeyBlob() {
            return this.blob;
        }

        public byte[] getSignature(byte[] data) {
            return DBeaverIdentityRepository.this.impl.agentSign(this.blob, data);
        }

        public boolean decrypt() {
            return true;
        }

        public String getAlgName() {
            return this.algname;
        }

        public String getName() {
            return new String(this.comment);
        }

        public boolean isEncrypted() {
            return false;
        }

        public void clear() {
        }
    }
}

