/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.redis.exec;

import com.dbeaver.db.redis.RedisUtils;
import com.dbeaver.db.redis.exec.RedisBaseResultSet;
import com.dbeaver.db.redis.exec.RedisBaseStatement;
import com.dbeaver.db.redis.exec.RedisSession;
import com.dbeaver.db.redis.model.RedisKey;
import com.dbeaver.db.redis.model.RedisKeyType;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBValueFormatting;
import org.jkiss.dbeaver.model.data.DBDDisplayFormat;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCStatement;
import org.jkiss.dbeaver.model.qm.QMUtils;
import org.jkiss.utils.CommonUtils;
import redis.clients.jedis.commands.JedisClusterCommands;
import redis.clients.jedis.commands.JedisCommands;

public class RedisKeySetStatement
extends RedisBaseStatement {
    private static final Log log = Log.getLog(RedisKeySetStatement.class);
    @NotNull
    private final RedisKeyType keyType;
    @NotNull
    private final RedisKey key;
    private String name;
    private Object value;
    private Object oldValue;

    public RedisKeySetStatement(@NotNull RedisSession session, @NotNull RedisKey key, @NotNull RedisKeyType keyType, @Nullable String name, @Nullable Object value) {
        super(session, RedisKeySetStatement.makeQuery(key, keyType, name, value));
        this.key = key;
        this.keyType = keyType;
        this.name = name;
        this.value = value;
    }

    public RedisKeyType getKeyType() {
        return this.keyType;
    }

    private static String makeQuery(@NotNull RedisKey key, @NotNull RedisKeyType keyType, @Nullable String name, @Nullable Object value) {
        String setCommand;
        if (value == null) {
            String delCommand;
            switch (keyType) {
                case hash: {
                    delCommand = "HDEL";
                    break;
                }
                case set: {
                    delCommand = "SREM";
                    break;
                }
                case zset: {
                    delCommand = "ZREM";
                    break;
                }
                case list: {
                    delCommand = "LREM";
                    break;
                }
                default: {
                    delCommand = "DEL";
                }
            }
            return String.valueOf(delCommand) + " " + key.getFullyQualifiedName(DBPEvaluationContext.DDL) + (keyType == RedisKeyType.string ? "" : " " + name);
        }
        switch (keyType) {
            case hash: {
                setCommand = "HSET";
                break;
            }
            case list: {
                setCommand = "LSET";
                break;
            }
            case set: {
                setCommand = "SADD";
                break;
            }
            case zset: {
                setCommand = "ZADD";
                break;
            }
            default: {
                setCommand = "SET";
            }
        }
        return String.valueOf(setCommand) + " " + key.getFullyQualifiedName(DBPEvaluationContext.DDL) + (keyType == RedisKeyType.string ? "" : " " + name) + " " + DBValueFormatting.getDefaultValueDisplayString((Object)value, (DBDDisplayFormat)DBDDisplayFormat.UI);
    }

    public void setName(String name) {
        this.name = name;
        this.setQuery(RedisKeySetStatement.makeQuery(this.key, this.keyType, name, this.value));
    }

    public void setValue(Object value) {
        this.value = value;
        this.setQuery(RedisKeySetStatement.makeQuery(this.key, this.keyType, this.name, value));
    }

    public void setOldValue(Object value) {
        this.oldValue = value;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean executeStatement() throws DBCException {
        if (this.session.isLoggingEnabled()) {
            QMUtils.getDefaultHandler().handleStatementExecuteBegin((DBCStatement)this);
        }
        RedisUtils.selectCurDatabase(this.session, this.key.getDatabase());
        String keyName = this.key.getFullyQualifiedName(DBPEvaluationContext.DML);
        try {
            String strValue = CommonUtils.toString((Object)this.value);
            if (this.getSession().supportsCommands(JedisCommands.class)) {
                JedisCommands jedis = this.getSession().getCommands(JedisCommands.class);
                switch (this.keyType) {
                    case string: {
                        if (this.value == null) {
                            jedis.del(keyName);
                            return false;
                        } else {
                            jedis.set(keyName, strValue);
                        }
                        return false;
                    }
                    case hash: {
                        if (this.value == null) {
                            jedis.hdel(keyName, new String[]{this.name});
                            return false;
                        } else {
                            jedis.hset(keyName, this.name, strValue);
                        }
                        return false;
                    }
                    case set: {
                        if (this.value == null) {
                            jedis.srem(keyName, new String[]{this.name});
                            return false;
                        } else {
                            jedis.sadd(keyName, new String[]{strValue});
                        }
                        return false;
                    }
                    case zset: {
                        if (this.oldValue != null) {
                            jedis.zrem(keyName, new String[]{CommonUtils.toString((Object)this.oldValue)});
                        } else {
                            jedis.zrem(keyName, new String[]{this.value == null ? this.name : strValue});
                        }
                        if (this.value == null) return false;
                        jedis.zadd(keyName, CommonUtils.toDouble((Object)this.name), strValue);
                        return false;
                    }
                    case list: {
                        if (this.value == null) {
                            jedis.lrem(keyName, 1L, strValue);
                            return false;
                        } else {
                            jedis.lset(keyName, (long)CommonUtils.toInt((Object)this.name), strValue);
                        }
                        return false;
                    }
                    default: {
                        throw new DBCException("Unsupported key type: " + (Object)((Object)this.keyType));
                    }
                }
            }
            JedisClusterCommands jedis = this.getSession().getCommands(JedisClusterCommands.class);
            switch (this.keyType) {
                case string: {
                    if (this.value == null) {
                        jedis.del(keyName);
                        return false;
                    }
                    jedis.set(keyName, strValue);
                    return false;
                }
                case hash: {
                    if (this.value == null) {
                        jedis.hdel(keyName, new String[]{this.name});
                        return false;
                    }
                    jedis.hset(keyName, this.name, strValue);
                    return false;
                }
                case set: {
                    if (this.value == null) {
                        jedis.srem(keyName, new String[]{this.name});
                        return false;
                    }
                    jedis.sadd(keyName, new String[]{strValue});
                    return false;
                }
                case zset: {
                    if (this.value == null) {
                        jedis.zrem(keyName, new String[]{this.name});
                        return false;
                    }
                    jedis.zadd(keyName, CommonUtils.toDouble((Object)this.name), strValue);
                    return false;
                }
                case list: {
                    if (this.value == null) {
                        jedis.lrem(keyName, 1L, strValue);
                        return false;
                    }
                    jedis.lset(keyName, (long)CommonUtils.toInt((Object)this.name), strValue);
                    return false;
                }
                default: {
                    throw new DBCException("Unsupported key type: " + (Object)((Object)this.keyType));
                }
            }
        }
        catch (Throwable e) {
            throw this.handleExecuteError(e);
        }
        finally {
            if (this.session.isLoggingEnabled()) {
                QMUtils.getDefaultHandler().handleStatementExecuteEnd((DBCStatement)this, -1L, this.executeError);
            }
        }
    }

    public RedisBaseResultSet openResultSet() throws DBCException {
        throw new DBCException("No result set");
    }
}

