/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.redis.exec;

import com.dbeaver.db.redis.exec.RedisSession;
import java.io.IOException;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCExecutionSource;
import org.jkiss.dbeaver.model.exec.DBCResultSet;
import org.jkiss.dbeaver.model.exec.DBCStatement;
import org.jkiss.dbeaver.model.qm.QMUtils;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import redis.clients.jedis.Jedis;

public abstract class RedisBaseStatement
implements DBCStatement {
    private static final Log log = Log.getLog(RedisBaseStatement.class);
    protected final RedisSession session;
    protected String query;
    protected DBCExecutionSource source;
    protected Throwable executeError;
    protected long offset;
    protected long limit;
    protected long updateCount = -1L;

    protected RedisBaseStatement(RedisSession session, String query) {
        this(session, query, 0L, 0L);
    }

    protected RedisBaseStatement(RedisSession session, String query, long firstRow, long maxRows) {
        this.session = session;
        this.query = query;
        this.offset = firstRow;
        this.limit = maxRows;
        if (session.isLoggingEnabled()) {
            QMUtils.getDefaultHandler().handleStatementOpen((DBCStatement)this);
        }
    }

    @NotNull
    public RedisSession getSession() {
        return this.session;
    }

    public String getQueryString() {
        return this.query;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public DBCExecutionSource getStatementSource() {
        return this.source;
    }

    public void setStatementSource(@Nullable DBCExecutionSource source) {
        this.source = source;
    }

    public void addToBatch() throws DBCException {
        throw new DBCException("Not implemented");
    }

    public int[] executeStatementBatch() throws DBCException {
        throw new DBCException("Not implemented");
    }

    public DBCResultSet openGeneratedKeysResultSet() throws DBCException {
        throw new DBCException("Not implemented");
    }

    public long getUpdateRowCount() {
        return this.updateCount;
    }

    public boolean nextResults() {
        this.updateCount = -1L;
        return false;
    }

    public void close() {
        if (this.session.isLoggingEnabled()) {
            QMUtils.getDefaultHandler().handleStatementClose((DBCStatement)this, this.getUpdateRowCount());
        }
    }

    public void setLimit(long offset, long limit) throws DBCException {
        this.offset = offset;
        this.limit = limit;
    }

    @Nullable
    public Throwable[] getStatementWarnings() throws DBCException {
        return null;
    }

    public void cancelBlock(@NotNull DBRProgressMonitor monitor, @Nullable Thread blockThread) throws DBException {
        Object jedisClient = this.session.getJedisClient();
        if (jedisClient instanceof Jedis) {
            try {
                ((Jedis)jedisClient).getClient().getSocket().close();
                return;
            }
            catch (IOException e) {
                throw new DBCException("Error closing Redis client socket", (Throwable)e);
            }
        }
        throw new DBException("Redis command cancel not implemented");
    }

    public void setStatementTimeout(int timeout) throws DBCException {
    }

    public void setResultsFetchSize(int fetchSize) throws DBCException {
    }

    public long getOffset() {
        return this.offset;
    }

    public long getLimit() {
        return this.limit;
    }

    protected DBCException handleExecuteError(Throwable ex) {
        this.executeError = ex;
        if (ex instanceof DBCException) {
            return (DBCException)ex;
        }
        return new DBCException(ex, (DBCExecutionContext)this.session.getExecutionContext());
    }

    protected String getClusterSampleKey() {
        return "";
    }
}

