/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.jdbc;

import java.io.UnsupportedEncodingException;

public class ChaCha20 {
    private int[] input = new int[16];

    protected static int U8TO32_LE(byte[] byArray, int n) {
        return byArray[n] & 0xFF | (byArray[n + 1] & 0xFF) << 8 | (byArray[n + 2] & 0xFF) << 16 | (byArray[n + 3] & 0xFF) << 24;
    }

    private static void U32TO8_LE(int[] nArray, int n, int n2) {
        nArray[n] = n2;
        nArray[n + 1] = n2 >>>= 8;
        nArray[n + 2] = n2 >>>= 8;
        nArray[n + 3] = n2 >>>= 8;
    }

    private static int ROTATE(int n, int n2) {
        return n << n2 | n >>> 32 - n2;
    }

    public ChaCha20(byte[] byArray) {
        String string = "expand 32-byte k";
        byte[] byArray2 = null;
        try {
            byArray2 = string.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
        }
        this.input[0] = ChaCha20.U8TO32_LE(byArray2, 0);
        this.input[1] = ChaCha20.U8TO32_LE(byArray2, 4);
        this.input[2] = ChaCha20.U8TO32_LE(byArray2, 8);
        this.input[3] = ChaCha20.U8TO32_LE(byArray2, 12);
        this.input[4] = ChaCha20.U8TO32_LE(byArray, 0);
        this.input[5] = ChaCha20.U8TO32_LE(byArray, 4);
        this.input[6] = ChaCha20.U8TO32_LE(byArray, 8);
        this.input[7] = ChaCha20.U8TO32_LE(byArray, 12);
        this.input[8] = ChaCha20.U8TO32_LE(byArray, 16);
        this.input[9] = ChaCha20.U8TO32_LE(byArray, 20);
        this.input[10] = ChaCha20.U8TO32_LE(byArray, 24);
        this.input[11] = ChaCha20.U8TO32_LE(byArray, 28);
        this.input[12] = 0;
        this.input[13] = 0;
        this.input[14] = 0;
        this.input[15] = 0;
    }

    private void quarterRound(int[] nArray, int n, int n2, int n3, int n4) {
        int n5 = n;
        nArray[n5] = nArray[n5] + nArray[n2];
        nArray[n4] = ChaCha20.ROTATE(nArray[n4] ^ nArray[n], 16);
        int n6 = n3;
        nArray[n6] = nArray[n6] + nArray[n4];
        nArray[n2] = ChaCha20.ROTATE(nArray[n2] ^ nArray[n3], 12);
        int n7 = n;
        nArray[n7] = nArray[n7] + nArray[n2];
        nArray[n4] = ChaCha20.ROTATE(nArray[n4] ^ nArray[n], 8);
        int n8 = n3;
        nArray[n8] = nArray[n8] + nArray[n4];
        nArray[n2] = ChaCha20.ROTATE(nArray[n2] ^ nArray[n3], 7);
    }

    public void encrypt(byte[] byArray, byte[] byArray2, int n) {
        int[] nArray = new int[16];
        int[] nArray2 = new int[64];
        int n2 = 0;
        int n3 = 0;
        while (n > 0) {
            int n4 = 16;
            while (n4-- > 0) {
                nArray[n4] = this.input[n4];
            }
            for (n4 = 20; n4 > 0; n4 -= 2) {
                this.quarterRound(nArray, 0, 4, 8, 12);
                this.quarterRound(nArray, 1, 5, 9, 13);
                this.quarterRound(nArray, 2, 6, 10, 14);
                this.quarterRound(nArray, 3, 7, 11, 15);
                this.quarterRound(nArray, 0, 5, 10, 15);
                this.quarterRound(nArray, 1, 6, 11, 12);
                this.quarterRound(nArray, 2, 7, 8, 13);
                this.quarterRound(nArray, 3, 4, 9, 14);
            }
            n4 = 16;
            while (n4-- > 0) {
                int n5 = n4;
                nArray[n5] = nArray[n5] + this.input[n4];
            }
            n4 = 16;
            while (n4-- > 0) {
                ChaCha20.U32TO8_LE(nArray2, 4 * n4, nArray[n4]);
            }
            this.input[12] = this.input[12] + 1;
            if (this.input[12] <= 0) {
                this.input[13] = this.input[13] + 1;
            }
            if (n <= 64) {
                n4 = n;
                while (n4-- > 0) {
                    byArray[n4 + n2] = (byte)(byArray2[n4 + n3] ^ nArray2[n4]);
                }
                return;
            }
            n4 = 64;
            while (n4-- > 0) {
                byArray[n4 + n2] = (byte)(byArray2[n4 + n3] ^ nArray2[n4]);
            }
            n -= 64;
            n3 += 64;
            n2 += 64;
        }
    }
}

