/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.jdbc;

import com.exasol.jdbc.Column;
import com.exasol.jdbc.EXAConnection;
import com.exasol.jdbc.EXAInputStream;
import com.exasol.jdbc.EXAOutputStream;
import com.exasol.jdbc.Translator;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.SQLException;

public class BigDecimalColumn
extends Column {
    private BigDecimal[] values;
    private int precision = 36;
    private int scale = 0;

    int getPrecision() throws SQLException {
        return this.precision;
    }

    void setPrecision(int n) throws SQLException {
        this.precision = n;
    }

    int getScale() throws SQLException {
        return this.scale;
    }

    protected void setScale(int n) throws SQLException {
        this.scale = n;
    }

    protected BigDecimalColumn(String string, int n, int n2, BigDecimal[] bigDecimalArray) {
        this.precision = n;
        this.scale = n2;
        this.values = bigDecimalArray;
    }

    protected BigDecimalColumn(int n, int n2) {
        this.values = new BigDecimal[initialBatchCapacity];
        this.precision = n;
        this.scale = n2;
    }

    void resize(int n) {
        int n2;
        if (n < 0) {
            System.out.println("Negative array size: " + n);
        }
        BigDecimal[] bigDecimalArray = new BigDecimal[n];
        boolean[] blArray = new boolean[n];
        int n3 = this.values.length;
        if (n3 > n) {
            n3 = n;
        }
        for (n2 = 0; n2 < n3; ++n2) {
            blArray[n2] = this.validMask[n2];
            bigDecimalArray[n2] = this.values[n2];
        }
        for (n2 = n3; n2 < n; ++n2) {
            blArray[n2] = false;
        }
        this.values = bigDecimalArray;
        this.validMask = blArray;
    }

    String getClassName() throws SQLException {
        return "java.math.BigDecimal";
    }

    int getDisplaySize(EXAConnection eXAConnection) throws SQLException {
        return this.precision + 2;
    }

    int getType() {
        return 3;
    }

    String getTypeName() {
        return "DECIMAL";
    }

    Object getObject(int n) throws SQLException {
        return this.getBigDecimal(n);
    }

    void setBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        this.values[n] = bigDecimal;
        this.validMask[n] = bigDecimal != null;
    }

    void setBigDecimal(int n, int n2, BigDecimal bigDecimal) throws SQLException {
        super.setBigDecimal(n, n2, bigDecimal);
    }

    void setByte(int n, byte by) throws SQLException {
        this.values[n] = BigDecimal.valueOf(by);
        this.validMask[n] = false;
    }

    void setDouble(int n, double d) throws SQLException {
        this.values[n] = new BigDecimal(d);
        this.validMask[n] = true;
    }

    void setFloat(int n, float f) throws SQLException {
        this.values[n] = new BigDecimal(f);
        this.validMask[n] = true;
    }

    void setInt(int n, int n2) throws SQLException {
        this.values[n] = BigDecimal.valueOf(n2);
        this.validMask[n] = true;
    }

    void setLong(int n, long l) throws SQLException {
        this.values[n] = BigDecimal.valueOf(l);
        this.validMask[n] = true;
    }

    void setShort(int n, short s) throws SQLException {
        this.values[n] = BigDecimal.valueOf(s);
        this.validMask[n] = true;
    }

    BigDecimal getBigDecimal(int n) throws SQLException {
        if (!this.validMask[n]) {
            throw new SQLException("BigDecimalColumn::getBigDecimal: " + Translator.Accessed_null_value());
        }
        return this.values[n];
    }

    double getDouble(int n) throws SQLException {
        if (!this.validMask[n]) {
            throw new SQLException("BigDecimalColumn::getDouble: " + Translator.Accessed_null_value());
        }
        return this.values[n].doubleValue();
    }

    float getFloat(int n) throws SQLException {
        if (!this.validMask[n]) {
            throw new SQLException("BigDecimalColumn::getFloat: " + Translator.Accessed_null_value());
        }
        return this.values[n].floatValue();
    }

    String getString(int n) throws SQLException {
        if (!this.validMask[n]) {
            throw new SQLException("BigDecimalColumn::getString: " + Translator.Accessed_null_value());
        }
        return this.values[n].toString();
    }

    boolean getBoolean(int n) throws SQLException {
        if (!this.validMask[n]) {
            throw new SQLException("DecimalColumn::getByte: " + Translator.Accessed_null_value());
        }
        long l = 0L;
        try {
            l = this.values[n].longValue();
        }
        catch (Exception exception) {
            new SQLException("DecimalColumn::getBoolean: " + Translator.Conversion_not_possible() + " " + exception.toString());
        }
        if (l == 0L) {
            return false;
        }
        if (l == 1L) {
            return true;
        }
        throw new SQLException("DecimalColumn::getBoolean: " + Translator.Conversion_not_possible());
    }

    int getInt(int n) throws SQLException {
        if (!this.validMask[n]) {
            throw new SQLException("BigDecimalColumn::getInt: " + Translator.Accessed_null_value());
        }
        return this.values[n].intValue();
    }

    long getLong(int n) throws SQLException {
        if (!this.validMask[n]) {
            throw new SQLException("BigDecimalColumn::getLong: " + Translator.Accessed_null_value());
        }
        return this.values[n].longValue();
    }

    short getShort(int n) throws SQLException {
        if (!this.validMask[n]) {
            throw new SQLException("BigDecimalColumn::getShort: " + Translator.Accessed_null_value());
        }
        return this.values[n].shortValue();
    }

    byte getByte(int n) throws SQLException {
        if (!this.validMask[n]) {
            throw new SQLException("BigDecimalColumn::getByte: " + Translator.Accessed_null_value());
        }
        return this.values[n].byteValue();
    }

    void value_to_jdbc(EXAOutputStream eXAOutputStream, int n) throws SQLException, IOException {
        if (this.validMask[n]) {
            eXAOutputStream.writeByte((byte)1);
            if (this.scale == this.values[n].scale()) {
                eXAOutputStream.writeBigInteger(this.values[n].unscaledValue());
            } else {
                eXAOutputStream.writeBigInteger(this.values[n].unscaledValue().multiply(new BigInteger("10").pow(this.scale - this.values[n].scale())));
            }
        } else {
            eXAOutputStream.writeByte((byte)0);
        }
    }

    void value_from_jdbc(EXAInputStream eXAInputStream, int n) throws SQLException, IOException {
        if (eXAInputStream.nextIsNull()) {
            this.validMask[n] = false;
        } else {
            this.validMask[n] = true;
            this.values[n] = new BigDecimal(eXAInputStream.readBigInteger(), this.scale);
        }
    }

    static Column from_jdbc_type(EXAInputStream eXAInputStream) throws IOException {
        int n = eXAInputStream.readInt();
        int n2 = eXAInputStream.readInt();
        return new BigDecimalColumn(n, n2);
    }

    int getEXAType() {
        return 64;
    }

    boolean isSigned() throws SQLException {
        return true;
    }
}

