/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.sql.parser.tokens.predicates;

import java.util.ArrayDeque;
import java.util.Collections;
import java.util.Deque;
import java.util.HashSet;
import java.util.Set;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.sql.parser.SQLParserActionKind;
import org.jkiss.dbeaver.model.sql.parser.SQLTokenPredicate;
import org.jkiss.dbeaver.model.sql.parser.SQLTokenPredicateSet;
import org.jkiss.dbeaver.model.sql.parser.TokenEntry;
import org.jkiss.dbeaver.model.sql.parser.TrieNode;
import org.jkiss.dbeaver.utils.ListNode;

public class SQLTokenPredicateEvaluator {
    protected static final Log log = Log.getLog(SQLTokenPredicateEvaluator.class);
    private final SQLTokenPredicateSet predicatesSet;
    private final Deque<TokenEntry> statementPrefixTokens;
    private final Deque<TokenEntry> statementSuffixTokens;
    private final Set<SQLTokenPredicate> plausibleConditions = new HashSet<SQLTokenPredicate>();
    private final Set<SQLTokenPredicate> plausiblePrefixOnlyConditions = new HashSet<SQLTokenPredicate>();
    private ListNode<TrieNode<TokenEntry, SQLTokenPredicate>> statementPrefixPredicates;

    public SQLTokenPredicateEvaluator(@NotNull SQLTokenPredicateSet predicatesSet) {
        this.predicatesSet = predicatesSet;
        this.statementPrefixTokens = new ArrayDeque<TokenEntry>(predicatesSet.getMaxPrefixLength());
        this.statementSuffixTokens = new ArrayDeque<TokenEntry>(predicatesSet.getMaxSuffixLength());
        this.statementPrefixPredicates = ListNode.of((Object)predicatesSet.getPrefixTreeRoot());
    }

    public void captureToken(@NotNull TokenEntry entry) {
        if (this.statementPrefixTokens.size() <= this.predicatesSet.getMaxPrefixLength()) {
            if (this.statementPrefixTokens.size() < this.predicatesSet.getMaxPrefixLength()) {
                this.statementPrefixTokens.add(entry);
            }
            ListNode accumulator = null;
            ListNode node = this.statementPrefixPredicates;
            while (node != null) {
                Set currentlyMatchedHeads = ((TrieNode)node.data).getValues();
                if (currentlyMatchedHeads.size() > 0) {
                    for (SQLTokenPredicate matchedByPrefix : currentlyMatchedHeads) {
                        if (matchedByPrefix.getMaxSuffixLength() == 0) {
                            this.plausiblePrefixOnlyConditions.add(matchedByPrefix);
                            continue;
                        }
                        this.plausibleConditions.add(matchedByPrefix);
                    }
                }
                accumulator = ((TrieNode)node.data).accumulateSubnodesByTerm((Object)entry, accumulator);
                node = node.next;
            }
            this.statementPrefixPredicates = accumulator;
        }
        if (this.predicatesSet.getMaxSuffixLength() > 0) {
            if (this.statementSuffixTokens.size() >= this.predicatesSet.getMaxSuffixLength()) {
                this.statementSuffixTokens.removeFirst();
            }
            this.statementSuffixTokens.add(entry);
        }
    }

    @Nullable
    public SQLParserActionKind evaluatePredicates() {
        Set tailConditionsMatched = this.plausibleConditions.size() > 0 ? this.predicatesSet.matchSuffix(this.statementSuffixTokens) : Collections.emptySet();
        tailConditionsMatched.retainAll(this.plausibleConditions);
        if (tailConditionsMatched.size() + this.plausiblePrefixOnlyConditions.size() > 1) {
            log.warn((Object)"Ambiguous token predicates match");
        } else {
            if (tailConditionsMatched.size() > 0) {
                return ((SQLTokenPredicate)tailConditionsMatched.iterator().next()).getActionKind();
            }
            if (this.plausiblePrefixOnlyConditions.size() > 0) {
                SQLTokenPredicate matchedByPrefix = this.plausiblePrefixOnlyConditions.iterator().next();
                this.plausiblePrefixOnlyConditions.clear();
                return matchedByPrefix.getActionKind();
            }
        }
        return null;
    }

    public void reset() {
        this.statementPrefixTokens.clear();
        this.statementSuffixTokens.clear();
        this.plausibleConditions.clear();
        this.plausiblePrefixOnlyConditions.clear();
        this.statementPrefixPredicates = ListNode.of((Object)this.predicatesSet.getPrefixTreeRoot());
    }
}

