/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tools.transfer.stream;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.meta.DBSerializable;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.DBRRunnableContext;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.task.DBTTask;
import org.jkiss.dbeaver.runtime.serialize.DBPObjectSerializer;
import org.jkiss.dbeaver.tools.transfer.IDataTransferConsumer;
import org.jkiss.dbeaver.tools.transfer.IDataTransferProcessor;
import org.jkiss.dbeaver.tools.transfer.IDataTransferProducer;
import org.jkiss.dbeaver.tools.transfer.registry.DataTransferNodeDescriptor;
import org.jkiss.dbeaver.tools.transfer.registry.DataTransferProcessorDescriptor;
import org.jkiss.dbeaver.tools.transfer.registry.DataTransferRegistry;
import org.jkiss.dbeaver.tools.transfer.stream.IStreamDataImporter;
import org.jkiss.dbeaver.tools.transfer.stream.StreamDataImporterSite;
import org.jkiss.dbeaver.tools.transfer.stream.StreamEntityMapping;
import org.jkiss.dbeaver.tools.transfer.stream.StreamProducerSettings;
import org.jkiss.utils.CommonUtils;

@DBSerializable(value="streamTransferProducer")
public class StreamTransferProducer
implements IDataTransferProducer<StreamProducerSettings> {
    private static final Log log = Log.getLog(StreamTransferProducer.class);
    public static final String NODE_ID = "stream_producer";
    private StreamEntityMapping entityMapping;
    private DataTransferProcessorDescriptor defaultProcessor;

    public StreamTransferProducer() {
    }

    public StreamTransferProducer(StreamEntityMapping entityMapping) {
        this(entityMapping, null);
    }

    public StreamTransferProducer(StreamEntityMapping entityMapping, DataTransferProcessorDescriptor defaultProcessor) {
        this.entityMapping = entityMapping;
        this.defaultProcessor = defaultProcessor;
    }

    public StreamEntityMapping getEntityMapping() {
        return this.entityMapping;
    }

    public StreamEntityMapping getDatabaseObject() {
        return this.entityMapping;
    }

    @Override
    public String getObjectName() {
        return this.entityMapping == null ? null : this.entityMapping.getName();
    }

    @Override
    public DBPImage getObjectIcon() {
        if (this.defaultProcessor != null) {
            return this.defaultProcessor.getIcon();
        }
        return null;
    }

    @Override
    public String getObjectContainerName() {
        if (this.entityMapping == null) {
            return "";
        }
        File inputFile = this.entityMapping.getInputFile();
        return inputFile == null ? null : inputFile.getParentFile().getAbsolutePath();
    }

    @Override
    public DBPImage getObjectContainerIcon() {
        return DBIcon.TREE_FOLDER;
    }

    @Override
    public boolean isConfigurationComplete() {
        return this.entityMapping != null;
    }

    public File getInputFile() {
        return this.entityMapping == null ? null : this.entityMapping.getInputFile();
    }

    @Override
    public void transferData(@NotNull DBRProgressMonitor monitor, @NotNull IDataTransferConsumer consumer, @Nullable IDataTransferProcessor processor, @NotNull StreamProducerSettings settings, @Nullable DBTTask task) throws DBException {
        DBSObject databaseObject = consumer.getDatabaseObject();
        boolean cfr_ignored_0 = databaseObject instanceof DBSEntity;
        if (processor == null) {
            throw new DBException("Stream data producer requires data processor");
        }
        Map<String, Object> processorProperties = settings.getProcessorProperties();
        StreamDataImporterSite site = new StreamDataImporterSite(settings, this.entityMapping, processorProperties);
        IStreamDataImporter importer = (IStreamDataImporter)processor;
        importer.init(site);
        try {
            try {
                Throwable throwable = null;
                Object var11_13 = null;
                try (FileInputStream is = new FileInputStream(this.entityMapping.getInputFile());){
                    importer.runImport(monitor, this.entityMapping.getDataSource(), is, consumer);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                throw new DBException("IO error", (Throwable)e);
            }
        }
        finally {
            importer.dispose();
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof StreamTransferProducer) {
            return CommonUtils.equalObjects((Object)this.entityMapping, (Object)((StreamTransferProducer)obj).entityMapping);
        }
        return super.equals(obj);
    }

    public static class ObjectSerializer
    implements DBPObjectSerializer<DBTTask, StreamTransferProducer> {
        public void serializeObject(DBRRunnableContext runnableContext, DBTTask context, StreamTransferProducer object, Map<String, Object> state) {
            state.put("file", object.getInputFile().getAbsolutePath());
            if (object.defaultProcessor != null) {
                state.put("node", object.defaultProcessor.getNode().getId());
                state.put("processor", object.defaultProcessor.getId());
            }
        }

        public StreamTransferProducer deserializeObject(DBRRunnableContext runnableContext, DBTTask objectContext, Map<String, Object> state) {
            File inputFile = new File(CommonUtils.toString((Object)state.get("file")));
            String nodeId = CommonUtils.toString((Object)state.get("node"));
            String processorId = CommonUtils.toString((Object)state.get("processor"));
            DataTransferProcessorDescriptor processor = null;
            if (!CommonUtils.isEmpty((String)nodeId) && !CommonUtils.isEmpty((String)processorId)) {
                DataTransferNodeDescriptor nodeDesc = DataTransferRegistry.getInstance().getNodeById(nodeId);
                if (nodeDesc == null) {
                    log.warn((Object)("Stream producer node " + nodeId + " not found"));
                } else {
                    processor = nodeDesc.getProcessor(processorId);
                    if (processor == null) {
                        log.warn((Object)("Stream processor " + processorId + " not found"));
                    }
                }
            }
            return new StreamTransferProducer(new StreamEntityMapping(inputFile), processor);
        }
    }
}

