/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.mongodb.exec.js;

import com.dbeaver.db.mongodb.exec.MGSession;
import com.dbeaver.db.mongodb.exec.js.MongoJSCursor;
import com.dbeaver.db.mongodb.exec.js.MongoJSDatabase;
import com.dbeaver.db.mongodb.exec.js.MongoJSUtils;
import com.dbeaver.db.mongodb.model.MGCollection;
import com.mongodb.BasicDBObject;
import com.mongodb.MongoNamespace;
import com.mongodb.client.ClientSession;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.model.IndexOptions;
import com.mongodb.client.model.RenameCollectionOptions;
import com.mongodb.client.model.UpdateOptions;
import com.mongodb.client.result.DeleteResult;
import com.mongodb.client.result.UpdateResult;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;

public class MongoJSCollection
extends AbstractMap<String, Object> {
    private static final Log log = Log.getLog(MongoJSCollection.class);
    private final MongoJSDatabase database;
    private final MGCollection collection;

    public MongoJSCollection(MongoJSDatabase database, MGCollection collection) {
        this.database = database;
        this.collection = collection;
    }

    @Nullable
    private ClientSession getClientSession() {
        return this.getMongoSession().getClientSession();
    }

    @NotNull
    private MGSession getMongoSession() {
        return this.database.getProcessor().getSession();
    }

    @Override
    public Object get(Object key) {
        return null;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.get(key) != null;
    }

    @Override
    @NotNull
    public Set<Map.Entry<String, Object>> entrySet() {
        return Collections.emptySet();
    }

    @Override
    public int hashCode() {
        return ((Object)((Object)this.collection)).hashCode();
    }

    @NotNull
    private MongoCollection<Document> getMongoCollection() throws DBCException {
        return this.collection.getMongoCollection(this.getMongoSession());
    }

    public Object insert(Map<String, Object> document) throws DBCException {
        ClientSession clientSession = this.getClientSession();
        if (clientSession == null) {
            return this.getMongoCollection().insertOne((Object)MongoJSUtils.createBasicDocument(MongoJSUtils.unwrapMap(document)));
        }
        this.getMongoCollection().insertOne(clientSession, (Object)MongoJSUtils.createDocument(document));
        return "Inserted 1 document";
    }

    public Object insert(List<Map<String, Object>> documents) throws DBCException {
        ClientSession clientSession = this.getClientSession();
        if (clientSession == null) {
            return this.getMongoCollection().insertMany(MongoJSUtils.createBasicList(documents));
        }
        this.getMongoCollection().insertMany(clientSession, MongoJSUtils.createDocumentList(documents));
        return "Inserted " + documents.size() + " document(s)";
    }

    public Object save(Map<String, Object> document) throws DBCException {
        return this.getMongoCollection().insertOne((Object)MongoJSUtils.createBasicDocument(document));
    }

    public Object update(Map<String, Object> query, Map<String, Object> update, boolean upsert) throws DBCException {
        return this.getMongoCollection().updateOne((Bson)MongoJSUtils.createBasicDocument(query), (Bson)MongoJSUtils.createBasicDocument(update), new UpdateOptions().upsert(upsert));
    }

    public UpdateResult update(Map<String, Object> query, Map<String, Object> update) throws DBCException {
        return this.getMongoCollection().updateOne((Bson)MongoJSUtils.createBasicDocument(query), (Bson)MongoJSUtils.createBasicDocument(update));
    }

    public DeleteResult remove(Map<String, Object> query) throws DBCException {
        return this.getMongoCollection().deleteOne((Bson)MongoJSUtils.createBasicDocument(query));
    }

    public DeleteResult delete(Map<String, Object> query) throws DBCException {
        return this.remove(query);
    }

    public MongoJSCursor find(Map<String, Object> query) throws DBCException {
        return new MongoJSCursor((FindIterable<Document>)this.getMongoCollection().find((Bson)MongoJSUtils.createBasicDocument(query)));
    }

    public MongoJSCursor find(Map<String, Object> query, Map<String, Object> projection) throws DBCException {
        return new MongoJSCursor((FindIterable<Document>)this.getMongoCollection().find((Bson)MongoJSUtils.createBasicDocument(query)).projection((Bson)MongoJSUtils.createBasicDocument(projection)));
    }

    public Iterable<Document> aggregate(List<Map<String, Object>> documents) throws DBCException {
        ClientSession clientSession = this.getClientSession();
        if (clientSession == null) {
            return this.getMongoCollection().aggregate(MongoJSUtils.createBasicList(documents));
        }
        return this.getMongoCollection().aggregate(clientSession, MongoJSUtils.createDocumentList(documents)).map(Document::new);
    }

    private Document getOne(FindIterable<Document> i) {
        i.limit(1);
        MongoCursor iterator = i.iterator();
        return iterator.hasNext() ? (Document)iterator.next() : null;
    }

    public MongoJSCursor find() throws DBCException {
        return new MongoJSCursor((FindIterable<Document>)this.getMongoCollection().find());
    }

    @Nullable
    public Document findOne() throws DBCException {
        return this.getOne((FindIterable<Document>)this.getMongoCollection().find());
    }

    @Nullable
    public Document findOne(Map<String, Object> query) throws DBCException {
        return this.getOne((FindIterable<Document>)this.getMongoCollection().find((Bson)MongoJSUtils.createBasicDocument(query)));
    }

    @Nullable
    public Document findOne(Map<String, Object> query, Map<String, Object> projection) throws DBCException {
        return this.getOne((FindIterable<Document>)this.getMongoCollection().find((Bson)MongoJSUtils.createBasicDocument(query)).projection((Bson)MongoJSUtils.createBasicDocument(projection)));
    }

    @Nullable
    public Document findOne(Map<String, Object> query, Map<String, Object> projection, Map<String, Object> sort) throws DBCException {
        return this.getOne((FindIterable<Document>)this.getMongoCollection().find((Bson)MongoJSUtils.createBasicDocument(query)).projection((Bson)MongoJSUtils.createBasicDocument(projection)).sort((Bson)MongoJSUtils.createBasicDocument(sort)));
    }

    @Nullable
    public Document findOne(Object id) throws DBCException {
        return this.getOne((FindIterable<Document>)this.getMongoCollection().find((Bson)new Document("_id", id)));
    }

    @Nullable
    public Document findOne(Object id, Map<String, Object> projection) throws DBCException {
        return this.getOne((FindIterable<Document>)this.getMongoCollection().find((Bson)new Document("_id", id)).projection((Bson)MongoJSUtils.createBasicDocument(projection)));
    }

    public long count() throws DBCException {
        return this.getMongoCollection().countDocuments();
    }

    public long count(@Nullable Map<String, Object> query) throws DBCException {
        return this.getMongoCollection().countDocuments((Bson)MongoJSUtils.createBasicDocument(query));
    }

    public Object rename(String newName) throws DBCException {
        this.getMongoCollection().renameCollection(new MongoNamespace(newName));
        return this;
    }

    public MongoJSCollection rename(String newName, boolean dropTarget) throws DBCException {
        this.getMongoCollection().renameCollection(new MongoNamespace(newName), new RenameCollectionOptions().dropTarget(dropTarget));
        return this;
    }

    public long deleteOne(Map<String, Object> filter) throws DBCException {
        return this.getMongoCollection().deleteOne((Bson)MongoJSUtils.createBasicDocument(filter)).getDeletedCount();
    }

    public long deleteMany(Map<String, Object> filter) throws DBCException {
        return this.getMongoCollection().deleteMany((Bson)MongoJSUtils.createBasicDocument(filter)).getDeletedCount();
    }

    public long updateOne(Map<String, Object> filter, Map<String, Object> update) throws DBCException {
        return this.getMongoCollection().updateOne((Bson)MongoJSUtils.createBasicDocument(filter), (Bson)MongoJSUtils.createBasicDocument(update)).getModifiedCount();
    }

    public long updateMany(Map<String, Object> filter, Map<String, Object> update) throws DBCException {
        return this.getMongoCollection().updateMany((Bson)MongoJSUtils.createBasicDocument(filter), (Bson)MongoJSUtils.createBasicDocument(update)).getModifiedCount();
    }

    public void drop() throws DBCException {
        this.getMongoCollection().drop();
    }

    public MongoCursor<Object> distinct(String fieldName) throws DBCException {
        return this.getMongoCollection().distinct(fieldName, Object.class).iterator();
    }

    public MongoCursor<Object> distinct(String fieldName, Map<String, Object> query) throws DBCException {
        return this.getMongoCollection().distinct(fieldName, (Bson)MongoJSUtils.createBasicDocument(query), Object.class).iterator();
    }

    public String getName() throws DBCException {
        return this.getMongoCollection().getNamespace().getCollectionName();
    }

    public String getFullName() throws DBCException {
        return this.getMongoCollection().getNamespace().getFullName();
    }

    public Object getMongoCollection(String name) {
        return this.database.get(name);
    }

    public void createIndex(String name) throws DBCException {
        this.getMongoCollection().createIndex((Bson)new BasicDBObject(name, (Object)1));
    }

    public void createIndex(Map<String, Object> keys, String name) throws DBCException {
        this.getMongoCollection().createIndex((Bson)MongoJSUtils.createBasicDocument(keys), new IndexOptions().name(name));
    }

    public void createIndex(Map<String, Object> keys, @Nullable String name, boolean unique) throws DBCException {
        this.getMongoCollection().createIndex((Bson)MongoJSUtils.createBasicDocument(keys), new IndexOptions().name(name).unique(unique));
    }

    public void createIndex(Map<String, Object> keys) throws DBCException {
        this.getMongoCollection().createIndex((Bson)MongoJSUtils.createBasicDocument(keys));
    }

    public MongoCursor<Document> getIndexInfo() throws DBCException {
        return this.getMongoCollection().listIndexes().iterator();
    }

    public MongoCursor<Document> listIndexes() throws DBCException {
        return this.getMongoCollection().listIndexes().iterator();
    }

    public void dropIndex(Map<String, Object> index) throws DBCException {
        this.getMongoCollection().dropIndex((Bson)MongoJSUtils.createBasicDocument(index));
    }

    public void dropIndex(String indexName) throws DBCException {
        this.getMongoCollection().dropIndex(indexName);
    }

    public void dropIndexes() throws DBCException {
        this.getMongoCollection().dropIndexes();
    }

    public MGCollection.Stats getStats() throws DBCException {
        return this.collection.getStats((DBRProgressMonitor)new VoidProgressMonitor());
    }

    public MGCollection.Stats stats() throws DBCException {
        return this.getStats();
    }

    @Nullable
    public Document findAndModify(@Nullable Map<String, Object> query, Map<String, Object> update) throws DBCException {
        return (Document)this.getMongoCollection().findOneAndUpdate((Bson)(query == null ? null : MongoJSUtils.createBasicDocument(query)), (Bson)MongoJSUtils.createBasicDocument(update));
    }

    @Nullable
    public Document findAndRemove(@Nullable Map<String, Object> query) throws DBCException {
        return (Document)this.getMongoCollection().findOneAndDelete((Bson)(query == null ? null : MongoJSUtils.createBasicDocument(query)));
    }

    public long totalSize() throws DBCException {
        return 0L;
    }
}

