/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.mongodb.exec;

import com.dbeaver.db.mongodb.data.MGDocument;
import com.dbeaver.db.mongodb.exec.MGBaseStatement;
import com.dbeaver.db.mongodb.exec.MGCursor;
import com.dbeaver.db.mongodb.exec.MGSession;
import com.dbeaver.db.mongodb.model.MGDataSource;
import com.dbeaver.ee.model.document.exec.DocumentResultSet;
import com.mongodb.client.MongoCursor;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.bson.Document;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCResultSet;
import org.jkiss.dbeaver.model.exec.DBCResultSetMetaData;
import org.jkiss.dbeaver.model.exec.DBCResultSetSampleProvider;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.DBCStatement;
import org.jkiss.dbeaver.model.qm.QMUtils;
import org.jkiss.dbeaver.model.runtime.DBRBlockingObject;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;

public class MGResultSet
extends DocumentResultSet<MGSession, MGBaseStatement>
implements DBRBlockingObject,
DBCResultSetSampleProvider {
    private final MGCursor cursor;
    private final MongoCursor mongoCursor;
    private final List<Document> list;
    private DBCResultSetMetaData metaData;
    private Object curRow;
    private transient Iterator<Document> iterator;

    public MGResultSet(MGBaseStatement statement, MGCursor cursor) {
        super((DBCStatement)statement);
        long limit;
        this.cursor = cursor;
        this.mongoCursor = null;
        this.list = null;
        long offset = statement.getOffset();
        if (offset > 0L) {
            this.cursor.skip((int)offset);
        }
        if ((limit = statement.getLimit()) > 0L) {
            this.cursor.batchSize((int)limit);
            this.cursor.limit((int)limit);
        } else if (statement.getResultsFetchSize() > 0) {
            this.cursor.batchSize(statement.getResultsFetchSize());
        }
        if (((MGSession)statement.getSession()).isLoggingEnabled()) {
            QMUtils.getDefaultHandler().handleResultSetOpen((DBCResultSet)this);
        }
        ((MGSession)statement.getSession()).getProgressMonitor().startBlock((DBRBlockingObject)this, "Fetch result");
    }

    public MGResultSet(MGBaseStatement statement, MongoCursor mongoCursor) {
        super((DBCStatement)statement);
        this.mongoCursor = mongoCursor;
        this.cursor = null;
        this.list = null;
        long offset = statement.getOffset();
        if (offset > 0L) {
            int i = 0;
            while ((long)i < offset) {
                if (!this.mongoCursor.hasNext()) break;
                this.mongoCursor.next();
                ++i;
            }
        }
        if (((MGSession)statement.getSession()).isLoggingEnabled()) {
            QMUtils.getDefaultHandler().handleResultSetOpen((DBCResultSet)this);
        }
        ((MGSession)statement.getSession()).getProgressMonitor().startBlock((DBRBlockingObject)this, "Fetch result");
    }

    public MGResultSet(MGBaseStatement statement, List<Document> list) {
        super((DBCStatement)statement);
        this.cursor = null;
        this.mongoCursor = null;
        this.list = list;
        if (((MGSession)statement.getSession()).isLoggingEnabled()) {
            QMUtils.getDefaultHandler().handleResultSetOpen((DBCResultSet)this);
        }
        ((MGSession)statement.getSession()).getProgressMonitor().startBlock((DBRBlockingObject)this, "Fetch result");
    }

    public MGSession getSession() {
        return (MGSession)((MGBaseStatement)this.statement).getSession();
    }

    public MGBaseStatement getSourceStatement() {
        return (MGBaseStatement)this.statement;
    }

    protected void checkRowFetched() throws DBCException {
        if (this.curRow == null) {
            throw new DBCException("Row not fetched");
        }
    }

    public Object getAttributeValue(int index) throws DBCException {
        this.checkRowFetched();
        if (index == 0) {
            return this.curRow;
        }
        throw new DBCException("Index out of range (" + index + ")");
    }

    public Object getAttributeValue(String name) throws DBCException {
        this.checkRowFetched();
        if (this.curRow instanceof Map) {
            return ((Map)this.curRow).get(name);
        }
        return this.curRow;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean nextRow() throws DBCException {
        long limit = ((MGBaseStatement)this.statement).getLimit();
        if (limit > 0L && (long)(this.itemNumber + 1) >= limit) {
            return false;
        }
        if (this.list != null) {
            if (this.list.size() > this.itemNumber + 1) {
                this.curRow = this.list.get(this.itemNumber + 1);
                ++this.itemNumber;
                return true;
            }
            return false;
        }
        try {
            if (this.mongoCursor != null) {
                if (!this.mongoCursor.hasNext()) {
                    this.curRow = null;
                    return false;
                }
                this.curRow = this.mongoCursor.next();
            } else if (this.iterator != null) {
                if (!this.iterator.hasNext()) {
                    this.curRow = null;
                    return false;
                }
                this.curRow = this.iterator.next();
            } else {
                if (this.cursor != null) {
                    this.iterator = this.cursor.iterator();
                    return this.nextRow();
                }
                throw new DBCException("Null result");
            }
            ++this.itemNumber;
            return true;
        }
        catch (Exception e) {
            throw new DBCException("Error fetching Mongo cursor", (Throwable)e);
        }
    }

    public boolean moveTo(int position) throws DBCException {
        return false;
    }

    public String getResultSetName() throws DBCException {
        return null;
    }

    public Object getFeature(String name) {
        if ("document".equals(name)) {
            return true;
        }
        return null;
    }

    public void close() {
        ((MGSession)((MGBaseStatement)this.statement).getSession()).getProgressMonitor().endBlock();
        if (((MGSession)((MGBaseStatement)this.statement).getSession()).isLoggingEnabled()) {
            QMUtils.getDefaultHandler().handleResultSetClose((DBCResultSet)this, (long)this.itemNumber);
        }
        this.iterator = null;
    }

    public void cancelBlock(@NotNull DBRProgressMonitor monitor, @Nullable Thread blockThread) throws DBException {
        if (this.cursor != null) {
            this.cursor.close();
        }
    }

    @NotNull
    public List<Object[]> getSampleRows(DBCSession session, int maxRows) throws DBCException {
        ArrayList<Object[]> sample;
        block6: {
            sample = new ArrayList<Object[]>();
            if (this.list != null) {
                for (Document object : this.list) {
                    sample.add(new Object[]{new MGDocument((MGDataSource)session.getDataSource(), object)});
                    if (sample.size() >= maxRows) break;
                }
            }
            try {
                if (this.mongoCursor != null || this.cursor == null) break block6;
                for (Document object : this.cursor) {
                    sample.add(new Object[]{new MGDocument((MGDataSource)session.getDataSource(), object)});
                    if (sample.size() < maxRows && !session.getProgressMonitor().isCanceled()) {
                        continue;
                    }
                    break;
                }
            }
            catch (Exception e) {
                throw new DBCException("Error fetching Mongo cursor", (Throwable)e);
            }
        }
        return sample;
    }
}

