/*
 * Decompiled with CFR 0.152.
 */
package net.ucanaccess.jdbc;

import java.io.PrintWriter;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Properties;
import java.util.logging.Logger;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import javax.sql.DataSource;
import net.ucanaccess.jdbc.UcanaccessDataSourceFactory;
import net.ucanaccess.jdbc.UcanaccessDriver;

public class UcanaccessDataSource
implements Serializable,
Referenceable,
DataSource {
    private static final long serialVersionUID = -5622403376078548785L;
    private String accessPath;
    private int loginTimeout = 0;
    private transient PrintWriter logWriter = net.ucanaccess.util.Logger.getLogPrintWriter();
    private String password = "";
    private String user;
    private final Properties props = new Properties();

    public String getAccessPath() {
        return this.accessPath;
    }

    public String getColumnOrder() {
        return this.getPropAsString("columnorder");
    }

    public Boolean getConcatNulls() {
        return this.getPropAsBoolean("concatnulls");
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.getConnection(this.user, this.password);
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        if (username != null) {
            this.props.put("user", username);
        }
        if (password != null) {
            this.props.put("password", password);
        }
        return new UcanaccessDriver().connect("jdbc:ucanaccess://" + this.accessPath, this.props);
    }

    public Boolean getEncrypt() {
        return this.getPropAsBoolean("encrypt");
    }

    public Boolean getIgnoreCase() {
        return this.getPropAsBoolean("ignorecase");
    }

    public Boolean getImmediatelyReleaseResources() {
        return this.getPropAsBoolean("immediatelyreleaseresources");
    }

    public Integer getInactivityTimeout() {
        return this.getPropAsInteger("inactivitytimeout");
    }

    public String getJackcessOpener() {
        return this.getPropAsString("jackcessopener");
    }

    public String getKeepMirror() {
        return this.getPropAsString("keepmirror");
    }

    public Integer getLobScale() {
        return this.getPropAsInteger("lobscale");
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return this.loginTimeout;
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return this.logWriter;
    }

    public Boolean getMemory() {
        return this.getPropAsBoolean("memory");
    }

    public String getMirrorFolder() {
        return this.getPropAsString("mirrorfolder");
    }

    public String getNewDatabaseVersion() {
        return this.getPropAsString("newdatabaseversion");
    }

    public Boolean getOpenExclusive() {
        return this.getPropAsBoolean("openexclusive");
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException();
    }

    public Boolean getPreventReloading() {
        return this.getPropAsBoolean("preventreloading");
    }

    private Boolean getPropAsBoolean(String key) {
        Boolean rtn = null;
        String value = this.props.getProperty(key);
        if (value != null) {
            rtn = Boolean.valueOf(value);
        }
        return rtn;
    }

    private Integer getPropAsInteger(String key) {
        Integer rtn = null;
        String value = this.props.getProperty(key);
        if (value != null) {
            rtn = Integer.valueOf(value);
        }
        return rtn;
    }

    private String getPropAsString(String key) {
        return this.props.getProperty(key);
    }

    @Override
    public Reference getReference() throws NamingException {
        String clazz = UcanaccessDataSourceFactory.class.getName();
        Reference ref = new Reference(this.getClass().getName(), clazz, null);
        ref.add(new StringRefAddr("accessPath", this.getAccessPath()));
        ref.add(new StringRefAddr("user", this.getUser()));
        ref.add(new StringRefAddr("password", this.password));
        ref.add(new StringRefAddr("columnorder", this.getPropAsString("columnorder")));
        ref.add(new StringRefAddr("concatnulls", this.getPropAsString("concatnulls")));
        ref.add(new StringRefAddr("encrypt", this.getPropAsString("encrypt")));
        ref.add(new StringRefAddr("ignorecase", this.getPropAsString("ignorecase")));
        ref.add(new StringRefAddr("immediatelyreleaseresources", this.getPropAsString("immediatelyreleaseresources")));
        ref.add(new StringRefAddr("inactivitytimeout", this.getPropAsString("inactivitytimeout")));
        ref.add(new StringRefAddr("jackcessopener", this.getPropAsString("jackcessopener")));
        ref.add(new StringRefAddr("keepmirror", this.getPropAsString("keepmirror")));
        ref.add(new StringRefAddr("lobscale", this.getPropAsString("lobscale")));
        ref.add(new StringRefAddr("memory", this.getPropAsString("memory")));
        ref.add(new StringRefAddr("mirrorfolder", this.getPropAsString("mirrorfolder")));
        ref.add(new StringRefAddr("newdatabaseversion", this.getPropAsString("newdatabaseversion")));
        ref.add(new StringRefAddr("openexclusive", this.getPropAsString("openexclusive")));
        ref.add(new StringRefAddr("preventreloading", this.getPropAsString("preventreloading")));
        ref.add(new StringRefAddr("remap", this.getPropAsString("remap")));
        ref.add(new StringRefAddr("showschema", this.getPropAsString("showschema")));
        ref.add(new StringRefAddr("skipindexes", this.getPropAsString("skipindexes")));
        ref.add(new StringRefAddr("sysschema", this.getPropAsString("sysschema")));
        return ref;
    }

    public String getReMap() {
        return this.getPropAsString("remap");
    }

    public Boolean getShowSchema() {
        return this.getPropAsBoolean("showschema");
    }

    public Boolean getSkipIndexes() {
        return this.getPropAsBoolean("skipindexes");
    }

    public Boolean getSysSchema() {
        return this.getPropAsBoolean("sysschema");
    }

    public String getUser() {
        return this.user;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void setAccessPath(String accessPath) {
        this.accessPath = accessPath;
    }

    public void setColumnOrder(String value) {
        this.setProp("columnorder", value, new ArrayList<Object>(Arrays.asList("DATA", "DISPLAY")));
    }

    public void setConcatNulls(Boolean value) {
        this.setProp("concatnulls", value, null);
    }

    public void setEncrypt(Boolean value) {
        this.setProp("encrypt", value, null);
    }

    public void setIgnoreCase(Boolean value) {
        this.setProp("ignorecase", value, null);
    }

    public void setImmediatelyReleaseResources(Boolean value) {
        this.setProp("immediatelyreleaseresources", value, null);
    }

    public void setInactivityTimeout(Integer value) {
        this.setProp("inactivitytimeout", value, null);
    }

    public void setJackcessOpener(String value) {
        this.setProp("jackcessopener", value, null);
    }

    public void setKeepMirror(String value) {
        this.setProp("keepmirror", value, null);
    }

    public void setLobScale(Integer value) {
        this.setProp("lobscale", value, new ArrayList<Object>(Arrays.asList(1, 2, 4, 8, 16, 32)));
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        this.loginTimeout = seconds;
    }

    @Override
    public void setLogWriter(PrintWriter logWriter) throws SQLException {
        net.ucanaccess.util.Logger.setLogPrintWriter(logWriter);
    }

    public void setMemory(Boolean value) {
        this.setProp("memory", value, null);
    }

    public void setMirrorFolder(String value) {
        this.setProp("mirrorfolder", value, null);
    }

    public void setNewDatabaseVersion(String value) {
        this.setProp("newdatabaseversion", value, new ArrayList<Object>(Arrays.asList("V2000", "V2003", "V2007", "V2010")));
    }

    public void setOpenExclusive(Boolean value) {
        this.setProp("openexclusive", value, null);
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setPreventReloading(Boolean value) {
        this.setProp("preventreloading", value, null);
    }

    private void setProp(String key, Object value, ArrayList<Object> validValues) {
        if (value == null) {
            this.props.remove(key);
        } else {
            boolean isValid = true;
            if (validValues != null) {
                isValid = value instanceof String ? validValues.contains(value.toString().toUpperCase()) : validValues.contains(value);
            }
            if (isValid) {
                this.props.setProperty(key, value.toString());
            } else {
                throw new IllegalArgumentException();
            }
        }
    }

    public void setReMap(String value) {
        this.setProp("remap", value, null);
    }

    public void setShowSchema(Boolean value) {
        this.setProp("showschema", value, null);
    }

    public void setSkipIndexes(Boolean value) {
        this.setProp("skipindexes", value, null);
    }

    public void setSysSchema(Boolean value) {
        this.setProp("sysschema", value, null);
    }

    public void setUser(String user) {
        this.user = user;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

