/*
 * Decompiled with CFR 0.152.
 */
package net.ucanaccess.console;

import com.healthmarketscience.jackcess.Database;
import com.healthmarketscience.jackcess.DatabaseBuilder;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import net.ucanaccess.console.Exporter;
import net.ucanaccess.util.Logger;

public class Main {
    private static final String EXPORT_USAGE = "export [--help] [--bom] [-d <delimiter>] [-t <table>] [--big_query_schema <pathToSchemaFile>] [--newlines] <pathToCsv>";
    private static final String EXPORT_PROMPT = "Export command syntax is: export [--help] [--bom] [-d <delimiter>] [-t <table>] [--big_query_schema <pathToSchemaFile>] [--newlines] <pathToCsv>";
    private static boolean batchMode = false;
    private Connection conn;
    private boolean connected = true;
    private BufferedReader input;
    private String lastSqlQuery;

    public Main(Connection conn, BufferedReader input) {
        this.conn = conn;
        this.input = input;
    }

    private static boolean hasPassword(File fl) throws IOException {
        Database db;
        try {
            db = DatabaseBuilder.open((File)fl);
        }
        catch (IOException e) {
            DatabaseBuilder dbb = new DatabaseBuilder();
            dbb.setReadOnly(true);
            dbb.setFile(fl);
            db = dbb.open();
        }
        String pwd = db.getDatabasePassword();
        db.close();
        return pwd != null;
    }

    private static void lcProperties(Properties pr) {
        Properties nb = new Properties();
        for (Map.Entry<Object, Object> entry : pr.entrySet()) {
            String key = (String)entry.getKey();
            if (key == null) continue;
            nb.put(key.toLowerCase(), entry.getValue());
        }
        pr.clear();
        pr.putAll((Map<?, ?>)nb);
    }

    public static void main(String[] args) throws Exception {
        File pfl;
        Logger.setLogPrintWriter(new PrintWriter(System.out));
        BufferedReader input = new BufferedReader(new InputStreamReader(System.in));
        Properties info = new Properties();
        if (args.length > 0 && (pfl = new File(args[0])).exists()) {
            FileInputStream fis = new FileInputStream(pfl);
            info.load(fis);
            Main.lcProperties(info);
        }
        try {
            Class.forName("net.ucanaccess.jdbc.UcanaccessDriver");
        }
        catch (ClassNotFoundException e) {
            System.out.println(e.getMessage());
            System.out.println("Check your classpath! ");
            System.exit(1);
        }
        Connection conn = null;
        File fl = null;
        long size = 0L;
        while (fl == null || !fl.exists()) {
            if (fl != null) {
                System.out.println("Given file does not exist");
            }
            System.out.print("Please, enter the full path to the access file (.mdb or .accdb): ");
            String path = input.readLine().trim();
            if (path.endsWith(";")) {
                path = path.substring(0, path.length() - 1);
            }
            if (path.equalsIgnoreCase("quit")) {
                System.out.println("I'm so unhappy. Goodbye.");
                System.exit(1);
            }
            fl = new File(path);
            size = fl.length();
        }
        try {
            String passwordEntry = "";
            String noMem = "";
            if (info.containsKey("jackcessopener") || Main.hasPassword(fl)) {
                System.out.print("Please, enter password: ");
                passwordEntry = ";password=" + input.readLine().trim();
            }
            if (!info.containsKey("jackcessopener")) {
                noMem = size > 30000000L ? ";memory=false" : "";
            }
            conn = DriverManager.getConnection("jdbc:ucanaccess://" + fl.getAbsolutePath() + passwordEntry + noMem, info);
            for (SQLWarning sqlw = conn.getWarnings(); sqlw != null; sqlw = sqlw.getNextWarning()) {
                System.out.println(sqlw.getMessage());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println(e.getMessage());
            System.exit(1);
        }
        Main main = new Main(conn, input);
        main.sayHello(conn.getMetaData().getDriverVersion());
        main.start();
    }

    public static void setBatchMode(boolean batchMode) {
        Main.batchMode = batchMode;
    }

    public void consoleDump(ResultSet rs, PrintStream out) throws SQLException {
        int i;
        ResultSetMetaData meta = rs.getMetaData();
        int cols = meta.getColumnCount();
        StringBuilder header = new StringBuilder("| ");
        for (int i2 = 1; i2 <= cols; ++i2) {
            header.append(meta.getColumnLabel(i2));
            header.append(" | ");
        }
        StringBuilder interline = new StringBuilder();
        for (i = 0; i < header.length(); ++i) {
            interline.append("-");
        }
        out.println(interline);
        out.println(header);
        out.println(interline);
        out.println();
        while (rs.next()) {
            System.out.print("| ");
            for (i = 1; i <= cols; ++i) {
                Object o = rs.getObject(i);
                if (o != null && o.getClass().isArray()) {
                    o = Arrays.toString((Object[])o);
                }
                out.print(o + " | ");
            }
            out.println();
            out.println();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeStatement(String sql) throws SQLException {
        Statement st = this.conn.createStatement();
        try {
            if (st.execute(sql)) {
                ResultSet rs = st.getResultSet();
                if (rs != null) {
                    this.consoleDump(rs, System.out);
                    this.lastSqlQuery = sql;
                } else {
                    System.out.println("Ok!");
                }
            } else {
                int num = st.getUpdateCount();
                this.prompt(num == 0 ? "No rows affected" : num + " row(s) affected");
            }
        }
        finally {
            st.close();
        }
    }

    private void prompt() {
        System.out.println();
        if (!batchMode) {
            System.out.print("UCanAccess>");
        }
    }

    private void prompt(String content) {
        if (!batchMode) {
            System.out.println("UCanAccess>" + content);
        }
    }

    private String readInput() {
        try {
            String ret = this.input.readLine();
            if (ret == null) {
                this.prompt("Ciao!");
                System.exit(0);
            }
            return ret.trim();
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    private void sayHello(String version) {
        this.prompt("");
        System.out.printf("Copyright (c) %d Marco Amadei%n", Calendar.getInstance().get(1));
        System.out.println("UCanAccess version " + version);
        System.out.println("You are connected!! ");
        System.out.println("Type quit to exit ");
        System.out.println();
        System.out.println("Commands end with ; ");
        System.out.println();
        System.out.println("Use:   ");
        System.out.printf("   %s;%n", EXPORT_USAGE);
        System.out.println("for exporting the result set from the last executed query or a specific table into a .csv file");
        this.prompt();
    }

    private void printExportHelp() {
        System.out.printf("Usage: %s;%n", EXPORT_USAGE);
        System.out.println("Export the most recent SQL query to the given <pathToCsv> file.");
        System.out.println("  -d <delimiter> Set the CSV column delimiter (default: ';').");
        System.out.println("  -t <table>     Output the <table> instead of the previous query.");
        System.out.println("  --big_query_schema <schemaFile>  Output the BigQuery schema to <schemaFile>.");
        System.out.println("  --bom          Output the UTF-8 byte order mark.");
        System.out.println("  --newlines     Preserve embedded newlines (\\r, \\n).");
        System.out.println("  --help         Print this help message.");
        System.out.println("Single (') or double (\") quoted strings are supported.");
        System.out.println("Backslash (\\) escaping (e.g. \\n, \\t) is enabled within quotes.");
        System.out.println("Use two backslashes (\\\\) to insert one backslash within quotes (e.g. \"c:\\\\temp\\\\newfile.csv\").");
    }

    private void start() {
        StringBuilder sb = new StringBuilder();
        while (this.connected) {
            String userInput = this.readInput();
            if (userInput.equalsIgnoreCase("quit")) {
                this.connected = false;
                break;
            }
            sb.append(" ").append(userInput);
            if (!userInput.endsWith(";")) continue;
            String cmd = sb.toString().substring(0, sb.length() - 1).trim();
            try {
                if (cmd.toLowerCase().startsWith("export ")) {
                    this.executeExport(cmd);
                } else {
                    this.executeStatement(cmd);
                }
            }
            catch (Exception e) {
                this.prompt(e.getMessage());
            }
            sb = new StringBuilder();
            this.prompt();
        }
        System.out.println("Cheers! Thank you for using the UCanAccess JDBC Driver.");
    }

    private void executeExport(String cmd) throws SQLException, FileNotFoundException, IOException {
        String sqlQuery;
        String arg;
        int i;
        List<String> tokens = Main.tokenize(cmd);
        Exporter.Builder exporterBuilder = new Exporter.Builder();
        String table = null;
        String schemaFileName = null;
        for (i = 1; i < tokens.size() && (arg = tokens.get(i)).startsWith("-"); ++i) {
            if ("-d".equals(arg)) {
                if (++i >= tokens.size()) {
                    this.prompt("Missing parameter for -d flag");
                    this.prompt(EXPORT_PROMPT);
                    return;
                }
                exporterBuilder.setDelimiter(tokens.get(i));
                continue;
            }
            if ("-t".equals(arg)) {
                if (++i >= tokens.size()) {
                    this.prompt("Missing parameter for -t flag");
                    this.prompt(EXPORT_PROMPT);
                    return;
                }
                table = tokens.get(i);
                continue;
            }
            if ("--bom".equals(arg)) {
                exporterBuilder.includeBom(true);
                continue;
            }
            if ("--newlines".equals(arg)) {
                exporterBuilder.preserveNewlines(true);
                continue;
            }
            if ("--big_query_schema".equals(arg)) {
                if (++i >= tokens.size()) {
                    this.prompt("Missing parameter for --big_query_schema flag");
                    this.prompt(EXPORT_PROMPT);
                    return;
                }
                schemaFileName = tokens.get(i);
                continue;
            }
            if ("--help".equals(arg)) {
                this.printExportHelp();
                return;
            }
            if ("--".equals(arg)) {
                ++i;
                break;
            }
            this.prompt("Unknown flag " + arg);
            this.prompt(EXPORT_PROMPT);
            return;
        }
        if (i >= tokens.size()) {
            this.prompt("File name not found");
            this.prompt(EXPORT_PROMPT);
            return;
        }
        if (i < tokens.size() - 1) {
            this.prompt("Too many arguments");
            this.prompt(EXPORT_PROMPT);
            return;
        }
        String csvFileName = tokens.get(i);
        Exporter exporter = exporterBuilder.build();
        if (table != null && !table.isEmpty()) {
            sqlQuery = "select * from [" + table + "]";
        } else if (this.lastSqlQuery != null) {
            sqlQuery = this.lastSqlQuery;
        } else {
            this.prompt("You must first execute an SQL query, then export the ResultSet!");
            return;
        }
        this.exportCsvAndSchema(sqlQuery, csvFileName, schemaFileName, exporter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exportCsvAndSchema(String sqlQuery, String csvFileName, String schemaFileName, Exporter exporter) throws SQLException, IOException {
        block10: {
            Statement statement = this.conn.createStatement();
            try {
                ResultSet rs = statement.executeQuery(sqlQuery);
                File csvFile = new File(csvFileName);
                PrintStream out = new PrintStream(csvFile);
                try {
                    exporter.dumpCsv(rs, out);
                    out.flush();
                }
                finally {
                    out.close();
                }
                this.prompt("Created CSV file: " + csvFile.getAbsolutePath());
                if (schemaFileName == null) break block10;
                File schemaFile = new File(schemaFileName);
                out = new PrintStream(schemaFile);
                try {
                    exporter.dumpSchema(rs, out);
                    out.flush();
                }
                finally {
                    out.close();
                }
                this.prompt("Created schema file: " + schemaFile.getAbsolutePath());
            }
            finally {
                statement.close();
            }
        }
    }

    static List<String> tokenize(String s) throws IOException {
        int ttype;
        StreamTokenizer st = new StreamTokenizer(new StringReader(s));
        st.resetSyntax();
        st.wordChars(33, 255);
        st.whitespaceChars(0, 32);
        st.quoteChar(34);
        st.quoteChar(39);
        ArrayList<String> tokens = new ArrayList<String>();
        while ((ttype = st.nextToken()) != -1) {
            if (ttype == -3) {
                tokens.add(st.sval);
                continue;
            }
            if (ttype != 39 && ttype != 34) continue;
            tokens.add(st.sval);
        }
        return tokens;
    }
}

