/*
 * Decompiled with CFR 0.152.
 */
package com.edb.jms.message;

import com.edb.jms.message.EDBMessageSession;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Enumeration;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageNotReadableException;
import javax.jms.MessageNotWriteableException;

public class EDBMessageImpl
implements Message,
Externalizable,
Cloneable {
    static final long serialVersionUID = 1L;
    private EDBMessageSession _session = null;
    protected boolean _propertiesReadOnly = false;
    protected boolean _bodyReadOnly = false;
    protected long _acceptedTime;
    protected long _sequenceNumber;
    protected transient long _connectionId;
    protected boolean _processed = false;
    protected static final byte[] EMPTY = new byte[0];

    public Object clone() throws CloneNotSupportedException {
        EDBMessageImpl result = (EDBMessageImpl)super.clone();
        return result;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeLong(1L);
        out.writeBoolean(this._propertiesReadOnly || this._bodyReadOnly);
        out.writeBoolean(this._processed);
        out.writeLong(this._acceptedTime);
        out.writeLong(this._sequenceNumber);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        boolean readOnly;
        long version = in.readLong();
        if (version != 1L) {
            throw new IOException("Incorrect version enountered: " + version + ". This version = " + 1L);
        }
        this._propertiesReadOnly = readOnly = in.readBoolean();
        this._bodyReadOnly = readOnly;
        this._processed = in.readBoolean();
        this._acceptedTime = in.readLong();
        this._sequenceNumber = in.readLong();
    }

    public void setSession(EDBMessageSession session) {
        this._session = session;
    }

    @Override
    public String getJMSMessageID() throws JMSException {
        return null;
    }

    @Override
    public void setJMSMessageID(String id) throws JMSException {
    }

    public String getAckMessageID() {
        return null;
    }

    @Override
    public long getJMSTimestamp() throws JMSException {
        return 0L;
    }

    @Override
    public void setJMSTimestamp(long timestamp) throws JMSException {
    }

    public String getWildcard() {
        return null;
    }

    public void setWildcard(String wildcard) {
    }

    public long getConsumerId() {
        return 0L;
    }

    public void setConsumerId(long consumerId) {
    }

    @Override
    public void setJMSCorrelationIDAsBytes(byte[] correlationID) throws JMSException {
    }

    @Override
    public void setJMSCorrelationID(String correlationID) throws JMSException {
    }

    @Override
    public String getJMSCorrelationID() throws JMSException {
        return null;
    }

    @Override
    public Destination getJMSReplyTo() throws JMSException {
        return null;
    }

    @Override
    public void setJMSReplyTo(Destination replyTo) throws JMSException {
    }

    @Override
    public Destination getJMSDestination() throws JMSException {
        return null;
    }

    @Override
    public void setJMSDestination(Destination destination) throws JMSException {
    }

    @Override
    public int getJMSDeliveryMode() throws JMSException {
        return 0;
    }

    @Override
    public void setJMSDeliveryMode(int deliveryMode) throws JMSException {
    }

    @Override
    public boolean getJMSRedelivered() throws JMSException {
        return false;
    }

    @Override
    public void setJMSRedelivered(boolean redelivered) throws JMSException {
    }

    @Override
    public String getJMSType() throws JMSException {
        return null;
    }

    @Override
    public void setJMSType(String type) throws JMSException {
    }

    @Override
    public long getJMSExpiration() throws JMSException {
        return 0L;
    }

    @Override
    public void setJMSExpiration(long expiration) throws JMSException {
    }

    @Override
    public int getJMSPriority() throws JMSException {
        return 0;
    }

    @Override
    public void setJMSPriority(int priority) throws JMSException {
    }

    @Override
    public void clearProperties() throws JMSException {
        this._propertiesReadOnly = false;
    }

    @Override
    public boolean propertyExists(String name) throws JMSException {
        return false;
    }

    @Override
    public boolean getBooleanProperty(String name) throws JMSException {
        return false;
    }

    @Override
    public short getShortProperty(String name) throws JMSException {
        return 0;
    }

    @Override
    public int getIntProperty(String name) throws JMSException {
        return 0;
    }

    @Override
    public long getLongProperty(String name) throws JMSException {
        return 0L;
    }

    @Override
    public float getFloatProperty(String name) throws JMSException {
        return 0.0f;
    }

    @Override
    public double getDoubleProperty(String name) throws JMSException {
        return 0.0;
    }

    @Override
    public String getStringProperty(String name) throws JMSException {
        return null;
    }

    @Override
    public Object getObjectProperty(String name) throws JMSException {
        return null;
    }

    @Override
    public void acknowledge() throws JMSException {
        if (this.getAckMessageID() == null) {
            throw new JMSException("Cannot acknowledge message: no identifier");
        }
        if (this._session == null) {
            throw new JMSException("Cannot acknowledge message: unknown session");
        }
        this._session.acknowledgeMessage(this);
    }

    @Override
    public void clearBody() throws JMSException {
        this._bodyReadOnly = false;
    }

    public final void checkPropertyWrite() throws MessageNotWriteableException {
        if (this._propertiesReadOnly) {
            throw new MessageNotWriteableException("Message in read-only mode");
        }
    }

    public final void checkWrite() throws MessageNotWriteableException {
        if (this._bodyReadOnly) {
            throw new MessageNotWriteableException("Message in read-only mode");
        }
    }

    public final void checkRead() throws MessageNotReadableException {
        if (!this._bodyReadOnly) {
            throw new MessageNotReadableException("Message in write-only mode");
        }
    }

    public String getId() {
        return null;
    }

    public void setAcceptedTime(long time) {
        this._acceptedTime = time;
    }

    public long getAcceptedTime() {
        return this._acceptedTime;
    }

    public void setSequenceNumber(long seq) {
        this._sequenceNumber = seq;
    }

    public long getSequenceNumber() {
        return this._sequenceNumber;
    }

    public void setConnectionId(long id) {
        this._connectionId = id;
    }

    public long getConnectionId() {
        return this._connectionId;
    }

    public void setProcessed(boolean state) {
        this._processed = state;
    }

    public boolean getProcessed() {
        return this._processed;
    }

    public void setReadOnly(boolean readOnly) throws JMSException {
        this._propertiesReadOnly = readOnly;
        this._bodyReadOnly = readOnly;
    }

    public final boolean getReadOnly() {
        return this._propertiesReadOnly && this._bodyReadOnly;
    }

    public void setJMSXRcvTimestamp(long timestamp) {
    }

    @Override
    public long getJMSDeliveryTime() throws JMSException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setJMSDeliveryTime(long arg0) throws JMSException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public <T> T getBody(Class<T> arg0) throws JMSException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean isBodyAssignableTo(Class arg0) throws JMSException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public byte[] getJMSCorrelationIDAsBytes() throws JMSException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public byte getByteProperty(String arg0) throws JMSException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Enumeration getPropertyNames() throws JMSException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setBooleanProperty(String arg0, boolean arg1) throws JMSException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setByteProperty(String arg0, byte arg1) throws JMSException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setShortProperty(String arg0, short arg1) throws JMSException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setIntProperty(String arg0, int arg1) throws JMSException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setLongProperty(String arg0, long arg1) throws JMSException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setFloatProperty(String arg0, float arg1) throws JMSException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setDoubleProperty(String arg0, double arg1) throws JMSException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setStringProperty(String arg0, String arg1) throws JMSException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setObjectProperty(String arg0, Object arg1) throws JMSException {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

