/*
 * Decompiled with CFR 0.152.
 */
package com.edb.core;

import com.edb.core.Field;
import com.edb.core.Query;
import com.edb.core.ResultCursor;
import com.edb.core.ResultHandler;
import com.edb.core.Tuple;
import com.edb.shaded.org.checkerframework.checker.nullness.qual.Nullable;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.List;

public class ResultHandlerDelegate
implements ResultHandler {
    private final @Nullable ResultHandler delegate;

    public ResultHandlerDelegate(@Nullable ResultHandler delegate) {
        this.delegate = delegate;
    }

    @Override
    public void handleResultRows(Query fromQuery, Field[] fields, List<Tuple> tuples, @Nullable ResultCursor cursor) {
        if (this.delegate != null) {
            this.delegate.handleResultRows(fromQuery, fields, tuples, cursor);
        }
    }

    @Override
    public void handleCommandStatus(String status, long updateCount, long insertOID) {
        if (this.delegate != null) {
            this.delegate.handleCommandStatus(status, updateCount, insertOID);
        }
    }

    @Override
    public void handleWarning(SQLWarning warning) {
        if (this.delegate != null) {
            this.delegate.handleWarning(warning);
        }
    }

    @Override
    public void handleError(SQLException error) {
        if (this.delegate != null) {
            this.delegate.handleError(error);
        }
    }

    @Override
    public void handleCompletion() throws SQLException {
        if (this.delegate != null) {
            this.delegate.handleCompletion();
        }
    }

    @Override
    public void secureProgress() {
        if (this.delegate != null) {
            this.delegate.secureProgress();
        }
    }

    @Override
    public @Nullable SQLException getException() {
        if (this.delegate != null) {
            return this.delegate.getException();
        }
        return null;
    }

    @Override
    public @Nullable SQLWarning getWarning() {
        if (this.delegate != null) {
            return this.delegate.getWarning();
        }
        return null;
    }

    @Override
    public void notifyCommandStatus(String message) {
    }
}

