/*
 * Decompiled with CFR 0.152.
 */
package com.edb.core;

import com.edb.core.BaseQueryKey;
import com.edb.core.CachedQuery;
import com.edb.core.CallableQueryKey;
import com.edb.core.JdbcCallParseInfo;
import com.edb.core.NativeQuery;
import com.edb.core.Parser;
import com.edb.core.Query;
import com.edb.core.QueryExecutor;
import com.edb.core.QueryWithReturningColumnsKey;
import com.edb.jdbc.PreferQueryMode;
import com.edb.util.LruCache;
import com.edb.util.internal.Nullness;
import java.sql.SQLException;
import java.util.List;

class CachedQueryCreateAction
implements LruCache.CreateAction<Object, CachedQuery> {
    private static final String[] EMPTY_RETURNING = new String[0];
    private final QueryExecutor queryExecutor;

    CachedQueryCreateAction(QueryExecutor queryExecutor) {
        this.queryExecutor = queryExecutor;
    }

    @Override
    public CachedQuery create(Object key) throws SQLException {
        boolean isCallable;
        boolean outParmBeforeFunc;
        boolean isFunction;
        String parsedSql;
        BaseQueryKey queryKey;
        assert (key instanceof String || key instanceof BaseQueryKey) : "Query key should be String or BaseQueryKey. Given " + key.getClass() + ", sql: " + key;
        if (key instanceof BaseQueryKey) {
            queryKey = (BaseQueryKey)key;
            parsedSql = queryKey.sql;
        } else {
            queryKey = null;
            parsedSql = (String)key;
        }
        if (key instanceof String || Nullness.castNonNull(queryKey).escapeProcessing) {
            parsedSql = Parser.replaceProcessing(parsedSql, true, this.queryExecutor.getStandardConformingStrings());
        }
        if (key instanceof CallableQueryKey) {
            JdbcCallParseInfo callInfo = Parser.modifyJdbcCall(parsedSql, this.queryExecutor.getStandardConformingStrings(), this.queryExecutor.getServerVersionNum(), this.queryExecutor.getProtocolVersion(), this.queryExecutor.getEscapeSyntaxCallMode(), this.queryExecutor.getEdbServer());
            parsedSql = callInfo.getSql();
            isFunction = callInfo.isFunction();
            outParmBeforeFunc = callInfo.isOutParmBeforeFunc();
            isCallable = callInfo.isCallable();
        } else {
            isFunction = false;
            outParmBeforeFunc = false;
            isCallable = false;
        }
        boolean isParameterized = key instanceof String || Nullness.castNonNull(queryKey).isParameterized;
        boolean splitStatements = isParameterized || this.queryExecutor.getPreferQueryMode().compareTo(PreferQueryMode.EXTENDED) >= 0;
        String[] returningColumns = key instanceof QueryWithReturningColumnsKey ? ((QueryWithReturningColumnsKey)key).columnNames : EMPTY_RETURNING;
        List<NativeQuery> queries = Parser.parseJdbcSql(parsedSql, this.queryExecutor.getStandardConformingStrings(), isParameterized, splitStatements, this.queryExecutor.isReWriteBatchedInsertsEnabled(), this.queryExecutor.getQuoteReturningIdentifiers(), this.queryExecutor.getSkipQuotesOnReturning(), this.queryExecutor.getAllowMultipleQueryPerStatement(), returningColumns);
        Query query = this.queryExecutor.wrap(queries);
        return new CachedQuery(key, query, isFunction, outParmBeforeFunc, isCallable);
    }
}

