/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.dc.client.model.role;

import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.security.user.SMRole;

public class DCRole {
    private final String roleId;
    private final String name;
    private final String description;

    public DCRole(String roleId, String name, String description) {
        this.roleId = roleId;
        this.name = name;
        this.description = description;
    }

    public String getRoleId() {
        return this.roleId;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String toString() {
        return this.roleId;
    }

    public static DCRole fromSMRole(SMRole webRole) {
        return new DCRole(webRole.getRoleId(), webRole.getName(), webRole.getDescription());
    }

    @Nullable
    public static SMRole toSMRole(@Nullable DCRole dcRole) {
        if (dcRole == null) {
            return null;
        }
        SMRole webRole = new SMRole(dcRole.getRoleId());
        webRole.setDescription(dcRole.getDescription());
        webRole.setName(dcRole.getName());
        return webRole;
    }
}

