/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.dc.client.internal;

import com.dbeaver.ee.dc.client.DCClientConfiguration;
import com.dbeaver.ee.dc.client.model.DCAdminRolesService;
import com.dbeaver.ee.dc.client.model.DCAdminSubjectsService;
import com.dbeaver.ee.dc.client.model.DCAdminUserService;
import com.dbeaver.ee.dc.client.model.DCAuthService;
import com.dbeaver.ee.dc.client.model.DCSessionsService;
import com.dbeaver.ee.dc.client.model.DCSubjectsService;
import com.dbeaver.ee.dc.client.model.DCUsersService;
import com.dbeaver.ee.dc.client.model.role.DCRole;
import com.dbeaver.ee.dc.client.model.role.DCRoleCreateRequest;
import com.dbeaver.ee.dc.client.model.role.DCRoleUpdateRequest;
import com.dbeaver.ee.dc.client.model.session.DCSessionAuthRequest;
import com.dbeaver.ee.dc.client.model.session.DCSessionUpdateRequest;
import com.dbeaver.ee.dc.client.model.subjects.DCDataSourceSubjectAccessUpdateRequest;
import com.dbeaver.ee.dc.client.model.subjects.DCSubjectUpdateDataSourceAccessRequest;
import com.dbeaver.ee.dc.client.model.subjects.DCSubjectUpdatePermissionsRequest;
import com.dbeaver.ee.dc.client.model.user.DCEnableUserUpdateRequest;
import com.dbeaver.ee.dc.client.model.user.DCUser;
import com.dbeaver.ee.dc.client.model.user.DCUserByCredentialsSearchRequest;
import com.dbeaver.ee.dc.client.model.user.DCUserCreateRequest;
import com.dbeaver.ee.dc.client.model.user.DCUserRolesUpdateRequest;
import com.dbeaver.ee.dc.client.model.user.DCUserUpdateCredentialsRequest;
import com.dbeaver.ee.dc.client.model.user.DCUserUpdateParameterRequest;
import com.dbeaver.remote.client.AbstractRemoteClient;
import com.dbeaver.remote.client.interceptor.DCAuthInterceptor;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.auth.SMAuthInfo;
import org.jkiss.dbeaver.model.security.SMDataSourceGrant;
import org.jkiss.dbeaver.model.security.exception.SMException;
import org.jkiss.dbeaver.model.security.user.SMAuthPermissions;
import org.jkiss.utils.CommonUtils;

public class DCSecurityControllerClient
extends AbstractRemoteClient
implements DCAdminUserService,
DCUsersService,
DCAdminRolesService,
DCSessionsService,
DCAdminSubjectsService,
DCSubjectsService,
DCAuthService {
    private static final String ROLES = "roles";
    private static final String CREDENTIALS = "credentials";
    private static final String PERMISSIONS = "permissions";
    private static final String SUBJECTS = "subjects";
    private static final String ADMIN_ENDPOINTS = "admin";
    private static final String ADMIN_ROLES_ENDPOINTS = DCSecurityControllerClient.buildEndpointUrl((String[])new String[]{"admin", "roles"});
    private static final String SESSIONS_ENDPOINTS = "sessions";
    private static final String AUTH_ENDPOINTS = "auth";
    private static final String USERS_ENDPOINTS = "users";
    private static final String ADMIN_USERS_ENDPOINTS = DCSecurityControllerClient.buildEndpointUrl((String[])new String[]{"admin", "users"});
    private static final String SUBJECTS_ENDPOINTS = "subjects";
    private static final String SUBJECTS_DATA_SOURCES_ENDPOINTS = DCSecurityControllerClient.buildEndpointUrl((String[])new String[]{"subjects", "dataSources"});
    private static final String ADMIN_SUBJECTS_ENDPOINTS = DCSecurityControllerClient.buildEndpointUrl((String[])new String[]{"admin", "subjects"});

    public DCSecurityControllerClient(DCClientConfiguration dcClientConfiguration) {
        super(dcClientConfiguration.getApiUrl(), List.of(new DCAuthInterceptor(dcClientConfiguration.getCredentialsProvider().getActiveUserCredentials())));
    }

    protected void handleRequestException(Exception e) throws DBException {
        throw new SMException(e.getMessage(), (Throwable)e);
    }

    @Override
    public DCUser[] findUsers(@Nullable String userNameMask) throws DBException {
        HashMap<String, String> queryParams = new HashMap<String, String>();
        if (CommonUtils.isNotEmpty((String)userNameMask)) {
            queryParams.put("userNameMask", userNameMask);
        }
        return (DCUser[])this.executeGetRequest(ADMIN_USERS_ENDPOINTS, queryParams, (Type)((Object)DCUser[].class));
    }

    @Override
    public void createUser(DCUserCreateRequest userCreateRequest) throws DBException {
        this.executePostRequest(ADMIN_USERS_ENDPOINTS, userCreateRequest, (Type)((Object)Void.class));
    }

    @Override
    public void deleteUser(String userId) throws DBException {
        this.executeDeleteRequest(DCSecurityControllerClient.buildEndpointUrl((String[])new String[]{ADMIN_USERS_ENDPOINTS, userId}), (Type)((Object)Void.class));
    }

    @Override
    public void updateUserRoles(String userId, DCUserRolesUpdateRequest rolesUpdateRequest) throws DBException {
        String endpointUrl = DCSecurityControllerClient.buildEndpointUrl((String[])new String[]{ADMIN_USERS_ENDPOINTS, userId, ROLES});
        this.executePutRequest(endpointUrl, rolesUpdateRequest, (Type)((Object)Void.class));
    }

    @Override
    public List<DCRole> getUserRoles(String userId) throws DBException {
        String endpointUrl = DCSecurityControllerClient.buildEndpointUrl((String[])new String[]{USERS_ENDPOINTS, userId, ROLES});
        return (List)this.executeGetRequest(endpointUrl, TypeToken.getParameterized(List.class, (Type[])new Type[]{DCRole.class}).getType());
    }

    @Override
    public DCUser getUserById(String userId) throws DBException {
        return (DCUser)this.executeGetRequest(DCSecurityControllerClient.buildEndpointUrl((String[])new String[]{USERS_ENDPOINTS, userId}), (Type)((Object)DCUser.class));
    }

    @Override
    public Map<String, Object> getUserParameters(String userId) throws DBException {
        return (Map)this.executeGetRequest(DCSecurityControllerClient.buildEndpointUrl((String[])new String[]{USERS_ENDPOINTS, userId, "parameters"}), new TypeToken<HashMap<String, Object>>(){}.getType());
    }

    @Override
    public void setUserParameter(String userId, DCUserUpdateParameterRequest userUpdateParameterRequest) throws DBException {
        this.executePutRequest(DCSecurityControllerClient.buildEndpointUrl((String[])new String[]{USERS_ENDPOINTS, userId}), userUpdateParameterRequest, (Type)((Object)Void.class));
    }

    @Override
    public void setUserCredentials(String userId, DCUserUpdateCredentialsRequest updateCredentialsRequest) throws DBException {
        this.executePutRequest(DCSecurityControllerClient.buildEndpointUrl((String[])new String[]{USERS_ENDPOINTS, userId, CREDENTIALS}), updateCredentialsRequest, (Type)((Object)Void.class));
    }

    @Nullable
    public String getUserByCredentials(DCUserByCredentialsSearchRequest searchRequest) throws DBException {
        String url = DCSecurityControllerClient.buildEndpointUrl((String[])new String[]{USERS_ENDPOINTS, CREDENTIALS, "search"});
        return (String)this.executePostRequest(url, searchRequest, (Type)((Object)String.class));
    }

    @Override
    public Map<String, Object> getUserCredentials(String userId, String authProviderId) throws DBException {
        String url = DCSecurityControllerClient.buildEndpointUrl((String[])new String[]{USERS_ENDPOINTS, userId, CREDENTIALS});
        Map<String, String> queryParams = Map.of("authProviderId", authProviderId);
        return (Map)this.executeGetRequest(url, queryParams, new TypeToken<HashMap<String, Object>>(){}.getType());
    }

    @Override
    public String[] getUserLinkedProviders(String userId) throws DBException {
        String url = DCSecurityControllerClient.buildEndpointUrl((String[])new String[]{USERS_ENDPOINTS, userId, "providers"});
        return (String[])this.executeGetRequest(url, (Type)((Object)String[].class));
    }

    @Override
    @NotNull
    public Set<String> getUserPermissions(String userId) throws DBException {
        String url = DCSecurityControllerClient.buildEndpointUrl((String[])new String[]{USERS_ENDPOINTS, userId, PERMISSIONS});
        return (Set)this.executeGetRequest(url, TypeToken.getParameterized(HashSet.class, (Type[])new Type[]{String.class}).getType());
    }

    @Override
    public void updateUserMeta(String userId, Map<String, Object> metaParameters) throws DBException {
        String url = DCSecurityControllerClient.buildEndpointUrl((String[])new String[]{ADMIN_USERS_ENDPOINTS, userId, "meta"});
        this.executePutRequest(url, metaParameters, (Type)((Object)Void.class));
    }

    @Override
    public void enableUser(String userId, DCEnableUserUpdateRequest userIsEnabledUpdateRequest) throws DBException {
        String url = DCSecurityControllerClient.buildEndpointUrl((String[])new String[]{ADMIN_USERS_ENDPOINTS, userId, "enable"});
        this.executePutRequest(url, userIsEnabledUpdateRequest, (Type)((Object)Void.class));
    }

    @Override
    public List<DCRole> getAllRoles() throws DBException {
        return (List)this.executeGetRequest(ADMIN_ROLES_ENDPOINTS, TypeToken.getParameterized(ArrayList.class, (Type[])new Type[]{DCRole.class}).getType());
    }

    @Override
    public void createRole(DCRoleCreateRequest roleCreateRequest) throws DBException {
        this.executePostRequest(ADMIN_ROLES_ENDPOINTS, roleCreateRequest, (Type)((Object)Void.class));
    }

    @Override
    public void updateRole(String roleId, DCRoleUpdateRequest roleUpdateRequest) throws DBException {
        this.executePutRequest(DCSecurityControllerClient.buildEndpointUrl((String[])new String[]{ADMIN_ROLES_ENDPOINTS, roleId}), roleUpdateRequest, (Type)((Object)Void.class));
    }

    @Override
    public String[] getRoleSubjects(String roleId) throws DBException {
        String url = DCSecurityControllerClient.buildEndpointUrl((String[])new String[]{ADMIN_ROLES_ENDPOINTS, roleId, "subjects"});
        return (String[])this.executeGetRequest(url, (Type)((Object)String[].class));
    }

    @Override
    public DCRole findRole(String roleId) throws DBException {
        return (DCRole)this.executeGetRequest(DCSecurityControllerClient.buildEndpointUrl((String[])new String[]{ADMIN_ROLES_ENDPOINTS, roleId}), (Type)((Object)DCRole.class));
    }

    @Override
    public void deleteRole(String roleId) throws DBException {
        this.executeDeleteRequest(DCSecurityControllerClient.buildEndpointUrl((String[])new String[]{ADMIN_ROLES_ENDPOINTS, roleId}), (Type)((Object)Void.class));
    }

    @Override
    public SMAuthInfo authenticate(DCSessionAuthRequest sessionCreateRequest) throws DBException {
        return (SMAuthInfo)this.executePostRequest(AUTH_ENDPOINTS, sessionCreateRequest, (Type)((Object)SMAuthInfo.class));
    }

    @Override
    public SMAuthPermissions currentAuthInfo() throws DBException {
        return (SMAuthPermissions)this.executeGetRequest(DCSecurityControllerClient.buildEndpointUrl((String[])new String[]{AUTH_ENDPOINTS, "info"}), Map.of(), (Type)((Object)SMAuthPermissions.class));
    }

    @Override
    public void updateSession(String sessionId, DCSessionUpdateRequest sessionUpdateRequest) throws DBException {
        this.executePutRequest(DCSecurityControllerClient.buildEndpointUrl((String[])new String[]{SESSIONS_ENDPOINTS, sessionId}), sessionUpdateRequest, (Type)((Object)Void.class));
    }

    @Override
    public boolean isSessionPersisted(String sessionId) throws DBException {
        return (Boolean)this.executeGetRequest(DCSecurityControllerClient.buildEndpointUrl((String[])new String[]{SESSIONS_ENDPOINTS, sessionId, "persistence"}), (Type)((Object)Boolean.class));
    }

    @Override
    public void setSubjectPermissions(String subjectId, DCSubjectUpdatePermissionsRequest subjectUpdatePermissionsRequest) throws DBException {
        String url = DCSecurityControllerClient.buildEndpointUrl((String[])new String[]{ADMIN_SUBJECTS_ENDPOINTS, subjectId, PERMISSIONS});
        this.executePutRequest(url, subjectUpdatePermissionsRequest, (Type)((Object)Void.class));
    }

    @Override
    public void setSubjectDataSourceAccess(@NotNull String subjectId, DCSubjectUpdateDataSourceAccessRequest subjectUpdateDataSourceAccessRequest) throws DBException {
        String url = DCSecurityControllerClient.buildEndpointUrl((String[])new String[]{ADMIN_SUBJECTS_ENDPOINTS, subjectId, "dataSources"});
        this.executePutRequest(url, subjectUpdateDataSourceAccessRequest, (Type)((Object)Void.class));
    }

    @Override
    @NotNull
    public Set<String> getSubjectPermissions(String subjectId) throws DBException {
        String url = DCSecurityControllerClient.buildEndpointUrl((String[])new String[]{"subjects", subjectId, PERMISSIONS});
        return (Set)this.executeGetRequest(url, TypeToken.getParameterized(HashSet.class, (Type[])new Type[]{String.class}).getType());
    }

    @Override
    @NotNull
    public SMDataSourceGrant[] getSubjectDataSourceAccess(@NotNull String[] subjectIds) throws DBException {
        return (SMDataSourceGrant[])this.executeGetRequest(SUBJECTS_DATA_SOURCES_ENDPOINTS, Map.of("subjectId", subjectIds), (Type)((Object)SMDataSourceGrant[].class));
    }

    @Override
    @NotNull
    public SMDataSourceGrant[] getDataSourceSubjectAccess(String dataSourceId) throws DBException {
        String url = DCSecurityControllerClient.buildEndpointUrl((String[])new String[]{SUBJECTS_DATA_SOURCES_ENDPOINTS, dataSourceId});
        return (SMDataSourceGrant[])this.executeGetRequest(url, (Type)((Object)SMDataSourceGrant[].class));
    }

    @Override
    public void setDataSourceSubjectAccess(@NotNull String dataSourceId, DCDataSourceSubjectAccessUpdateRequest dataSourceSubjectAccessUpdateRequest) throws DBException {
        String url = DCSecurityControllerClient.buildEndpointUrl((String[])new String[]{SUBJECTS_DATA_SOURCES_ENDPOINTS, dataSourceId});
        this.executePutRequest(url, dataSourceSubjectAccessUpdateRequest, (Type)((Object)Void.class));
    }
}

