/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.dc.client.internal;

import com.dbeaver.ee.dc.client.DCClientConfiguration;
import com.dbeaver.ee.dc.client.model.DCLicenseService;
import com.dbeaver.ee.dc.client.model.license.DCLicense;
import com.dbeaver.ee.dc.client.model.license.DCLicenseImportRequest;
import com.dbeaver.remote.client.AbstractRemoteClient;
import com.dbeaver.remote.client.interceptor.DCAuthInterceptor;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.lm.LMException;
import org.jkiss.lm.LMProduct;

public class DCLicenseClient
extends AbstractRemoteClient
implements DCLicenseService {
    private static final String LICENSES = "licenses";

    public DCLicenseClient(DCClientConfiguration dcClientConfiguration) {
        super(dcClientConfiguration.getApiUrl(), List.of(new DCAuthInterceptor(dcClientConfiguration.getCredentialsProvider().getActiveUserCredentials())));
    }

    @Override
    public DCLicense getActiveProductLicense(boolean validate) throws LMException {
        try {
            String url = DCLicenseClient.buildEndpointUrl((String[])new String[]{LICENSES, "active"});
            return (DCLicense)this.executeGetRequest(url, Map.of("validate", validate), (Type)((Object)DCLicense.class));
        }
        catch (Exception e) {
            throw new LMException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public DCLicense[] getAllProductLicenses() throws LMException {
        try {
            return (DCLicense[])this.executeGetRequest(LICENSES, (Type)((Object)DCLicense[].class));
        }
        catch (Exception e) {
            throw new LMException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public DCLicense importProductLicense(DCLicenseImportRequest request) throws LMException {
        try {
            return (DCLicense)this.executePostRequest(LICENSES, request, (Type)((Object)DCLicense.class));
        }
        catch (Exception e) {
            throw new LMException("Error importing license", (Throwable)e);
        }
    }

    @Override
    public boolean invalidateLicense() throws LMException {
        try {
            String url = DCLicenseClient.buildEndpointUrl((String[])new String[]{LICENSES, "invalidate"});
            return (Boolean)this.executeGetRequest(url, (Type)((Object)Boolean.class));
        }
        catch (Exception e) {
            throw new LMException("Error invalidating license", (Throwable)e);
        }
    }

    public LMProduct getActiveProduct() throws LMException {
        try {
            String url = DCLicenseClient.buildEndpointUrl((String[])new String[]{LICENSES, "product"});
            return (LMProduct)this.executeGetRequest(url, (Type)((Object)LMProduct.class));
        }
        catch (Exception e) {
            throw new LMException(e.getMessage(), (Throwable)e);
        }
    }

    protected void handleRequestException(Exception e) throws DBCException {
        throw new DBCException(e.getMessage(), (Throwable)e);
    }
}

