/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.dc.client;

import com.dbeaver.ee.dc.client.DCClientConfiguration;
import com.dbeaver.ee.dc.client.internal.DCSecurityControllerClient;
import com.dbeaver.ee.dc.client.model.role.DCRole;
import com.dbeaver.ee.dc.client.model.role.DCRoleCreateRequest;
import com.dbeaver.ee.dc.client.model.role.DCRoleUpdateRequest;
import com.dbeaver.ee.dc.client.model.session.DCSessionAuthRequest;
import com.dbeaver.ee.dc.client.model.session.DCSessionUpdateRequest;
import com.dbeaver.ee.dc.client.model.subjects.DCDataSourceSubjectAccessUpdateRequest;
import com.dbeaver.ee.dc.client.model.subjects.DCSubjectUpdateDataSourceAccessRequest;
import com.dbeaver.ee.dc.client.model.subjects.DCSubjectUpdatePermissionsRequest;
import com.dbeaver.ee.dc.client.model.user.DCEnableUserUpdateRequest;
import com.dbeaver.ee.dc.client.model.user.DCUser;
import com.dbeaver.ee.dc.client.model.user.DCUserCreateRequest;
import com.dbeaver.ee.dc.client.model.user.DCUserRolesUpdateRequest;
import com.dbeaver.ee.dc.client.model.user.DCUserUpdateCredentialsRequest;
import com.dbeaver.ee.dc.client.model.user.DCUserUpdateParameterRequest;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.auth.SMAuthInfo;
import org.jkiss.dbeaver.model.security.SMAdminController;
import org.jkiss.dbeaver.model.security.SMDataSourceGrant;
import org.jkiss.dbeaver.model.security.SMSessionType;
import org.jkiss.dbeaver.model.security.user.SMAuthPermissions;
import org.jkiss.dbeaver.model.security.user.SMRole;
import org.jkiss.dbeaver.model.security.user.SMUser;

public class DCRemoteSecurityController
implements SMAdminController {
    private final DCSecurityControllerClient dcClient;

    public DCRemoteSecurityController(DCClientConfiguration dcClientConfiguration) {
        this.dcClient = new DCSecurityControllerClient(dcClientConfiguration);
    }

    public Map<String, Object> getUserCredentials(String userId, String authProviderId) throws DBException {
        return this.dcClient.getUserCredentials(userId, authProviderId);
    }

    public void createUser(String userId, Map<String, String> metaParameters) throws DBException {
        this.dcClient.createUser(DCUserCreateRequest.builder(userId, metaParameters).build());
    }

    public void deleteUser(String userId) throws DBException {
        this.dcClient.deleteUser(userId);
    }

    public void setUserRoles(String userId, String[] roleIds, String grantorId) throws DBException {
        this.dcClient.updateUserRoles(userId, DCUserRolesUpdateRequest.builder().setRoleIds(Arrays.asList(roleIds)).build());
    }

    @NotNull
    public SMRole[] getUserRoles(String userId) throws DBException {
        return (SMRole[])this.dcClient.getUserRoles(userId).stream().map(DCRole::toSMRole).toArray(SMRole[]::new);
    }

    public SMUser getUserById(String userId) throws DBException {
        return DCUser.toWebUser(this.dcClient.getUserById(userId));
    }

    public Map<String, Object> getUserParameters(String userId) throws DBException {
        return this.dcClient.getUserParameters(userId);
    }

    public void setUserParameter(String userId, String name, Object value) throws DBException {
        this.dcClient.setUserParameter(userId, DCUserUpdateParameterRequest.builder().setName(name).setValue(value).build());
    }

    public void enableUser(String userId, boolean enabled) throws DBException {
        this.dcClient.enableUser(userId, DCEnableUserUpdateRequest.builder(enabled).build());
    }

    public void setUserCredentials(String userId, String authProviderId, Map<String, Object> credentials) throws DBException {
        this.dcClient.setUserCredentials(userId, DCUserUpdateCredentialsRequest.builder(authProviderId).setCredentials(credentials).build());
    }

    public String[] getUserLinkedProviders(String userId) throws DBException {
        return this.dcClient.getUserLinkedProviders(userId);
    }

    @NotNull
    public Set<String> getUserPermissions(String userId) throws DBException {
        return this.dcClient.getUserPermissions(userId);
    }

    public boolean isSessionPersisted(String id) throws DBException {
        return this.dcClient.isSessionPersisted(id);
    }

    public SMAuthInfo authenticateAnonymousUser(@NotNull String appSessionId, @NotNull Map<String, Object> sessionParameters, @NotNull SMSessionType sessionType) throws DBException {
        return this.dcClient.authenticate(DCSessionAuthRequest.builder(appSessionId).setSessionParameters(sessionParameters).setSessionType(sessionType).setAnonymousAuth(true).build());
    }

    public SMAuthInfo authenticate(@NotNull String appSessionId, @NotNull Map<String, Object> sessionParameters, @NotNull SMSessionType sessionType, @NotNull String authProviderId, @NotNull Map<String, Object> userCredentials) throws DBException {
        return this.dcClient.authenticate(DCSessionAuthRequest.builder(appSessionId).setSessionParameters(sessionParameters).setSessionType(sessionType).setAuthProviderId(authProviderId).setUserCredentials(userCredentials).build());
    }

    public void updateSession(@NotNull String sessionId, @Nullable String userId, Map<String, Object> parameters) throws DBException {
        this.dcClient.updateSession(sessionId, DCSessionUpdateRequest.builder().setUserId(userId).setParameters(parameters).build());
    }

    public void setSubjectPermissions(String subjectId, List<String> permissionIds, String grantorId) throws DBException {
        this.dcClient.setSubjectPermissions(subjectId, DCSubjectUpdatePermissionsRequest.builder().setPermissionIds(permissionIds).build());
    }

    public void setSubjectConnectionAccess(@NotNull String subjectId, @NotNull List<String> connectionIds, String grantor) throws DBException {
        this.dcClient.setSubjectDataSourceAccess(subjectId, DCSubjectUpdateDataSourceAccessRequest.builder().setDataSourceIds(connectionIds).build());
    }

    @NotNull
    public Set<String> getSubjectPermissions(String subjectId) throws DBException {
        return this.dcClient.getSubjectPermissions(subjectId);
    }

    @NotNull
    public SMDataSourceGrant[] getSubjectConnectionAccess(@NotNull String[] subjectId) throws DBException {
        return this.dcClient.getSubjectDataSourceAccess(subjectId);
    }

    @NotNull
    public SMDataSourceGrant[] getConnectionSubjectAccess(String connectionId) throws DBException {
        return this.dcClient.getDataSourceSubjectAccess(connectionId);
    }

    public void setConnectionSubjectAccess(@NotNull String connectionId, @Nullable String[] subjects, @Nullable String grantorId) throws DBException {
        this.dcClient.setDataSourceSubjectAccess(connectionId, DCDataSourceSubjectAccessUpdateRequest.builder().setSubjectIds(Arrays.asList(subjects)).build());
    }

    public SMAuthPermissions getTokenPermissions(String token) throws DBException {
        return this.dcClient.currentAuthInfo();
    }

    @NotNull
    public SMUser[] findUsers(String userNameMask) throws DBException {
        return (SMUser[])Arrays.stream(this.dcClient.findUsers(userNameMask)).map(dcUser -> new SMUser(dcUser.getUserId(), dcUser.getMetaParameters(), dcUser.isEnabled())).toArray(SMUser[]::new);
    }

    public void setUserMeta(String userId, Map<String, Object> metaParameters) throws DBException {
        this.dcClient.updateUserMeta(userId, metaParameters);
    }

    @NotNull
    public SMRole[] readAllRoles() throws DBException {
        return (SMRole[])this.dcClient.getAllRoles().stream().map(DCRole::toSMRole).toArray(SMRole[]::new);
    }

    public SMRole findRole(String roleId) throws DBException {
        return DCRole.toSMRole(this.dcClient.findRole(roleId));
    }

    @NotNull
    public String[] getRoleSubjects(String roleId) throws DBException {
        return this.dcClient.getRoleSubjects(roleId);
    }

    public void createRole(@NotNull String roleId, @Nullable String name, @Nullable String description, @NotNull String grantor) throws DBException {
        this.dcClient.createRole(DCRoleCreateRequest.builder(roleId, grantor).setName(name).setDescription(description).build());
    }

    public void updateRole(@NotNull String roleId, @Nullable String name, @Nullable String description) throws DBException {
        this.dcClient.updateRole(roleId, DCRoleUpdateRequest.builder().setName(name).setDescription(description).build());
    }

    public void deleteRole(String roleId) throws DBException {
        this.dcClient.deleteRole(roleId);
    }
}

