/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.dc.client;

import com.dbeaver.ee.dc.client.DCClientConfiguration;
import com.dbeaver.ee.dc.client.internal.DCLicenseClient;
import com.dbeaver.ee.dc.client.model.license.DCLicense;
import com.dbeaver.ee.dc.client.model.license.DCLicenseImportRequest;
import java.util.Arrays;
import org.jkiss.lm.LMException;
import org.jkiss.lm.LMLicense;
import org.jkiss.lm.LMProduct;
import org.jkiss.lm.LMService;
import org.jkiss.lm.LMSubscription;

public class DCRemoteLicenseService
implements LMService {
    private final DCLicenseClient dcLicenceClient;

    public DCRemoteLicenseService(DCClientConfiguration dcClientConfiguration) {
        this.dcLicenceClient = new DCLicenseClient(dcClientConfiguration);
    }

    public LMLicense getActiveProductLicense(boolean validate) throws LMException {
        DCLicense license = this.dcLicenceClient.getActiveProductLicense(validate);
        if (license == null) {
            return null;
        }
        return DCLicense.toLMLicense(license);
    }

    public LMLicense[] getAllProductLicenses() throws LMException {
        return (LMLicense[])Arrays.stream(this.dcLicenceClient.getAllProductLicenses()).map(DCLicense::toLMLicense).toArray(LMLicense[]::new);
    }

    public LMLicense importProductLicense(String licenseText) throws LMException {
        return DCLicense.toLMLicense(this.dcLicenceClient.importProductLicense(DCLicenseImportRequest.builder(licenseText).build()));
    }

    public LMProduct getActiveProduct() throws LMException {
        return this.dcLicenceClient.getActiveProduct();
    }

    public boolean invalidateActiveLicense(boolean forceRefresh) throws LMException {
        return this.dcLicenceClient.invalidateLicense();
    }

    public void validateLicense(LMLicense license) throws LMException {
        throw new LMException("Not implemented");
    }

    public String getLicenseStatus(LMLicense license) throws LMException {
        throw new LMException("Not implemented");
    }

    public LMSubscription getSubscriptionInfo(LMLicense license) throws LMException {
        throw new LMException("Not implemented");
    }

    public void deleteLicense(LMLicense license) throws LMException {
        throw new LMException("Not implemented");
    }
}

