CREATE TABLE QM_INFO (
    VERSION INTEGER AUTO_INCREMENT NOT NULL,
    UPDATE_TIME TIMESTAMP NOT NULL
);

CREATE TABLE QM_DBEAVER_DEPLOYMENT (
    DEPLOY_ID INTEGER AUTO_INCREMENT NOT NULL,
    INSTALL_PATH VARCHAR(1024) NOT NULL,
    HOST_NAME VARCHAR(1024) NOT NULL,
    UPDATE_TIME TIMESTAMP NOT NULL,

    PRIMARY KEY (DEPLOY_ID)
);

CREATE TABLE QM_DBEAVER_VERSION (
    VERSION_ID INTEGER AUTO_INCREMENT NOT NULL,
    VERSION_NAME VARCHAR(32) NOT NULL,

    UPDATE_DEPLOY_ID INTEGER NOT NULL,
    UPDATE_TIME TIMESTAMP NOT NULL,

    PRIMARY KEY (VERSION_ID),
    FOREIGN KEY (UPDATE_DEPLOY_ID) REFERENCES QM_DBEAVER_DEPLOYMENT(DEPLOY_ID)
);

CREATE TABLE QM_DBEAVER_WORKSPACE (
    WORKSPACE_ID INTEGER AUTO_INCREMENT NOT NULL,
    WORKSPACE_PATH VARCHAR(1024) NOT NULL,
    UPDATE_TIME TIMESTAMP NOT NULL,

    PRIMARY KEY (WORKSPACE_ID)
);

CREATE TABLE QM_DBEAVER_RUN (
    RUN_ID BIGINT AUTO_INCREMENT NOT NULL,
    DEPLOY_ID INTEGER NOT NULL,
    VERSION_ID INTEGER NOT NULL,
    WORKSPACE_ID INTEGER NOT NULL,
    HOST_NAME VARCHAR(255) NOT NULL,
    START_TIME TIMESTAMP NOT NULL,
    STOP_TIME TIMESTAMP,

    PRIMARY KEY (RUN_ID),
    FOREIGN KEY (DEPLOY_ID) REFERENCES QM_DBEAVER_DEPLOYMENT(DEPLOY_ID),
    FOREIGN KEY (VERSION_ID) REFERENCES QM_DBEAVER_VERSION(VERSION_ID),
    FOREIGN KEY (WORKSPACE_ID) REFERENCES QM_DBEAVER_WORKSPACE(WORKSPACE_ID)
);

CREATE TABLE QM_DATASOURCE (
    DATASOURCE_ID VARCHAR(100) NOT NULL,

    NAME VARCHAR(255) NOT NULL,
    DRIVER VARCHAR(255) NOT NULL,
    URL VARCHAR(1024) NOT NULL,
    UPDATE_TIME TIMESTAMP NOT NULL,

    PRIMARY KEY (DATASOURCE_ID)
);

CREATE TABLE QM_CONNECTION (
    CONNECTION_ID BIGINT AUTO_INCREMENT NOT NULL,
    RUN_ID BIGINT NOT NULL,
    DATASOURCE_ID VARCHAR(100) NOT NULL,
    INSTANCE_ID VARCHAR(64),

    CONTEXT_ID VARCHAR(64),
    CONTEXT_NAME VARCHAR(255),
    CONNECTION_USER VARCHAR(64),

    CONNECT_TIME TIMESTAMP NOT NULL,
    DISCONNECT_TIME TIMESTAMP,

    PRIMARY KEY (CONNECTION_ID),
    FOREIGN KEY (RUN_ID) REFERENCES QM_DBEAVER_RUN(RUN_ID),
    FOREIGN KEY (DATASOURCE_ID) REFERENCES QM_DATASOURCE(DATASOURCE_ID)
);

CREATE TABLE QM_EVENT_SOURCE (
    SOURCE_ID VARCHAR(64) NOT NULL,

    UPDATE_TIME TIMESTAMP NOT NULL,

    PRIMARY KEY (SOURCE_ID)
);

CREATE TABLE QM_EVENT (
    EVENT_ID BIGINT AUTO_INCREMENT NOT NULL,
    CONNECTION_ID BIGINT NOT NULL,
    SOURCE_ID VARCHAR(64),

    EVENT_ACTION INTEGER NOT NULL,
    EVENT_TYPE INTEGER NOT NULL,
    EVENT_TIME TIMESTAMP NOT NULL,

    PRIMARY KEY (EVENT_ID),
    FOREIGN KEY (CONNECTION_ID) REFERENCES QM_CONNECTION(CONNECTION_ID),
    FOREIGN KEY (SOURCE_ID) REFERENCES QM_EVENT_SOURCE(SOURCE_ID)
);

CREATE INDEX IDX_EVENT_ID_DESC ON QM_EVENT(EVENT_ID DESC);

CREATE TABLE QM_QUERY (
    QUERY_ID BIGINT AUTO_INCREMENT NOT NULL,
    QUERY_HASH BIGINT NOT NULL,

    QUERY_TEXT CLOB NOT NULL,

    PRIMARY KEY (QUERY_ID)
);

CREATE INDEX QM_QUERY_HASH_INDEX ON QM_QUERY(QUERY_HASH);

CREATE TABLE QM_QUERY_FILTER (
    FILTER_ID BIGINT AUTO_INCREMENT NOT NULL,
    QUERY_ID BIGINT NOT NULL,

    FILTER_HASH BIGINT NOT NULL,
    FILTER_TEXT CLOB NOT NULL,

    PRIMARY KEY (FILTER_ID),
    FOREIGN KEY (QUERY_ID) REFERENCES QM_QUERY(QUERY_ID)
);

CREATE INDEX QM_FILTER_HASH_INDEX ON QM_QUERY_FILTER(FILTER_HASH);

CREATE TABLE QM_STATEMENT (
    STATEMENT_ID BIGINT NOT NULL,

    STATEMENT_PURPOSE INTEGER NOT NULL,

    QUERY_ID BIGINT NOT NULL,
    ROW_COUNT INTEGER,
    ERROR_CODE INTEGER,
    ERROR_MESSAGE CLOB,

    EXECUTE_TIME INTEGER,
    FETCH_TIME INTEGER,

    PRIMARY KEY (STATEMENT_ID),
    FOREIGN KEY (STATEMENT_ID) REFERENCES QM_EVENT(EVENT_ID),
    FOREIGN KEY (QUERY_ID) REFERENCES QM_QUERY(QUERY_ID)
);
