/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.message.internal;

import com.couchbase.client.core.annotations.InterfaceAudience;
import com.couchbase.client.core.annotations.InterfaceStability;
import com.couchbase.client.core.message.internal.EndpointHealth;
import com.couchbase.client.core.service.ServiceType;
import com.couchbase.client.core.tracing.RingBufferDiagnostics;
import com.couchbase.client.core.utils.DefaultObjectMapper;
import com.couchbase.client.deps.com.fasterxml.jackson.core.JsonProcessingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;

@InterfaceAudience.Public
@InterfaceStability.Experimental
public class DiagnosticsReport {
    static final int VERSION = 1;
    private final int version;
    private final List<EndpointHealth> endpoints;
    private final String sdk;
    private final String id;
    private final RingBufferDiagnostics ringBufferDiagnostics;

    public DiagnosticsReport(List<EndpointHealth> endpoints, String sdk, String id, RingBufferDiagnostics ringBufferDiagnostics) {
        this.id = id == null ? UUID.randomUUID().toString() : id;
        this.endpoints = endpoints;
        this.version = 1;
        this.sdk = sdk;
        this.ringBufferDiagnostics = ringBufferDiagnostics;
    }

    public String id() {
        return this.id;
    }

    public String sdk() {
        return this.sdk;
    }

    public List<EndpointHealth> endpoints() {
        return this.endpoints;
    }

    public List<EndpointHealth> endpoints(ServiceType type) {
        ArrayList<EndpointHealth> filtered = new ArrayList<EndpointHealth>(this.endpoints.size());
        for (EndpointHealth h : this.endpoints) {
            if (!h.type().equals((Object)type)) continue;
            filtered.add(h);
        }
        return filtered;
    }

    public RingBufferDiagnostics ringBufferDiagnostics() {
        return this.ringBufferDiagnostics;
    }

    public String exportToJson() {
        return this.exportToJson(false);
    }

    public String exportToJson(boolean pretty) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        HashMap services = new HashMap();
        for (EndpointHealth h : this.endpoints) {
            String type = DiagnosticsReport.serviceTypeFromEnum(h.type());
            if (!services.containsKey(type)) {
                services.put(type, new ArrayList());
            }
            List eps = (List)services.get(type);
            eps.add(h.toMap());
        }
        result.put("version", this.version);
        result.put("services", services);
        result.put("sdk", this.sdk);
        result.put("id", this.id);
        try {
            if (pretty) {
                return DefaultObjectMapper.prettyWriter().writeValueAsString(result);
            }
            return DefaultObjectMapper.writeValueAsString(result);
        }
        catch (JsonProcessingException e) {
            throw new IllegalStateException("Could not encode as JSON string.", e);
        }
    }

    static String serviceTypeFromEnum(ServiceType type) {
        switch (type) {
            case VIEW: {
                return "view";
            }
            case BINARY: {
                return "kv";
            }
            case QUERY: {
                return "n1ql";
            }
            case CONFIG: {
                return "mgmt";
            }
            case SEARCH: {
                return "fts";
            }
            case ANALYTICS: {
                return "cbas";
            }
        }
        throw new IllegalArgumentException();
    }

    public String toString() {
        return "ServicesHealth{version=" + this.version + ", endpoints=" + this.endpoints + '}';
    }
}

