/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.oracle.model.data.spatial;

import com.dbeaver.db.oracle.model.data.spatial.SDOUtils;
import java.lang.reflect.Array;
import java.sql.Struct;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;

public class SDOGeometryConverter {
    private final GeometryFactory geometryFactory;
    public static final String DATATYPE = "MDSYS.SDO_GEOMETRY";

    public SDOGeometryConverter() {
        this(new GeometryFactory());
    }

    public SDOGeometryConverter(GeometryFactory geometryFactory) {
        this.geometryFactory = geometryFactory;
    }

    public String getDataTypeName() {
        return DATATYPE;
    }

    public boolean isCapable(Geometry geom) {
        if (geom == null) {
            return true;
        }
        if (geom instanceof Point || geom instanceof MultiPoint || geom instanceof LineString || geom instanceof MultiLineString || geom instanceof Polygon || geom instanceof MultiPolygon || geom instanceof GeometryCollection) {
            int d = SDOUtils.D(geom);
            int l = SDOUtils.L(geom);
            return l == 0 && (d == 2 || d == 3);
        }
        return false;
    }

    public Geometry asGeometry(Struct sdoGeometry) throws Exception {
        if (sdoGeometry == null) {
            return null;
        }
        Object[] data = sdoGeometry.getAttributes();
        int GTYPE = this.asInteger(data[0], 0);
        int SRID = this.asInteger(data[1], -1);
        double[] POINT = this.asDoubleArray((Struct)data[2], Double.NaN);
        int[] ELEMINFO = this.asIntArray((java.sql.Array)data[3], 0);
        double[] ORDINATES = this.asDoubleArray((java.sql.Array)data[4], Double.NaN);
        Geometry geometry = SDOUtils.create(this.geometryFactory, GTYPE, SRID, POINT, ELEMINFO, ORDINATES);
        geometry.setUserData((Object)sdoGeometry);
        return geometry;
    }

    protected int asInteger(Object datum, int DEFAULT) throws Exception {
        if (datum == null) {
            return DEFAULT;
        }
        return (Integer)datum.getClass().getMethod("intValue", new Class[0]).invoke(datum, new Object[0]);
    }

    protected double asDouble(Object datum, double DEFAULT) throws Exception {
        if (datum == null) {
            return DEFAULT;
        }
        return (Double)datum.getClass().getMethod("doubleValue", new Class[0]).invoke(datum, new Object[0]);
    }

    protected double[] asDoubleArray(Struct struct, double DEFAULT) throws Exception {
        if (struct == null) {
            return null;
        }
        return this.asDoubleArray(struct.getAttributes(), DEFAULT);
    }

    protected double[] asDoubleArray(java.sql.Array array, double DEFAULT) throws Exception {
        if (array == null) {
            return null;
        }
        return this.asDoubleArray(array.getArray(), DEFAULT);
    }

    protected double[] asDoubleArray(Object data, double DEFAULT) throws Exception {
        if (data == null) {
            return null;
        }
        int length = Array.getLength(data);
        double[] array = new double[length];
        int i = 0;
        while (i < length) {
            array[i] = this.asDouble(Array.get(data, i), DEFAULT);
            ++i;
        }
        return array;
    }

    protected double[] asDoubleArray(Object[] data, double DEFAULT) throws Exception {
        if (data == null) {
            return null;
        }
        double[] array = new double[data.length];
        int i = 0;
        while (i < data.length) {
            array[i] = this.asDouble(data[i], DEFAULT);
            ++i;
        }
        return array;
    }

    protected int[] asIntArray(java.sql.Array array, int DEFAULT) throws Exception {
        if (array == null) {
            return null;
        }
        return this.asIntArray(array.getArray(), DEFAULT);
    }

    protected int[] asIntArray(Object data, int DEFAULT) throws Exception {
        if (data == null) {
            return null;
        }
        int length = Array.getLength(data);
        int[] array = new int[length];
        int i = 0;
        while (i < length) {
            array[i] = this.asInteger(Array.get(data, i), DEFAULT);
            ++i;
        }
        return array;
    }

    protected int[] asIntArray(Object[] data, int DEFAULT) throws Exception {
        if (data == null) {
            return null;
        }
        int[] array = new int[data.length];
        int i = 0;
        while (i < data.length) {
            array[i] = this.asInteger(data[i], DEFAULT);
            ++i;
        }
        return array;
    }
}

