/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.oracle.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.ext.oracle.model.OracleObject;
import org.jkiss.dbeaver.ext.oracle.model.OracleTablespace;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.utils.CommonUtils;

public class OracleDataFile
extends OracleObject<OracleTablespace> {
    private final OracleTablespace tablespace;
    private long id;
    private long relativeNo;
    private BigDecimal bytes;
    private BigDecimal blocks;
    private BigDecimal maxBytes;
    private BigDecimal maxBlocks;
    private long incrementBy;
    private BigDecimal userBytes;
    private BigDecimal userBlocks;
    private boolean available;
    private boolean autoExtensible;
    private OnlineStatus onlineStatus;
    private boolean temporary;

    protected OracleDataFile(OracleTablespace tablespace, ResultSet dbResult, boolean temporary) {
        super(tablespace, JDBCUtils.safeGetString((ResultSet)dbResult, (String)"FILE_NAME"), true);
        this.tablespace = tablespace;
        this.temporary = temporary;
        this.id = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"FILE_ID");
        this.relativeNo = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"RELATIVE_FNO");
        this.bytes = JDBCUtils.safeGetBigDecimal((ResultSet)dbResult, (String)"BYTES");
        this.blocks = JDBCUtils.safeGetBigDecimal((ResultSet)dbResult, (String)"BLOCKS");
        this.maxBytes = JDBCUtils.safeGetBigDecimal((ResultSet)dbResult, (String)"MAXBYTES");
        this.maxBlocks = JDBCUtils.safeGetBigDecimal((ResultSet)dbResult, (String)"MAXBLOCKS");
        this.incrementBy = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"INCREMENT_BY");
        this.userBytes = JDBCUtils.safeGetBigDecimal((ResultSet)dbResult, (String)"USER_BYTES");
        this.userBlocks = JDBCUtils.safeGetBigDecimal((ResultSet)dbResult, (String)"USER_BLOCKS");
        this.autoExtensible = JDBCUtils.safeGetBoolean((ResultSet)dbResult, (String)"AUTOEXTENSIBLE", (String)"Y");
        this.available = "AVAILABLE".equals(JDBCUtils.safeGetStringTrimmed((ResultSet)dbResult, (String)"STATUS"));
        if (!this.temporary) {
            this.onlineStatus = (OnlineStatus)CommonUtils.valueOf(OnlineStatus.class, (String)JDBCUtils.safeGetStringTrimmed((ResultSet)dbResult, (String)"ONLINE_STATUS"));
        }
    }

    public OracleTablespace getTablespace() {
        return this.tablespace;
    }

    @Override
    @Property(viewable=true, editable=true, order=1)
    @NotNull
    public String getName() {
        return this.name;
    }

    @Property(order=2)
    public long getId() {
        return this.id;
    }

    @Property(order=3)
    public long getRelativeNo() {
        return this.relativeNo;
    }

    @Property(viewable=true, order=4)
    public BigDecimal getBytes() {
        return this.bytes;
    }

    @Property(viewable=true, order=5)
    public BigDecimal getBlocks() {
        return this.blocks;
    }

    @Property(viewable=true, order=6)
    public BigDecimal getMaxBytes() {
        return this.maxBytes;
    }

    @Property(viewable=true, order=7)
    public BigDecimal getMaxBlocks() {
        return this.maxBlocks;
    }

    @Property(viewable=true, order=8)
    public long getIncrementBy() {
        return this.incrementBy;
    }

    @Property(viewable=true, order=9)
    public BigDecimal getUserBytes() {
        return this.userBytes;
    }

    @Property(viewable=true, order=10)
    public BigDecimal getUserBlocks() {
        return this.userBlocks;
    }

    @Property(viewable=true, order=11)
    public boolean isAvailable() {
        return this.available;
    }

    @Property(viewable=true, order=12)
    public boolean isAutoExtensible() {
        return this.autoExtensible;
    }

    @Property(order=13)
    public OnlineStatus getOnlineStatus() {
        return this.onlineStatus;
    }

    @Property(order=14)
    public boolean isTemporary() {
        return this.temporary;
    }

    public static enum OnlineStatus {
        SYSOFF,
        SYSTEM,
        OFFLINE,
        ONLINE,
        RECOVER;

    }
}

