/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.athena.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.athena.model.EncryptionConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ResultConfigurationUpdates
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ResultConfigurationUpdates> {
    private static final SdkField<String> OUTPUT_LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OutputLocation").getter(ResultConfigurationUpdates.getter(ResultConfigurationUpdates::outputLocation)).setter(ResultConfigurationUpdates.setter(Builder::outputLocation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputLocation").build()}).build();
    private static final SdkField<Boolean> REMOVE_OUTPUT_LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("RemoveOutputLocation").getter(ResultConfigurationUpdates.getter(ResultConfigurationUpdates::removeOutputLocation)).setter(ResultConfigurationUpdates.setter(Builder::removeOutputLocation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RemoveOutputLocation").build()}).build();
    private static final SdkField<EncryptionConfiguration> ENCRYPTION_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EncryptionConfiguration").getter(ResultConfigurationUpdates.getter(ResultConfigurationUpdates::encryptionConfiguration)).setter(ResultConfigurationUpdates.setter(Builder::encryptionConfiguration)).constructor(EncryptionConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EncryptionConfiguration").build()}).build();
    private static final SdkField<Boolean> REMOVE_ENCRYPTION_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("RemoveEncryptionConfiguration").getter(ResultConfigurationUpdates.getter(ResultConfigurationUpdates::removeEncryptionConfiguration)).setter(ResultConfigurationUpdates.setter(Builder::removeEncryptionConfiguration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RemoveEncryptionConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OUTPUT_LOCATION_FIELD, REMOVE_OUTPUT_LOCATION_FIELD, ENCRYPTION_CONFIGURATION_FIELD, REMOVE_ENCRYPTION_CONFIGURATION_FIELD));
    private static final long serialVersionUID = 1L;
    private final String outputLocation;
    private final Boolean removeOutputLocation;
    private final EncryptionConfiguration encryptionConfiguration;
    private final Boolean removeEncryptionConfiguration;

    private ResultConfigurationUpdates(BuilderImpl builder) {
        this.outputLocation = builder.outputLocation;
        this.removeOutputLocation = builder.removeOutputLocation;
        this.encryptionConfiguration = builder.encryptionConfiguration;
        this.removeEncryptionConfiguration = builder.removeEncryptionConfiguration;
    }

    public final String outputLocation() {
        return this.outputLocation;
    }

    public final Boolean removeOutputLocation() {
        return this.removeOutputLocation;
    }

    public final EncryptionConfiguration encryptionConfiguration() {
        return this.encryptionConfiguration;
    }

    public final Boolean removeEncryptionConfiguration() {
        return this.removeEncryptionConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.outputLocation());
        hashCode = 31 * hashCode + Objects.hashCode(this.removeOutputLocation());
        hashCode = 31 * hashCode + Objects.hashCode(this.encryptionConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.removeEncryptionConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResultConfigurationUpdates)) {
            return false;
        }
        ResultConfigurationUpdates other = (ResultConfigurationUpdates)obj;
        return Objects.equals(this.outputLocation(), other.outputLocation()) && Objects.equals(this.removeOutputLocation(), other.removeOutputLocation()) && Objects.equals(this.encryptionConfiguration(), other.encryptionConfiguration()) && Objects.equals(this.removeEncryptionConfiguration(), other.removeEncryptionConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"ResultConfigurationUpdates").add("OutputLocation", (Object)this.outputLocation()).add("RemoveOutputLocation", (Object)this.removeOutputLocation()).add("EncryptionConfiguration", (Object)this.encryptionConfiguration()).add("RemoveEncryptionConfiguration", (Object)this.removeEncryptionConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "OutputLocation": {
                return Optional.ofNullable(clazz.cast(this.outputLocation()));
            }
            case "RemoveOutputLocation": {
                return Optional.ofNullable(clazz.cast(this.removeOutputLocation()));
            }
            case "EncryptionConfiguration": {
                return Optional.ofNullable(clazz.cast(this.encryptionConfiguration()));
            }
            case "RemoveEncryptionConfiguration": {
                return Optional.ofNullable(clazz.cast(this.removeEncryptionConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ResultConfigurationUpdates, T> g) {
        return obj -> g.apply((ResultConfigurationUpdates)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String outputLocation;
        private Boolean removeOutputLocation;
        private EncryptionConfiguration encryptionConfiguration;
        private Boolean removeEncryptionConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(ResultConfigurationUpdates model) {
            this.outputLocation(model.outputLocation);
            this.removeOutputLocation(model.removeOutputLocation);
            this.encryptionConfiguration(model.encryptionConfiguration);
            this.removeEncryptionConfiguration(model.removeEncryptionConfiguration);
        }

        public final String getOutputLocation() {
            return this.outputLocation;
        }

        @Override
        public final Builder outputLocation(String outputLocation) {
            this.outputLocation = outputLocation;
            return this;
        }

        public final void setOutputLocation(String outputLocation) {
            this.outputLocation = outputLocation;
        }

        public final Boolean getRemoveOutputLocation() {
            return this.removeOutputLocation;
        }

        @Override
        public final Builder removeOutputLocation(Boolean removeOutputLocation) {
            this.removeOutputLocation = removeOutputLocation;
            return this;
        }

        public final void setRemoveOutputLocation(Boolean removeOutputLocation) {
            this.removeOutputLocation = removeOutputLocation;
        }

        public final EncryptionConfiguration.Builder getEncryptionConfiguration() {
            return this.encryptionConfiguration != null ? this.encryptionConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder encryptionConfiguration(EncryptionConfiguration encryptionConfiguration) {
            this.encryptionConfiguration = encryptionConfiguration;
            return this;
        }

        public final void setEncryptionConfiguration(EncryptionConfiguration.BuilderImpl encryptionConfiguration) {
            this.encryptionConfiguration = encryptionConfiguration != null ? encryptionConfiguration.build() : null;
        }

        public final Boolean getRemoveEncryptionConfiguration() {
            return this.removeEncryptionConfiguration;
        }

        @Override
        public final Builder removeEncryptionConfiguration(Boolean removeEncryptionConfiguration) {
            this.removeEncryptionConfiguration = removeEncryptionConfiguration;
            return this;
        }

        public final void setRemoveEncryptionConfiguration(Boolean removeEncryptionConfiguration) {
            this.removeEncryptionConfiguration = removeEncryptionConfiguration;
        }

        public ResultConfigurationUpdates build() {
            return new ResultConfigurationUpdates(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ResultConfigurationUpdates> {
        public Builder outputLocation(String var1);

        public Builder removeOutputLocation(Boolean var1);

        public Builder encryptionConfiguration(EncryptionConfiguration var1);

        default public Builder encryptionConfiguration(Consumer<EncryptionConfiguration.Builder> encryptionConfiguration) {
            return this.encryptionConfiguration((EncryptionConfiguration)((EncryptionConfiguration.Builder)EncryptionConfiguration.builder().applyMutation(encryptionConfiguration)).build());
        }

        public Builder removeEncryptionConfiguration(Boolean var1);
    }
}

