/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc4.jdbc;

import com.sybase.jdbc4.jdbc.ErrorMessage;
import com.sybase.jdbc4.utils.LogUtil;
import java.sql.SQLException;
import java.sql.Savepoint;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Logger;

public class SybSavepoint
implements Savepoint {
    private static final Logger LOG = Logger.getLogger(SybSavepoint.class.getName());
    private static volatile long _logIdCounter = 0L;
    protected String _logId = null;
    private AtomicLong _apiCount = new AtomicLong(0L);
    protected String _name = null;
    protected int _id = 0;
    protected boolean _isNamed = false;

    public SybSavepoint(String string, String string2) {
        this(string, string2, 0);
    }

    public SybSavepoint(String string, int n) {
        this(string, null, n);
    }

    public SybSavepoint(String string, String string2, int n) {
        this._logId = string + "_Sp" + _logIdCounter++;
        this._id = n;
        this._name = string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getSavepointId() throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(LOG);
        long l = bl ? this._apiCount.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(LOG, this._logId, l);
            }
            if (this._isNamed) {
                ErrorMessage.raiseError("JZ018");
            }
            int n = this._id;
            return n;
        }
        finally {
            if (bl) {
                LogUtil.logEnd(LOG, null, null, this._logId, "getSavepointId", null, null, l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getSavepointName() throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(LOG);
        long l = bl ? this._apiCount.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(LOG, this._logId, l);
            }
            if (!this._isNamed) {
                ErrorMessage.raiseError("JZ018");
            }
            String string = this._name;
            return string;
        }
        finally {
            if (bl) {
                LogUtil.logEnd(LOG, null, null, this._logId, "getSavepointName", null, null, l);
            }
        }
    }

    public String getLogId() {
        return this._logId;
    }
}

