/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.plugin.httpserver;

import com.amazon.redshift.plugin.httpserver.InvalidHttpRequestHandler;
import com.amazon.redshift.plugin.httpserver.ValidHttpRequestHandler;
import java.io.IOException;
import java.util.List;
import java.util.function.Function;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.RequestLine;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.message.BasicHttpEntityEnclosingRequest;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpRequestHandler;

public class RequestHandler
implements HttpRequestHandler {
    public static final String REDSHIFT_PATH = "/redshift/";
    private static final String SUPPORTED_METHOD = "POST";
    private final Function<List<NameValuePair>, Object> m_requestProcessLogic;
    private final HttpRequestHandler m_invalidRequestHandler;
    private final HttpRequestHandler m_validRequestHandler;
    private Object m_result;

    public RequestHandler(Function<List<NameValuePair>, Object> function) {
        this.m_requestProcessLogic = function;
        this.m_invalidRequestHandler = new InvalidHttpRequestHandler();
        this.m_validRequestHandler = new ValidHttpRequestHandler();
    }

    public void handle(HttpRequest httpRequest, HttpResponse httpResponse, HttpContext httpContext) throws HttpException, IOException {
        if (this.isRequestValid(httpRequest)) {
            this.m_result = this.m_requestProcessLogic.apply(URLEncodedUtils.parse((HttpEntity)((BasicHttpEntityEnclosingRequest)httpRequest).getEntity()));
            this.m_validRequestHandler.handle(httpRequest, httpResponse, httpContext);
        } else {
            this.m_invalidRequestHandler.handle(httpRequest, httpResponse, httpContext);
        }
    }

    private boolean isRequestValid(HttpRequest httpRequest) {
        RequestLine requestLine = httpRequest.getRequestLine();
        if (!SUPPORTED_METHOD.equalsIgnoreCase(requestLine.getMethod())) {
            return false;
        }
        return requestLine.getUri().startsWith(REDSHIFT_PATH);
    }

    public Object getResult() {
        return this.m_result;
    }

    public boolean hasResult() {
        return this.m_result != null;
    }
}

