/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.plugin;

import com.amazon.redshift.plugin.SamlCredentialsProvider;
import com.amazonaws.SdkClientException;
import com.amazonaws.util.IOUtils;
import com.amazonaws.util.StringUtils;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;

public class AdfsCredentialsProvider
extends SamlCredentialsProvider {
    private static final Pattern SAML_PATTERN = Pattern.compile("SAMLResponse\\W+value=\"([^\"]+)\"");

    @Override
    protected String getSamlAssertion() throws IOException {
        if (StringUtils.isNullOrEmpty(this.m_idpHost)) {
            throw new IOException("Missing required property: idp_host");
        }
        if (StringUtils.isNullOrEmpty(this.m_userName) || StringUtils.isNullOrEmpty(this.m_password)) {
            return this.windowsIntegratedAuthentication();
        }
        return this.formBasedAuthentication();
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String windowsIntegratedAuthentication() {
        String string;
        String string2 = System.getProperty("os.name").toLowerCase(Locale.getDefault());
        if (!string2.contains("windows")) {
            throw new SdkClientException("WIA only support Windows platform.");
        }
        InputStream inputStream = null;
        OutputStream outputStream = null;
        File file = null;
        try {
            file = this.extractExecutable();
            String[] stringArray = new String[]{file.getAbsolutePath(), "https://" + this.m_idpHost + ':' + this.m_idpPort + "/adfs/ls/IdpInitiatedSignOn.aspx?loginToRp=urn:amazon:webservices", String.valueOf(Boolean.getBoolean("adfs.insecure"))};
            Process process = Runtime.getRuntime().exec(stringArray);
            inputStream = process.getInputStream();
            outputStream = process.getOutputStream();
            String string3 = IOUtils.toString(inputStream);
            int n = process.waitFor();
            if (n != 0) {
                throw new SdkClientException("Failed execute adfs command, return: " + n);
            }
            string = string3;
        }
        catch (InterruptedException interruptedException) {
            try {
                throw new SdkClientException("Failed execute adfs command.", interruptedException);
                catch (IOException iOException) {
                    throw new SdkClientException("Failed execute adfs command.", iOException);
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(inputStream, null);
                IOUtils.closeQuietly(outputStream, null);
                if (file != null && !file.delete()) {
                    file.deleteOnExit();
                }
                throw throwable;
            }
        }
        IOUtils.closeQuietly(inputStream, null);
        IOUtils.closeQuietly(outputStream, null);
        if (file != null && !file.delete()) {
            file.deleteOnExit();
        }
        return string;
    }

    private String formBasedAuthentication() throws IOException {
        String string = "https://" + this.m_idpHost + ':' + this.m_idpPort + "/adfs/ls/IdpInitiatedSignOn.aspx?loginToRp=urn:amazon:webservices";
        CloseableHttpClient closeableHttpClient = null;
        try {
            String string2;
            Object object;
            String string3;
            String string42;
            closeableHttpClient = this.getHttpClient();
            HttpGet httpGet = new HttpGet(string);
            CloseableHttpResponse closeableHttpResponse = closeableHttpClient.execute((HttpUriRequest)httpGet);
            if (closeableHttpResponse.getStatusLine().getStatusCode() != 200) {
                throw new IOException("Failed send request: " + closeableHttpResponse.getStatusLine().getReasonPhrase());
            }
            String string5 = EntityUtils.toString((HttpEntity)closeableHttpResponse.getEntity());
            ArrayList<BasicNameValuePair> arrayList = new ArrayList<BasicNameValuePair>();
            for (String string42 : this.getInputTagsfromHTML(string5)) {
                string3 = this.getValueByKey(string42, "name");
                object = this.getValueByKey(string42, "value");
                string2 = string3.toLowerCase();
                if (string2.contains("username")) {
                    arrayList.add(new BasicNameValuePair(string3, this.m_userName));
                    continue;
                }
                if (string2.contains("authmethod")) {
                    if (((String)object).isEmpty()) continue;
                    arrayList.add(new BasicNameValuePair(string3, (String)object));
                    continue;
                }
                if (string2.contains("password")) {
                    arrayList.add(new BasicNameValuePair(string3, this.m_password));
                    continue;
                }
                if (string3.isEmpty()) continue;
                arrayList.add(new BasicNameValuePair(string3, (String)object));
            }
            String string6 = this.getFormAction(string5);
            if (!StringUtils.isNullOrEmpty(string6) && string6.startsWith("/")) {
                string = "https://" + this.m_idpHost + ':' + this.m_idpPort + (String)string6;
            }
            string42 = new HttpPost(string);
            string42.setEntity((HttpEntity)new UrlEncodedFormEntity(arrayList));
            closeableHttpResponse = closeableHttpClient.execute((HttpUriRequest)string42);
            if (closeableHttpResponse.getStatusLine().getStatusCode() != 200) {
                throw new IOException("Failed send request: " + closeableHttpResponse.getStatusLine().getReasonPhrase());
            }
            string3 = EntityUtils.toString((HttpEntity)closeableHttpResponse.getEntity());
            object = SAML_PATTERN.matcher(string3);
            if (!((Matcher)object).find()) {
                throw new IOException("Failed to login ADFS.");
            }
            string2 = ((Matcher)object).group(1);
            return string2;
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new SdkClientException("Failed create SSLContext.", generalSecurityException);
        }
        finally {
            IOUtils.closeQuietly((Closeable)closeableHttpClient, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File extractExecutable() throws IOException {
        File file = File.createTempFile("adfs", ".exe");
        InputStream inputStream = null;
        FileOutputStream fileOutputStream = null;
        try {
            inputStream = AdfsCredentialsProvider.class.getResourceAsStream("adfs.exe");
            fileOutputStream = new FileOutputStream(file);
            IOUtils.copy(inputStream, fileOutputStream);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(inputStream, null);
            IOUtils.closeQuietly(fileOutputStream, null);
            throw throwable;
        }
        IOUtils.closeQuietly(inputStream, null);
        IOUtils.closeQuietly(fileOutputStream, null);
        return file;
    }
}

