/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.core.jdbc42;

import com.amazon.dsi.dataengine.interfaces.IColumn;
import com.amazon.dsi.dataengine.interfaces.IResultSet;
import com.amazon.exceptions.ExceptionConverter;
import com.amazon.jdbc.common.SStatement;
import com.amazon.jdbc.jdbc42.S42ForwardResultSet;
import com.amazon.redshift.api.PGDataTypeUtilities;
import com.amazon.redshift.api.PGGeometryColumnMetaData;
import com.amazon.redshift.api.PGTimestamp;
import com.amazon.redshift.dataengine.metadata.PGResultSetMetaData;
import com.amazon.support.ILogger;
import com.amazon.support.LogUtilities;
import java.sql.Date;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;

public class PGJDBCS42ForwardResultSet
extends S42ForwardResultSet {
    public PGJDBCS42ForwardResultSet(SStatement sStatement, IResultSet iResultSet, ILogger iLogger) throws SQLException {
        super(sStatement, iResultSet, iLogger);
    }

    @Override
    public Date getDate(int n) throws SQLException {
        Date date = null;
        IColumn iColumn = (IColumn)this.m_resultSetColumns.get(n - 1);
        short s = iColumn.getTypeMetadata().getType();
        if (s == 93) {
            Timestamp timestamp = super.getTimestamp(n);
            if (timestamp instanceof PGTimestamp) {
                PGTimestamp pGTimestamp = (PGTimestamp)timestamp;
                date = PGDataTypeUtilities.castTimestampToDate(pGTimestamp, null);
            } else {
                date = super.getDate(n);
            }
        } else {
            date = super.getDate(n);
        }
        return date;
    }

    @Override
    public Date getDate(int n, Calendar calendar) throws SQLException {
        Date date = null;
        IColumn iColumn = (IColumn)this.m_resultSetColumns.get(n - 1);
        short s = iColumn.getTypeMetadata().getType();
        if (s == 93) {
            Timestamp timestamp = super.getTimestamp(n);
            if (timestamp instanceof PGTimestamp) {
                PGTimestamp pGTimestamp = (PGTimestamp)timestamp;
                date = PGDataTypeUtilities.castTimestampToDate(pGTimestamp, calendar);
            } else {
                date = super.getDate(n, calendar);
            }
        } else {
            date = super.getDate(n, calendar);
        }
        return date;
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.getLogger(), new Object[0]);
            this.checkIfOpen();
            if (null == this.getResultSetMetaData()) {
                this.initializeResultSetColumns();
                this.setResultSetMetadata(new PGResultSetMetaData(this.getResultSetColumns(), this.getLogger(), this.getWarningListener(), this.m_resultSet));
            }
            return this.getResultSetMetaData();
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.getWarningListener(), this.getLogger());
        }
    }

    @Override
    public String getString(int n) throws SQLException {
        String string = null;
        IColumn iColumn = (IColumn)this.m_resultSetColumns.get(n - 1);
        short s = iColumn.getTypeMetadata().getType();
        if (s == 93) {
            Timestamp timestamp = super.getTimestamp(n);
            string = timestamp instanceof PGTimestamp ? ((PGTimestamp)timestamp).getPostgresqlString() : super.getString(n);
        } else if (iColumn instanceof PGGeometryColumnMetaData) {
            byte[] byArray = super.getBytes(n);
            char[] cArray = "0123456789ABCDEF".toCharArray();
            char[] cArray2 = new char[2 * byArray.length];
            for (int i = 0; i < byArray.length; ++i) {
                int n2 = byArray[i] & 0xFF;
                cArray2[i * 2] = cArray[n2 >>> 4];
                cArray2[i * 2 + 1] = cArray[n2 & 0xF];
            }
            string = new String(cArray2);
        } else {
            string = super.getString(n);
        }
        return string;
    }

    @Override
    public Time getTime(int n) throws SQLException {
        Time time = null;
        IColumn iColumn = (IColumn)this.m_resultSetColumns.get(n - 1);
        short s = iColumn.getTypeMetadata().getType();
        if (s == 93) {
            Timestamp timestamp = super.getTimestamp(n);
            if (timestamp instanceof PGTimestamp) {
                PGTimestamp pGTimestamp = (PGTimestamp)timestamp;
                time = PGDataTypeUtilities.castTimestampToTime(pGTimestamp, null);
            } else {
                time = super.getTime(n);
            }
        } else {
            time = super.getTime(n);
        }
        return time;
    }

    @Override
    public Time getTime(int n, Calendar calendar) throws SQLException {
        Time time = null;
        IColumn iColumn = (IColumn)this.m_resultSetColumns.get(n - 1);
        short s = iColumn.getTypeMetadata().getType();
        if (s == 93) {
            Timestamp timestamp = super.getTimestamp(n);
            if (timestamp instanceof PGTimestamp) {
                PGTimestamp pGTimestamp = (PGTimestamp)timestamp;
                time = PGDataTypeUtilities.castTimestampToTime(pGTimestamp, calendar);
            } else {
                time = super.getTime(n, calendar);
            }
        } else {
            time = super.getTime(n, calendar);
        }
        return time;
    }

    @Override
    public void initializeColumnNameMap() throws SQLException {
        super.initializeColumnNameMap();
    }
}

