/*
 * Decompiled with CFR 0.152.
 */
package com.simba.athena.commons.codec.language;

import com.simba.athena.commons.codec.EncoderException;
import com.simba.athena.commons.codec.StringEncoder;
import com.simba.athena.commons.codec.language.SoundexUtils;

public class Soundex
implements StringEncoder {
    public static final Soundex US_ENGLISH = new Soundex();
    public static final String US_ENGLISH_MAPPING_STRING = "01230120022455012623010202";
    public static final char[] US_ENGLISH_MAPPING = "01230120022455012623010202".toCharArray();
    private int maxLength = 4;
    private char[] soundexMapping;

    public int difference(String s1, String s2) throws EncoderException {
        return SoundexUtils.difference(this, s1, s2);
    }

    public Soundex() {
        this(US_ENGLISH_MAPPING);
    }

    public Soundex(char[] mapping) {
        this.setSoundexMapping(mapping);
    }

    public Object encode(Object pObject) throws EncoderException {
        if (!(pObject instanceof String)) {
            throw new EncoderException("Parameter supplied to Soundex encode is not of type java.lang.String");
        }
        return this.soundex((String)pObject);
    }

    public String encode(String pString) {
        return this.soundex(pString);
    }

    private char getMappingCode(String str, int index) {
        char preHWChar;
        char firstCode;
        char hwChar;
        char mappedChar = this.map(str.charAt(index));
        if (!(index <= 1 || mappedChar == '0' || 'H' != (hwChar = str.charAt(index - 1)) && 'W' != hwChar || (firstCode = this.map(preHWChar = str.charAt(index - 2))) != mappedChar && 'H' != preHWChar && 'W' != preHWChar)) {
            return '\u0000';
        }
        return mappedChar;
    }

    public int getMaxLength() {
        return this.maxLength;
    }

    private char[] getSoundexMapping() {
        return this.soundexMapping;
    }

    private char map(char ch) {
        int index = ch - 65;
        if (index < 0 || index >= this.getSoundexMapping().length) {
            throw new IllegalArgumentException("The character is not mapped: " + ch);
        }
        return this.getSoundexMapping()[index];
    }

    public void setMaxLength(int maxLength) {
        this.maxLength = maxLength;
    }

    private void setSoundexMapping(char[] soundexMapping) {
        this.soundexMapping = soundexMapping;
    }

    public String soundex(String str) {
        if (str == null) {
            return null;
        }
        if ((str = SoundexUtils.clean(str)).length() == 0) {
            return str;
        }
        char[] out = new char[]{'0', '0', '0', '0'};
        int incount = 1;
        int count = 1;
        out[0] = str.charAt(0);
        char last = this.getMappingCode(str, 0);
        while (incount < str.length() && count < out.length) {
            char mapped;
            if ((mapped = this.getMappingCode(str, incount++)) == '\u0000') continue;
            if (mapped != '0' && mapped != last) {
                out[count++] = mapped;
            }
            last = mapped;
        }
        return new String(out);
    }
}

